/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import bcutil.BCUtil;
import com.aem.BuildDateUtil;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStats;
import com.aem.sdesktop.Util;
import com.aem.sdesktop.interfaces.ServerConnection;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.controller.AsyncServer;
import com.aem.sdesktop.server.controller.ChatServer;
import com.aem.sdesktop.server.controller.ClipboardServer;
import com.aem.sdesktop.server.controller.FTPServer;
import com.aem.sdesktop.server.controller.InputServer;
import com.aem.sdesktop.server.controller.NullServer;
import com.aem.sdesktop.server.controller.PermissionDeniedServer;
import com.aem.sdesktop.server.controller.PortRedirectServer;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.ScreenServer;
import com.aem.sdesktop.server.controller.SoundServer;
import com.aem.sdesktop.server.controller.TerminalServer;
import com.aem.sdesktop.server.controller.WhiteboardServer;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.util.MouseMover;
import com.aem.sdesktop.util.TransportCommsLine;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.shelp.util.SHelpNodelinkPatcher;
import com.aem.shelp.util.SHelpUdpNlNatHpMk2;
import com.aem.shelp.util.TechPresenceVisibilityDialog;
import com.aem.utils.Debugger;
import com.aem.utils.multiplex.MultiplexingInput;
import com.aem.utils.multiplex.MultiplexingOutput;
import com.aem.utils.streamenc.ChunkFilter;
import com.aem.utils.streamenc.ChunkFilterOutputStream;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.TransactionListener;
import utils.stream.StreamUtils;
import utils.switches.Switches;

public class SDesktopServerInstance
implements TransactionListener,
ServerConnection {
    public boolean INPUT_USE_TRANSACTION = false;
    public boolean SCREEN_USE_TRANSACTION = false;
    ServerUserInterface gui;
    SDesktopServerController controller;
    InputServer inputserver;
    ScreenServer screenserver;
    ClipboardServer clipboardserver;
    ChatServer chatserver;
    WhiteboardServer wboardserver;
    FTPServer ftpserver;
    AsyncServer asyncserver;
    PortRedirectServer portserver;
    SoundServer soundServer;
    TerminalServer terminalServer;
    TransportCommsLine transportLine;
    String username;
    String hostname;
    Node assocNode;
    NodeLink socket;
    NodeLink directSocket;
    long started = 0L;
    BufferedImage wboard;
    boolean doAuth = true;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss, dd MMMM yyyy");
    boolean cleanedUp = false;
    Object cleanup_LOCK = new Object();
    Object die_LOCK = new Object();
    boolean diedAlready = false;
    TechPresenceVisibilityDialog visd;

    public void setLowLatencyRequired(boolean b) {
        try {
            this.socket.setLowLatencyRequired(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.directSocket.setLowLatencyRequired(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NodeLinkStats getSessionStats() {
        if (this.directSocket != null) {
            return this.directSocket.getStats();
        }
        return this.socket.getStats();
    }

    public void reestablishNonUdpTransport(int type, long id) {
        new NonUdpTransportReestablish(type, id).start();
    }

    public void reestablishUdpTransport(boolean direct, boolean allowPortScan, int initialKBps) {
        new UdpTransportReestablish(direct, allowPortScan, initialKBps).start();
    }

    public int getMaxMeasuredReadRate(boolean direct) {
        int maxKBps = 0;
        if (this.socket != null) {
            maxKBps = direct ? this.socket.getMaxReadRateDirectKBps() : this.socket.getMaxReadRateProxiedKBps();
        }
        if (this.directSocket != null) {
            maxKBps = direct ? Math.max(maxKBps, this.directSocket.getMaxReadRateDirectKBps()) : Math.max(maxKBps, this.directSocket.getMaxReadRateProxiedKBps());
        }
        return maxKBps;
    }

    @Override
    public void cleanUp() {
        try {
            this.inputserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.screenserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.clipboardserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.chatserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.wboardserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.ftpserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.asyncserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.portserver.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.soundServer.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.terminalServer.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public BufferedImage getWhiteboard() {
        return this.wboard;
    }

    @Override
    public void setWhiteboard(BufferedImage img) {
        this.wboard = img;
    }

    @Override
    public long getConnectionTime() {
        return this.started;
    }

    @Override
    public String getUser() {
        return this.username;
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    public void doCAD() {
        if (this.inputserver != null) {
            this.inputserver.doCAD();
        }
    }

    public String toString() {
        return this.username + "@" + this.hostname + " (since " + sdf.format(new Date(this.started)) + ")";
    }

    public void log(String msg) {
        System.out.println(msg);
    }

    public boolean isUDPConnection() {
        if (this.directSocket == null) {
            return false;
        }
        NodeLinkStats sessionStats = this.directSocket.getStats();
        return sessionStats != null && (sessionStats.type == 4 || sessionStats.type == 3);
    }

    @Override
    public boolean isAlive() {
        return this.socket.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSettingsAndCleanUp() {
        Object object = this.cleanup_LOCK;
        synchronized (object) {
            block7: {
                System.out.println("[ServerInstance] cleaning up");
                try {
                    if (this.cleanedUp) break block7;
                    this.cleanedUp = true;
                    this.cleanUp();
                    boolean lastConnectionAlive = this.controller.getLiveConnectionCount(this) == 0;
                    this.asyncserver.restoreSettings(lastConnectionAlive);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.screenserver.cleanUp(lastConnectionAlive);
                    this.portserver.cleanup(lastConnectionAlive);
                    this.inputserver.cleanUpMmove(lastConnectionAlive);
                    this.wboard = null;
                    this.gui = null;
                    this.controller = null;
                    this.inputserver = null;
                    this.screenserver = null;
                    this.clipboardserver = null;
                    this.chatserver = null;
                    this.wboardserver = null;
                    this.ftpserver = null;
                    this.asyncserver = null;
                    this.portserver = null;
                    this.soundServer = null;
                    this.terminalServer = null;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void died() {
        Object object = this.die_LOCK;
        synchronized (object) {
            if (this.diedAlready) {
                return;
            }
            this.diedAlready = true;
        }
        try {
            this.visd.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.stop("SDServerInstance died");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.controller.checkConnections();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void kill() {
        try {
            this.visd.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gui.printToConnectionLog(this, System.currentTimeMillis(), "server requested connection termination");
        try {
            this.socket.stop("SDServerInstance explicit kill");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.controller.checkConnections();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InputStream nextReader(MultiplexingInput mxin, int N, String name) {
        InputStream in = mxin.getInputStream((short)N, name);
        return in;
    }

    public OutputStream nextWriter(MultiplexingOutput mxout, int N) {
        OutputStream out = mxout.getOutputStream((short)N);
        return out;
    }

    public SDesktopServerInstance(ServerUserInterface gui, SDesktopServerController controller, NodeLink socket, NodeLink directSocket, boolean encryption_on, MultiplexingInput mxin, MultiplexingOutput mxout, String username, String hostname, boolean FTP, boolean RDP, boolean CHAT, String connected_host, int connected_port, boolean mmoveRequiredButFailed, ScreenServer preloadedScreenServer, TransportCommsLine transportLine, Node assocNode, long maxFileTransferSize, boolean sdemoConnection) {
        System.out.println("[SDesktopServerInstance] About to spin up all session servers");
        this.gui = gui;
        this.controller = controller;
        this.username = username;
        this.hostname = hostname;
        this.socket = socket;
        this.transportLine = transportLine;
        this.directSocket = directSocket;
        this.assocNode = assocNode;
        gui.printToConnectionLog(this, System.currentTimeMillis(), "connection started");
        this.started = System.currentTimeMillis();
        try {
            NullServer ns;
            int SERVER_N = 0;
            ChunkFilter low_priority = Util.low_priority;
            InputStream in = this.nextReader(mxin, SERVER_N, "Session Input");
            OutputStream out = this.nextWriter(mxout, SERVER_N);
            if (!gui.isHeadless() && RDP) {
                System.out.println("[SDesktopServerInstance] Remote desktop allowed, initing InputServer");
                this.inputserver = new InputServer(this, gui, controller, in, out, connected_host, connected_port);
                this.inputserver.start();
            } else {
                System.out.println("[SDesktopServerInstance] Remote desktop NOT allowed, will not init InputServer");
                ns = new NullServer(this, controller, in, out);
                ns.start();
                ns.send(new Message(113595));
            }
            in = this.nextReader(mxin, ++SERVER_N, "Session Screen Updates");
            out = this.nextWriter(mxout, SERVER_N);
            if (RDP) {
                System.out.println("[SDesktopServerInstance] Remote desktop allowed, initing ScreenServer");
                this.screenserver = preloadedScreenServer;
                this.screenserver.initMK2_SendScreens(this, controller, in, out);
                if (this.inputserver != null) {
                    this.inputserver.setScreenServer(this.screenserver);
                }
            } else {
                System.out.println("[SDesktopServerInstance] Remote desktop NOT allowed, will not init ScreenServer");
                new NullServer(this, controller, in, out).start();
            }
            in = this.nextReader(mxin, ++SERVER_N, "Session Clipboard");
            out = this.nextWriter(mxout, SERVER_N);
            out = new ChunkFilterOutputStream(out, low_priority);
            if (FTP) {
                this.clipboardserver = new ClipboardServer(this, controller, in, out);
                this.clipboardserver.start();
            } else {
                new NullServer(this, controller, in, out).start();
            }
            in = this.nextReader(mxin, ++SERVER_N, "Session Chat");
            out = this.nextWriter(mxout, SERVER_N);
            if (CHAT) {
                this.chatserver = new ChatServer(this, controller, gui, in, out, username, hostname);
                this.chatserver.start();
            } else {
                ns = new NullServer(this, controller, in, out);
                ns.start();
                ns.send(new Message(327683));
            }
            in = this.nextReader(mxin, ++SERVER_N, "Session Whiteboard");
            out = this.nextWriter(mxout, SERVER_N);
            out = new ChunkFilterOutputStream(out, low_priority);
            if (CHAT) {
                this.wboardserver = new WhiteboardServer(this, controller, in, out, username);
                this.wboardserver.start();
            } else {
                new NullServer(this, controller, in, out).start();
            }
            in = this.nextReader(mxin, ++SERVER_N, "Session File Transfer Main (1/5)");
            out = this.nextWriter(mxout, SERVER_N);
            InputStream in2 = this.nextReader(mxin, ++SERVER_N, "Session FTP 2/5");
            OutputStream out2 = this.nextWriter(mxout, SERVER_N);
            InputStream in3 = this.nextReader(mxin, ++SERVER_N, "Session FTP 3/5");
            OutputStream out3 = this.nextWriter(mxout, SERVER_N);
            InputStream in4 = this.nextReader(mxin, ++SERVER_N, "Session FTP 4/5");
            OutputStream out4 = this.nextWriter(mxout, SERVER_N);
            InputStream in5 = this.nextReader(mxin, ++SERVER_N, "Session FTP 5/5");
            OutputStream out5 = this.nextWriter(mxout, SERVER_N);
            System.out.println("[ServerInstance] All channels OK " + ++SERVER_N);
            out2 = new ChunkFilterOutputStream(out2, low_priority);
            out3 = new ChunkFilterOutputStream(out3, low_priority);
            if (FTP) {
                this.ftpserver = new FTPServer(this, controller, in, out, in2, out2, in3, out3, in4, out4, in5, out5, this.inputserver, maxFileTransferSize);
                this.ftpserver.start();
            } else {
                new PermissionDeniedServer(this, controller, in, out).start();
                new PermissionDeniedServer(this, controller, in2, out2).start();
                new PermissionDeniedServer(this, controller, in3, out3).start();
                new PermissionDeniedServer(this, controller, in4, out4).start();
                new PermissionDeniedServer(this, controller, in5, out5).start();
            }
            in = this.nextReader(mxin, SERVER_N, "Session Async Commands");
            out = this.nextWriter(mxout, SERVER_N);
            if (RDP) {
                this.asyncserver = new AsyncServer(this, gui, controller, in, out, mmoveRequiredButFailed);
                this.asyncserver.start();
            } else {
                NullServer ns2 = new NullServer(this, controller, in, out);
                ns2.start();
                ns2.send(new Message(100488));
            }
            ++SERVER_N;
            if (!sdemoConnection) {
                in = this.nextReader(mxin, SERVER_N, "Session Port Redirect");
                out = this.nextWriter(mxout, SERVER_N);
                this.portserver = new PortRedirectServer(this, gui, controller, in, out);
                ++SERVER_N;
            }
            if (!sdemoConnection) {
                in = this.nextReader(mxin, SERVER_N, "Session Sound");
                out = this.nextWriter(mxout, SERVER_N);
                this.soundServer = new SoundServer(this, gui, controller, in, out);
                this.soundServer.start();
                ++SERVER_N;
            }
            if (!sdemoConnection) {
                in = this.nextReader(mxin, SERVER_N, "Terminal");
                out = this.nextWriter(mxout, SERVER_N);
                this.terminalServer = new TerminalServer(this, gui, controller, in, out);
                this.terminalServer.start();
                ++SERVER_N;
            }
        }
        catch (Throwable t) {
            this.log(Debugger.getStackTrace(t));
        }
    }

    public void warnPoorConnection() {
        try {
            this.asyncserver.warnPoorConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Message doTransaction(Message m) {
        return m;
    }

    public void broadcastWhiteboard(Message m) throws IOException {
        this.wboardserver.broadcastWhiteboard(m);
    }

    public void broadcastMessage(Message m) throws IOException {
        this.chatserver.broadcastMessage(m);
    }

    public void setUseHardwareAcceleratedScreenGrab(boolean b) {
        this.screenserver.setUseHardwareAcceleratedScreenGrab(b);
    }

    public Point getMouseLocation() {
        return this.inputserver.getMouseLocation();
    }

    public void sendMessageToServer_Unencrypted(Message message, boolean flushAndWait50ms) throws Exception {
        byte[] bytesToSend = MessageUtils.messageToBytes(message);
        this.socket.sendOutOfBandData_Unecrypted(Integer.toString(message.getType()), bytesToSend);
        if (flushAndWait50ms) {
            this.socket.flushAllBuffers(50);
        }
    }

    public void runCommand(String cmd, String dir, boolean elevate) {
        System.out.println("[AsyncServer] Asked to run " + cmd);
        new CommandRunner(cmd, dir, elevate).start();
    }

    class CommandRunner
    extends Thread {
        private String cmd;
        private String dir;
        private boolean elevate;

        public CommandRunner(String cmd, String dir, boolean elevate) {
            this.cmd = cmd;
            this.dir = dir;
            this.elevate = elevate;
        }

        @Override
        public void run() {
            if (this.elevate && MouseMover.getStaticMouseMover() != null) {
                System.out.println("[CommandRunner] Issuing run via mmove");
                MouseMover.runCommand(this.cmd, this.dir, this.elevate, true);
            } else {
                System.out.println("[CommandRunner] Issuing run without mmove");
                MouseMover.runCommand(this.cmd, this.dir, this.elevate, false);
            }
        }
    }

    class ReconnectStopper
    extends Thread {
        ReconnectStopper() {
        }

        @Override
        public void run() {
            SDesktopServerInstance.this.asyncserver.stopTechnicianReconnects();
        }
    }

    class CloseActionListener
    implements ActionListener {
        CloseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ReconnectStopper().start();
            SDesktopServerInstance.this.visd.setVisible(false);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SDesktopServerInstance.this.kill();
        }
    }

    class UdpTransportReestablish
    extends Thread {
        boolean direct;
        boolean allowPortScan;
        int initialKBps;

        public UdpTransportReestablish(boolean direct, boolean allowPortScan, int initialKBps) {
            this.direct = direct;
            this.allowPortScan = allowPortScan;
            this.initialKBps = initialKBps;
        }

        @Override
        public void run() {
            ConnectionSettings settings = SDesktopServerInstance.this.controller.getPreviousConnectionSettings();
            NodeLink nl = this.direct ? SHelpUdpNlNatHpMk2.establishDirectUDP(null, settings.host, settings.port, SDesktopServerInstance.this.transportLine.in, SDesktopServerInstance.this.transportLine.out, this.allowPortScan) : SHelpUdpNlNatHpMk2.establishProxiedUDP(null, settings.host, settings.port, SDesktopServerInstance.this.transportLine.in, SDesktopServerInstance.this.transportLine.out);
            if (nl != null) {
                boolean success;
                try {
                    success = SDesktopServerInstance.this.directSocket.replaceTransportWithTransportFrom(nl, SDesktopServerInstance.this.transportLine.in, SDesktopServerInstance.this.transportLine.out, 0, true);
                }
                catch (Exception x) {
                    System.out.println("UDP transport switch failed with exception: " + x);
                    x.printStackTrace();
                    success = false;
                }
                if (success) {
                    SDesktopServerInstance.this.directSocket.setInitialRateKbPerSec(this.initialKBps);
                }
                if (!success && Switches.SH_1468_nlCloseShellNlOnSwitchFail) {
                    System.out.println("UDP transport switch failed, closing shell NL");
                    nl.stop("close shell NL after failed udp transport switch");
                }
            }
        }
    }

    class NonUdpTransportReestablish
    extends Thread {
        long id;
        int type;

        public NonUdpTransportReestablish(int type, long id) {
            this.id = id;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                boolean success;
                ConnectionSettings settings = SDesktopServerInstance.this.controller.getPreviousConnectionSettings();
                NodeLink nonudp = null;
                try {
                    nonudp = SHelpNodelinkConnector.getSpecificConnection(this.type, settings.host, settings.port, null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                boolean iAmOk = nonudp != null;
                StreamUtils.writeBoolean(SDesktopServerInstance.this.transportLine.out, iAmOk);
                SDesktopServerInstance.this.transportLine.out.flush();
                boolean theyAreOk = StreamUtils.readBoolean(SDesktopServerInstance.this.transportLine.in);
                if (!iAmOk || !theyAreOk) {
                    return;
                }
                OutputStream out = nonudp.getOutputStream();
                StreamUtils.writeLong(out, BuildDateUtil.getPatchMagicBuildDate());
                out.flush();
                InputStream in = nonudp.getInputStream();
                try {
                    if (BuildDateUtil.getPatchMagicBuildDate() != StreamUtils.readLong(in)) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw new IOException("Server does not appear to be a SimpleHelp server or is an incompatible version");
                }
                int fwdID = BCUtil.getSecureRandom().nextInt();
                SHelpNodelinkPatcher.issuePatchRequestAndWait(nonudp, this.id, fwdID, SDesktopServerInstance.this.directSocket, SDesktopServerInstance.this.assocNode, false);
                try {
                    success = SDesktopServerInstance.this.directSocket.replaceTransportWithTransportFrom(nonudp, SDesktopServerInstance.this.transportLine.in, SDesktopServerInstance.this.transportLine.out, fwdID, false);
                }
                catch (Exception x) {
                    System.out.println("Non-UDP transport switch failed with exception: " + x);
                    x.printStackTrace();
                    success = false;
                }
                if (!success && Switches.SH_1468_nlCloseShellNlOnSwitchFail) {
                    System.out.println("Non-UDP transport switch failed, closing shell NL");
                    nonudp.stop("close shell NL after failed non-udp transport switch");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

