/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.peer.RobotPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OSRobotPeer {
    private AbstractPeer peer;

    public OSRobotPeer(RobotPeer rp, int peerIndex, Rectangle bounds) throws Throwable {
        Class<?> rpClass = rp.getClass();
        String rpClassName = rpClass.getName();
        if (rpClassName.equals("sun.awt.X11.XRobotPeer")) {
            this.peer = new LinuxRobotPeer(rp, rpClass);
        } else if (rpClassName.equals("sun.awt.windows.WRobotPeer")) {
            this.peer = new WindowsRobotPeer(rp, rpClass);
        } else if (rpClassName.equals("apple.awt.CRobot") || rpClassName.equals("sun.lwawt.macosx.CRobot")) {
            this.peer = new MacRobotPeer(peerIndex, rp, rpClass, bounds);
        }
    }

    public int[] getRGBPixels(Rectangle grabby, int[] dest) throws Throwable {
        return this.peer.getRGBPixels(grabby, dest);
    }

    class MacRobotPeer
    implements AbstractPeer {
        Method getScreenPixelsImpl;
        Method getScreenPixelsImpl2;
        RobotPeer rp;
        int peerIndex;
        Rectangle bounds;

        public MacRobotPeer(int peerIndex, RobotPeer rp, Class rpClass, Rectangle bounds) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
            this.rp = rp;
            this.peerIndex = peerIndex;
            this.bounds = bounds;
            try {
                this.getScreenPixelsImpl = rpClass.getDeclaredMethod("getScreenPixels", Integer.TYPE, Rectangle.class, int[].class);
                this.getScreenPixelsImpl.setAccessible(true);
            }
            catch (Throwable t) {
                this.getScreenPixelsImpl2 = rpClass.getDeclaredMethod("getScreenPixels", Rectangle.class, int[].class);
                this.getScreenPixelsImpl2.setAccessible(true);
            }
        }

        @Override
        public int[] getRGBPixels(Rectangle grabby, int[] dat) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
            if (this.getScreenPixelsImpl != null) {
                Rectangle r2 = new Rectangle(grabby.x - this.bounds.x, grabby.y - this.bounds.y, grabby.width, grabby.height);
                this.getScreenPixelsImpl.invoke((Object)this.rp, new Integer(this.peerIndex), r2, dat);
            } else {
                this.getScreenPixelsImpl2.invoke((Object)this.rp, grabby, dat);
            }
            return dat;
        }
    }

    class WindowsRobotPeer
    implements AbstractPeer {
        Field offsetField;
        Method getRGBPixelsImpl;
        RobotPeer rp;

        public WindowsRobotPeer(RobotPeer rp, Class rpClass) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
            this.rp = rp;
            this.getRGBPixelsImpl = rpClass.getDeclaredMethod("getRGBPixels", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class);
            this.getRGBPixelsImpl.setAccessible(true);
            try {
                this.offsetField = rpClass.getDeclaredField("offset");
                this.offsetField.setAccessible(true);
            }
            catch (Throwable t) {
                this.offsetField = null;
            }
        }

        @Override
        public int[] getRGBPixels(Rectangle grabby, int[] dat) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
            Rectangle grabby2 = (Rectangle)grabby.clone();
            if (this.offsetField != null) {
                Object offsetValue = this.offsetField.get(this.rp);
                if (offsetValue instanceof Point) {
                    Point offset = (Point)offsetValue;
                    grabby2.translate(offset.x, offset.y);
                } else if (offsetValue instanceof Rectangle) {
                    Rectangle offset = (Rectangle)offsetValue;
                    grabby2.translate(offset.x, offset.y);
                }
            }
            this.getRGBPixelsImpl.invoke((Object)this.rp, new Integer(grabby2.x), new Integer(grabby2.y), new Integer(grabby2.width), new Integer(grabby2.height), dat);
            return dat;
        }
    }

    class LinuxRobotPeer
    implements AbstractPeer {
        Field xgc;
        Method getRGBPixelsImpl;
        RobotPeer rp;
        Object xgcValue;

        public LinuxRobotPeer(RobotPeer rp, Class rpClass) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
            this.rp = rp;
            this.getRGBPixelsImpl = rpClass.getDeclaredMethod("getRGBPixelsImpl", Class.forName("sun.awt.X11GraphicsConfig"), Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class);
            this.getRGBPixelsImpl.setAccessible(true);
            this.xgc = rpClass.getDeclaredField("xgc");
            this.xgc.setAccessible(true);
        }

        @Override
        public int[] getRGBPixels(Rectangle grabby, int[] dat) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
            this.xgcValue = this.xgc.get(this.rp);
            this.getRGBPixelsImpl.invoke((Object)this.rp, this.xgcValue, new Integer(grabby.x), new Integer(grabby.y), new Integer(grabby.width), new Integer(grabby.height), dat);
            return dat;
        }
    }

    static interface AbstractPeer {
        public int[] getRGBPixels(Rectangle var1, int[] var2) throws Throwable;
    }
}

