/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.server.controller.NativeGrab;
import com.aem.sdesktop.server.controller.OSRobotPeer;
import com.aem.shelp.util.ScreenDimension;
import com.aem.utils.NativeLibraryLoader;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.peer.RobotPeer;
import java.lang.reflect.Field;
import utils.ostools.OS;

public class MultiScreenMapper {
    Rectangle max;
    Rectangle[] mine;
    GraphicsDevice[] devs;
    Robot[] robots;
    RobotPeer[] robotpeers;
    OSRobotPeer[] osRobotPeers;
    int xoff;
    int yoff;
    boolean notEnoughMemoryForOsPeers = false;
    NativeGrab grabUtilGrab = NativeGrab.getInstance();
    private long lastRecalculated = 0L;
    int[] subcached;
    int[] cached;

    public void cleanUpForShutdown() {
        this.mine = null;
        this.devs = null;
        this.robots = null;
        this.robotpeers = null;
        this.osRobotPeers = null;
    }

    public static void main(String[] args) throws AWTException {
        NativeLibraryLoader.loadLibrary();
        MultiScreenMapper msm = new MultiScreenMapper();
        for (Rectangle min : msm.mine) {
            System.out.println(min);
        }
        System.out.println("Max: " + msm.max);
        System.out.println(msm.translateReverseX(-1));
    }

    public MultiScreenMapper() throws AWTException {
        this.recalculateScreens();
    }

    private OSRobotPeer getOsRobotPeer(RobotPeer peer, int gdevIndex, Rectangle bounds) {
        if (peer == null) {
            return null;
        }
        if (this.notEnoughMemoryForOsPeers) {
            return null;
        }
        try {
            return new OSRobotPeer(peer, gdevIndex, bounds);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private void recalculateScreens() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (this.devs == null || devices.length != this.devs.length) {
            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                System.out.println("**Expensive** Graphics devices have changed, recalculating screens");
            }
            GraphicsDevice[] olddevs = this.devs;
            this.devs = devices;
            this.mine = new Rectangle[this.devs.length];
            Robot[] oldrobots = this.robots;
            RobotPeer[] oldpeers = this.robotpeers;
            this.robots = new Robot[this.devs.length];
            this.robotpeers = new RobotPeer[this.devs.length];
            this.osRobotPeers = new OSRobotPeer[this.devs.length];
            for (int i = 0; i < this.devs.length; ++i) {
                boolean found = false;
                if (olddevs != null) {
                    String newID = this.devs[i].getIDstring();
                    for (int k = 0; k < olddevs.length; ++k) {
                        try {
                            String oldID = olddevs[k].getIDstring();
                            if (!newID.equals(oldID)) continue;
                            this.robots[i] = oldrobots[k];
                            this.robotpeers[i] = oldpeers[k];
                            this.osRobotPeers[i] = this.getOsRobotPeer(this.robotpeers[i], i, this.mine[i]);
                            found = true;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (found) continue;
                try {
                    this.robots[i] = new Robot(this.devs[i]);
                    Field field = Robot.class.getDeclaredField("peer");
                    field.setAccessible(true);
                    this.robotpeers[i] = (RobotPeer)field.get(this.robots[i]);
                    this.osRobotPeers[i] = this.getOsRobotPeer(this.robotpeers[i], i, this.mine[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.lastRecalculated = 0L;
        }
        if (System.currentTimeMillis() - this.lastRecalculated > 5000L) {
            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                System.out.println("Recalculating screen size(s)");
            }
            for (int i = 0; i < this.devs.length; ++i) {
                Rectangle bounds = ScreenDimension.getOriginalScreenBoundsFor(i);
                System.out.println("Bounds for " + i + "=" + bounds);
                this.mine[i] = bounds;
                this.max = i == 0 ? bounds : this.max.union(bounds);
            }
            this.xoff = this.max.x;
            this.yoff = this.max.y;
            this.lastRecalculated = System.currentTimeMillis();
        }
    }

    public int translateX(int x) {
        this.recalculateScreens();
        return x + this.xoff;
    }

    public int translateY(int y) {
        this.recalculateScreens();
        return y + this.yoff;
    }

    public int translateReverseX(int x) {
        return x - this.xoff;
    }

    public int translateReverseY(int y) {
        return y - this.yoff;
    }

    public int[] getValidCoord() {
        if (this.mine.length > 0) {
            return new int[]{this.mine[0].x, this.mine[0].y};
        }
        return new int[]{0, 0};
    }

    public boolean isCoordValid(int x, int y) {
        if (OS.isWindowsVistaOrAbove()) {
            return true;
        }
        this.recalculateScreens();
        x = this.translateX(x);
        y = this.translateY(y);
        for (int i = 0; i < this.mine.length; ++i) {
            if (!this.mine[i].contains(x, y)) continue;
            return true;
        }
        return false;
    }

    private int[] getOpenGLPixels(int i, Rectangle grabby, int[] dest) {
        this.grabUtilGrab.scrapeScreensAsInts(dest, grabby.width, grabby.height, dest.length, i);
        return dest;
    }

    private int[] getNativePixels(int i, Rectangle grabby, int[] dest) {
        if (this.osRobotPeers[i] != null) {
            try {
                return this.osRobotPeers[i].getRGBPixels(grabby, dest);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    private int[] getNonNativePixels(int i, Rectangle grabby) {
        return this.robotpeers[i].getRGBPixels(grabby);
    }

    private void disableOsPeers() {
        this.subcached = null;
        this.notEnoughMemoryForOsPeers = true;
        for (int x = 0; x < this.osRobotPeers.length; ++x) {
            this.osRobotPeers[x] = null;
        }
    }

    public void temporarilyFreeMemoryAtFutureCost() {
        this.subcached = null;
        this.cached = null;
    }

    public int[] getRGBPixels(Rectangle r, boolean forceNonNative) {
        int[] data;
        if (CentralDebugging.SCR_FORCE_NON_NATIVE_GRAB) {
            forceNonNative = true;
        }
        try {
            if (this.cached != null) {
                if (this.cached.length == r.width * r.height) {
                    data = this.cached;
                } else {
                    this.cached = null;
                    this.cached = new int[r.width * r.height];
                    if (CentralDebugging.SCR_GRAB_VERBOSE) {
                        System.out.println("**Expensive** Creating new cached int array (wrong size)");
                    }
                }
            } else {
                this.cached = null;
                this.cached = new int[r.width * r.height];
                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                    System.out.println("**Expensive** Creating new cached int array (no cached int array)");
                }
            }
            data = this.cached;
        }
        catch (OutOfMemoryError e) {
            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                System.out.println("**Important** Disabling robot peers (out of memory creating cached)");
                e.printStackTrace();
            }
            this.disableOsPeers();
            if (this.cached != null) {
                if (this.cached.length == r.width * r.height) {
                    data = this.cached;
                } else {
                    this.cached = null;
                    this.cached = new int[r.width * r.height];
                    if (CentralDebugging.SCR_GRAB_VERBOSE) {
                        System.out.println("**Expensive** Post rp disabling, Creating new cached int array (wrong size)");
                    }
                }
            } else {
                this.cached = null;
                this.cached = new int[r.width * r.height];
                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                    System.out.println("**Expensive** Post rp disabling, Creating new cached int array (no cached int array)");
                }
            }
            data = this.cached;
        }
        try {
            this.recalculateScreens();
            r = new Rectangle(this.translateX(r.x), this.translateY(r.y), r.width, r.height);
            for (int i = 0; i < this.mine.length; ++i) {
                if (!this.mine[i].intersects(r)) continue;
                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                    System.out.println("Requested rectable " + r + " intersects with GD " + i + " rectangle " + this.mine[i]);
                }
                Rectangle grabby = this.mine[i].intersection(r);
                Rectangle altgrabby = (Rectangle)grabby.clone();
                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                    System.out.println("Grabbing " + grabby + " from GD " + i + " ()");
                }
                try {
                    int[] dat;
                    block48: {
                        CentralDebugging.timerStart("Grab screen pixels");
                        if (!this.notEnoughMemoryForOsPeers) {
                            if (this.subcached == null) {
                                this.subcached = new int[grabby.width * grabby.height];
                            } else if (this.subcached.length < grabby.width * grabby.height) {
                                this.subcached = null;
                                this.subcached = new int[grabby.width * grabby.height];
                            }
                        }
                        try {
                            if (!this.notEnoughMemoryForOsPeers && !forceNonNative) {
                                if (CentralDebugging.SCR_GRAB_OPENGL_NATIVE) {
                                    if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                        System.out.println("Grabbing opengl pixels (fastest)");
                                    }
                                    dat = this.getOpenGLPixels(i, grabby, this.subcached);
                                    if (CentralDebugging.SCR_GRAB_VERBOSE && dat == null) {
                                        System.out.println("OpenGL pixel grab failed (null array)");
                                    }
                                } else {
                                    if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                        System.out.println("Grabbing native pixels (faster)");
                                    }
                                    dat = this.getNativePixels(i, grabby, this.subcached);
                                    if (CentralDebugging.SCR_GRAB_VERBOSE && dat == null) {
                                        System.out.println("Native pixel grab failed (null array)");
                                    }
                                }
                            } else {
                                dat = null;
                            }
                            if (dat == null) {
                                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                    System.out.println("Grabbing non native pixels from GD (null) " + i + " " + this.robotpeers[i] + " (slower)");
                                }
                                this.subcached = null;
                                dat = this.getNonNativePixels(i, grabby);
                                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                    System.out.println("Got " + dat);
                                }
                            }
                        }
                        catch (NegativeArraySizeException e) {
                            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                System.out.println("NegativeArraySizeException, rebasing X, Y");
                            }
                            altgrabby.x -= this.mine[i].x;
                            altgrabby.y -= this.mine[i].y;
                            if (!this.notEnoughMemoryForOsPeers && !forceNonNative) {
                                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                    System.out.println("Post rebase, Grabbing native pixels (fastest)");
                                }
                                dat = this.getNativePixels(i, altgrabby, this.subcached);
                            } else {
                                dat = null;
                            }
                            if (dat != null) break block48;
                            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                System.out.println("Post rebase, Grabbing non native pixels from GD (exception) " + i + " " + this.robotpeers[i]);
                            }
                            this.subcached = null;
                            dat = this.getNonNativePixels(i, altgrabby);
                            if (!CentralDebugging.SCR_GRAB_VERBOSE) break block48;
                            System.out.println("Post rebase, Got " + dat);
                        }
                    }
                    CentralDebugging.timerStop("Grab screen pixels");
                    CentralDebugging.timerStart("Copy screen data from grab to master array");
                    for (int yy = 0; yy < grabby.height; ++yy) {
                        int lineOffset = (grabby.y - r.y + yy) * r.width;
                        int glineOffset = yy * grabby.width;
                        int colOffset = grabby.x - r.x;
                        System.arraycopy(dat, glineOffset, data, lineOffset + colOffset, grabby.width);
                    }
                    CentralDebugging.timerStop("Copy screen data from grab to master array");
                    continue;
                }
                catch (OutOfMemoryError e) {
                    if (CentralDebugging.SCR_GRAB_VERBOSE) {
                        System.out.println("**Important** Disabling robot peers (out of memory in main block of getRGBPixels)");
                        e.printStackTrace();
                    }
                    this.disableOsPeers();
                    continue;
                }
                catch (Throwable e) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Error grabbing screen data (" + e + ") from display " + i + "...\n");
                    sb.append("\tRectangle requested: " + r + "\n");
                    sb.append("\tRectangle available: " + this.mine[i] + "\n");
                    sb.append("\tIntersecting rectangle requested: " + grabby + "\n");
                    sb.append("\tGraphics Device Configuration: " + this.devs[i] + "\n");
                    System.out.println(sb);
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return data;
    }

    public Dimension getScreenSize() {
        this.recalculateScreens();
        return new Dimension(this.max.width, this.max.height);
    }
}

