/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.sdesktop.server.controller.NativeGrab;
import com.aem.utils.NativeLibraryLoader;
import java.awt.Robot;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.DataUtil;

public class LinuxKeyboardHandler {
    public static LinuxKeyboardHandler INSTANCE;
    private HashMap<Integer, KeySym> unicodeToKeySymMapping = new HashMap();

    public LinuxKeyboardHandler() throws Exception {
        INSTANCE = this;
        this.reinit();
    }

    public void reinit() throws Exception {
        this.unicodeToKeySymMapping = this.parseXModMap();
    }

    public static void main(String[] args) throws Exception {
        NativeLibraryLoader.loadLibrary(new File("lib"));
        LinuxKeyboardHandler linuxKeyboardHandler = new LinuxKeyboardHandler();
        Robot r = new Robot();
        KeySym key = linuxKeyboardHandler.getKeysToProduce(92);
        System.out.println("Found: " + key);
        Thread.sleep(2000L);
        r.keyPress(17);
        Thread.sleep(20L);
        NativeGrab.getInstance().keyDown(20);
        Thread.sleep(20L);
        NativeGrab.getInstance().keyUp(20);
        Thread.sleep(20L);
        r.keyRelease(17);
    }

    public static String getCurrentLayoutName() {
        RunCommandGetOutput.CommandResponse commandResponse = RunCommandGetOutput.runCommand(new String[]{"setxkbmap", "-print", "-verbose", "10"});
        if (commandResponse != null && commandResponse.stdout != null && commandResponse.stdout.length() > 0) {
            String[] lines;
            String data = commandResponse.stdout;
            for (String line : lines = data.split("\n")) {
                if (!line.contains("layout:")) continue;
                line = line.substring(line.indexOf(58) + 1);
                line = line.trim();
                return line;
            }
        }
        return null;
    }

    public KeySym getKeysToProduce(int c) {
        return this.unicodeToKeySymMapping.get(c);
    }

    public void dumpToStdout() {
        ArrayList<KeySym> keycodes = new ArrayList<KeySym>();
        keycodes.addAll(this.unicodeToKeySymMapping.values());
        Collections.sort(keycodes, new Comparator<KeySym>(){

            @Override
            public int compare(KeySym o1, KeySym o2) {
                return DataUtil.compare(o1.keycode, o2.keycode);
            }
        });
        for (KeySym key : keycodes) {
            System.out.println(key);
        }
    }

    private HashMap<Integer, KeySym> parseXModMap() throws Exception {
        String[] lines;
        HashMap<Integer, KeySym> unicodeToKeySymMapping = new HashMap<Integer, KeySym>();
        RunCommandGetOutput.CommandResponse result = RunCommandGetOutput.runCommand(new String[]{"xmodmap", "-pk"}, null, true, true);
        if (result != null && result.returnCode != 0) {
            result = RunCommandGetOutput.runCommand(new String[]{"/bin/bash", "xmodmap", "-pk"});
        }
        for (String line : lines = result.stdout.split("\n")) {
            Object[] elements = line.trim().split("\\s+");
            if (elements.length <= 2 || !elements[1].startsWith("0x")) continue;
            try {
                KeySym existingKey;
                Object name;
                int keychar;
                KeySym newKey;
                int index = 0;
                int keycode = Integer.parseInt(((String)elements[index++]).trim());
                if (elements.length > index + 2 && this.isSimpler(newKey = new KeySym(keycode, 0, keychar = LinuxKeyboardHandler.toKeyCode((String)elements[index++]), (String)(name = elements[index++])), existingKey = unicodeToKeySymMapping.get(keychar))) {
                    unicodeToKeySymMapping.put(keychar, newKey);
                }
                if (elements.length > index + 2) {
                    keychar = LinuxKeyboardHandler.toKeyCode((String)elements[index++]);
                    name = elements[index++];
                    existingKey = unicodeToKeySymMapping.get(keychar);
                    newKey = new KeySym(keycode, LinuxKeyboardHandler.setShiftDown(0), keychar, (String)name);
                    if (this.isSimpler(newKey, existingKey)) {
                        unicodeToKeySymMapping.put(keychar, newKey);
                    }
                }
                index += 2;
                if (elements.length <= (index += 2) + 2) continue;
                keychar = LinuxKeyboardHandler.toKeyCode((String)elements[index++]);
                name = elements[index++];
                existingKey = unicodeToKeySymMapping.get(keychar);
                newKey = new KeySym(keycode, LinuxKeyboardHandler.setAltGraphDown(0), keychar, (String)name);
                if (!this.isSimpler(newKey, existingKey)) continue;
                unicodeToKeySymMapping.put(keychar, newKey);
            }
            catch (Throwable t) {
                System.out.println(Arrays.toString(elements));
                System.out.println("[LinuxKeyboardHandler] Unable to parse " + line);
                t.printStackTrace();
            }
        }
        return unicodeToKeySymMapping;
    }

    private boolean isSimpler(KeySym newKey, KeySym existingKey) {
        if (existingKey == null) {
            return true;
        }
        return newKey.modifier < existingKey.modifier;
    }

    private static int toKeyCode(String hexKeycode) {
        if ((hexKeycode = hexKeycode.trim()).startsWith("0x")) {
            return Integer.parseInt(hexKeycode.substring(2), 16);
        }
        return Integer.parseInt(hexKeycode, 16);
    }

    public static int setAltDown(int modifiers) {
        return modifiers | 4;
    }

    public static int setShiftDown(int modifiers) {
        return modifiers | 1;
    }

    public static int setControlDown(int modifiers) {
        return modifiers | 2;
    }

    public static int setAltGraphDown(int modifiers) {
        return modifiers | 6;
    }

    public class KeySym {
        int keycode;
        int modifier;
        int unicodeChar;
        String name;

        public KeySym(int keycode, int modifier, int unicodeChar, String name) {
            this.keycode = keycode;
            this.modifier = modifier;
            this.unicodeChar = unicodeChar;
            if (name.startsWith("(")) {
                name = name.substring(1);
            }
            if (name.endsWith(")")) {
                name = name.substring(0, name.length() - 1);
            }
            this.name = name;
        }

        public String toString() {
            return this.keycode + ": 0x" + Integer.toHexString(this.unicodeChar) + "/" + this.modifier + " (" + this.name + ")";
        }
    }
}

