/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools.ui;

import com.aem.sdesktop.client.gui.tools.RecordTool;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.font.GlyphIconsLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class RecordToolButton
extends AbstractToolButton
implements ActionListener {
    private GbPanel buttonRoot = new GbPanel();
    private JLabel text = new JLabel();
    private JLabel iconLabel = new JLabel();
    private boolean isOn = false;
    private JButton testButton;
    private ChangeListener listener;
    public boolean isEnabled = true;
    private GbPanel buttonContent;
    private static final Color shadedBackground = new Color(252, 252, 252);

    public RecordToolButton(Tool tool, boolean shaded, ChangeListener listener) {
        super(tool);
        this.listener = listener;
        this.initButtonUI(shaded);
    }

    private void initButtonUI(boolean shaded) {
        if (!shaded) {
            this.buttonRoot.setBackground(Color.WHITE);
        } else {
            this.buttonRoot.setBackground(shadedBackground);
        }
        this.text.setText(this.tool.title);
        this.text.setPreferredSize(new Dimension(-1, 24));
        GlyphIconsLabel restartLabel = new GlyphIconsLabel(12.0f);
        restartLabel.setText("\ue172");
        restartLabel.setForeground(new Color(118, 118, 118));
        JPanel controlsPanel = new JPanel(new GridLayout(1, 2));
        controlsPanel.setOpaque(false);
        controlsPanel.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 0, 11));
        controlsPanel.add(restartLabel);
        restartLabel.setToolTipText(Language.get("TOOLS_RECORD_RESTART"));
        restartLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                RecordToolButton.this.restartRecording();
            }
        });
        JLabel leftIcon = new JLabel(this.tool.icon);
        leftIcon.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 8));
        this.buttonContent = new GbPanel();
        int X = 0;
        this.buttonContent.add(leftIcon, X++, 0, 1, 1, 0, 0, 17, 3);
        this.buttonContent.add(this.text, X++, 0, 1, 1, 1, 1, 17, 1);
        this.buttonContent.add(controlsPanel, X++, 0, 1, 1, 0, 1, 10, 0);
        this.buttonContent.add(this.iconLabel, X++, 0, 1, 1, 0, 0, 10, 3);
        this.buttonContent.setOpaque(false);
        this.buttonRoot.add(this.buttonContent, 0, 0, 1, 1, 100, 0, 10, 1);
        this.buttonContent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                RecordToolButton.this.buttonPressed();
            }
        });
        this.setPaused();
    }

    @Override
    public JComponent getRootComponent() {
        return this.buttonRoot;
    }

    public void setRecording() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecordToolButton.this.iconLabel.setVisible(true);
                RecordToolButton.this.text.setEnabled(true);
                RecordToolButton.this.iconLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/switch-on.svg,24"));
                RecordToolButton.this.iconLabel.repaint();
            }
        });
        this.isOn = true;
    }

    public void setPaused() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecordToolButton.this.iconLabel.setVisible(true);
                RecordToolButton.this.text.setEnabled(true);
                RecordToolButton.this.iconLabel.setIcon(ImageLoader.getImageIconDisabled("images/svg/general/switch-on.svg,24"));
                RecordToolButton.this.iconLabel.repaint();
            }
        });
        this.isOn = false;
    }

    public void setBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecordToolButton.this.iconLabel.setVisible(false);
                RecordToolButton.this.text.setEnabled(false);
                RecordToolButton.this.buttonRoot.invalidate();
            }
        });
    }

    public void setFinished(final boolean on) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (on) {
                    RecordToolButton.this.setRecording();
                } else {
                    RecordToolButton.this.setPaused();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.buttonPressed();
    }

    private void restartRecording() {
        if (!this.isEnabled) {
            return;
        }
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RecordToolButton.this.text.setEnabled(false);
                    }
                });
                try {
                    ((RecordTool)RecordToolButton.this.tool).restartRecording();
                    try {
                        Thread.sleep(Math.max(1000L, System.currentTimeMillis() - start));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RecordToolButton.this.text.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        runner.start();
    }

    private void buttonPressed() {
        if (!this.isEnabled) {
            return;
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                RecordToolButton.this.setBusy();
                if (RecordToolButton.this.isOn) {
                    if (RecordToolButton.this.tool.toolActioned()) {
                        RecordToolButton.this.setPaused();
                        if (RecordToolButton.this.listener != null) {
                            RecordToolButton.this.listener.stateChanged(new ChangeEvent(RecordToolButton.this));
                        }
                    } else {
                        RecordToolButton.this.setRecording();
                    }
                } else if (RecordToolButton.this.tool.toolActioned()) {
                    RecordToolButton.this.setRecording();
                    if (RecordToolButton.this.listener != null) {
                        RecordToolButton.this.listener.stateChanged(new ChangeEvent(RecordToolButton.this));
                    }
                } else {
                    RecordToolButton.this.setPaused();
                }
            }
        };
        runner.start();
    }

    @Override
    public void setEnabled(boolean b) {
        this.isEnabled = b;
        if (this.isEnabled) {
            this.buttonContent.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.buttonContent.setCursor(null);
        }
        if (this.testButton != null) {
            this.testButton.setEnabled(b);
        }
        this.text.setEnabled(b);
        this.iconLabel.setEnabled(b);
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.getRootComponent().setVisible(isVisible);
        ((RecordTool)this.tool).getRecordPanel().setVisible(isVisible);
    }
}

