/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools;

import com.aem.sdesktop.client.gui.tools.api.AbstractOnOffTool;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.PC;
import jwrapper.hidden.JWNativeAPI;
import utils.ostools.OS;
import utils.swing.images.ImageLoader;

public class CaptureKeys
extends AbstractOnOffTool
implements PC {
    private boolean currentState = this.isOnByDefault();

    public CaptureKeys() {
        super(Language.get("TOOLS_CAPTURE_KEYS"), CONTROL_GROUP, ImageLoader.getImageIcon("images/svg/general/funnel-abstract-blue.svg,16"));
    }

    @Override
    public int getUniqueID() {
        return 0xF00007;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean toggleOnOffTool(boolean turningOn) {
        CaptureKeys captureKeys = this;
        synchronized (captureKeys) {
            this.currentState = turningOn;
            if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
                JWNativeAPI.getInstance().setKeyboardHookEnabled(turningOn);
            }
            return true;
        }
    }

    @Override
    public boolean isOnByDefault() {
        return true;
    }

    @Override
    public boolean showForThisRemoteOS(int remoteOSBase, int remoteOSVariant) {
        return remoteOSBase == 0 && OS.isWindows();
    }

    @Override
    public boolean isAdvanced() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkDown(Throwable reason) {
        CaptureKeys captureKeys = this;
        synchronized (captureKeys) {
            System.out.println("[CaptureKeys] Session down - disabling keyboard capture");
            if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
                JWNativeAPI.getInstance().setKeyboardHookEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkOK() {
        CaptureKeys captureKeys = this;
        synchronized (captureKeys) {
            System.out.println("[CaptureKeys] Session OK - resetting keyboard capture");
            if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
                JWNativeAPI.getInstance().setKeyboardHookEnabled(this.currentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkDead(String reason) {
        CaptureKeys captureKeys = this;
        synchronized (captureKeys) {
            System.out.println("[CaptureKeys] Session dead - disabling keyboard capture");
            if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
                JWNativeAPI.getInstance().setKeyboardHookEnabled(false);
            }
        }
    }

    @Override
    public boolean isTechnicianSideOnly() {
        return true;
    }
}

