/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools;

import com.aem.sdesktop.client.gui.tools.BlankMonitorGlassDialog;
import com.aem.sdesktop.client.gui.tools.PreventControl;
import com.aem.sdesktop.client.gui.tools.api.AbstractOnOffTool;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.config.TransientTechUser;
import utils.message.Message;
import utils.ostools.OS;
import utils.swing.images.ImageLoader;

public class BlankDesktopTool
extends AbstractOnOffTool {
    private String technicianName;
    private boolean oldControlSetting = false;

    @Override
    public int getUniqueID() {
        return 0xF00008;
    }

    public BlankDesktopTool() {
        super(Language.get("TOOLS_BLANK_DESKTOP"), SECURITY_GROUP, ImageLoader.getImageIcon("images/svg/general/funnel-abstract-blue.svg,16"));
    }

    @Override
    public void setTechUser(TransientTechUser user) {
        if (user != null) {
            if (user.isServerAdmin()) {
                this.technicianName = OemBranding.OEM_ADMIN_USERNAME;
            } else {
                this.technicianName = user.displayName;
                if (this.technicianName == null) {
                    this.technicianName = "";
                }
            }
        }
    }

    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean configure() {
        String title = SessionProperties.INSTANCE.getProp(SessionProperties.PROP_BLANK_DISPLAY_TITLE, Language.get("BLANK_DISPLAY_DEFAULT_TITLE"));
        String message = SessionProperties.INSTANCE.getProp(SessionProperties.PROP_BLANK_DISPLAY_MESSAGE, this.technicianName + " " + Language.get("BLANK_DISPLAY_DEFAULT_MESSAGE"));
        if (message != null && message.startsWith("null")) {
            message = OemBranding.OEM_ADMIN_USERNAME + message.substring(4);
        }
        BlankMonitorGlassDialog gd = new BlankMonitorGlassDialog(this.getRpcForConfigurationUI(), title, message);
        message = gd.getReturnMessage();
        title = gd.getReturnTitle();
        if (title == null || message == null) {
            return false;
        }
        SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_BLANK_DISPLAY_TITLE, title);
        SessionProperties.INSTANCE.setPropNoSave(SessionProperties.PROP_BLANK_DISPLAY_MESSAGE, message);
        SessionProperties.INSTANCE.save();
        return true;
    }

    @Override
    protected boolean toggleOnOffTool(boolean turningOn) {
        PreventControl controlTool;
        String title = SessionProperties.INSTANCE.getProp(SessionProperties.PROP_BLANK_DISPLAY_TITLE, Language.get("BLANK_DISPLAY_DEFAULT_TITLE"));
        String message = SessionProperties.INSTANCE.getProp(SessionProperties.PROP_BLANK_DISPLAY_MESSAGE, this.technicianName + " " + Language.get("BLANK_DISPLAY_DEFAULT_MESSAGE"));
        if (this.technicianName != null && message.startsWith("null ")) {
            message = this.technicianName + message.substring(4);
        }
        this.toolsInterface.setBlankScreenState(turningOn, title, message);
        if (this.toolsInterface.isTechnicianSide() && (controlTool = (PreventControl)Tool.getToolByClass(PreventControl.class)) != null) {
            if (turningOn) {
                this.oldControlSetting = controlTool.getCurrentState();
                controlTool.toggleOnOffTool(true);
                controlTool.setButtonUIEnabled(false);
            } else {
                controlTool.toggleOnOffTool(this.oldControlSetting);
                controlTool.setButtonUIEnabled(true);
            }
        }
        return true;
    }

    @Override
    public boolean isOnByDefault() {
        return false;
    }

    @Override
    public boolean showForThisRemoteOS(int remoteOSBase, int remoteOSVariant) {
        return remoteOSBase == 0 && !OS.isVariantWindows8OrAbove(remoteOSVariant);
    }

    @Override
    public boolean isAdvanced() {
        return false;
    }

    @Override
    public Message getDesiredStateAsMessage() {
        String defaultMessage = this.technicianName == null ? Language.get("TECHNICIAN") + " " + Language.get("BLANK_DISPLAY_DEFAULT_MESSAGE") : this.technicianName + " " + Language.get("BLANK_DISPLAY_DEFAULT_MESSAGE");
        String title = SessionProperties.INSTANCE.getProp(SessionProperties.PROP_BLANK_DISPLAY_TITLE, Language.get("BLANK_DISPLAY_DEFAULT_TITLE"));
        String msg = SessionProperties.INSTANCE.getProp(SessionProperties.PROP_BLANK_DISPLAY_MESSAGE, defaultMessage);
        if (msg.startsWith("null ")) {
            msg = this.technicianName != null ? this.technicianName + msg.substring(4) : Language.get("TECHNICIAN") + msg.substring(4);
        }
        Message message = new Message(1);
        message.append(this.getUniqueID());
        message.append(this.currentState);
        message.append(title);
        message.append(msg);
        return message;
    }

    @Override
    public boolean isTechnicianSideOnly() {
        return false;
    }
}

