/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.terminal.process;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.terminal.process.AbstractTerminalProcess;
import com.aem.sdesktop.client.gui.terminal.process.TerminalOutputHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import utils.ostools.OS;

public class TerminalProcess
extends AbstractTerminalProcess {
    Object LOCK = new Object();
    private boolean echo;
    private Process process;
    private OutputStream controlOutputStream;
    int availableBytesInStdoutInputStream = 0;

    public TerminalProcess(TerminalOutputHandler targetOutputStream) {
        super(targetOutputStream);
        try {
            this.initProcess();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void initProcess() throws IOException {
        if (OS.isWindows()) {
            this.process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/Q"});
            this.echo = true;
        } else {
            this.process = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-i", "-l"}, new String[]{"TERM=vt100"});
        }
        new ThreadDeadDetector(this.process);
        StdInPrinter printer = new StdInPrinter("1");
        printer.in = this.process.getInputStream();
        printer.start();
        StdErrPrinter errPrinter = new StdErrPrinter("2");
        errPrinter.inErr = this.process.getErrorStream();
        errPrinter.start();
        this.controlOutputStream = this.process.getOutputStream();
    }

    @Override
    public void writeCommand(byte[] dat) throws IOException {
        if (CentralDebugging.TERMINAL_VERBOSE) {
            System.out.println("[TerminalProcess] Writing command " + dat.length + " " + Arrays.toString(dat));
        }
        this.controlOutputStream.write(dat);
        this.controlOutputStream.flush();
    }

    @Override
    public void setWinSize(int cols, int rows) {
    }

    class StdErrPrinter
    extends Thread {
        private InputStream inErr;
        private String id;

        public StdErrPrinter(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                byte[] buf = new byte[10240];
                int n = 0;
                System.out.println("[Printer] Printer " + this.id + " is running...");
                while (n != -1) {
                    while (TerminalProcess.this.availableBytesInStdoutInputStream > 0 || this.inErr.available() == 0) {
                        Thread.sleep(30L);
                    }
                    n = this.inErr.read(buf, 0, buf.length);
                    if (CentralDebugging.TERMINAL_VERBOSE) {
                        System.out.println("[TerminalProcess][err] Received data from process of " + n + " characters");
                    }
                    if (n <= 0) continue;
                    Object object = TerminalProcess.this.LOCK;
                    synchronized (object) {
                        TerminalProcess.this.targetOutputStream.write(buf, 0, n);
                    }
                }
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    class StdInPrinter
    extends Thread {
        private InputStream in;
        private String id;

        public StdInPrinter(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                byte[] buf = new byte[10240];
                int n = 0;
                System.out.println("[Printer] Printer " + this.id + " is running...");
                while (n != -1) {
                    TerminalProcess.this.availableBytesInStdoutInputStream = this.in.available();
                    n = this.in.read(buf, 0, buf.length);
                    if (CentralDebugging.TERMINAL_VERBOSE) {
                        System.out.println("[TerminalProcess][in] Received data from process of " + n + " characters");
                    }
                    if (n <= 0) continue;
                    Object object = TerminalProcess.this.LOCK;
                    synchronized (object) {
                        TerminalProcess.this.targetOutputStream.write(buf, 0, n);
                    }
                }
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    class ThreadDeadDetector
    extends Thread {
        private Process process;

        public ThreadDeadDetector(Process process) {
            this.process = process;
            this.start();
        }

        @Override
        public void run() {
            int ret = 0;
            while (true) {
                try {
                    ret = this.process.waitFor();
                    System.out.println("[ThreadDeadDetector] Terminal process has died! (" + ret + ")");
                    return;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

