/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.terminal;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.terminal.TerminalControl;
import com.aem.sdesktop.util.ClipboardUtil;
import com.grahamedgecombe.jterminal.JTerminal;
import com.grahamedgecombe.jterminal.TerminalModel;
import com.grahamedgecombe.jterminal.vt100.Vt100TerminalModel;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import utils.ostools.OS;
import utils.string.HexData;
import utils.switches.Switches;

public class TerminalUI
implements MouseListener,
KeyListener {
    private TerminalModel model = new Vt100TerminalModel(80, 25, 1000);
    private JTerminal jt = new JTerminal(this.model);
    private static boolean echo;
    private TerminalControl terminalController;
    private int remoteBase;
    private int remoteVariant;
    private int lastSizeRows = -1;
    private int lastSizeCols = -1;

    public TerminalUI(TerminalControl terminalController) {
        this.terminalController = terminalController;
        this.initUI();
    }

    public void setEnabled(boolean enabled) {
        this.jt.getRootComponent().setEnabled(enabled);
    }

    public JComponent getRootComponent() {
        return this.jt.getRootComponent();
    }

    public void setRemoteOS(int base, int variant) {
        if (CentralDebugging.TERMINAL_VERBOSE) {
            System.out.println("[TerminalUI] Set remote OS " + base + "," + variant);
        }
        this.remoteBase = base;
        this.remoteVariant = variant;
        if (!Switches.WINPTY_SUPPORT && this.remoteBase == 0) {
            echo = true;
        }
    }

    public void initUI() {
        this.jt.getRootComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TerminalUI.this.updateWindowSize();
            }
        });
        this.jt.getTerminal().addMouseListener(this);
        this.jt.getTerminal().addKeyListener(this);
        this.getRootComponent().setFocusable(true);
    }

    public void updateWindowSize() {
        int rows = (this.jt.getRootComponent().getHeight() - 6) / JTerminal.CELL_HEIGHT;
        int columns = (this.jt.getRootComponent().getWidth() - 6) / JTerminal.CELL_WIDTH;
        if (rows == 0 || columns == 0) {
            System.out.println("[TerminalUI] Avoiding resizing to r:" + rows + ",c:" + columns);
            return;
        }
        if (this.lastSizeRows == rows && this.lastSizeCols == columns) {
            return;
        }
        this.lastSizeRows = rows;
        this.lastSizeCols = columns;
        System.out.println("[TerminalUI] Set window size to r:" + rows + " x c:" + columns);
        this.jt.getModel().setWindowSize(rows, columns);
        try {
            if (this.terminalController != null) {
                this.terminalController.setWinSize(columns, rows);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.jt.getRootComponent().repaint();
    }

    public void addTerminalOutput(String string) {
        if (CentralDebugging.TERMINAL_VERBOSE) {
            System.out.println("[TerminalUI] Adding terminal output: " + HexData.stringToHexString(string));
        }
        this.jt.print(string);
        this.jt.getRootComponent().repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.jt.getTerminal().requestFocusInWindow();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!this.jt.getRootComponent().isEnabled()) {
            return;
        }
        char toWrite = e.getKeyChar();
        if (this.remoteBase == 0) {
            if (e.getKeyChar() == '\n') {
                toWrite = !Switches.WINPTY_SUPPORT ? (char)'\n' : '\r';
            } else if (e.getKeyCode() == 9) {
                toWrite = '\t';
            } else if (e.getKeyCode() == 8) {
                toWrite = '\b';
            }
        } else if (e.getKeyChar() == '\n') {
            toWrite = '\r';
        } else if (e.getKeyCode() == 9) {
            toWrite = '\t';
        } else if (e.getKeyCode() == 8) {
            toWrite = '\b';
        }
        if (toWrite == '\u0003') {
            String text = this.jt.getSelectionText();
            if ((OS.isWindows() || OS.isLinux()) && text != null) {
                System.out.println("[TerminalUI] Copying text to clipboard");
                ClipboardUtil.setClipboardAsText(text);
                return;
            }
        } else if (toWrite == '\u0016' && (OS.isWindows() || OS.isLinux())) {
            this.handlePaste();
            return;
        }
        if (this.terminalController != null) {
            this.terminalController.sendTerminalControl(toWrite);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.jt.getRootComponent().isEnabled()) {
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.jt.getRootComponent().isEnabled()) {
            return;
        }
        int len = 0;
        byte[] buf = new byte[5];
        switch (e.getKeyCode()) {
            case 86: {
                if (!OS.isMacOS() || !e.isMetaDown()) break;
                this.handlePaste();
                return;
            }
            case 37: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 68;
                len = 3;
                break;
            }
            case 39: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 67;
                len = 3;
                break;
            }
            case 38: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 65;
                len = 3;
                break;
            }
            case 40: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 66;
                len = 3;
                break;
            }
            case 67: {
                String text;
                if (!OS.isMacOS() || !e.isMetaDown() || (text = this.jt.getSelectionText()) == null) break;
                System.out.println("[TerminalUI] Copying text to clipboard (macOS)");
                ClipboardUtil.setClipboardAsText(text);
            }
        }
        if (len > 0 && this.terminalController != null) {
            this.terminalController.sendTerminalControl(buf, 0, len);
        }
    }

    private void handlePaste() {
        if (!this.jt.getRootComponent().isEnabled()) {
            return;
        }
        try {
            String text = ClipboardUtil.getClipboardAsText();
            if (text != null) {
                for (int i = 0; i < text.length(); ++i) {
                    this.terminalController.sendTerminalControl(text.charAt(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void grabFocus() {
        this.jt.getTerminal().requestFocusInWindow();
        this.updateWindowSize();
    }
}

