/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import utils.message.Message;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SysInfoPanel
extends JPanel
implements CommandResponseListener {
    ClientController con;
    JTabbedPane tabs = new JTabbedPane(2);
    boolean requested = false;

    public SysInfoPanel(ClientController con) {
        this.con = con;
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabs);
    }

    public void connected() {
        if (this.con != null) {
            this.con.registerOngoingListener(this, "sysinfo");
        }
    }

    @Override
    public void response(Message m) {
        if (m.getType() == -1061158911) {
            String name = (String)m.get(0);
            String cmd = (String)m.get(1);
            String out = (String)m.get(2);
            JTextArea area = new JTextArea();
            area.setBackground(Color.white);
            area.setEditable(false);
            area.setText(out);
            area.setFont(new Font("courier", 0, SimpleHelpLookAndFeel.scale(12)));
            JPanel tmp = new JPanel();
            tmp.setLayout(new BorderLayout());
            JLabel lab = new JLabel(Language.get("COMMAND") + ": " + cmd);
            lab.setFont(lab.getFont().deriveFont(1));
            tmp.add("North", lab);
            tmp.add("Center", new JScrollPane(area));
            this.tabs.addTab(Language.get(name), tmp);
        }
    }

    public void diagnosticsOn(boolean b) {
        if (!this.requested) {
            this.requested = true;
            Message m = new Message(-1061158911);
            if (this.con != null) {
                this.con.sendAsyncRemoteCommand(m, "sysinfo");
            }
        }
    }
}

