/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.shelp.common.Language;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class ServicesTableModel
extends SimpleTableModel {
    private final TableStructure tableStructure;

    public ServicesTableModel(SimpleList list, TableStructure tableStructure) {
        super(list, tableStructure);
        this.tableStructure = tableStructure;
    }

    private static int[] getMinColWidths() {
        return new int[]{SimpleHelpLookAndFeel.scale(100), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(100), SimpleHelpLookAndFeel.scale(100)};
    }

    private static int[] getMaxColWidths() {
        return new int[]{-1, SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(80), -1, -1};
    }

    private static int[] getPreferredColWidths() {
        return new int[]{SimpleHelpLookAndFeel.scale(200), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(200), SimpleHelpLookAndFeel.scale(200)};
    }

    public static ServicesTableModel getInstance(SimpleList<Service> list) {
        TableStructure structure = TableStructure.createTableStructure(Service.class, new String[]{"name", "started", "mode", "commandLine", "description"}, new String[]{Language.get("SERVICE_COL_NAME"), Language.get("SERVICE_COL_STARTED"), Language.get("SERVICE_COL_MODE"), Language.get("SERVICE_COL_CMDLINE"), Language.get("SERVICE_COL_DESCRIPTION")}, ServicesTableModel.getPreferredColWidths(), null);
        structure.setMaxWidths(ServicesTableModel.getMaxColWidths());
        structure.setMinWidths(ServicesTableModel.getMinColWidths());
        return new ServicesTableModel(list, structure);
    }

    public void initTableDimensions(SHJTable processTable) {
        this.tableStructure.initTableDimensions(processTable);
    }

    public static class Service {
        String name;
        String started;
        String mode;
        String commandLine;
        String description;

        public boolean isStarted() {
            return !this.started.toUpperCase().equals("NO") && !this.started.toUpperCase().equals(Language.get("FALSE"));
        }
    }
}

