/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.shelp.common.Language;
import java.util.Comparator;
import utils.osstats.Stats;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class ProcessTableModel
extends SimpleTableModel {
    private final TableStructure tableStructure;

    public ProcessTableModel(SimpleList list, TableStructure tableStructure) {
        super(list, tableStructure);
        this.tableStructure = tableStructure;
    }

    private static int[] getMinColWidths() {
        return new int[]{SimpleHelpLookAndFeel.scale(200), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(50), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(200)};
    }

    private static int[] getMaxColWidths() {
        return new int[]{-1, SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(50), -1, -1};
    }

    private static int[] getPreferredColWidths() {
        return new int[]{SimpleHelpLookAndFeel.scale(200), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(50), SimpleHelpLookAndFeel.scale(80), SimpleHelpLookAndFeel.scale(200)};
    }

    public static ProcessTableModel getInstance(SimpleList<Stats.ProcessStatistic> list) {
        TableStructure structure = TableStructure.createTableStructure(Stats.ProcessStatistic.class, new String[]{"name", "cpuPercentage", "memPercentage", "id", "user", "cmdLineArgs"}, new String[]{Language.get("PROCESS_COL_NAME"), Language.get("PROCESS_COL_CPU"), Language.get("PROCESS_COL_MEM"), Language.get("PROCESS_COL_PID"), Language.get("PROCESS_COL_USER"), Language.get("PROCESS_COL_CMDLINE")}, ProcessTableModel.getPreferredColWidths(), null);
        structure.setMaxWidths(ProcessTableModel.getMaxColWidths());
        structure.setMinWidths(ProcessTableModel.getMinColWidths());
        return new ProcessTableModel(list, structure);
    }

    public void initTableDimensions(SHJTable processTable) {
        this.tableStructure.initTableDimensions(processTable);
    }

    public static class ProcessSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            if (o1 instanceof Byte && o2 instanceof Byte) {
                return Byte.compare((Byte)o1, (Byte)o2);
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return Integer.compare((Integer)o1, (Integer)o2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

