/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;
import utils.swing.images.ImageLoader;

public class FramerateLabel
extends JLabel
implements ActionListener {
    Image ball;
    Color bg = Color.white;
    int delay = 40;
    Timer timer;
    int W = 230;
    int H = 70;
    int YDIST;
    AnimIcon icon = new AnimIcon();

    public FramerateLabel() {
        this.timer = new Timer(this.delay, this);
        this.timer.start();
        this.setIcon(this.icon);
        this.ball = ImageLoader.getAsImage("images/svg/bulbs/bulb-blue.svg,30");
        this.YDIST = this.H - this.ball.getHeight(null);
    }

    public void update(long delay) {
        this.timer.setDelay((int)delay);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
    }

    public static void main(String[] args) {
        double inc = 0.02718281828459045;
        for (double i = 1.0; i < Math.E; i += inc) {
            System.out.println(100.0 * Math.log(i));
        }
    }

    class AnimIcon
    implements Icon {
        int hpos = 0;
        int vpos = 1;
        int frame = 0;
        boolean mult = true;
        long last_paint = -1L;

        @Override
        public int getIconHeight() {
            return FramerateLabel.this.H;
        }

        @Override
        public int getIconWidth() {
            return FramerateLabel.this.W;
        }

        @Override
        public void paintIcon(Component c, Graphics g1, int x, int y) {
            int count = 1;
            if (this.last_paint != -1L) {
                long tdiff = System.currentTimeMillis() - this.last_paint;
                count = (int)(tdiff / 40L);
            }
            if (count > 24) {
                count = 25;
            }
            this.last_paint = System.currentTimeMillis();
            g1.setColor(FramerateLabel.this.bg);
            g1.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            for (int i = 0; i < count; ++i) {
                ++this.frame;
                this.hpos += 3;
                if (this.mult) {
                    this.vpos *= 2;
                    if (this.vpos > FramerateLabel.this.YDIST) {
                        this.vpos = FramerateLabel.this.YDIST;
                        this.mult = false;
                    }
                } else {
                    this.vpos /= 2;
                    if (this.vpos == 1 || this.vpos == 0) {
                        this.vpos = 1;
                        this.mult = true;
                    }
                }
                if (this.vpos > FramerateLabel.this.YDIST) {
                    // empty if block
                }
                if (this.hpos <= FramerateLabel.this.W) continue;
                this.hpos = 0;
            }
            g1.drawImage(FramerateLabel.this.ball, this.hpos, this.vpos, null);
            g1.drawImage(FramerateLabel.this.ball, this.hpos - FramerateLabel.this.W, this.vpos, null);
        }
    }
}

