/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.client.gui.ModifiedUpdater;
import com.aem.sdesktop.client.gui.ftp.BlockTransfer;
import com.aem.sdesktop.client.gui.ftp.FileJobTreeTableModel;
import com.aem.sdesktop.client.gui.ftp.FileTransferJob;
import com.aem.sdesktop.client.gui.ftp.JobStatus;
import com.aem.sdesktop.common.FileTransferStats;
import com.aem.sdesktop.common.SpecialFolderUtil;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.util.FileEntry;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.util.EasyDateTimeFormatter;
import com.aem.shelp.util.RequestFocusListener;
import com.aem.shelp.util.WEnv;
import com.aem.shelp.util.treetable.JTreeTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import utils.files.RemoteFile;
import utils.ostools.OS;
import utils.swing.SwingUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.SHJTable;
import utils.swing.components.SHProgressBarPanel;
import utils.swing.components.SHSplitPane;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.components.path.PathBar;
import utils.swing.components.path.PathBarListener;
import utils.swing.components.path.elements.FTPVolume;
import utils.swing.components.path.elements.PathElement;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHCheckBoxIcon;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.formatters.DataSizeFormatter;
import utils.swing.icons.SystemIconUtil;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableSorter;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public class FileTransferPanel
extends JPanel
implements ActionListener,
MouseListener,
KeyListener,
DropTargetListener,
PathBarListener,
ComponentListener {
    private FileTransferStats fileTransferStats = new FileTransferStats();
    private final ClientController con;
    private final GUI gui;
    private String leftSeparator = "\\";
    private String rightSeparator = "\\";
    private final FilesTableRenderer filesrenderer = new FilesTableRenderer();
    private final Icon redX = ImageLoader.getImageIcon("images/svg/general/remove.svg,24");
    private final JPanel left_panel = new JPanel();
    private final PathBar left_path_bar = new PathBar(true);
    private SimpleList<FileEntry> leftFileList = new SimpleList();
    private final JTable left_table = new SHJTable();
    private final SortWrapper<FileEntry> leftSortWrapper = new SortWrapper<FileEntry>(this.leftFileList, FileEntry.getOSDependentComparator());
    private final FilterWrapper<FileEntry> leftFilterWrapper = new FilterWrapper<FileEntry>(this.leftSortWrapper);
    private final JScrollPane left_scroll = new JScrollPane(this.left_table);
    private final JPanel centre_panel = new JPanel();
    private final JButton transfer_right = new JButton(Language.get("PUT"));
    private final JButton mirror_right = new JButton(Language.get("MIRROR"));
    private final JButton del_right = new JButton(Language.get("DELETE"));
    private final JButton new_right = new JButton(Language.get("NEW_FOLDER"));
    private final JButton name_right = new JButton(Language.get("RENAME_FILE"));
    private final JButton mirror_left = new JButton(Language.get("MIRROR"));
    private final JButton transfer_left = new JButton(Language.get("GET"));
    private final JButton del_left = new JButton(Language.get("DELETE"));
    private final JButton new_left = new JButton(Language.get("NEW_FOLDER"));
    private final JButton name_left = new JButton(Language.get("RENAME_FILE"));
    private final JPanel right_panel = new JPanel();
    private final PathBar right_path_bar = new PathBar(false);
    private SimpleList<FileEntry> rightFileList = new SimpleList();
    private final SHJTable right_table = new SHJTable();
    private final SortWrapper<FileEntry> rightSortWrapper = new SortWrapper<FileEntry>(this.rightFileList, FileEntry.getOSDependentComparator());
    private final FilterWrapper<FileEntry> rightFilterWrapper = new FilterWrapper<FileEntry>(this.rightSortWrapper);
    private final JScrollPane right_scroll = new JScrollPane(this.right_table);
    private final JPanel button_panel = new JPanel();
    private final JButton button_done = new JButton("Finished");
    private final JButton button_refresh = new JButton(Language.get("REFRESH"), ImageLoader.getImageIcon("images/svg/arrows/refresh.svg,24"));
    private final JButton button_stop = new JButton(Language.get("STOP"), ImageLoader.getImageIcon("images/svg/av/stop.svg,24"));
    private final JButton button_start = new JButton(Language.get("GO_RETRY"), ImageLoader.getImageIcon("images/svg/av/play.svg,24"));
    private final JButton button_remove = new JButton(Language.get("REMOVE"), ImageLoader.getImageIcon("images/svg/general/remove.svg,24"));
    private final Object jobs_LOCK = new Object();
    private final ArrayList<FileTransferJob> jobs = new ArrayList();
    private final FileJobTreeTableModel model = new FileJobTreeTableModel(this.jobs, this.jobs_LOCK);
    private final JTreeTable jobs_table = new JTreeTable(this.model){

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                return this.getParent().getWidth() > this.getPreferredSize().width;
            }
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                return this.getParent().getHeight() > this.getPreferredSize().height;
            }
            return super.getScrollableTracksViewportHeight();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getParent() instanceof JViewport && this.getParent().getWidth() < super.getPreferredSize().width) {
                return this.getMinimumSize();
            }
            return super.getPreferredSize();
        }
    };
    private final JScrollPane jobs_scroll = new JScrollPane(this.jobs_table);
    private boolean controlEnabled = true;
    private final FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private boolean leftShowHidden = false;
    private boolean rightShowHidden = false;
    private static final DateFormat LAST_MODIFIED_DF = DateFormat.getDateTimeInstance(2, 2);
    private JSearchTextField leftSearchTextField;
    private JSearchTextField rightSearchTextField;
    private final KeyListener keySearchListener = new KeyAdapter(){

        public void scrollToVisible(JTable table, int rowIndex) {
            if (!(table.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)table.getParent();
            Rectangle rect = table.getCellRect(rowIndex, 0, true);
            Point pt = viewport.getViewPosition();
            rect.setLocation(rect.x - pt.x, rect.y - pt.y);
            viewport.scrollRectToVisible(rect);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            char searchChar = Character.toLowerCase(e.getKeyChar());
            if (!Character.isLetter(searchChar)) {
                return;
            }
            JTable source = (JTable)e.getSource();
            FilterWrapper wrapper = FileTransferPanel.this.leftFilterWrapper;
            if (source == FileTransferPanel.this.right_table) {
                wrapper = FileTransferPanel.this.rightFilterWrapper;
            }
            int size = wrapper.size();
            for (int i = 0; i < size; ++i) {
                FileEntry entry = (FileEntry)wrapper.get(i);
                char entryChar = Character.toLowerCase(entry.name.charAt(0));
                if (entryChar < searchChar) continue;
                source.getSelectionModel().setSelectionInterval(i, i);
                this.scrollToVisible(source, i);
                return;
            }
            if (size > 0) {
                source.getSelectionModel().setSelectionInterval(size - 1, size - 1);
                this.scrollToVisible(source, size - 1);
            }
        }
    };
    private final TableSelectionListener selectionListener = new TableSelectionListener();
    private final EasyDateTimeFormatter elapsedTimeFormatter = new EasyDateTimeFormatter();
    private final Map<RemoteFile, FileEntry[]> cache = Collections.synchronizedMap(new HashMap());
    private String remoteHomeDir;
    private boolean haveSetDirsOnce = false;
    private static int TransferIDs = 0;
    private static final Object TransferID_LOCK = new Object();
    private final Object RELOAD_LOCK = new Object();
    private final JLabel statusLabel = new JLabel();
    DecimalFormat df = new DecimalFormat("###,###,###,###,##0");
    private long lastDownloadMessage = 0L;
    private int downloadPercent = 0;
    private long downloadRemaining = 0L;
    private long lastUploadMessage = 0L;
    private int uploadPercent = 0;
    private long uploadRemaining = 0L;
    private long lastUpdate = 0L;
    long lastGuiUpdate = 0L;
    private boolean ignoreVolumeSelections = false;
    private boolean viewEnabled;
    private int remoteOsBase;
    private TransientTechUser techUser;

    public FileTransferPanel(ClientController con, GUI gui) {
        this.con = con;
        this.gui = gui;
        this.initGraphics();
        this.initEventHandling();
        this.initListeners();
        this.setEnabled(false);
    }

    private FileEntry[] getSelectedValues(JTable table) {
        int[] rows;
        ArrayList result = new ArrayList();
        FilterWrapper<FileEntry> wrapper = this.leftFilterWrapper;
        if (table == this.right_table) {
            wrapper = this.rightFilterWrapper;
        }
        for (int row : rows = table.getSelectedRows()) {
            result.add(wrapper.get(row));
        }
        return result.toArray(new FileEntry[0]);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean enabled = this.isEnabled();
        enabled = enabled && this.viewEnabled;
        boolean leftEnabled = this.left_table.getSelectedRowCount() > 0;
        boolean leftNameEnabled = this.left_table.getSelectedRowCount() == 1;
        boolean rightEnabled = this.right_table.getSelectedRowCount() > 0;
        boolean rightNameEnabled = this.right_table.getSelectedRowCount() == 1;
        this.left_panel.setEnabled(enabled);
        this.left_path_bar.setEnabled(enabled);
        this.left_table.setEnabled(enabled);
        this.left_scroll.setEnabled(enabled);
        this.right_panel.setEnabled(enabled);
        this.right_path_bar.setEnabled(enabled);
        this.right_table.setEnabled(enabled);
        this.right_scroll.setEnabled(enabled);
        this.centre_panel.setEnabled(enabled && this.controlEnabled);
        this.right_path_bar.setEnabled(enabled && this.controlEnabled);
        this.new_right.setEnabled(enabled && this.controlEnabled);
        this.del_right.setEnabled(enabled && this.controlEnabled && rightEnabled);
        this.name_right.setEnabled(enabled && this.controlEnabled && rightNameEnabled);
        this.mirror_left.setEnabled(enabled && this.controlEnabled && rightEnabled);
        this.transfer_left.setEnabled(enabled && this.controlEnabled && rightEnabled);
        this.new_left.setEnabled(enabled && this.controlEnabled);
        this.del_left.setEnabled(enabled && this.controlEnabled && leftEnabled);
        this.name_left.setEnabled(enabled && this.controlEnabled && leftNameEnabled);
        this.mirror_right.setEnabled(enabled && this.controlEnabled && leftEnabled);
        this.transfer_right.setEnabled(enabled && this.controlEnabled && leftEnabled);
        this.button_panel.setEnabled(enabled);
        this.button_done.setEnabled(enabled);
        this.button_refresh.setEnabled(enabled);
        this.button_stop.setEnabled(enabled);
        this.button_start.setEnabled(enabled);
        this.button_remove.setEnabled(enabled);
        this.jobs_table.setEnabled(enabled);
        this.jobs_scroll.setEnabled(enabled);
        if (enabled) {
            this.updateJobListButtons();
        }
    }

    private void initState() {
        this.button_stop.setEnabled(false);
        this.button_start.setEnabled(false);
        this.button_remove.setEnabled(false);
        this.transfer_right.setEnabled(false);
        this.mirror_right.setEnabled(false);
        this.del_right.setEnabled(false);
        this.name_right.setEnabled(false);
        this.transfer_left.setEnabled(false);
        this.mirror_left.setEnabled(false);
        this.del_left.setEnabled(false);
        this.name_left.setEnabled(false);
        this.button_refresh.setEnabled(true);
        this.new_right.setEnabled(this.controlEnabled);
        this.new_left.setEnabled(this.controlEnabled);
    }

    private void initListeners() {
        this.jobs_table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.left_table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.right_table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.left_table.addKeyListener(this.keySearchListener);
        this.right_table.addKeyListener(this.keySearchListener);
    }

    public void setFilter(String filter, boolean immediately) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void updateJobListButtons() {
        TreePath[] paths = this.jobs_table.getTree().getSelectionPaths();
        ArrayList<Object> trimmedPaths = new ArrayList<Object>();
        if (paths != null) {
            for (TreePath path : paths) {
                if (!(path.getLastPathComponent() instanceof FileTransferJob)) continue;
                trimmedPaths.add(path.getLastPathComponent());
            }
        }
        int count = trimmedPaths.size();
        boolean haveActiveJobs = false;
        boolean haveStoppedJobs = false;
        boolean haveFinishedJobs = false;
        boolean haveWaitingJobs = false;
        for (Object e : trimmedPaths) {
            try {
                FileTransferJob job = (FileTransferJob)e;
                JobStatus js = job.getJobStatus();
                if (js.status == 1) {
                    haveActiveJobs = true;
                    continue;
                }
                if (js.status == 0) {
                    haveWaitingJobs = true;
                    continue;
                }
                if (js.status == 3) {
                    haveStoppedJobs = true;
                    continue;
                }
                if (js.status != 2) continue;
                haveFinishedJobs = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (count > 0) {
            if (haveActiveJobs || haveWaitingJobs) {
                this.button_stop.setEnabled(true);
            } else {
                this.button_stop.setEnabled(false);
            }
            if (haveStoppedJobs || haveFinishedJobs) {
                this.button_start.setEnabled(true);
            } else {
                this.button_start.setEnabled(false);
            }
            this.button_remove.setEnabled(true);
        } else {
            this.button_stop.setEnabled(false);
            this.button_start.setEnabled(false);
            this.button_remove.setEnabled(false);
        }
        this.updateStatusLabel();
    }

    public void connected() {
        this.setEnabled(true);
        this.initState();
        this.reloadVolumes();
        this.flushCache();
        this.reload(false, true, true);
    }

    private void flushCache() {
        this.cache.clear();
    }

    private FileEntry[] cachedRemoteDir(RemoteFile dir, boolean flush) {
        FileEntry[] cached = this.cache.get(dir);
        if ((cached == null || flush) && this.con != null) {
            cached = this.con.getRemoteDir(dir);
            this.cache.put(dir, cached);
        }
        return cached;
    }

    private void reloadVolumes() {
        new ReloadVolumesThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextTransferID() {
        int n;
        Object object = TransferID_LOCK;
        synchronized (object) {
            n = TransferIDs++;
        }
        return n;
    }

    private void reload(boolean force, boolean resetLeft, boolean resetRight) {
        new ReloadThread(force, resetLeft, resetRight).start();
    }

    private void initEventHandling() {
        this.button_done.addActionListener(this);
        this.button_refresh.addActionListener(this);
        this.button_stop.addActionListener(this);
        this.button_start.addActionListener(this);
        this.button_remove.addActionListener(this);
        this.left_path_bar.addPathBarListener(this);
        this.right_path_bar.addPathBarListener(this);
        this.del_left.addActionListener(this);
        this.del_right.addActionListener(this);
        this.transfer_left.addActionListener(this);
        this.transfer_right.addActionListener(this);
        this.mirror_right.addActionListener(this);
        this.mirror_left.addActionListener(this);
        this.new_left.addActionListener(this);
        this.new_right.addActionListener(this);
        this.name_left.addActionListener(this);
        this.name_right.addActionListener(this);
        this.left_table.addMouseListener(this);
        this.right_table.addMouseListener(this);
        this.left_table.addKeyListener(this);
        this.right_table.addKeyListener(this);
    }

    private void initGraphics() {
        TableStructure leftTableStructure = TableStructure.createTableStructure(TechUser.class, new String[]{"", "", ""}, new String[]{Language.get("FILES_COL_NAME"), Language.get("FILES_COL_SIZE"), Language.get("FILES_COL_MOD")});
        TableStructure rightTableStructure = TableStructure.createTableStructure(TechUser.class, new String[]{"", "", ""}, new String[]{Language.get("FILES_COL_NAME"), Language.get("FILES_COL_SIZE"), Language.get("FILES_COL_MOD")});
        leftTableStructure.setMinWidths(new int[]{160, 50, 120});
        rightTableStructure.setMinWidths(new int[]{160, 50, 120});
        leftTableStructure.setMaxWidths(new int[]{-1, 80, 150});
        rightTableStructure.setMaxWidths(new int[]{-1, 80, 150});
        leftTableStructure.setAlignment(new int[]{2, 4, 4});
        rightTableStructure.setAlignment(new int[]{2, 4, 4});
        SimpleTableModel leftTableModel = new SimpleTableModel(this.leftFilterWrapper, leftTableStructure);
        SimpleTableModel rightTableModel = new SimpleTableModel(this.rightFilterWrapper, rightTableStructure);
        leftTableModel.assignToTable(this.left_table);
        rightTableModel.assignToTable(this.right_table);
        JTableHeader header = this.left_table.getTableHeader();
        header.setDefaultRenderer(new FileTableHeaderRenderer(this.left_table));
        header.setReorderingAllowed(false);
        header = this.right_table.getTableHeader();
        header.setDefaultRenderer(new FileTableHeaderRenderer(this.right_table));
        header.setReorderingAllowed(false);
        ColumnSorter leftComparator = new ColumnSorter();
        ColumnSorter rightComparator = new ColumnSorter();
        new TableSorter<FileEntry>(this.left_table, this.leftSortWrapper, leftComparator);
        new TableSorter<FileEntry>(this.right_table, this.rightSortWrapper, rightComparator);
        this.initJobsTable(this.jobs_table, this);
        this.left_path_bar.setShowHiddenFiles(true, Language.get("FILE_TRANSFER_SHOW_HIDDEN"), new SHCheckBoxIcon(), null);
        this.right_path_bar.setShowHiddenFiles(true, Language.get("FILE_TRANSFER_SHOW_HIDDEN"), new SHCheckBoxIcon(), null);
        this.left_path_bar.setShortcutFoldersImage(ImageLoader.getImageIconDisabled("images/svg/general/star.svg,16"));
        this.right_path_bar.setShortcutFoldersImage(ImageLoader.getImageIconDisabled("images/svg/general/star.svg,16"));
        this.left_table.setRowHeight(SimpleHelpLookAndFeel.scale(22));
        this.right_table.setRowHeight(SimpleHelpLookAndFeel.scale(22));
        this.left_table.setDefaultRenderer(FileEntry.class, this.filesrenderer);
        this.left_table.setDefaultRenderer(String.class, this.filesrenderer);
        this.left_table.setDefaultRenderer(Object.class, this.filesrenderer);
        this.right_table.setDefaultRenderer(FileEntry.class, this.filesrenderer);
        this.right_table.setDefaultRenderer(String.class, this.filesrenderer);
        this.right_table.setDefaultRenderer(Object.class, this.filesrenderer);
        this.left_table.setSurrendersFocusOnKeystroke(true);
        this.right_table.setSurrendersFocusOnKeystroke(true);
        GbPanel topPanel = new GbPanel();
        JPanel fileListsPanel = new JPanel();
        fileListsPanel.setLayout(new GridLayout(1, 2));
        this.right_panel.setBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, SHStyle.BORDER_COLOR));
        this.left_panel.setBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 1, SHStyle.BORDER_COLOR));
        fileListsPanel.add(this.left_panel);
        fileListsPanel.add(this.right_panel);
        topPanel.add(fileListsPanel, 0, 1, 1, 1, 100, 100, 11, 1, new Insets(0, 0, 0, 0));
        topPanel.add(this.button_panel, 0, 3, 3, 1, 100, 1, 11, 2, new Insets(0, 0, 0, 0));
        this.del_right.setIcon(this.redX);
        this.del_left.setIcon(this.redX);
        this.mirror_left.setIcon(ImageLoader.getImageIcon("images/svg/arrows/left-moving.svg,24"));
        this.mirror_right.setIcon(ImageLoader.getImageIcon("images/svg/arrows/right-moving.svg,24"));
        this.transfer_left.setIcon(ImageLoader.getImageIcon("images/svg/arrows/left-blue.svg,24"));
        this.transfer_right.setIcon(ImageLoader.getImageIcon("images/svg/arrows/right-blue.svg,24"));
        this.new_left.setIcon(ImageLoader.getImageIcon("O[images/svg/files-folders/folder.svg,24 | images/svg/general/add.svg,12]"));
        this.new_right.setIcon(ImageLoader.getImageIcon("O[images/svg/files-folders/folder.svg,24 | images/svg/general/add.svg,12]"));
        this.name_left.setIcon(ImageLoader.getImageIcon("O[images/svg/text/text.svg,24 | images/svg/general/pencil.svg,12"));
        this.name_right.setIcon(ImageLoader.getImageIcon("O[images/svg/text/text.svg,24 | images/svg/general/pencil.svg,12"));
        this.del_right.setHorizontalAlignment(2);
        this.del_left.setHorizontalAlignment(2);
        this.mirror_left.setHorizontalAlignment(2);
        this.mirror_right.setHorizontalAlignment(2);
        this.transfer_left.setHorizontalAlignment(2);
        this.transfer_right.setHorizontalAlignment(2);
        this.new_left.setHorizontalAlignment(2);
        this.new_right.setHorizontalAlignment(2);
        this.name_left.setHorizontalAlignment(2);
        this.name_right.setHorizontalAlignment(2);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(true, this.new_left, this.name_left);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(true, this.new_right, this.name_right);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(true, this.transfer_left, this.mirror_left);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(true, this.transfer_right, this.mirror_right);
        this.mirror_left.setToolTipText(Language.get("TT_MIRROR_DOWNLOAD"));
        this.mirror_right.setToolTipText(Language.get("TT_MIRROR_UPLOAD"));
        this.transfer_left.setToolTipText(Language.get("TT_DOWNLOAD"));
        this.transfer_right.setToolTipText(Language.get("TT_UPLOAD"));
        this.del_left.setToolTipText(Language.get("TT_DELETE_LOCAL"));
        this.del_right.setToolTipText(Language.get("TT_DELETE_REMOTE"));
        this.new_left.setToolTipText(Language.get("TT_NEW_FOLDER_LOCAL"));
        this.new_right.setToolTipText(Language.get("TT_NEW_FOLDER_REMOTE"));
        this.name_left.setToolTipText(Language.get("TT_RENAME_FILE_LOCAL"));
        this.name_right.setToolTipText(Language.get("TT_RENAME_FILE_REMOTE"));
        this.button_refresh.setToolTipText(Language.get("TT_REFRESH_DIRS"));
        this.button_stop.setToolTipText(Language.get("TT_FTP_STOP"));
        this.button_start.setToolTipText(Language.get("TT_FTP_START"));
        this.button_remove.setToolTipText(Language.get("TT_FTP_REMOVE"));
        this.left_panel.setLayout(new BorderLayout());
        JPanel topLeftPanel = new JPanel(new BorderLayout());
        JLabel localLabel = new JLabel(Language.get("LOCAL_MACHINE"));
        localLabel.setHorizontalAlignment(0);
        localLabel.setBorder(SHBorderFactory.createEmptyBorder(2, 5, 2, 0));
        localLabel.setFont(SHStyle.mediumFont);
        topLeftPanel.add((Component)localLabel, "West");
        this.leftSearchTextField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.leftSearchTextField.addIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.leftSearchTextField.addIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        SwingUtil.setWidth(this.leftSearchTextField, SimpleHelpLookAndFeel.scale(150));
        topLeftPanel.add((Component)this.leftSearchTextField, "East");
        this.leftSearchTextField.setFilterListener(new MessageFieldHandler.FilterListener(){

            @Override
            public void setFilter(String filter, boolean immediately) {
                FileTransferPanel.this.setFileListSearchFilter(FileTransferPanel.this.leftSearchTextField, filter, immediately);
            }
        });
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add("Center", this.left_path_bar.getRootComponent());
        parentPanel.add("North", topLeftPanel);
        parentPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.left_panel.add("North", parentPanel);
        this.left_panel.add("Center", this.left_scroll);
        this.left_scroll.setBorder(SHBorderFactory.createEmptyBorder());
        this.right_scroll.setBorder(SHBorderFactory.createEmptyBorder());
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        int Y = 0;
        buttonsPanel.add(this.transfer_right, 0, Y++, 1, 1, 1, 0, 10, 2);
        buttonsPanel.add(this.mirror_right, 0, Y++, 1, 1, 1, 0, 10, 2);
        buttonsPanel.add(this.new_left, 0, Y++, 1, 1, 1, 0, 10, 2, new Insets(10, 2, 0, 2));
        buttonsPanel.add(this.name_left, 0, Y++, 1, 1, 1, 0, 10, 2);
        buttonsPanel.add(this.del_left, 0, Y++, 1, 1, 1, 0, 10, 2, new Insets(10, 2, 0, 2));
        this.left_panel.add("East", buttonsPanel);
        this.right_panel.setLayout(new BorderLayout());
        JPanel topRightPanel = new JPanel(new BorderLayout());
        JLabel remoteLabel = new JLabel(Language.get("REMOTE_MACHINE"));
        remoteLabel.setBorder(SHBorderFactory.createEmptyBorder(2, 5, 2, 0));
        remoteLabel.setFont(SHStyle.mediumFont);
        topRightPanel.add((Component)remoteLabel, "West");
        this.rightSearchTextField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.rightSearchTextField.addIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.rightSearchTextField.addIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        SwingUtil.setWidth(this.rightSearchTextField, SimpleHelpLookAndFeel.scale(150));
        topRightPanel.add((Component)this.rightSearchTextField, "East");
        this.rightSearchTextField.setFilterListener(new MessageFieldHandler.FilterListener(){

            @Override
            public void setFilter(String filter, boolean immediately) {
                FileTransferPanel.this.setFileListSearchFilter(FileTransferPanel.this.rightSearchTextField, filter, immediately);
            }
        });
        parentPanel = new JPanel(new BorderLayout());
        parentPanel.add("Center", this.right_path_bar.getRootComponent());
        parentPanel.add("North", topRightPanel);
        parentPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.right_path_bar.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.left_path_bar.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.right_panel.add("North", parentPanel);
        this.right_panel.add("Center", this.right_scroll);
        buttonsPanel = new GbPanel(new ScaledInsets(0, 2, 0, 2));
        Y = 0;
        buttonsPanel.add(this.transfer_left, 0, Y++, 1, 1, 1, 0, 10, 2);
        buttonsPanel.add(this.mirror_left, 0, Y++, 1, 1, 1, 0, 10, 2);
        buttonsPanel.add(this.new_right, 0, Y++, 1, 1, 1, 0, 10, 2, new Insets(10, 2, 0, 2));
        buttonsPanel.add(this.name_right, 0, Y++, 1, 1, 1, 0, 10, 2);
        buttonsPanel.add(this.del_right, 0, Y++, 1, 1, 1, 0, 10, 2, new Insets(10, 2, 0, 2));
        this.right_panel.add("West", buttonsPanel);
        this.button_panel.setLayout(new FlowLayout(1));
        this.button_panel.add(this.button_refresh);
        this.button_panel.add(new JToolBar.Separator(new Dimension(10, 10)));
        this.button_panel.add(this.button_stop);
        this.button_panel.add(new JToolBar.Separator(new Dimension(10, 10)));
        this.button_panel.add(this.button_start);
        this.button_panel.add(new JToolBar.Separator(new Dimension(10, 10)));
        this.button_panel.add(this.button_remove);
        this.button_panel.add(new JToolBar.Separator(new Dimension(10, 10)));
        this.jobs_scroll.setBorder(SHBorderFactory.createEmptyBorder());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)this.statusLabel, "Center");
        statusPanel.setBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, new Color(220, 220, 220)));
        this.statusLabel.setText(" ");
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setFont(SHStyle.smallerFont);
        this.statusLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 0));
        bottomPanel.add((Component)this.jobs_scroll, "Center");
        bottomPanel.add((Component)statusPanel, "South");
        SHSplitPane pane = new SHSplitPane(0);
        pane.setDividerLocation(0.8);
        pane.setLeftComponent(topPanel);
        pane.setRightComponent(bottomPanel);
        pane.setBorder(null);
        pane.setResizeWeight(0.5);
        pane.setOneTouchExpandable(false);
        pane.setContinuousLayout(true);
        this.setLayout(new GridLayout(1, 1));
        this.add(pane);
        new DropTarget(this.right_panel, this);
        this.right_table.addAncestorListener(new RequestFocusListener());
    }

    private void setFileListSearchFilter(JSearchTextField source, String filter, boolean immediately) {
        if (source == this.leftSearchTextField) {
            this.leftFilterWrapper.setCaseSensitive(false);
            this.leftFilterWrapper.setFilterText(filter);
        } else {
            this.rightFilterWrapper.setCaseSensitive(false);
            this.rightFilterWrapper.setFilterText(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFTPJobFinished(int jobID) {
        try {
            Object object = this.jobs_LOCK;
            synchronized (object) {
                FileTransferJob job = this.getJobWithID(jobID);
                if (job != null) {
                    JobStatus js = job.getJobStatus();
                    if (js.status != 3) {
                        js.status = 2;
                    }
                    this.model.jobFinished(job);
                }
            }
            SwingUtilities.invokeLater(new JobsRepaint());
            this.updateStatusLabel();
            if (this.gui != null) {
                this.gui.setTopLeftGreyOverlay(Language.get("FILE_TRANSFER_COMPLETE"), 3000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void updateJobsTable() {
        SwingUtilities.invokeLater(new JobsRepaint());
    }

    public void updateFTPProgressError(int jobID, String message) {
        new ProgressErrorThread(jobID, message).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFTPProgress(int jobID, long totalSize) {
        Object object = this.jobs_LOCK;
        synchronized (object) {
            JobStatus jobStatus;
            FileTransferJob job = this.getJobWithID(jobID);
            if (job != null && (jobStatus = job.getJobStatus()) != null) {
                jobStatus.totalBytes = totalSize;
            }
            this.updateStatusLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFTPProgress(int jobID, boolean upload, String dir, String file, long sent, long max, long transferred) {
        if (CentralDebugging.FILE_TRANSFER) {
            System.out.println("[FtpGui] progress job " + jobID + " " + (upload ? ">>" : "<<") + " " + file + " " + transferred + " " + sent + "/" + max);
        }
        try {
            boolean forceUpdate = false;
            if (sent == max) {
                forceUpdate = true;
            }
            Object object = this.jobs_LOCK;
            synchronized (object) {
                FileTransferJob job = this.getJobWithID(jobID);
                if (job != null) {
                    JobStatus js = job.getJobStatus();
                    if (js.status != 3) {
                        js.status = 1;
                    }
                    if (file != null) {
                        if (transferred > 0L) {
                            BlockTransfer.addBlockTransfer(transferred, System.currentTimeMillis(), js.btransfers);
                            js.transferredBytes += transferred;
                            this.fileTransferStats.totalBytesTransferred += transferred;
                        }
                        String thisFile = dir + "/" + file;
                        if (js.previousFile == null) {
                            js.previousFile = thisFile;
                            ++js.files;
                            ++this.fileTransferStats.totalFilesTransferred;
                        } else if (!js.previousFile.equals(thisFile)) {
                            ++js.files;
                            js.previousFile = thisFile;
                            ++this.fileTransferStats.totalFilesTransferred;
                        }
                    } else {
                        forceUpdate = true;
                    }
                }
            }
            if (forceUpdate || System.currentTimeMillis() - this.lastUpdate > 150L) {
                SwingUtilities.invokeLater(new JobsRepaint());
                this.lastUpdate = System.currentTimeMillis();
                if (file == null) {
                    this.reload(true, false, false);
                } else {
                    double percent = (double)sent / (double)max;
                    if (sent == 0L && max == 0L) {
                        percent = 1.0;
                    }
                    percent *= 100.0;
                    long remaining = max - sent;
                    remaining /= 1024L;
                    max /= 1024L;
                    if (upload) {
                        this.lastUploadMessage = System.currentTimeMillis();
                        this.uploadPercent = (int)percent;
                        this.uploadRemaining = remaining;
                    } else {
                        this.lastDownloadMessage = System.currentTimeMillis();
                        this.downloadPercent = (int)percent;
                        this.downloadRemaining = remaining;
                    }
                    int tot = 0;
                    int cur = 0;
                    if (System.currentTimeMillis() - this.lastDownloadMessage < 5000L) {
                        tot += 100;
                        cur += this.downloadPercent;
                    }
                    if (System.currentTimeMillis() - this.lastUploadMessage < 5000L) {
                        tot += 100;
                        cur += this.uploadPercent;
                    }
                    if (this.gui != null) {
                        this.gui.setFileTransferProgress(cur, tot);
                    }
                    this.updateStatusLabel();
                }
            }
        }
        catch (Throwable t) {
            System.out.println("Problem updating FTP progress (ignored):");
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileTransferJob getJobWithID(int jobID) {
        Object object = this.jobs_LOCK;
        synchronized (object) {
            for (FileTransferJob job : this.jobs) {
                if (job.getID() != jobID) continue;
                return job;
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<FileTransferJob> actionPerformed(Object o) {
        ArrayList<FileTransferJob> ret = null;
        if (o == this.button_done) {
            this.gui.setDefaultMode();
            return ret;
        }
        if (o == this.button_start) {
            int[] rows = this.jobs_table.getSelectedRows();
            Object object = this.jobs_LOCK;
            synchronized (object) {
                for (int row : rows) {
                    try {
                        JobStatus js;
                        FileTransferJob job = this.jobs.get(row);
                        if (job.isMirrorJob()) {
                            js = job.getJobStatus();
                        } else {
                            js = new JobStatus();
                            job.setJobStatus(js);
                        }
                        if (job.isMirrorJob()) {
                            js.status = 1;
                        } else if (job.isGetJob()) {
                            this.con.addGetRequest(job.getID(), job.getLdir(), job.getRdir(), job.getFileOrDirectoryName());
                        } else {
                            this.con.addPutRequest(job.getID(), job.getLdir(), job.getRdir(), job.getFileOrDirectoryName());
                        }
                        new SizeUpdateThread(job);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            SwingUtilities.invokeLater(new JobsRepaint());
            this.updateJobListButtons();
            return ret;
        }
        if (o == this.button_stop) {
            int[] rows = this.jobs_table.getSelectedRows();
            Object object = this.jobs_LOCK;
            synchronized (object) {
                for (int row : rows) {
                    try {
                        FileTransferJob job = this.jobs.get(row);
                        job.getJobStatus().status = 3;
                        if (job.isMirrorJob()) {
                            job.getJobStatus().status = 3;
                            continue;
                        }
                        if (job.isGetJob()) {
                            this.con.cancelGet(job.getID());
                            continue;
                        }
                        this.con.cancelPut(job.getID());
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            SwingUtilities.invokeLater(new JobsRepaint());
            this.updateJobListButtons();
            return ret;
        }
        if (o == this.button_remove) {
            int[] rows = this.jobs_table.getSelectedRows();
            Object object = this.jobs_LOCK;
            synchronized (object) {
                for (int row1 : rows) {
                    try {
                        FileTransferJob job = this.jobs.get(row1);
                        if (job.isMirrorJob()) {
                            job.getJobStatus().status = 2;
                            continue;
                        }
                        if (job.isGetJob()) {
                            this.con.cancelGet(job.getID());
                            continue;
                        }
                        this.con.cancelPut(job.getID());
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                Arrays.sort(rows);
                for (int i = rows.length - 1; i >= 0; --i) {
                    try {
                        int row = rows[i];
                        FileTransferJob removedObject = this.jobs.remove(row);
                        this.model.fireJobRemoved(removedObject);
                        continue;
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                return ret;
            }
        } else if (o == this.button_refresh) {
            this.reload(true, false, false);
            return ret;
        } else if (o == this.new_left) {
            System.out.println("[FileTransferPanel] Local current folder is " + this.left_path_bar.getCurrentFolder());
            String ldir = this.left_path_bar.getCurrentFolder().getRemotePath();
            System.out.println("[FileTransferPanel] Local path is '" + ldir + "'");
            String input = SHGlassOptionPane.showInputDialog(this.gui.getParentFrame(), Language.get("NEW_LOCAL_FOLDER_NAME"), Language.get("NEW_LOCAL_FOLDER"), ImageLoader.getImageIcon("O[images/svg/files-folders/folder.svg,24 | images/svg/general/add.svg,12]"), null, "");
            if (input != null) {
                this.con.newLocalFolder(ldir, input);
            }
            this.reload(true, false, false);
            return ret;
        } else if (o == this.new_right) {
            System.out.println("[FileTransferPanel] Remote current folder is " + this.right_path_bar.getCurrentFolder());
            String rdir = this.right_path_bar.getCurrentFolder().getRemotePath();
            System.out.println("[FileTransferPanel] Remote path is '" + rdir + "'");
            String input = SHGlassOptionPane.showInputDialog(this.gui.getParentFrame(), Language.get("NEW_REMOTE_FOLDER_NAME"), Language.get("NEW_REMOTE_FOLDER"), ImageLoader.getImageIcon("O[images/svg/files-folders/folder.svg,24 | images/svg/general/add.svg,12]"), null, "");
            if (input != null) {
                this.con.newRemoteFolder(rdir, input);
            }
            this.reload(true, false, false);
            return ret;
        } else if (o == this.name_left) {
            String ldir = this.left_path_bar.getCurrentFolder().getRemotePath();
            FileEntry[] files = this.getSelectedValues(this.left_table);
            if (files.length != 1) return ret;
            String input = SHGlassOptionPane.showInputDialog(this.gui.getParentFrame(), Language.get("RENAME_LOCAL_FILE_NAME"), Language.get("RENAME_LOCAL_FILE"), ImageLoader.getImageIcon("O[images/svg/text/text.svg,48 | images/svg/general/pencil.svg,24"), null, files[0].name);
            if (input != null) {
                this.con.renameLocalFile(ldir, files[0].name, input);
            }
            this.reload(true, false, false);
            return ret;
        } else if (o == this.name_right) {
            String rightDirectory = this.right_path_bar.getCurrentFolder().getRemotePath();
            FileEntry[] files = this.getSelectedValues(this.right_table);
            if (files.length != 1) return ret;
            String input = SHGlassOptionPane.showInputDialog(this.gui.getParentFrame(), Language.get("RENAME_REMOTE_FILE_NAME"), Language.get("RENAME_REMOTE_FILE"), ImageLoader.getImageIcon("O[images/svg/text/text.svg,48 | images/svg/general/pencil.svg,24"), null, files[0].name);
            if (input != null) {
                this.con.renameRemoteFile(rightDirectory, files[0].name, input);
            }
            this.reload(true, false, false);
            return ret;
        } else if (o == this.mirror_left) {
            ArrayList<FileTransferJob> status = this.actionPerformed(this.transfer_left);
            String ldir = this.left_path_bar.getCurrentFolder().getRemotePath();
            String rdir = this.right_path_bar.getCurrentFolder().getRemotePath();
            FileEntry[] entries = this.getSelectedValues(this.right_table);
            if (entries.length <= 0) return ret;
            String[] names = new String[entries.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = entries[i].name;
            }
            int ID = FileTransferPanel.nextTransferID();
            FileTransferJob job = FileTransferJob.newMirrorJob(ID, ldir, rdir, names[0] + "...");
            this.addJob(job);
            new ModifiedUpdater(this, this.con, job.getJobStatus(), ldir, rdir, names, status);
            return ret;
        } else if (o == this.mirror_right) {
            ArrayList<FileTransferJob> status = this.actionPerformed(this.transfer_right);
            String leftDirectory = this.left_path_bar.getCurrentFolder().getRemotePath();
            String rightDirectory = this.right_path_bar.getCurrentFolder().getRemotePath();
            FileEntry[] entries = this.getSelectedValues(this.left_table);
            if (entries.length <= 0) return ret;
            String[] names = new String[entries.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = entries[i].name;
            }
            int ID = FileTransferPanel.nextTransferID();
            FileTransferJob job = FileTransferJob.newMirrorJob(ID, leftDirectory, rightDirectory, names[0] + "...");
            this.addJob(job);
            new ModifiedUpdater(this, this.con, job.getJobStatus(), leftDirectory, rightDirectory, names, status);
            return ret;
        } else if (o == this.transfer_left) {
            String ldir = this.left_path_bar.getCurrentFolder().getRemotePath();
            String rdir = this.right_path_bar.getCurrentFolder().getRemotePath();
            FileEntry[] entries = this.getSelectedValues(this.right_table);
            try {
                boolean exists = false;
                for (FileEntry entry1 : entries) {
                    if (!this.filenameExists(this.leftFileList, entry1.name)) continue;
                    exists = true;
                    break;
                }
                boolean overwrite = true;
                if (exists) {
                    overwrite = SHGlassOptionPane.showConfirmDialog(this.gui.getParentFrame(), Language.get("OVERWRITE_MSG"), Language.get("OVERWRITE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("YES"));
                }
                if (!overwrite) return ret;
                ret = new ArrayList<FileTransferJob>();
                for (FileEntry entry : entries) {
                    String fname = entry.name;
                    int ID = FileTransferPanel.nextTransferID();
                    if ((ID = this.con.addGetRequest(ID, ldir, rdir, fname)) == -1) continue;
                    FileTransferJob job = FileTransferJob.newGetJob(ID, ldir, rdir, fname);
                    ret.add(job);
                    this.addJob(job);
                }
                return ret;
            }
            catch (Exception ee) {
                ee.printStackTrace();
                return ret;
            }
        } else if (o == this.transfer_right) {
            String leftDirectory = this.left_path_bar.getCurrentFolder().getRemotePath();
            String rightDirectory = this.right_path_bar.getCurrentFolder().getRemotePath();
            FileEntry[] entries = this.getSelectedValues(this.left_table);
            boolean exists = false;
            for (FileEntry entry1 : entries) {
                if (!this.filenameExists(this.rightFileList, entry1.name)) continue;
                exists = true;
                break;
            }
            boolean overwrite = true;
            if (exists) {
                overwrite = SHGlassOptionPane.showConfirmDialog(this.gui.getParentFrame(), Language.get("OVERWRITE_MSG"), Language.get("OVERWRITE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("YES"));
            }
            if (!overwrite) return ret;
            ret = new ArrayList();
            for (FileEntry entry : entries) {
                String fname = entry.name;
                int ID = FileTransferPanel.nextTransferID();
                if ((ID = this.con.addPutRequest(ID, leftDirectory, rightDirectory, fname)) == -1) continue;
                FileTransferJob job = FileTransferJob.newPutJob(ID, leftDirectory, rightDirectory, fname);
                ret.add(job);
                this.addJob(job);
            }
            new SizeUpdateThread(ret);
            this.reload(false, false, false);
            return ret;
        } else if (o == this.del_left) {
            FileEntry[] entries;
            if (!SHGlassOptionPane.showConfirmDialog(this.gui.getParentFrame(), Language.get("CONFIRM_DELETE_LOCAL_MSG"), Language.get("CONFIRM_DELETE_LOCAL_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("YES"))) return ret;
            String ldir = this.left_path_bar.getCurrentFolder().getRemotePath();
            for (FileEntry entry : entries = this.getSelectedValues(this.left_table)) {
                this.con.deleteLocalFile(ldir, entry.name);
            }
            this.reload(true, true, false);
            return ret;
        } else {
            FileEntry[] entries;
            if (o != this.del_right || !SHGlassOptionPane.showConfirmDialog(this.gui.getParentFrame(), Language.get("CONFIRM_DELETE_REMOTE_MSG"), Language.get("CONFIRM_DELETE_REMOTE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("YES"))) return ret;
            String rdir = this.right_path_bar.getCurrentFolder().getRemotePath();
            for (FileEntry entry : entries = this.getSelectedValues(this.right_table)) {
                this.con.deleteRemoteFile(rdir, entry.name);
            }
            this.reload(true, false, true);
        }
        return ret;
    }

    private boolean filenameExists(SimpleList<FileEntry> fileList, String name) {
        for (FileEntry entry : fileList) {
            if (!entry.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void addErrorForJob(FileTransferJob job, String error) {
        JobStatus js = job.getJobStatus();
        JobStatus.ErrorMessage eMessage = js.addFailure(job, error);
        this.model.fireErrorAdded(eMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(FileTransferJob job) {
        int indexToAdd = 0;
        Object object = this.jobs_LOCK;
        synchronized (object) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (this.jobs.get(i).isTransferring()) continue;
                indexToAdd = i;
                break;
            }
            this.jobs.add(indexToAdd, job);
        }
        this.model.fireJobAdded(job, indexToAdd);
        this.updateStatusLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatusLabel() {
        int activeCount = 0;
        long totalBytes = -1L;
        long totalBytesDone = 0L;
        Object object = this.jobs_LOCK;
        synchronized (object) {
            for (FileTransferJob job : this.jobs) {
                if (!job.isGetJob() && !job.isPutJob()) continue;
                JobStatus status = job.getJobStatus();
                if (status.status != 0 && status.status != 1) continue;
                ++activeCount;
                if (status.totalBytes != -1L) {
                    totalBytes += status.totalBytes;
                }
                totalBytesDone += status.transferredBytes;
            }
        }
        if (activeCount > 0) {
            int percent = (int)(totalBytesDone * 100L / totalBytes);
            if (percent < 0) {
                percent = 0;
            }
            this.statusLabel.setText(activeCount + " " + Language.get("FTP_STATUS") + " (" + percent + "% " + Language.get("COMPLETE") + ")");
        } else {
            this.statusLabel.setText(" ");
        }
        this.statusLabel.repaint();
    }

    public void doPut(String ldir, String rdir, String fname) {
        int ID = FileTransferPanel.nextTransferID();
        if ((ID = this.con.addPutRequest(ID, ldir, rdir, fname)) != -1) {
            FileTransferJob job = FileTransferJob.newPutJob(ID, ldir, rdir, fname);
            this.addJob(job);
            new SizeUpdateThread(job);
        }
    }

    private void changeFolder(JTable table, PathBar pathBar, String sep, boolean parent) {
        new FolderChange(table, pathBar, sep, parent).start();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object o = e.getSource();
        if (e.getKeyCode() == 10) {
            if (o == this.left_table) {
                this.changeFolder(this.left_table, this.left_path_bar, this.leftSeparator, false);
            } else if (o == this.right_table) {
                this.changeFolder(this.right_table, this.right_path_bar, this.rightSeparator, false);
            }
            e.consume();
        } else if (e.getKeyCode() == 8) {
            if (o == this.left_table) {
                this.changeFolder(this.left_table, this.left_path_bar, this.leftSeparator, true);
            } else if (o == this.right_table) {
                this.changeFolder(this.right_table, this.right_path_bar, this.rightSeparator, true);
            }
            e.consume();
        } else if (e.getKeyCode() == 127) {
            if (o == this.left_table) {
                this.actionPerformed(this.del_left);
            } else if (o == this.right_table) {
                this.actionPerformed(this.del_right);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object o = e.getSource();
        if (e.getClickCount() == 2) {
            if (o == this.left_table) {
                this.changeFolder(this.left_table, this.left_path_bar, this.leftSeparator, false);
            } else if (o == this.right_table) {
                this.changeFolder(this.right_table, this.right_path_bar, this.rightSeparator, false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            if (!this.controlEnabled) {
                dtde.dropComplete(true);
                return;
            }
            if ((dtde.getSourceActions() | 0x40000000) > 0) {
                dtde.acceptDrop(0x40000000);
            } else if ((dtde.getSourceActions() | 1) > 0) {
                dtde.acceptDrop(1);
            } else {
                dtde.acceptDrop(0);
            }
            List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            String rightDirectory = this.right_path_bar.getCurrentFolder().getRemotePath();
            boolean exists = false;
            for (File file1 : files) {
                if (!this.filenameExists(this.rightFileList, file1.getName())) continue;
                exists = true;
                break;
            }
            boolean overwrite = true;
            if (exists) {
                overwrite = SHGlassOptionPane.showConfirmDialog(this.gui.getParentFrame(), Language.get("OVERWRITE_MSG"), Language.get("OVERWRITE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("YES"));
            }
            if (overwrite) {
                ArrayList<FileTransferJob> ret = new ArrayList<FileTransferJob>();
                for (File file : files) {
                    String fname = file.getName();
                    String leftDirectory = file.getParent();
                    int ID = FileTransferPanel.nextTransferID();
                    if ((ID = this.con.addPutRequest(ID, leftDirectory, rightDirectory, fname)) == -1) continue;
                    FileTransferJob job = FileTransferJob.newPutJob(ID, leftDirectory, rightDirectory, fname);
                    ret.add(job);
                    this.addJob(job);
                }
                new SizeUpdateThread(ret);
                this.reload(false, false, false);
            }
            dtde.dropComplete(true);
        }
        catch (ClassCastException e) {
            dtde.dropComplete(true);
        }
        catch (NullPointerException e) {
            dtde.dropComplete(true);
        }
        catch (Throwable t) {
            dtde.dropComplete(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void setCanControlAndView(boolean canControl, boolean canView) {
        this.controlEnabled = canControl;
        this.viewEnabled = canView;
        this.updateEnabled();
    }

    private void initJobsTable(JTreeTable jobs_table, FileTransferPanel fileTransferPanel) {
        jobs_table.getTree().setUI(new JobsTreeUI());
        jobs_table.getTree().setRootVisible(false);
        jobs_table.getTree().setShowsRootHandles(true);
        FileTransferPanel fileTransferPanel2 = fileTransferPanel;
        fileTransferPanel2.getClass();
        jobs_table.setCellRenderer(fileTransferPanel2.new JobStatusTreeCellRenderer());
        jobs_table.setDefaultRenderer(String.class, fileTransferPanel.new JobStatusCellRenderer());
        jobs_table.setDefaultRenderer(Object.class, fileTransferPanel.new JobStatusCellRenderer());
        JTableHeader header = jobs_table.getTableHeader();
        header.setDefaultRenderer(new JobsTableHeaderRenderer(jobs_table));
        jobs_table.getColumnModel().getColumn(0).setPreferredWidth(SimpleHelpLookAndFeel.scale(300));
        jobs_table.getColumnModel().getColumn(1).setPreferredWidth(SimpleHelpLookAndFeel.scale(50));
        jobs_table.getColumnModel().getColumn(1).setMaxWidth(SimpleHelpLookAndFeel.scale(50));
        jobs_table.getColumnModel().getColumn(2).setPreferredWidth(SimpleHelpLookAndFeel.scale(40));
        jobs_table.getColumnModel().getColumn(2).setMaxWidth(SimpleHelpLookAndFeel.scale(40));
        jobs_table.getColumnModel().getColumn(3).setPreferredWidth(SimpleHelpLookAndFeel.scale(30));
        jobs_table.getColumnModel().getColumn(4).setPreferredWidth(SimpleHelpLookAndFeel.scale(30));
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        ((Window)frame).setSize(500, 500);
        frame.setDefaultCloseOperation(3);
        FileTransferPanel fileTransferPanel = new FileTransferPanel(null, null);
        fileTransferPanel.left_path_bar.setCurrentFolder(new File(System.getProperty("user.home")));
        fileTransferPanel.right_path_bar.setCurrentFolder(new File(System.getProperty("user.home")));
        fileTransferPanel.setRemoteOS(0, 7);
        fileTransferPanel.setEnabled(true);
        fileTransferPanel.setCanControlAndView(true, true);
        frame.getContentPane().add(fileTransferPanel);
        frame.setVisible(true);
        fileTransferPanel.reloadVolumes();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (FileEntry fe : fileTransferPanel.leftFilterWrapper) {
            System.out.println(fe);
        }
        for (FileEntry fe : fileTransferPanel.leftFileList) {
            System.out.println(fe);
        }
    }

    @Override
    public void selectedPathElement(PathBar source, PathElement element) {
        if (!this.ignoreVolumeSelections) {
            this.reload(false, source == this.left_path_bar, source == this.right_path_bar);
        }
    }

    @Override
    public void setShowHiddenFiles(PathBar source, boolean showHiddenFiles) {
        if (source == this.left_path_bar) {
            this.leftShowHidden = showHiddenFiles;
        } else {
            this.rightShowHidden = showHiddenFiles;
        }
        this.reload(false, source == this.left_path_bar, source == this.right_path_bar);
    }

    @Override
    public String resolveEnvironmental(String env, PathBar source) {
        String ret = null;
        if (source == this.left_path_bar) {
            ret = OS.isWindows() ? WEnv.getEnv(env) : System.getenv(env);
        } else if (source == this.right_path_bar) {
            ret = this.con.getRemoteEnv(env);
        }
        if (ret != null && (ret = ret.trim()).length() > 0 && !ret.equals(env)) {
            return ret;
        }
        return null;
    }

    public void setRemoteOS(int remoteOsBase, int remoteOsVariant) {
        this.remoteOsBase = remoteOsBase;
        this.right_path_bar.setOS(remoteOsBase);
    }

    public void setTechnicianDetails(TransientTechUser techUser) {
        this.techUser = techUser;
    }

    public FileTransferStats getFileTransferStats() {
        return this.fileTransferStats;
    }

    public class JobsTreeUI
    extends BasicTreeUI {
        private BasicTreeUI.NodeDimensionsHandler handler;

        @Override
        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            this.handler = new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    dimensions.x = 0;
                    Insets insets = JobsTreeUI.this.tree.getInsets();
                    int width = 1000;
                    dimensions.width = width - insets.left - insets.right;
                    return dimensions;
                }
            };
            return this.handler;
        }
    }

    private static class ColumnSorter
    extends TableSorter.SmartComparator<FileEntry> {
        private ColumnSorter() {
        }

        @Override
        public int compare(FileEntry o1, FileEntry o2) {
            int flip = 1;
            if (this.ascending) {
                flip = -1;
            }
            switch (this.column) {
                case 0: {
                    return flip * o1.compareTo(o2);
                }
                case 1: {
                    return flip * (o1.size < o2.size ? -1 : (o1.size == o2.size ? 0 : 1));
                }
                case 2: {
                    return flip * (o1.lastmod < o2.lastmod ? -1 : (o1.lastmod == o2.lastmod ? 0 : 1));
                }
            }
            return 0;
        }
    }

    class SizeUpdateThread
    extends Thread {
        private ArrayList<FileTransferJob> jobs;
        private FileTransferJob job;

        public SizeUpdateThread(ArrayList<FileTransferJob> jobs) {
            this.jobs = jobs;
            this.start();
        }

        public SizeUpdateThread(FileTransferJob job) {
            this.job = job;
            this.start();
        }

        @Override
        public void run() {
            if (this.job != null) {
                this.job.computeSizeToSend();
                FileTransferPanel.this.updateStatusLabel();
            } else {
                for (FileTransferJob job : this.jobs) {
                    job.computeSizeToSend();
                    FileTransferPanel.this.updateStatusLabel();
                }
            }
        }
    }

    class JobStatusCellRenderer
    extends DefaultTableCellRenderer {
        final SHProgressBarPanel progressPanel = new SHProgressBarPanel();

        JobStatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            JLabel ret = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ret.setEnabled(FileTransferPanel.this.jobs_table.isEnabled());
            ret.setDisabledIcon(null);
            ret.setHorizontalAlignment(4);
            ret.setIcon(null);
            if (value instanceof Integer) {
                Integer intVal = (Integer)value;
                if (intVal == 100) {
                    intVal = -1;
                }
                this.progressPanel.setPercentage(intVal);
                this.progressPanel.setEnabled(FileTransferPanel.this.jobs_table.isEnabled());
                this.progressPanel.setBackground(ret.getBackground());
                this.progressPanel.setForeground(ret.getForeground());
                return this.progressPanel;
            }
            return ret;
        }
    }

    private class JobStatusTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private JobStatusTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel ret = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ret.setOpaque(true);
            if (!sel) {
                if (row % 2 == 1) {
                    ret.setBackground(UIManager.getColor("Table.alternateRowColor"));
                } else {
                    ret.setBackground(Color.white);
                }
            } else {
                ret.setBackground(UIManager.getColor("Table.selectionBackground"));
            }
            if (value.getClass() == Object.class) {
                return ret;
            }
            if (value instanceof FileTransferJob) {
                FileTransferJob job = (FileTransferJob)value;
                JobStatus js = job.getJobStatus();
                String fontColor = Integer.toHexString(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST.getRGB());
                fontColor = fontColor.substring(2, fontColor.length());
                if (job.isGetJob()) {
                    ret.setText("<html><font color=\"#" + fontColor + "\">" + Language.get("GET") + "</font> " + job.getFileOrDirectoryName());
                } else if (job.isMirrorJob()) {
                    ret.setText("<html><font color=\"#" + fontColor + "\">" + Language.get("MIRROR") + "</font> " + job.getFileOrDirectoryName());
                } else {
                    ret.setText("<html><font color=\"#" + fontColor + "\">" + Language.get("PUT") + "</font> " + job.getFileOrDirectoryName());
                }
                ret.setHorizontalAlignment(2);
                switch (js.status) {
                    case 2: {
                        if (js.getFailureCount() == 0) {
                            ret.setIcon(ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
                            break;
                        }
                        if (js.getFailureCount() == js.files) {
                            ret.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16"));
                            break;
                        }
                        ret.setIcon(ImageLoader.getImageIcon(Icons.overlay("images/svg/general/ok.svg,16", "images/svg/dialogs/warning.svg,12")));
                        break;
                    }
                    case 3: {
                        ret.setIcon(ImageLoader.getImageIcon("images/svg/av/stop.svg,16"));
                        break;
                    }
                    case 1: {
                        if (js.getFailureCount() == 0) {
                            ret.setIcon(ImageLoader.getImageIcon("images/svg/av/play.svg,16"));
                            break;
                        }
                        ret.setIcon(ImageLoader.getImageIcon(Icons.overlay("images/svg/av/play.svg,16", "images/svg/dialogs/warning.svg,12")));
                        break;
                    }
                    case 0: {
                        ret.setIcon(ImageLoader.getImageIcon("images/svg/av/pause.svg,16"));
                        break;
                    }
                    default: {
                        ret.setIcon(null);
                        break;
                    }
                }
            } else {
                JobStatus.ErrorMessage message = (JobStatus.ErrorMessage)value;
                ret.setText(message.getMessage());
                ret.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16"));
            }
            return ret;
        }
    }

    private static class FileTableHeaderRenderer
    implements TableCellRenderer {
        final DefaultTableCellRenderer renderer;

        public FileTableHeaderRenderer(JTable table) {
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
            this.renderer.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            switch (col) {
                case 0: {
                    this.renderer.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.renderer.setHorizontalAlignment(4);
                }
            }
            JLabel result = (JLabel)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            result.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 3));
            return result;
        }
    }

    private static class JobsTableHeaderRenderer
    implements TableCellRenderer {
        final DefaultTableCellRenderer renderer;

        public JobsTableHeaderRenderer(JTable table) {
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
            this.renderer.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            switch (col) {
                case 0: {
                    this.renderer.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.renderer.setHorizontalAlignment(4);
                }
            }
            JLabel result = (JLabel)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            result.setBorder(SHBorderFactory.createEmptyBorder(0, 3, 0, 3));
            return result;
        }
    }

    class FolderChange
    extends Thread {
        final JTable table;
        final PathBar pathBar;
        final String sep;
        final boolean parent;

        public FolderChange(JTable table, PathBar pathBar, String sep, boolean jumpToParentDirectory) {
            this.table = table;
            this.pathBar = pathBar;
            this.sep = sep;
            this.parent = jumpToParentDirectory;
        }

        @Override
        public void run() {
            FileEntry[] fe = FileTransferPanel.this.getSelectedValues(this.table);
            if (fe.length != 1) {
                return;
            }
            FileEntry entry = fe[0];
            if (entry.folder) {
                RemoteFile dir = this.pathBar.getCurrentFolder();
                dir = new RemoteFile(dir, entry.name);
                System.out.println("[FolderChange] New folder is " + dir + " (added " + entry.name + ")");
                for (FTPVolume vol : this.pathBar.getVolumes()) {
                    if (!vol.isOSXRoot || !vol.path.equals(dir.getRemotePath())) continue;
                    dir = new RemoteFile("/", false);
                }
                ReloadThread rt = new ReloadThread(false, this.table == FileTransferPanel.this.left_table, this.table == FileTransferPanel.this.right_table);
                if (this.table == FileTransferPanel.this.left_table) {
                    rt.leftDirOverride = dir;
                } else {
                    rt.rightDirOverride = dir;
                }
                rt.run();
                FileTransferPanel.this.ignoreVolumeSelections = true;
                try {
                    this.pathBar.setCurrentFolder(dir.getFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileTransferPanel.this.ignoreVolumeSelections = false;
            }
        }
    }

    class ProgressErrorThread
    extends Thread {
        private final int jobID;
        private final String message;

        public ProgressErrorThread(int jobID, String message) {
            super("ProgressErrorThread");
            this.jobID = jobID;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileTransferJob job;
            int tries = 25;
            Object object = FileTransferPanel.this.jobs_LOCK;
            synchronized (object) {
                job = FileTransferPanel.this.getJobWithID(this.jobID);
            }
            while (tries >= 0) {
                if (job != null) {
                    try {
                        FileTransferPanel.this.addErrorForJob(job, this.message);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    return;
                }
                if (--tries <= 0) {
                    System.out.println("[FileTransferPanel] Received a warning for job " + this.jobID + " which never got created.");
                    return;
                }
                object = FileTransferPanel.this.jobs_LOCK;
                synchronized (object) {
                    try {
                        FileTransferPanel.this.jobs_LOCK.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class JobsRepaint
    implements Runnable {
        private JobsRepaint() {
        }

        @Override
        public void run() {
            FileTransferPanel.this.jobs_table.repaint();
        }
    }

    private class ReloadThread
    extends Thread {
        final boolean force;
        final boolean resetLeft;
        final boolean resetRight;
        RemoteFile leftDirOverride = null;
        RemoteFile rightDirOverride = null;

        public ReloadThread(boolean force, boolean resetLeft, boolean resetRight) {
            this.force = force;
            this.resetLeft = resetLeft;
            this.resetRight = resetRight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            FileTransferPanel.this.left_table.setCursor(Cursor.getPredefinedCursor(3));
            FileTransferPanel.this.right_table.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Object object = FileTransferPanel.this.RELOAD_LOCK;
                synchronized (object) {
                    final ArrayList leftSelected = new ArrayList();
                    final ArrayList rightSelected = new ArrayList();
                    for (int selectedIndex : FileTransferPanel.this.left_table.getSelectedRows()) {
                        if (selectedIndex < 0 || selectedIndex >= FileTransferPanel.this.leftFileList.size()) continue;
                        leftSelected.add(FileTransferPanel.this.leftFileList.get(selectedIndex));
                    }
                    for (int selectedIndex : FileTransferPanel.this.right_table.getSelectedRows()) {
                        if (selectedIndex < 0 || selectedIndex >= FileTransferPanel.this.rightFileList.size()) continue;
                        rightSelected.add(FileTransferPanel.this.rightFileList.get(selectedIndex));
                    }
                    RemoteFile leftCurrentFolder = FileTransferPanel.this.left_path_bar.getCurrentFolder();
                    RemoteFile rightCurrentFolder = FileTransferPanel.this.right_path_bar.getCurrentFolder();
                    System.out.println("[FileTransferPanel] Left current folder is " + leftCurrentFolder);
                    System.out.println("[FileTransferPanel] Right current folder is " + rightCurrentFolder);
                    RemoteFile ldir = this.leftDirOverride != null ? this.leftDirOverride : leftCurrentFolder;
                    FileTransferPanel.this.leftFileList.startBatch();
                    try {
                        FileTransferPanel.this.leftFileList.clear();
                        if (ldir != null && !ldir.isNull()) {
                            File[] files = ldir.getFile().listFiles();
                            if (files != null) {
                                for (Comparable comparable : files) {
                                    if (((File)comparable).isHidden() && !FileTransferPanel.this.leftShowHidden) continue;
                                    if (((File)comparable).isDirectory()) {
                                        FileTransferPanel.this.leftFileList.add(new FileEntry(((File)comparable).getName(), -1L, ((File)comparable).lastModified(), true, ((File)comparable).isHidden(), FileTransferPanel.this.fileSystemView.isFileSystemRoot((File)comparable), ldir));
                                        continue;
                                    }
                                    FileTransferPanel.this.leftFileList.add(new FileEntry(((File)comparable).getName(), ((File)comparable).length(), ((File)comparable).lastModified(), false, ((File)comparable).isHidden(), FileTransferPanel.this.fileSystemView.isFileSystemRoot((File)comparable), ldir));
                                }
                            }
                        } else {
                            FTPVolume[] volumes = FileTransferPanel.this.left_path_bar.getVolumes();
                            for (Comparable comparable : volumes) {
                                FileTransferPanel.this.leftFileList.add(new FileEntry(((FTPVolume)comparable).path, -1L, -1L, true, false, true, new RemoteFile(((FTPVolume)comparable).path, OS.isWindows()), ((FTPVolume)comparable).name));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        FileTransferPanel.this.leftFileList.endBatch();
                    }
                    RemoteFile rdir = this.rightDirOverride != null ? this.rightDirOverride : rightCurrentFolder;
                    FileTransferPanel.this.rightFileList.startBatch();
                    try {
                        int n;
                        FileTransferPanel.this.rightFileList.clear();
                        if (rdir != null && !rdir.isNull()) {
                            System.out.println("[FileTransferPanel] Querying remote directory " + rdir);
                            FileEntry[] files = FileTransferPanel.this.cachedRemoteDir(rdir, this.force);
                            if (files != null) {
                                void var11_23;
                                FileEntry[] fileEntryArray = files;
                                n = fileEntryArray.length;
                                boolean bl = false;
                                while (var11_23 < n) {
                                    FileEntry file = fileEntryArray[var11_23];
                                    if (!file.isHidden || FileTransferPanel.this.rightShowHidden) {
                                        FileTransferPanel.this.rightFileList.add(file);
                                    }
                                    ++var11_23;
                                }
                            }
                        } else {
                            void var11_25;
                            FTPVolume[] volumes;
                            FTPVolume[] fTPVolumeArray = volumes = FileTransferPanel.this.right_path_bar.getVolumes();
                            n = fTPVolumeArray.length;
                            boolean bl = false;
                            while (var11_25 < n) {
                                FTPVolume volume = fTPVolumeArray[var11_25];
                                FileTransferPanel.this.rightFileList.add(new FileEntry(volume.path, -1L, -1L, true, false, true, new RemoteFile(volume.path, FileTransferPanel.this.remoteOsBase == 0), volume.name));
                                ++var11_25;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        FileTransferPanel.this.rightFileList.endBatch();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int index;
                            for (FileEntry entry : leftSelected) {
                                index = FileTransferPanel.this.leftFileList.indexOf(entry);
                                if (index == -1) continue;
                                FileTransferPanel.this.left_table.addRowSelectionInterval(index, index);
                            }
                            for (FileEntry entry : rightSelected) {
                                index = FileTransferPanel.this.rightFileList.indexOf(entry);
                                if (index == -1) continue;
                                FileTransferPanel.this.right_table.addRowSelectionInterval(index, index);
                            }
                        }
                    });
                    FileTransferPanel.this.left_table.repaint();
                    FileTransferPanel.this.right_table.repaint();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            FileTransferPanel.this.left_table.setCursor(Cursor.getPredefinedCursor(0));
            FileTransferPanel.this.right_table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class ReloadVolumesThread
    extends Thread {
        private ReloadVolumesThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = FileTransferPanel.this.RELOAD_LOCK;
            synchronized (object) {
                System.out.println("[FileTransferPanel] Reloading local and remote volumes");
                FTPVolume[] lroots = PathBar.getLocalVolumes();
                FTPVolume[] specialVolumnes = SpecialFolderUtil.getSpecialFTPVolumes();
                FTPVolume[] result = new FTPVolume[lroots.length + specialVolumnes.length];
                System.arraycopy(lroots, 0, result, 0, lroots.length);
                System.arraycopy(specialVolumnes, 0, result, lroots.length, specialVolumnes.length);
                lroots = result;
                FTPVolume[] remoteroots = FileTransferPanel.this.con != null ? FileTransferPanel.this.con.getRemoteVolumes() : PathBar.getLocalVolumes();
                FileTransferPanel.this.left_path_bar.setOS(OS.base_type);
                FileTransferPanel.this.left_path_bar.setFileSystemRoots(lroots);
                FileTransferPanel.this.right_path_bar.setFileSystemRoots(remoteroots);
                FileTransferPanel.this.leftSeparator = File.separator;
                if (FileTransferPanel.this.con != null) {
                    FileTransferPanel.this.rightSeparator = FileTransferPanel.this.con.getRemoteSeparator();
                    FileTransferPanel.this.remoteHomeDir = FileTransferPanel.this.con.getRemoteHomeDir();
                } else {
                    FileTransferPanel.this.rightSeparator = File.separator;
                }
                System.out.println("[FileTransferPanel] Remote home dir is " + FileTransferPanel.this.remoteHomeDir);
                if (!FileTransferPanel.this.haveSetDirsOnce) {
                    FileTransferPanel.this.haveSetDirsOnce = true;
                    FileTransferPanel.this.left_path_bar.setCurrentFolder(new File(System.getProperty("user.home")));
                    if (FileTransferPanel.this.remoteHomeDir != null) {
                        FileTransferPanel.this.right_path_bar.setCurrentFolder(new File(FileTransferPanel.this.remoteHomeDir));
                    }
                }
            }
        }
    }

    private class FilesTableRenderer
    extends DefaultTableCellRenderer {
        private FilesTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            FileEntry fileEntry = (FileEntry)value;
            JLabel ret = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ret == null) {
                System.out.println("[FileTransferPanel] Warning! The table cell renderer is invalid [value=" + value + "]");
                return this;
            }
            if (column == 0) {
                ret.setFont(SHStyle.normalFont);
                if (fileEntry.alias != null) {
                    ret.setText(fileEntry.alias);
                } else {
                    ret.setText(fileEntry.name);
                }
                if (fileEntry.folder) {
                    ret.setToolTipText(null);
                } else {
                    ret.setToolTipText(Language.get("FILES_COL_MOD") + ": " + LAST_MODIFIED_DF.format(new Date(fileEntry.lastmod)));
                }
                if (!isSelected) {
                    ret.setForeground(Color.BLACK);
                }
                if (fileEntry.parentFile != null) {
                    File f = new File(fileEntry.parentFile.getFile(), fileEntry.name);
                    if (f.exists()) {
                        ret.setIcon(SystemIconUtil.getSystemIconFor(f));
                    } else if (fileEntry.folder) {
                        ret.setIcon(SystemIconUtil.getDefaultFolderIcon());
                    } else {
                        ret.setIcon(SystemIconUtil.getDefaultFileIcon());
                    }
                }
            } else {
                ret.setFont(SHStyle.smallerFont);
                if (!isSelected) {
                    ret.setForeground(Color.DARK_GRAY);
                }
                ret.setIcon(null);
                ret.setToolTipText(null);
            }
            if (column == 1) {
                long size = fileEntry.size;
                if (size == -1L) {
                    ret.setText("");
                } else {
                    ret.setText(DataSizeFormatter.INSTANCE.getFormattedSize(size));
                }
            }
            if (column == 2) {
                long lastMod = fileEntry.lastmod;
                if (lastMod == -1L) {
                    ret.setText("");
                } else {
                    ret.setText(FileTransferPanel.this.elapsedTimeFormatter.formatDateTime(lastMod));
                }
            }
            if (column == 0) {
                ret.setHorizontalAlignment(2);
            } else {
                ret.setHorizontalAlignment(4);
            }
            return ret;
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            if (source.equals(FileTransferPanel.this.jobs_table.getSelectionModel())) {
                FileTransferPanel.this.updateJobListButtons();
            } else if (source.equals(FileTransferPanel.this.left_table.getSelectionModel())) {
                FileTransferPanel.this.updateEnabled();
            } else if (source.equals(FileTransferPanel.this.right_table.getSelectionModel())) {
                FileTransferPanel.this.updateEnabled();
            }
        }
    }
}

