/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.shelp.common.Language;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class FPSSlider
implements ChangeListener {
    private GbPanel rootComponent = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
    private long minDelay = 0L;
    private JLabel framesLabel = new JLabel("", 0);
    private JSlider fpsSlider = new JSlider(1, 29, 29);

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public FPSSlider() {
        this.rootComponent.add(this.fpsSlider, 0, 1, 2, 1, 100, 10, 17, 2);
        this.rootComponent.add(this.framesLabel, 0, 2, 2, 1, 100, 10, 11, 2);
        this.fpsSlider.addChangeListener(this);
        this.updateLabel();
    }

    public void addChangeListener(ChangeListener listener) {
        this.fpsSlider.addChangeListener(listener);
    }

    private double getFps() {
        int value = this.fpsSlider.getValue();
        if (value == 1) {
            return 0.2;
        }
        if (value == 2) {
            return 0.25;
        }
        if (value == 3) {
            return 0.33;
        }
        if (value == 4) {
            return 0.5;
        }
        return value - 4;
    }

    private String getFpsString() {
        int value = this.fpsSlider.getValue();
        if (value == 1) {
            return Language.get("UPDATE_EVERY") + " 5 " + Language.get("SECONDS");
        }
        if (value == 2) {
            return Language.get("UPDATE_EVERY") + " 4 " + Language.get("SECONDS");
        }
        if (value == 3) {
            return Language.get("UPDATE_EVERY") + " 3 " + Language.get("SECONDS");
        }
        if (value == 4) {
            return Language.get("UPDATE_EVERY") + " 2 " + Language.get("SECONDS");
        }
        if (value == this.fpsSlider.getMaximum() && Switches.SH_TuneDialogSaysMax) {
            if (this.minDelay <= 0L) {
                return Language.get("MAXIMUM");
            }
            return Language.get("GROUP_LIMIT");
        }
        return value - 4 + " " + Language.get("UPDATES_PER_SECOND");
    }

    public long getAppropriateDelay() {
        double fps = this.getFps();
        double delay = 1000.0 / fps;
        return (long)delay;
    }

    public void setAppropriateDelay(long delayMS) {
        double fps = FPSSlider.getFPSFromDelay(delayMS);
        if (fps <= 0.2) {
            this.fpsSlider.setValue(1);
        } else if (fps <= 0.25) {
            this.fpsSlider.setValue(2);
        } else if (fps <= 0.333) {
            this.fpsSlider.setValue(3);
        } else if (fps <= 0.5) {
            this.fpsSlider.setValue(4);
        } else {
            this.fpsSlider.setValue(4 + (int)fps);
        }
    }

    public static double getFPSFromDelay(long delayMS) {
        return 1000.0 / (double)delayMS;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateLabel();
    }

    private void updateLabel() {
        this.framesLabel.setText(this.getFpsString());
    }

    public void setEnabled(boolean enabled) {
        this.rootComponent.setEnabled(enabled);
        this.framesLabel.setEnabled(enabled);
        this.fpsSlider.setEnabled(enabled);
    }

    public void setMinDelay(long minDelay) {
        this.minDelay = minDelay;
        if (minDelay > 0L) {
            double fps = FPSSlider.getFPSFromDelay(minDelay);
            int maxTick = fps <= 0.2 ? 1 : (fps <= 0.25 ? 2 : (fps <= 0.333 ? 3 : (fps <= 0.5 ? 4 : 4 + (int)fps)));
            this.fpsSlider.setMaximum(maxTick);
        }
    }
}

