/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.client.gui.CloseSessionAdvancedDialog;
import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import utils.swing.SafeDialogIcon;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class CloseSessionDialog
extends JDialog
implements ActionListener,
KeyListener {
    private JPanel main = new JPanel();
    protected JButton bok;
    protected JButton bcancel;
    protected JButton block;
    protected Object userData;
    private boolean okPressed = false;
    private boolean lockPressed = false;
    private static final int width = SimpleHelpLookAndFeel.scale(370);

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        CloseSessionDialog d = new CloseSessionDialog(frame, false);
        System.out.println(d.isOKPressed());
        CloseSessionAdvancedDialog dd = new CloseSessionAdvancedDialog(frame, true, true, "test", true);
        dd.setVisible(true);
    }

    public CloseSessionDialog(JFrame owner, boolean showLockOption) {
        super(owner);
        if (!showLockOption) {
            this.lockPressed = true;
        }
        this.setUndecorated(true);
        this.setTitle(Language.get("CONFIRM_CLOSE_TITLE"));
        this.initUI(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), showLockOption);
        this.setResizable(false);
        this.setSize(width, 120 + SimpleHelpFrame.EMPTY_WINDOW_DECORATIONS_HEIGHT);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke1 = KeyStroke.getKeyStroke(27, 0);
        KeyStroke stroke2 = KeyStroke.getKeyStroke(10, 0);
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloseSessionDialog.this.cancelPressed();
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloseSessionDialog.this.okPressed();
            }
        };
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(stroke1, "EXIT");
        rootPane.getActionMap().put("EXIT", exitAction);
        inputMap.put(stroke2, "OK");
        rootPane.getActionMap().put("OK", okAction);
        return rootPane;
    }

    private String getDescription() {
        return Language.get("CONFIRM_CLOSE");
    }

    private void initUI(Icon icon, boolean showLockOption) {
        SafeDialogIcon.setDialogIcon((JDialog)this, ClientBranding.get().getLogo32(true));
        this.main.setLayout(new BorderLayout());
        this.main.setBorder(SHBorderFactory.createLineBorder(SHStyle.BORDER_COLOR_LIGHT));
        GbPanel contentPanel = new GbPanel();
        JWrapLabel title = new JWrapLabel("<HTML><B>" + Language.get("CONFIRM_CLOSE_TITLE") + "</HTML>");
        title.setBorder(SHBorderFactory.createEmptyBorder(20, 10, 0, 0));
        contentPanel.add(title, 0, 0, 1, 1, 1, 0, 10, 2);
        JWrapLabel label = new JWrapLabel("<HTML>" + this.getDescription() + "</HTML>");
        label.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 0));
        contentPanel.add(label, 0, 1, 1, 1, 1, 1, 11, 2);
        this.main.add("Center", contentPanel);
        if (icon != null) {
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setBorder(SHBorderFactory.createEmptyBorder(20, 20, 10, 10));
            iconLabel.setVerticalAlignment(1);
            this.main.add("West", iconLabel);
        }
        this.bok = new JButton(Language.get("CLOSE_SESSION"));
        this.bok.requestFocusInWindow();
        this.block = new JButton(Language.get("CLOSE_SESSION_LOCK"));
        this.block.addActionListener(this);
        this.getRootPane().setDefaultButton(this.bok);
        SHButtonUI.makeButtonBlue(this.bok);
        this.bcancel = new JButton(Language.get("CANCEL"));
        this.bcancel.addActionListener(this);
        JPanel buttons = new JPanel(new BorderLayout());
        JPanel buttonLeft = new JPanel();
        buttonLeft.setLayout(new FlowLayout(2, 10, 10));
        buttonLeft.add(this.bcancel);
        JPanel buttonRight = new JPanel();
        buttonRight.setLayout(new FlowLayout(2, 10, 10));
        if (showLockOption) {
            buttonRight.add(this.block);
        }
        buttonRight.add(this.bok);
        buttons.add((Component)buttonLeft, "West");
        buttons.add((Component)buttonRight, "East");
        this.main.add("South", buttons);
        this.bok.addActionListener(this);
        this.getContentPane().add(this.main);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bok) {
            this.okPressed();
        } else if (e.getSource() == this.block) {
            this.lockPressed();
        } else {
            this.cancelPressed();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.okPressed();
        } else if (e.getKeyCode() == 27) {
            this.cancelPressed();
        }
    }

    private void okPressed() {
        this.okPressed = true;
        this.setVisible(false);
    }

    private void lockPressed() {
        this.lockPressed = true;
        this.setVisible(false);
    }

    protected void cancelPressed() {
        this.setVisible(false);
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }

    public boolean isLockPressed() {
        return this.lockPressed;
    }
}

