/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import utils.swing.JFixedWidthTextField;
import utils.swing.SafeDialogIcon;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class CloseSessionAdvancedDialog
extends JDialog
implements ActionListener,
KeyListener {
    private boolean allowComments = false;
    private boolean emailCust = false;
    private boolean allowSkip = false;
    private String customerEmailAddress = null;
    private JTextArea technicianNotes = new JTextArea();
    private JScrollPane pane = new JScrollPane(this.technicianNotes);
    private JCheckBox sendCustomerEmail;
    private JFixedWidthTextField sendCustomerEmailAddress;
    private JButton saveButton;
    private JButton skipButton;
    private JLabel warningIcon;
    private boolean okPressed = false;
    private boolean skipPressed = false;
    public String comments = null;
    public boolean sendCustomerEmailOption = false;
    public String customerEmailAddressOption = null;

    public CloseSessionAdvancedDialog(JFrame owner, boolean allowComments, boolean emailCust, String customerEmailAddress, boolean allowSkip) {
        super(owner, Language.get("CONFIRM_CLOSE_TITLE"), true);
        this.allowComments = allowComments;
        this.allowSkip = allowSkip;
        this.emailCust = emailCust;
        this.customerEmailAddress = customerEmailAddress;
        this.initGraphics();
        this.setResizable(false);
        int height = 180 + SimpleHelpFrame.EMPTY_WINDOW_DECORATIONS_HEIGHT;
        if (allowComments) {
            height += 250;
        }
        if (emailCust) {
            height += 20;
        }
        this.setSize(500, height);
        this.setLocationRelativeTo(owner);
    }

    public boolean isOK() {
        return this.okPressed;
    }

    public boolean isCancel() {
        return !this.okPressed && !this.skipPressed;
    }

    public boolean isSkip() {
        return this.skipPressed;
    }

    private void initGraphics() {
        SafeDialogIcon.setDialogIcon((JDialog)this, ClientBranding.get().getLogo32(true));
        this.technicianNotes.setBackground(UIManager.getColor("TextField.background"));
        JPanel panel = new JPanel();
        panel.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        JWrapLabel label = new JWrapLabel("<html>" + Language.get("CONFIRM_CLOSE") + "</html>");
        this.warningIcon = new JLabel(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"));
        this.skipButton = new JButton(Language.get("SKIP"), ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
        this.saveButton = new JButton(Language.get("CLOSE_SESSION"), ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
        this.sendCustomerEmail = new JCheckBox(Language.get("ARCHIVE_SEND_CUSTOMER"));
        this.sendCustomerEmailAddress = new JFixedWidthTextField();
        this.sendCustomerEmailAddress.addKeyListener(this);
        this.skipButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.sendCustomerEmail.addActionListener(this);
        GbPanel buttonPanel = new GbPanel();
        if (this.allowSkip) {
            SwingUtil.setSizesToWidest(this.saveButton, this.skipButton);
            buttonPanel.add(this.saveButton, 0, 0, 1, 1, 0, 1, 13, 0, new Insets(0, 0, 0, 10));
            buttonPanel.add(this.skipButton, 1, 0, 1, 1, 0, 1, 17, 0, new Insets(0, 10, 0, 0));
        } else {
            buttonPanel.add(this.saveButton, 0, 0, 1, 1, 0, 1, 13, 0, new Insets(0, 0, 0, 10));
        }
        RoundBorderPanel logPanel = new RoundBorderPanel(Language.get("CLOSE_SESSION_BORDER"));
        GridBagLayout gbl2 = new GridBagLayout();
        logPanel.setLayout(gbl2);
        int Y = 0;
        if (this.allowComments) {
            gbl2.setConstraints(this.pane, new GridBagConstraints(0, Y++, 2, 1, 1.0, 100.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            ((Container)logPanel).add(this.pane);
        }
        if (this.emailCust) {
            if (this.customerEmailAddress != null && this.customerEmailAddress.length() > 0) {
                this.sendCustomerEmail.setSelected(true);
            } else {
                this.sendCustomerEmail.setSelected(false);
            }
            if (this.customerEmailAddress != null) {
                this.sendCustomerEmailAddress.setText(this.customerEmailAddress);
            }
            gbl2.setConstraints(this.sendCustomerEmail, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            ((Container)logPanel).add(this.sendCustomerEmail);
            gbl2.setConstraints(this.sendCustomerEmailAddress, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 5, 0), 200, 0));
            ((Container)logPanel).add(this.sendCustomerEmailAddress);
        }
        Y = 0;
        gbl.setConstraints(this.warningIcon, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(this.warningIcon);
        gbl.setConstraints(label, new GridBagConstraints(1, Y++, 1, 1, 100.0, 1.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        panel.add(label);
        gbl.setConstraints(logPanel, new GridBagConstraints(0, Y++, 2, 1, 1.0, 100.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(logPanel);
        gbl.setConstraints(buttonPanel, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(buttonPanel);
        this.getContentPane().add(panel);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke1 = KeyStroke.getKeyStroke(27, 0);
        KeyStroke stroke2 = KeyStroke.getKeyStroke(10, 0);
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloseSessionAdvancedDialog.this.cancelOption();
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloseSessionAdvancedDialog.this.okOption();
            }
        };
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(stroke1, "EXIT");
        rootPane.getActionMap().put("EXIT", exitAction);
        inputMap.put(stroke2, "OK");
        rootPane.getActionMap().put("OK", okAction);
        return rootPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.saveButton)) {
            this.okOption();
        } else if (e.getSource().equals(this.skipButton)) {
            this.skipOption();
        } else if (e.getSource().equals(this.sendCustomerEmail)) {
            if (this.sendCustomerEmail.isSelected() && this.sendCustomerEmailAddress.getText().trim().length() == 0) {
                this.saveButton.setEnabled(false);
            } else {
                this.saveButton.setEnabled(true);
            }
        }
    }

    private void okOption() {
        this.okPressed = true;
        this.comments = this.technicianNotes.getText();
        this.sendCustomerEmailOption = this.sendCustomerEmail.isSelected();
        this.customerEmailAddressOption = this.sendCustomerEmailAddress.getText();
        this.setVisible(false);
    }

    private void cancelOption() {
        this.setVisible(false);
    }

    private void skipOption() {
        this.skipPressed = true;
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        if (this.sendCustomerEmailAddress.getText().length() > 0) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
        if (arg0.getKeyCode() == 27) {
            this.cancelOption();
        } else if (arg0.getKeyCode() == 10) {
            this.okOption();
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

