/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import com.aem.SHPreloadUI;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.utils.SafeClock;
import com.aem.sdesktop.client.gui.FasterScaledImagePanel;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.util.GuiConstants;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.ScreenDimension;
import com.aem.utils.CursorInfo;
import com.aem.utils.NativeUtils;
import com.aem.utils.keyhandling.KeyRequest;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.ostools.OS;
import utils.swing.SafeJFileChooser;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.utils.shadowlabel.Effects;
import utils.switches.Switches;

public class CentrePanel
extends JPanel
implements GuiConstants,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
DropTargetListener,
NodeLinkStatusListener {
    private static final Color CLEAR_COLOR = new Color(100, 100, 100);
    private static final Color OVERLAY_COLOR = new Color(255, 0, 255);
    private static final Color OVERLAY_FILL = new Color(255, 0, 255, 80);
    private static final Color CAPTURE_COLOR = new Color(220, 220, 220, 120);
    private static final Color SNAP_LINE_DARK = new Color(0, 0, 0, 50);
    private BuildTrackingThread trackingThread = null;
    private KeyStateMonitorThread keyStateMonitorThread;
    private boolean ignoreResolutionChange = false;
    private long lastMouseEventTime = 0L;
    private final ClientController controller;
    private final ClientUserInterface uinterface;
    private boolean show_screen_image = true;
    private BufferedImage screen_image = null;
    private Color tlHintBg = new Color(0, 0, 0, 128);
    private Color tlHintFg = Color.white;
    private Color ceHintBg = new Color(0, 0, 0, 128);
    private Color ceHintFg = Color.white;
    private Color bottomHintBg = new Color(0, 0, 0, 128);
    private Color bottomHintFg = Color.white;
    private final Image pointerImg = ImageLoader.getAsImage("images/pointer_large.png");
    private final Image pointerImgSmall = ImageLoader.getAsImage("images/pointer_small.png");
    private final Image haloImg = ImageLoader.getAsImage("images/halo.png");
    ImagePanel img_panel;
    JScrollPane img_scroll;
    private final Toolkit toolkit;
    private boolean meta_down = false;
    private boolean control_down = false;
    private boolean alt_down = false;
    private boolean alt_gr_down = false;
    private boolean capturing_rect = false;
    private boolean shift_down = false;
    private boolean overlayIsActive = false;
    private boolean clip_sent = false;
    private Point capt_pt1 = null;
    private Point capt_pt2 = null;
    private Rectangle track_rect = null;
    private boolean[] track_pts = null;
    private int[] track_ints = null;
    private long track_building_until = 0L;
    private boolean tracking_changes = false;
    private final int min_track_w_h = 3;
    private final Rectangle overlay_r = new Rectangle(0, 0, 1, 1);
    private boolean useOverlay = true;
    boolean control_enabled = true;
    private int pointerx = -1;
    private int pointery = -1;
    private BufferedImage ditheredGradient;
    private final RootPaneContainer rpc;
    private String topLeftGreyOverlayHint = null;
    private String centreGreyOverlayHint = null;
    private String bottomGreyOverlayHint = null;
    private final Object tlHint_LOCK = new Object();
    private long tlHintUntil = 0L;
    private TopLeftHint tlHint = null;
    private final Object ceHint_LOCK = new Object();
    private long ceHintUntil = 0L;
    private CentreHint ceHint = null;
    private final Object bottomHint_LOCK = new Object();
    private long bottomHintUntil = 0L;
    private BottomHint bottomHint = null;
    private ScreenDimension[] screens;
    private ScreenDimension activeScreen = null;
    private int remoteScalingPercentage = 100;
    private int originalWidth = 500;
    private int originalHeight = 500;
    private long nextCheck = 0L;
    private boolean mapKeycodesToKeycodes = true;
    private boolean fetchClipOnReleaseOfCorX = false;
    private int previous_down = -99999999;
    private boolean echo = true;
    private final Object typing_LOCK = new Object();
    private long lastTyped = System.currentTimeMillis();
    private StringBuffer typed = new StringBuffer();
    private int dragx;
    private int dragy;
    private final int LEGAL_BUTTON_MASK = 7196;
    private boolean someMouseButtonDown = false;
    private int unscaledX;
    private int unscaledY;
    private static final int[] BUTTON_DOWN_MASK = new int[]{1024, 2048, 4096, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
    private static final int[] BUTTONS_DOWN = new int[]{16, 8, 4};
    int px;
    int py;
    private Point snapStart;
    private Point snapEnd;
    private boolean showingAllScreens = false;
    private ScreenDimension previousActiveScreen = null;
    private int remoteOsBase;

    private Color getTrackingColour() {
        double mod = System.currentTimeMillis() % 2000L;
        mod -= 1000.0;
        return new Color(220 + (int)(mod /= 50.0), 0, 220 + (int)mod, 80);
    }

    private void clearTracking() {
        if (this.trackingThread != null) {
            this.trackingThread.die = true;
        }
        this.trackingThread = null;
        this.capturing_rect = false;
        this.tracking_changes = false;
        this.capt_pt1 = null;
        this.capt_pt2 = null;
        this.track_rect = null;
        this.track_pts = null;
        this.track_ints = null;
        this.track_building_until = 0L;
    }

    private void captureTrackingRect() {
        this.clearTracking();
        if (Switches.SH_1543_changeTrackingDebugging) {
            System.out.println("[SH-AutoTracking] Capturing tracking rectangle...");
        }
        this.uinterface.setTopLeftGreyOverlay(Language.get("TRACKING_MSG_CAPTURING"), 10000L);
        this.capturing_rect = true;
    }

    private Rectangle getTrackingVisibleRectFrom(Point p1, Point p2) {
        Point vis1 = this.custToTechLocation(p1.x, p1.y);
        Point vis2 = this.custToTechLocation(p2.x, p2.y);
        Rectangle rect = new Rectangle(vis1);
        rect.add(vis2);
        if (rect.width < 3) {
            rect.width = 3;
        }
        if (rect.height < 3) {
            rect.height = 3;
        }
        return rect;
    }

    private Rectangle getCaptureRect() {
        if (this.capturing_rect && this.capt_pt1 != null && this.capt_pt2 != null) {
            return this.getTrackingVisibleRectFrom(this.capt_pt1, this.capt_pt2);
        }
        return null;
    }

    private Rectangle getTrackingRect() {
        if (this.track_rect != null) {
            return this.getTrackingVisibleRectFrom(this.capt_pt1, this.capt_pt2);
        }
        return null;
    }

    private void trackRect(Rectangle rect) {
        System.out.println("[SH-AutoTracking] Asked to track changes on rectangle " + rect + ", building first...");
        this.uinterface.setTopLeftGreyOverlay(Language.get("TRACKING_MSG_BUILDING"), 10000L);
        this.capturing_rect = false;
        this.track_rect = rect;
        this.track_pts = null;
        this.track_ints = null;
        this.track_building_until = SafeClock.currentTimeMillis() + 10000L;
        this.trackingThread = new BuildTrackingThread();
        this.trackingThread.start();
    }

    public CentrePanel(RootPaneContainer rpc, ClientController c, ClientUserInterface ui) {
        this.rpc = rpc;
        this.controller = c;
        this.uinterface = ui;
        this.initGraphics();
        this.initEventHandling();
        this.toolkit = Toolkit.getDefaultToolkit();
        if (SHPreloadUI.PRELOADING) {
            return;
        }
        new TypingThread().start();
        new CreateDitheredImage().start();
    }

    public void cancelTracking() {
        this.clearTracking();
        this.repaint();
    }

    public void captureRectAndTrack() {
        this.captureTrackingRect();
    }

    public BufferedImage getScreenImage() {
        return this.screen_image;
    }

    public double getLocalRemoteScalingFactor() {
        double localScalingPercentage = 100.0 * SimpleHelpLookAndFeel.getScalingFactor();
        return localScalingPercentage / (double)this.remoteScalingPercentage;
    }

    public void connected() {
        if (this.keyStateMonitorThread == null) {
            this.keyStateMonitorThread = new KeyStateMonitorThread();
            this.keyStateMonitorThread.start();
        }
    }

    private void showScrollHint() {
        if (this.useOverlay) {
            this.showTopLeftGreyOverlayHint(Language.get("HOLD_ALT_AND_CLICK"), 2000L);
        }
    }

    public void showTopLeftGreyOverlayHint(String message) {
        this.showTopLeftGreyOverlayHint(message, 3000L);
    }

    public void showTopLeftGreyOverlayHint(String message, long delay) {
        this.tlHintUntil = System.currentTimeMillis() + delay;
        if (this.tlHint == null) {
            this.topLeftGreyOverlayHint = message;
            this.tlHint = new TopLeftHint();
            this.tlHint.start();
        } else {
            this.topLeftGreyOverlayHint = message;
            this.repaint();
        }
    }

    public void showCentreGreyOverlayHint(String message) {
        this.showCentreGreyOverlayHint(message, 3000L);
    }

    public void showCentreGreyOverlayHint(String message, long delay) {
        if (message == null && this.centreGreyOverlayHint == null) {
            return;
        }
        if (message != null && message.length() == 0) {
            message = null;
        }
        this.ceHintUntil = message == null || message.length() == 0 ? -1L : System.currentTimeMillis() + delay;
        if (this.ceHint == null) {
            this.centreGreyOverlayHint = message;
            this.ceHint = new CentreHint();
            this.ceHint.start();
        } else {
            this.centreGreyOverlayHint = message;
            this.repaint();
        }
    }

    private void showBottomGreyOverlayHint(String message) {
        this.showBottomGreyOverlayHint(message, 3000L);
    }

    private void showBottomGreyOverlayHint(String message, long delay) {
        if (message == null && this.bottomGreyOverlayHint == null) {
            return;
        }
        if (message != null && message.length() == 0) {
            message = null;
        }
        this.bottomHintUntil = message == null || message.length() == 0 ? -1L : System.currentTimeMillis() + delay;
        if (this.bottomHint == null) {
            this.bottomGreyOverlayHint = message;
            this.bottomHint = new BottomHint();
            this.bottomHint.start();
        } else {
            this.bottomGreyOverlayHint = message;
            this.repaint();
        }
    }

    public void setCanControlAndView(boolean canControl, boolean canView) {
        this.control_enabled = canControl;
        try {
            this.controller.sendAllowWiggle(canControl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFullScreen(boolean b) {
        if (b) {
            this.img_panel.cacheResolutionSettings();
            this.img_scroll.setHorizontalScrollBarPolicy(31);
            this.img_scroll.setVerticalScrollBarPolicy(21);
            this.setFitAll();
        } else {
            this.img_panel.restoreResolutionSettings();
        }
    }

    private void initGraphics() {
        this.img_scroll = new JScrollPane();
        this.img_panel = new ImagePanel();
        this.img_scroll.setViewportView(this.img_panel);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.img_scroll);
        this.img_scroll.getViewport().setScrollMode(0);
        this.img_scroll.setBorder(null);
        this.setBorder(null);
        new DropTarget(this, this);
        new DropTarget(this.img_scroll, this);
        new DropTarget(this.img_panel, this);
    }

    private void initEventHandling() {
        this.img_scroll.addMouseWheelListener(this);
        this.img_panel.addMouseWheelListener(this);
        this.img_panel.addMouseListener(this);
        this.img_panel.addMouseMotionListener(this);
        GrabRectNotifier grt = new GrabRectNotifier();
        this.img_scroll.getHorizontalScrollBar().addAdjustmentListener(grt);
        this.img_scroll.getVerticalScrollBar().addAdjustmentListener(grt);
        this.addComponentListener(grt);
    }

    public void setScreenSize(int w, int h, ScreenDimension[] screens, int remoteScalingPercentage) {
        boolean changed = this.originalWidth != w || this.originalHeight != h;
        this.originalWidth = w;
        this.originalHeight = h;
        this.screens = screens;
        this.remoteScalingPercentage = remoteScalingPercentage;
        this.img_panel.setFixedScalingFactor(this.getLocalRemoteScalingFactor());
        if (changed) {
            this.img_scroll.revalidate();
            this.img_scroll.getViewport().revalidate();
            JFrame frame = this.uinterface.getParentFrame();
            frame.getContentPane().invalidate();
            frame.getContentPane().validate();
            frame.repaint();
        }
    }

    public void clearScreenImage() {
        Graphics g;
        this.pointerx = -1;
        this.pointery = -1;
        if (this.screen_image != null && (g = this.screen_image.getGraphics()) != null) {
            int STEP = 32;
            int STEP2 = STEP * 2;
            g.setColor(CLEAR_COLOR);
            g.fillRect(0, 0, this.getWidth() * 4, this.getHeight() * 4);
            g.setColor(Color.black);
            int jump = 1;
            for (int x = 0; x < this.screen_image.getWidth(); x += STEP) {
                jump = 1 - jump;
                for (int y = jump * STEP; y < this.screen_image.getHeight(); y += STEP2) {
                    g.fillRect(x, y, STEP, STEP);
                }
            }
        }
    }

    public boolean getShowScreenImage() {
        return this.show_screen_image;
    }

    public void setShowScreenImage(boolean b) {
        this.show_screen_image = b;
    }

    public void setScreenImage(BufferedImage bimage, Rectangle[] updatedRegions) {
        if (CentralDebugging.SCR_SHOW_UPDATE_REGIONS) {
            System.out.println("[CentrePanel] Got " + updatedRegions.length + " updated regions");
            for (int i = 0; i < updatedRegions.length; ++i) {
                System.out.println("[CentrePanel]\tRegion" + i + " " + updatedRegions[i]);
            }
        }
        this.screen_image = bimage;
        this.img_panel.setImage(bimage);
        if (Switches.SH_1543_autoTracking) {
            try {
                long SC = SafeClock.currentTimeMillis();
                if (SC > this.track_building_until && this.track_rect != null) {
                    this.monitorTracking(bimage);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        this.img_panel.repaint();
    }

    private void buildTracking(BufferedImage bimg) {
        try {
            if (Switches.SH_1543_changeTrackingDebugging) {
                System.out.println("[SH-AutoTracking] Building tracking mask...");
            }
            if (this.track_rect != null) {
                Rectangle clipped = new Rectangle(0, 0, bimg.getWidth(), bimg.getHeight());
                clipped = clipped.intersection(this.track_rect);
                int[] tmp = bimg.getRGB(clipped.x, clipped.y, clipped.width, clipped.height, null, 0, clipped.width);
                if (this.track_ints == null) {
                    this.track_ints = tmp;
                    this.track_pts = new boolean[this.track_ints.length];
                    Arrays.fill(this.track_pts, true);
                } else {
                    for (int i = 0; i < tmp.length; ++i) {
                        if (this.track_ints[i] == tmp[i]) continue;
                        this.track_pts[i] = false;
                    }
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void monitorTracking(BufferedImage bimg) {
        try {
            long SC;
            if (!this.tracking_changes) {
                this.tracking_changes = true;
            }
            if ((SC = SafeClock.currentTimeMillis()) > this.nextCheck) {
                if (Switches.SH_1543_changeTrackingDebugging) {
                    System.out.println("[SH-AutoTracking] Looking for changes in tracked area...");
                }
                this.nextCheck = SC + 250L;
                Rectangle clipped = new Rectangle(0, 0, bimg.getWidth(), bimg.getHeight());
                clipped = clipped.intersection(this.track_rect);
                int[] tmp = bimg.getRGB(clipped.x, clipped.y, clipped.width, clipped.height, null, 0, clipped.width);
                for (int i = 0; i < tmp.length; ++i) {
                    if (!this.track_pts[i] || Math.abs(this.track_ints[i] - tmp[i]) < 5) continue;
                    System.out.println("[SH-AutoTracking] Changed detected");
                    this.clearTracking();
                    this.uinterface.notifyTrackingAlarmed();
                    return;
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void exportScreen() {
        BufferedImage screen = this.screen_image;
        File file = SafeJFileChooser.saveFile(this, new String[]{"png", "jpg", "jpeg"}, "screenshot.png");
        if (file == null) {
            return;
        }
        Color bg_col = Color.black;
        if (file.exists() && !SHGlassOptionPane.showConfirmDialog(this.rpc, Language.get("OVERWRITE_EXISTING_IMAGE"), Language.get("FILE_EXISTS"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("YES"))) {
            file = null;
        }
        if (file != null) {
            int sy2;
            int sx2;
            int sy1;
            int sx1;
            BufferedImage tmp;
            String lcfname = file.getName().toLowerCase();
            if (screen != null) {
                Rectangle cropArea = this.img_panel.getCropArea();
                if (this.img_panel.getCropArea() == null) {
                    tmp = new BufferedImage(screen.getWidth(), screen.getHeight(), 1);
                    sx1 = 0;
                    sy1 = 0;
                    sx2 = screen.getWidth() + sx1;
                    sy2 = screen.getHeight() + sy1;
                } else {
                    tmp = new BufferedImage(cropArea.width, cropArea.height, 1);
                    sx1 = cropArea.x;
                    sy1 = cropArea.y;
                    sx2 = cropArea.width + sx1;
                    sy2 = cropArea.height + sy1;
                }
            } else {
                System.out.println("[CentrePanel] unable to export (null) screen image");
                return;
            }
            Graphics2D graphics = (Graphics2D)tmp.getGraphics();
            graphics.setBackground(bg_col);
            graphics.setColor(bg_col);
            graphics.fillRect(0, 0, tmp.getWidth(), tmp.getHeight());
            graphics.drawImage(screen, 0, 0, tmp.getWidth(), tmp.getHeight(), sx1, sy1, sx2, sy2, null);
            graphics.dispose();
            String path = file.getAbsolutePath();
            if (lcfname.endsWith(".jpeg") || lcfname.endsWith(".jpg")) {
                try {
                    Class.forName("javax.imageio.ImageIO");
                    ImageIO.write((RenderedImage)tmp, "jpeg", new File(path));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    SHGlassOptionPane.showMessageDialog(this.rpc, Language.get("NOSUPPORT_MSG"), Language.get("NOSUPPORT_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"));
                }
            } else {
                if (!lcfname.endsWith(".png")) {
                    path = path + ".png";
                }
                try {
                    Class.forName("javax.imageio.ImageIO");
                    ImageIO.write((RenderedImage)tmp, "png", new File(path));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    SHGlassOptionPane.showMessageDialog(this.rpc, Language.get("NOSUPPORT_MSG"), Language.get("NOSUPPORT_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"));
                }
            }
        }
    }

    public Rectangle getGrabRectangle() {
        Rectangle rect = this.img_scroll.getViewport().getViewRect();
        rect = this.img_panel.scaledToOriginal(rect);
        return this.img_panel.restrictToImageOrCropArea(rect);
    }

    public void setPointerLocation(int x, int y) {
        if (x != this.pointerx || y != this.pointery) {
            this.pointerx = x;
            this.pointery = y;
            this.repaint();
        }
    }

    public void focusLostReleaseAllKeys() {
        if (this.control_down) {
            this.controller.sendKeyRequest(KeyRequest.getKeyRequestForCode(17, false));
            this.control_down = false;
        }
        if (this.shift_down) {
            this.controller.sendKeyRequest(KeyRequest.getKeyRequestForCode(16, false));
            this.shift_down = false;
        }
        if (this.meta_down) {
            this.controller.sendKeyRequest(KeyRequest.getKeyRequestForCode(157, false));
            this.meta_down = false;
        }
        if (this.alt_down) {
            this.controller.sendKeyRequest(KeyRequest.getKeyRequestForCode(18, false));
            this.alt_down = false;
        }
        if (this.alt_gr_down) {
            this.controller.sendKeyRequest(KeyRequest.getKeyRequestForCode(65406, false));
            this.alt_gr_down = false;
        }
    }

    public void mapKeycodesToKeycodes() {
        System.out.println("[Keymap] mapping keycodes to keycodes");
        this.mapKeycodesToKeycodes = true;
    }

    public void mapCharactersToCharacters() {
        System.out.println("[Keymap] mapping chars to chars");
        this.mapKeycodesToKeycodes = false;
    }

    public boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    private boolean isIgnorableEvent(KeyEvent e) {
        boolean result;
        boolean bl = result = e.getKeyCode() == 20 || e.getKeyCode() == 145;
        if (CentralDebugging.SHOW_IGNORED_CODES && result) {
            System.out.println("[CentrePanel] Ignoring key event " + e.getKeyCode());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (this.isIgnorableEvent(e)) {
            return;
        }
        this.fetchClipOnReleaseOfCorX = false;
        KeyRequest keyRequest = KeyRequest.getKeyRequest(e, !this.mapKeycodesToKeycodes, true);
        char kchar = e.getKeyChar();
        int kcode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (CentralDebugging.SHOW_KEY_INPUT_CODES) {
            System.out.println("Key press: " + keyRequest);
        }
        if (kcode == 17) {
            this.control_down = true;
        }
        if (kcode == 157) {
            this.meta_down = true;
        }
        if (kcode == 16) {
            this.shift_down = true;
        }
        if (kcode == 65406) {
            this.alt_gr_down = true;
        }
        if (kcode == 18) {
            this.alt_down = true;
            if (this.previous_down == 18) {
                return;
            }
        }
        this.clip_sent = false;
        if (this.controller != null && this.control_enabled) {
            if (!(kcode != 88 && kcode != 67 || !this.control_down && !this.meta_down || this.alt_down || this.alt_gr_down)) {
                System.out.println("[CentrePanel] Copy/Cut detected: control:" + this.control_down + "  meta:" + this.meta_down);
                this.controller.ignoreCurrentClipboard();
                this.fetchClipOnReleaseOfCorX = true;
            } else if (kcode == 86 && (this.control_down || this.meta_down) && !this.alt_down && !this.alt_gr_down) {
                System.out.println("[CentrePanel] Paste detected: control:" + this.control_down + "  meta:" + this.meta_down);
                if (this.controller.sendClipboardAndPaste()) {
                    this.clip_sent = true;
                    return;
                }
            }
            this.controller.sendKeyRequest(keyRequest);
            if (kcode == 524 || kcode == 525) {
                this.controller.sendKeyRequest(KeyRequest.getKeyRequestForCode(kcode, false));
            }
        }
        this.previous_down = kcode;
        Object object = this.typing_LOCK;
        synchronized (object) {
            if (this.echo) {
                this.lastTyped = System.currentTimeMillis();
                if (e.getKeyCode() == 8) {
                    if (this.typed.length() > 0) {
                        this.typed.setLength(this.typed.length() - 1);
                    }
                } else if (e.getKeyCode() == 10) {
                    this.typed.setLength(0);
                } else if (e.getKeyCode() == 9) {
                    this.typed.setLength(0);
                } else {
                    char c = e.getKeyChar();
                    if (Character.isLetterOrDigit(c) || c >= ' ' && c <= '~') {
                        this.typed.append(kchar);
                    }
                }
                while (this.typed.length() > 90) {
                    this.typed = new StringBuffer(this.typed.toString().substring(1));
                }
                this.uinterface.setTyping(this.typed.toString());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.isIgnorableEvent(e)) {
            return;
        }
        KeyRequest keyRequest = KeyRequest.getKeyRequest(e, !this.mapKeycodesToKeycodes, false);
        char kchar = e.getKeyChar();
        int kcode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (CentralDebugging.SHOW_KEY_INPUT_CODES) {
            System.out.println("Key release: " + keyRequest);
        }
        if (kcode == 17) {
            this.control_down = false;
        }
        if (kcode == 157) {
            this.meta_down = false;
        }
        if (kcode == 65406) {
            this.alt_gr_down = false;
        }
        if (kcode == 18) {
            this.alt_down = false;
            this.previous_down = -99999999;
        }
        if (kcode == 16) {
            this.shift_down = false;
        }
        if (this.controller != null && this.control_enabled) {
            if (kcode == 86 && (this.control_down || this.meta_down) && this.clip_sent) {
                return;
            }
            this.controller.sendKeyRequest(keyRequest);
            if ((kcode == 88 || kcode == 67) && (this.control_down || this.meta_down) && this.fetchClipOnReleaseOfCorX) {
                this.controller.fetchClipboardAfterInputSent();
                this.controller.flushAllBufferedKeys();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.isIgnorableEvent(e)) {
            return;
        }
        if (CentralDebugging.SHOW_KEY_INPUT_CODES) {
            System.out.println("Key typed (ignored): " + e.getKeyCode() + " / " + e.getKeyChar());
        }
    }

    public void setTextEcho(boolean b) {
        this.echo = b;
    }

    private void overlayRepaint() {
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.showingAllScreens) {
            return;
        }
        if (!(this.alt_down && this.useOverlay || !this.control_enabled || this.controller == null)) {
            int rotation = e.getWheelRotation();
            e.consume();
            this.controller.sendMouseWheel(rotation);
        }
    }

    public void setUseOverlay(boolean useOverlay) {
        System.out.println("[CentrePanel] Setting use of overlay to " + useOverlay);
        this.useOverlay = useOverlay;
        if (!useOverlay && this.overlayIsActive) {
            this.overlayIsActive = false;
            this.overlayRepaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMouseEventTime = System.currentTimeMillis();
        if (this.showingAllScreens) {
            return;
        }
        if (this.capturing_rect) {
            this.capt_pt1 = this.techToCustLocation(e.getX(), e.getY());
        } else if (this.alt_down && this.useOverlay) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.overlayIsActive = true;
                this.recalculateOverlayFractional(e);
            } else {
                this.overlayIsActive = false;
                this.dragx = e.getX();
                this.dragy = e.getY();
            }
            this.overlayRepaint();
        } else if (this.control_enabled) {
            int mX = e.getX();
            int mY = e.getY();
            Point point = this.techToCustLocation(mX, mY);
            mX = point.x;
            mY = point.y;
            Point snap = this.snapMouseToEdge(mX, mY);
            if (snap != null) {
                mX = snap.x;
                mY = snap.y;
            }
            if (this.controller != null) {
                this.controller.setCurrentMouseLocation(mX, mY);
            }
            int nativeButton = SwingUtilities.isLeftMouseButton(e) ? 0 : (SwingUtilities.isMiddleMouseButton(e) ? 1 : (SwingUtilities.isRightMouseButton(e) ? 2 : 0));
            if ((this.remoteOsBase == 1 || OS.isMacOS()) && nativeButton == 0 && this.control_down) {
                nativeButton = 2;
            }
            int buttonThatChangedState = this.getMaskForButton(e.getButton());
            int modifiers = e.getModifiersEx();
            if (this.controller != null) {
                this.controller.sendMouseDown(mX, mY, buttonThatChangedState, modifiers, nativeButton);
            }
            this.someMouseButtonDown = true;
            this.repaint();
        }
    }

    private void cropToScreen(ScreenDimension activeScreen) {
        if (activeScreen == null) {
            this.img_panel.setCropArea(null);
        } else {
            this.img_panel.setCropArea(activeScreen.getPhysicalBounds());
        }
        if (this.controller != null) {
            this.controller.notifyGrabRectangleHasChanged();
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (Switches.SH_1543_autoTracking && this.capturing_rect) {
            this.capt_pt2 = this.techToCustLocation(e.getX(), e.getY());
            Rectangle rect = new Rectangle(this.capt_pt1);
            rect.add(this.capt_pt2);
            if (rect.width < 2) {
                rect.width = 2;
            }
            if (rect.height < 2) {
                rect.height = 2;
            }
            this.trackRect(rect);
            this.repaint();
            return;
        }
        if (this.showingAllScreens) {
            this.toggleShowAllScreens();
            return;
        }
        if (this.overlayIsActive) {
            this.overlayIsActive = false;
            this.overlayRepaint();
        }
        if (!(this.alt_down && this.useOverlay || !this.control_enabled)) {
            int mX = e.getX();
            int mY = e.getY();
            Point point = this.techToCustLocation(mX, mY);
            mX = point.x;
            mY = point.y;
            Point snap = this.snapMouseToEdge(mX, mY);
            if (snap != null) {
                mX = snap.x;
                mY = snap.y;
            }
            this.clearSnapLine();
            int button = SwingUtilities.isLeftMouseButton(e) ? 0 : (SwingUtilities.isMiddleMouseButton(e) ? 1 : (SwingUtilities.isRightMouseButton(e) ? 2 : 0));
            if (this.remoteOsBase == 1 && button == 0 && this.control_down) {
                button = 2;
            }
            int buttonThatChangedState = this.getMaskForButton(e.getButton());
            int modifiers = e.getModifiersEx();
            if (this.controller != null) {
                this.controller.sendMouseUp(mX, mY, buttonThatChangedState, modifiers, button);
            }
            this.someMouseButtonDown = false;
            this.repaint();
        }
    }

    private int getMaskForButton(int button) {
        if (button <= 0 || button > BUTTON_DOWN_MASK.length) {
            throw new IllegalArgumentException("button doesn't exist " + button);
        }
        if (this.remoteOsBase == 2 || this.remoteOsBase == 1) {
            return BUTTONS_DOWN[button - 1];
        }
        return BUTTON_DOWN_MASK[button - 1];
    }

    private boolean drawRemotePointer() {
        return System.currentTimeMillis() - this.lastMouseEventTime > 2000L;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.lastMouseEventTime = System.currentTimeMillis();
        if (Switches.SH_1543_autoTracking && this.capturing_rect) {
            this.capt_pt2 = this.techToCustLocation(e.getX(), e.getY());
            this.repaint();
            return;
        }
        if (this.showingAllScreens) {
            return;
        }
        if (this.alt_down && this.useOverlay) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.overlayIsActive = true;
                this.recalculateOverlayFractional(e);
            } else {
                this.overlayIsActive = false;
                this.recalculateOverlayDrag(e);
            }
            this.overlayRepaint();
        } else if (this.control_enabled) {
            int mX = e.getX();
            int mY = e.getY();
            this.unscaledX = mX;
            this.unscaledY = mY;
            Point point = this.techToCustLocation(mX, mY);
            mX = point.x;
            mY = point.y;
            Point snap = this.snapMouseToEdge(mX, mY);
            if (snap != null) {
                this.setSnapLine(this.custToTechLocation(mX, mY), this.custToTechLocation(snap.x, snap.y));
                mX = snap.x;
                mY = snap.y;
                this.img_panel.repaint();
            } else {
                this.clearSnapLine();
            }
            if (this.controller != null) {
                if (CentralDebugging.SCR_SEND_NOTHING_ON_NO_CHANGE) {
                    this.controller.setCurrentMouseLocation(mX, mY);
                    this.controller.sendMouseMove(mX, mY);
                } else {
                    this.controller.setCurrentMouseLocation(mX, mY);
                }
            }
        }
    }

    private Point techToCustLocation(int mX, int mY) {
        if (this.screen_image == null) {
            return new Point(mX, mY);
        }
        return this.img_panel.scaledToOriginal(new Point(mX, mY));
    }

    private Point custToTechLocation(int mX, int mY) {
        if (this.screen_image == null) {
            return new Point(mX, mY);
        }
        return this.img_panel.originalToScaled(new Point(mX, mY));
    }

    private void setSnapLine(Point start, Point end) {
        this.snapStart = start;
        this.snapEnd = end;
    }

    private void clearSnapLine() {
        boolean mustRepaint = false;
        if (this.snapStart != null) {
            mustRepaint = true;
        }
        this.snapStart = null;
        this.snapEnd = null;
        if (mustRepaint) {
            this.img_panel.repaint();
        }
    }

    private int snapScalar(int val, double min, double max) {
        if ((double)val < min) {
            return (int)min;
        }
        if ((double)val > max) {
            return (int)max;
        }
        return val;
    }

    private Point snapMouseToEdge(int mX, int mY) {
        if (this.screens == null) {
            return null;
        }
        int snapDist = 999999999;
        Point snap = null;
        for (ScreenDimension sd : this.screens) {
            Point scrSnap = new Point(this.snapScalar(mX, sd.getPhysicalBounds().getX(), sd.getPhysicalBounds().getX() + sd.getPhysicalBounds().getWidth() - 1.0), this.snapScalar(mY, sd.getPhysicalBounds().getY(), sd.getPhysicalBounds().getY() + sd.getPhysicalBounds().getHeight() - 1.0));
            if (scrSnap.x == mX && scrSnap.y == mY) {
                snap = null;
                break;
            }
            int xDist = mX - scrSnap.x;
            int yDist = mY - scrSnap.y;
            int myDist = xDist * xDist + yDist * yDist;
            if (myDist >= snapDist) continue;
            snapDist = myDist;
            snap = scrSnap;
        }
        return snap;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastMouseEventTime = System.currentTimeMillis();
        if (Switches.SH_1543_autoTracking && this.capturing_rect) {
            return;
        }
        if (this.showingAllScreens) {
            int mX = e.getX();
            int mY = e.getY();
            if (this.screens != null) {
                this.activeScreen = null;
                for (ScreenDimension screen : this.screens) {
                    Rectangle2D bounds;
                    Object userObject = screen.getUserObject();
                    if (userObject == null || !(bounds = (Rectangle2D)userObject).contains(mX, mY)) continue;
                    this.activeScreen = screen;
                    break;
                }
                this.repaint();
            }
        } else if (!this.alt_down || !this.useOverlay) {
            int mX = e.getX();
            int mY = e.getY();
            if (this.control_enabled) {
                this.unscaledX = mX;
                this.unscaledY = mY;
                Point point = this.techToCustLocation(mX, mY);
                mX = point.x;
                mY = point.y;
                Point snap = this.snapMouseToEdge(mX, mY);
                if (snap != null) {
                    mX = snap.x;
                    mY = snap.y;
                }
                this.clearSnapLine();
                if (this.controller != null) {
                    if (CentralDebugging.SCR_SEND_NOTHING_ON_NO_CHANGE) {
                        this.controller.setCurrentMouseLocation(mX, mY);
                        this.controller.sendMouseMove(mX, mY);
                    } else {
                        this.controller.setCurrentMouseLocation(mX, mY);
                    }
                }
            }
        }
    }

    private void recalculateOverlayDrag(MouseEvent e) {
    }

    private void recalculateOverlayFractional(MouseEvent e) {
        JScrollBar h = this.img_scroll.getHorizontalScrollBar();
        JScrollBar v = this.img_scroll.getVerticalScrollBar();
        double pixel_indent = e.getX() - h.getValue();
        double vp_width = h.getVisibleAmount();
        double xratio = pixel_indent / vp_width;
        double pixel_choose = xratio * (double)h.getMaximum();
        int screenx = h.getVisibleAmount() / 2;
        int xval = (int)pixel_choose - screenx;
        h.setValue(xval);
        pixel_indent = e.getY() - v.getValue();
        vp_width = v.getVisibleAmount();
        double yratio = pixel_indent / vp_width;
        pixel_choose = yratio * (double)v.getMaximum();
        int screeny = v.getVisibleAmount() / 2;
        int yval = (int)pixel_choose - screeny;
        v.setValue(yval);
        double xrat = h.getVisibleAmount() / h.getMaximum();
        double yrat = v.getVisibleAmount() / v.getMaximum();
        int rx = (int)((double)h.getValue() / (double)h.getMaximum() * (double)h.getVisibleAmount());
        int ry = (int)((double)v.getValue() / (double)v.getMaximum() * (double)v.getVisibleAmount());
        int rw = (int)((double)h.getVisibleAmount() / (double)h.getMaximum() * (double)h.getVisibleAmount());
        int rh = (int)((double)v.getVisibleAmount() / (double)v.getMaximum() * (double)v.getVisibleAmount());
        this.overlay_r.setRect(rx + h.getValue(), ry + v.getValue(), rw, rh);
    }

    private boolean isTechCursorNear(int x, int y) {
        return Math.abs(this.unscaledX - x) < 30 && Math.abs(this.unscaledY - y) < 30;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            if ((dtde.getSourceActions() | 0x40000000) > 0) {
                dtde.acceptDrop(0x40000000);
            } else if ((dtde.getSourceActions() | 1) > 0) {
                dtde.acceptDrop(1);
            } else {
                dtde.acceptDrop(0);
            }
            List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            this.controller.sendFilesAndPaste(files);
            dtde.dropComplete(true);
        }
        catch (ClassCastException e) {
            dtde.dropComplete(true);
        }
        catch (NullPointerException e) {
            dtde.dropComplete(true);
        }
        catch (Throwable t) {
            dtde.dropComplete(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void setResolutionPercentage(double scale) {
        if (this.ignoreResolutionChange) {
            return;
        }
        this.img_panel.setCustomScaleMode(scale);
    }

    public void setFitAll() {
        this.img_panel.setScaleMode(2);
    }

    public void setFitHeight() {
        this.img_panel.setScaleMode(1);
    }

    public void setFitOneToOne() {
        this.img_panel.setScaleMode(0);
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        this.img_panel.setGrayScale(true);
        this.img_panel.setCursor((CursorInfo)null);
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        this.img_panel.setGrayScale(true);
        this.img_panel.setCursor((CursorInfo)null);
    }

    @Override
    public void linkOK(NodeLink link) {
        this.img_panel.setGrayScale(false);
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        Insets insets = this.getInsets();
        this.img_scroll.setBounds(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        this.img_scroll.doLayout();
        super.paintImmediately(x, y, w, h);
    }

    public void componentShown(ComponentEvent e) {
    }

    public void setTyping(String text) {
        this.showBottomGreyOverlayHint(text);
    }

    public void toggleShowAllScreens() {
        if (this.screens == null) {
            return;
        }
        boolean bl = this.showingAllScreens = !this.showingAllScreens;
        if (this.showingAllScreens) {
            this.previousActiveScreen = this.activeScreen;
            this.activeScreen = null;
            this.img_panel.cacheResolutionSettings();
            this.cropToScreen(null);
            this.img_panel.setCustomScaleMode(-50.0);
        } else {
            this.cropToScreen(this.activeScreen);
            this.img_panel.restoreResolutionSettings();
        }
    }

    public void setRemoteOS(int remoteOsBase, int remoteOsVariant) {
        this.remoteOsBase = remoteOsBase;
    }

    class CreateDitheredImage
    extends Thread {
        public CreateDitheredImage() {
            super("CreateDitheredImage");
        }

        public void addSaltAndPepperNoise(BufferedImage gradient, Graphics2D g) {
            Random pRandom = new Random();
            for (int x = 0; x < gradient.getWidth(); ++x) {
                for (int y = 0; y < gradient.getHeight(); ++y) {
                    int step = pRandom.nextInt(5) + 1;
                    int choice = pRandom.nextInt(3);
                    int yoffset = 0;
                    switch (choice) {
                        case 0: {
                            yoffset = 0;
                            break;
                        }
                        case 1: {
                            yoffset = 1;
                            break;
                        }
                        case 2: {
                            yoffset = 2;
                        }
                    }
                    int offsetYPixel = y + yoffset;
                    if (offsetYPixel < 0) {
                        offsetYPixel = 0;
                    }
                    if (offsetYPixel >= gradient.getHeight()) {
                        offsetYPixel = gradient.getHeight() - 1;
                    }
                    int rgb = gradient.getRGB(x, offsetYPixel);
                    Color orig = new Color(rgb);
                    int factor = 1;
                    if (x * y % 2 == 0) {
                        factor = -1;
                    }
                    int rr = orig.getRed();
                    int gg = orig.getGreen();
                    int bb = orig.getBlue();
                    if (pRandom.nextBoolean()) {
                        rr = orig.getRed() + factor * step;
                    }
                    if (pRandom.nextBoolean()) {
                        gg = orig.getGreen() + factor * step;
                    }
                    if (pRandom.nextBoolean()) {
                        bb = orig.getBlue() + factor * step;
                    }
                    if (rr < 0) {
                        rr = 0;
                    }
                    if (rr > 255) {
                        rr = 255;
                    }
                    if (gg < 0) {
                        gg = 0;
                    }
                    if (gg > 255) {
                        gg = 255;
                    }
                    if (bb < 0) {
                        bb = 0;
                    }
                    if (bb > 255) {
                        bb = 255;
                    }
                    ++step;
                    g.setColor(new Color(rr, gg, bb));
                    g.fillRect(x, y, 1, 1);
                }
            }
        }

        @Override
        public void run() {
            int width = 50;
            CentrePanel.this.ditheredGradient = new BufferedImage(width, 1200, 2);
            Graphics2D gg = CentrePanel.this.ditheredGradient.createGraphics();
            gg.setPaint(new GradientPaint(0.0f, 0.0f, new Color(100, 100, 100), 0.0f, 1200.0f, Color.BLACK));
            gg.fillRect(0, 0, width, 1200);
            gg.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.addSaltAndPepperNoise(CentrePanel.this.ditheredGradient, gg);
            gg.dispose();
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    class ImagePanel
    extends FasterScaledImagePanel {
        private CursorInfo remoteCursorImage;

        public ImagePanel() {
            super(CentrePanel.this.screen_image, CentrePanel.this.img_scroll);
            this.setBackground(CLEAR_COLOR);
        }

        @Override
        protected void notifyScalingFactorChange(double inUseScalingFactor) {
            CentrePanel.this.ignoreResolutionChange = true;
            CentrePanel.this.uinterface.setResolutionPercentage(inUseScalingFactor);
            CentrePanel.this.ignoreResolutionChange = false;
        }

        @Override
        protected void drawRelativeInformation(Graphics2D g, int xoffset, int yoffset) {
            if (CentrePanel.this.showingAllScreens) {
                double width = 1.0;
                g.setStroke(new BasicStroke((float)width));
                Font oldFont = g.getFont();
                g.setFont(SHStyle.mediumFont);
                for (ScreenDimension screen : CentrePanel.this.screens) {
                    Rectangle rect = new Rectangle(screen.getPhysicalBounds());
                    CentrePanel.this.img_panel.originalToScaled(rect);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Rectangle2D.Double r2d = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
                    screen.setUserObject(r2d);
                    if (screen == CentrePanel.this.activeScreen) {
                        g.setColor(new Color(120, 120, 120, 120));
                        g.fill(r2d);
                    }
                    double centrex = r2d.getCenterX();
                    double centrey = r2d.getCenterY();
                    String s = Language.get("SCREEN") + " " + screen.getScreenNumber();
                    this.renderScreenButton(s, g, centrex, centrey, 1, screen == CentrePanel.this.previousActiveScreen);
                }
                if (Switches.SH_view_all_monitors_button) {
                    this.renderScreenButton(Language.get("VIEW_ALL"), g, this.getWidth() / 2, this.getHeight() - SimpleHelpLookAndFeel.scale(20), 1, CentrePanel.this.activeScreen == null);
                }
                g.setFont(oldFont);
            }
        }

        private void renderScreenButton(String s, Graphics2D g, double centrex, double centrey, int size, boolean isActive) {
            TextLayout tl = new TextLayout(s, g.getFont(), g.getFontRenderContext());
            float textx = (float)(centrex - tl.getBounds().getWidth() / 2.0);
            double height = tl.getDescent() + tl.getAscent();
            double textWidth = tl.getBounds().getWidth() + (double)SimpleHelpLookAndFeel.scale(20);
            RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(centrex - textWidth / 2.0, centrey - height / 2.0 - (double)size - (double)SimpleHelpLookAndFeel.scale(7), textWidth, height + (double)(2 * size) + (double)SimpleHelpLookAndFeel.scale(5), SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(10));
            if (isActive) {
                g.setColor(new Color(102, 136, 186));
            } else {
                g.setColor(new Color(118, 118, 118));
            }
            g.fill(roundRect);
            g.setColor(new Color(118, 118, 118).darker());
            g.draw(roundRect);
            Effects.paintTextEffect(g, s, Color.DARK_GRAY, size, textx - (float)size + 1.0f, 2.0 + centrey - (double)size, true);
            g.setColor(Color.WHITE);
            tl.draw(g, textx, (float)centrey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g1) {
            long start = System.currentTimeMillis();
            Graphics2D g = (Graphics2D)g1;
            if (CentrePanel.this.showingAllScreens) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                for (int i = 0; i < this.getWidth(); i += CentrePanel.this.ditheredGradient.getWidth()) {
                    g.drawImage((Image)CentrePanel.this.ditheredGradient, i, 0, null);
                }
            } else {
                g.setColor(CLEAR_COLOR);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (CentrePanel.this.show_screen_image) {
                long tt = System.currentTimeMillis();
                super.paintComponent(g);
                if (CentralDebugging.TECH_UI_VERBOSE_PAINT) {
                    System.out.println("PaintComponent took " + (System.currentTimeMillis() - tt));
                }
            }
            if (CentrePanel.this.someMouseButtonDown && CentrePanel.this.haloImg != null) {
                g.drawImage(CentrePanel.this.haloImg, CentrePanel.this.unscaledX - 16, CentrePanel.this.unscaledY - 16, null);
            }
            if (CentrePanel.this.snapStart != null) {
                g.setColor(SNAP_LINE_DARK);
                g.drawLine(((CentrePanel)CentrePanel.this).snapStart.x, ((CentrePanel)CentrePanel.this).snapStart.y, ((CentrePanel)CentrePanel.this).snapEnd.x, ((CentrePanel)CentrePanel.this).snapEnd.y);
            }
            if (CentrePanel.this.pointerx != -1 && CentrePanel.this.pointery != -1 && CentrePanel.this.drawRemotePointer()) {
                Point point = CentrePanel.this.custToTechLocation(CentrePanel.this.pointerx, CentrePanel.this.pointery);
                int x = point.x;
                int y = point.y;
                if (!CentrePanel.this.control_enabled || !CentrePanel.this.isTechCursorNear(x, y)) {
                    if (this.remoteCursorImage == null) {
                        if (CentrePanel.this.img_panel.getInUseScalingFactor() <= 0.5) {
                            if (CentrePanel.this.pointerImgSmall != null) {
                                g.drawImage(CentrePanel.this.pointerImgSmall, x, y, null);
                            }
                        } else if (CentrePanel.this.pointerImg != null) {
                            g.drawImage(CentrePanel.this.pointerImg, x, y, null);
                        }
                    } else {
                        BufferedImage cursorImage = this.remoteCursorImage.getImage();
                        double scaledWidth = ((Image)cursorImage).getWidth(null);
                        double scaledHeight = ((Image)cursorImage).getHeight(null);
                        double scaledHotspotX = this.remoteCursorImage.hotSpotX;
                        double scaledHotspotY = this.remoteCursorImage.hotSpotY;
                        double cursorFactor = CentrePanel.this.getLocalRemoteScalingFactor();
                        double minResolutionFactor = Math.max(0.3, CentrePanel.this.img_panel.getInUseScalingFactor());
                        scaledWidth *= minResolutionFactor;
                        scaledHeight *= minResolutionFactor;
                        scaledHotspotX *= minResolutionFactor;
                        scaledHotspotY *= minResolutionFactor;
                        int targetX = x;
                        int targetY = y;
                        if (CentralDebugging.MOUSE_SCALING_GUI) {
                            System.out.println("[CentrePanel] Rendering remote user's cursor:");
                            System.out.println("[CentrePanel]    " + this.remoteCursorImage);
                            System.out.println("[CentrePanel]    scaledW:" + scaledWidth + " scaledH:" + scaledHeight + " minResolutionFactor:" + minResolutionFactor + " cursorFactor:" + cursorFactor);
                            System.out.println("[CentrePanel]    targetX:" + targetX + " targetY:" + targetY);
                            System.out.println("[CentrePanel] Scaled hotspot location: " + this.remoteCursorImage.hotSpotX + "," + this.remoteCursorImage.hotSpotY + " -> " + scaledHotspotX + "," + scaledHotspotY);
                        }
                        if (CentralDebugging.MOUSE_SCALING_DRAW_AT_HOTSPOT) {
                            targetX = (int)((double)x - scaledHotspotX);
                            targetY = (int)((double)y - scaledHotspotY);
                        }
                        g.drawImage(cursorImage, targetX, targetY, targetX + (int)scaledWidth, targetY + (int)scaledHeight, 0, 0, ((Image)cursorImage).getWidth(null), ((Image)cursorImage).getHeight(null), null);
                    }
                }
            }
            Shape clip = g.getClip();
            try {
                int ty;
                int hdescent;
                g.setClip(null);
                if (CentrePanel.this.overlayIsActive) {
                    g.setColor(OVERLAY_FILL);
                    g.fill(CentrePanel.this.overlay_r);
                }
                if (Switches.SH_1543_autoTracking) {
                    Rectangle captureRect = CentrePanel.this.getCaptureRect();
                    Rectangle trackingRect = CentrePanel.this.getTrackingRect();
                    if (captureRect != null) {
                        g.setColor(CAPTURE_COLOR);
                        g.fill(captureRect);
                    } else if (trackingRect != null) {
                        g.setColor(CentrePanel.this.getTrackingColour());
                        g.fill(trackingRect);
                    }
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                FontMetrics fm = g.getFontMetrics();
                if (CentrePanel.this.topLeftGreyOverlayHint != null) {
                    String hint = CentrePanel.this.topLeftGreyOverlayHint;
                    int hwidth = fm.stringWidth(hint);
                    int hascent = fm.getAscent();
                    hdescent = fm.getDescent();
                    int tx = 30 + CentrePanel.this.img_scroll.getHorizontalScrollBar().getValue();
                    ty = 30 + CentrePanel.this.img_scroll.getVerticalScrollBar().getValue();
                    g.setColor(CentrePanel.this.tlHintBg);
                    g.fillRoundRect(tx - 3, ty - hascent - 3, hwidth + 6, hascent + hdescent + 6, 10, 10);
                    g.setColor(CentrePanel.this.tlHintFg);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g.drawString(hint, tx, ty);
                }
                if (CentrePanel.this.centreGreyOverlayHint != null) {
                    String hint = CentrePanel.this.centreGreyOverlayHint;
                    int hwidth = fm.stringWidth(hint);
                    int hascent = fm.getAscent();
                    hdescent = fm.getDescent();
                    int tx = CentrePanel.this.img_scroll.getHorizontalScrollBar().getValue() + CentrePanel.this.getWidth() / 2 - hwidth / 2;
                    ty = CentrePanel.this.img_scroll.getVerticalScrollBar().getValue() + CentrePanel.this.getHeight() / 2 - hascent / 2;
                    g.setColor(CentrePanel.this.ceHintBg);
                    g.fillRoundRect(tx - 3, ty - hascent - 3, hwidth + 6, hascent + hdescent + 6, 10, 10);
                    g.setColor(CentrePanel.this.ceHintFg);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g.drawString(hint, tx, ty);
                }
                if (CentrePanel.this.bottomGreyOverlayHint != null) {
                    String hint = CentrePanel.this.bottomGreyOverlayHint;
                    int hascent = fm.getAscent();
                    int hdescent2 = fm.getDescent();
                    int tx = CentrePanel.this.img_scroll.getHorizontalScrollBar().getValue() + 4;
                    int width = CentrePanel.this.getWidth();
                    ty = CentrePanel.this.img_scroll.getVerticalScrollBar().getValue() + CentrePanel.this.getHeight() - hascent / 2;
                    if (CentrePanel.this.img_scroll.getHorizontalScrollBar().isVisible()) {
                        ty -= CentrePanel.this.img_scroll.getHorizontalScrollBar().getHeight();
                    }
                    g.setColor(CentrePanel.this.bottomHintBg);
                    g.fillRoundRect(0, ty - hascent, tx + width, hascent + hdescent2 + 6, 0, 0);
                    g.setColor(CentrePanel.this.bottomHintFg);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g.drawString(hint, tx, ty);
                }
            }
            finally {
                g.setClip(clip);
            }
            if (CentralDebugging.TECH_UI_VERBOSE_PAINT) {
                System.out.println("CentrePanel entire paint took " + (System.currentTimeMillis() - start) + "ms");
            }
        }

        public void setCursor(CursorInfo cInfo) {
            if (cInfo != null && cInfo.isVisible()) {
                double cursorFactor = CentrePanel.this.getLocalRemoteScalingFactor();
                this.setCursor(cInfo.getJavaCursor(cursorFactor));
                this.remoteCursorImage = cInfo;
            } else {
                this.setCursor(Cursor.getDefaultCursor());
                this.remoteCursorImage = null;
            }
        }
    }

    class TypingThread
    extends Thread {
        public TypingThread() {
            super("TypingThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(250L);
                        Object object = CentrePanel.this.typing_LOCK;
                        synchronized (object) {
                            if (System.currentTimeMillis() - CentrePanel.this.lastTyped > 3000L) {
                                CentrePanel.this.typed.setLength(0);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        CentrePanel.this.uinterface.setTyping(null);
                                    }
                                });
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    class KeyStateMonitorThread
    extends Thread {
        public KeyStateMonitorThread() {
            super("KeyStateMonitorThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            boolean first = true;
            boolean currentStateCapsLock = false;
            boolean currentStateScrollLock = false;
            while (true) {
                try {
                    boolean nextState = NativeUtils.getCapsLockState();
                    if (CentralDebugging.DUMP_LOCK_KEY_STATES) {
                        System.out.println("[KeyStateMonitorThread] Caps Lock is " + nextState);
                    }
                    if (first || nextState != currentStateCapsLock) {
                        currentStateCapsLock = nextState;
                        System.out.println("[KeyStateMonitorThread] Sending CAPS LOCK state (" + nextState + ")");
                        if (CentrePanel.this.controller != null) {
                            CentrePanel.this.controller.sendLockingKey(20, nextState);
                        }
                    }
                    if (!OS.isMacOS()) {
                        nextState = NativeUtils.getScrollLockState();
                        if (CentralDebugging.DUMP_LOCK_KEY_STATES) {
                            System.out.println("[KeyStateMonitorThread] Scroll Lock is " + nextState);
                        }
                        if (first || nextState != currentStateScrollLock) {
                            currentStateScrollLock = nextState;
                            System.out.println("[KeyStateMonitorThread] Sending SCROLL LOCK state (" + nextState + ")");
                            if (CentrePanel.this.controller != null) {
                                CentrePanel.this.controller.sendLockingKey(145, nextState);
                            }
                        }
                    }
                    first = false;
                }
                catch (Throwable t) {
                    System.out.println("[KeyStateMonitorThread] Unexpected error monitoring key states: " + t.getMessage());
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class BuildTrackingThread
    extends Thread {
        private boolean die = false;

        BuildTrackingThread() {
        }

        @Override
        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long SC = SafeClock.currentTimeMillis();
                if (SC < CentrePanel.this.track_building_until) {
                    if (CentrePanel.this.screen_image == null) continue;
                    CentrePanel.this.buildTracking(CentrePanel.this.screen_image);
                    continue;
                }
                CentrePanel.this.uinterface.notifyTrackingStarted();
                return;
            }
        }
    }

    private class GrabRectNotifier
    implements AdjustmentListener,
    ComponentListener {
        private GrabRectNotifier() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (CentrePanel.this.controller != null) {
                CentrePanel.this.controller.notifyGrabRectangleHasChanged();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (CentrePanel.this.controller != null) {
                CentrePanel.this.controller.notifyGrabRectangleHasChanged();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (CentrePanel.this.controller != null) {
                CentrePanel.this.controller.notifyGrabRectangleHasChanged();
            }
        }
    }

    class BottomHint
    extends Thread {
        BottomHint() {
        }

        private void setAlphaAndWait(int N, int wait) {
            CentrePanel.this.bottomHintBg = new Color(0, 0, 0, N);
            CentrePanel.this.bottomHintFg = new Color(255, 255, 255, N * 2);
            CentrePanel.this.repaint();
            try {
                Thread.sleep(wait);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int N;
            Object object = CentrePanel.this.bottomHint_LOCK;
            synchronized (object) {
                for (N = 0; N < 120; N += 10) {
                    this.setAlphaAndWait(N, 50);
                }
            }
            this.setAlphaAndWait(127, 2500);
            while (System.currentTimeMillis() < CentrePanel.this.bottomHintUntil) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            object = CentrePanel.this.bottomHint_LOCK;
            synchronized (object) {
                CentrePanel.this.bottomHint = null;
                if (CentrePanel.this.bottomHintUntil != -1L) {
                    for (N = 120; N >= 0; N -= 10) {
                        this.setAlphaAndWait(N, 50);
                    }
                } else {
                    this.setAlphaAndWait(0, 0);
                }
                CentrePanel.this.repaint();
            }
        }
    }

    class CentreHint
    extends Thread {
        CentreHint() {
        }

        private void setAlphaAndWait(int N, int wait) {
            CentrePanel.this.ceHintBg = new Color(0, 0, 0, N);
            CentrePanel.this.ceHintFg = new Color(255, 255, 255, N * 2);
            CentrePanel.this.repaint();
            try {
                Thread.sleep(wait);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int N;
            Object object = CentrePanel.this.ceHint_LOCK;
            synchronized (object) {
                for (N = 0; N < 120; N += 10) {
                    this.setAlphaAndWait(N, 50);
                }
            }
            this.setAlphaAndWait(127, 2500);
            while (System.currentTimeMillis() < CentrePanel.this.ceHintUntil) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            object = CentrePanel.this.ceHint_LOCK;
            synchronized (object) {
                CentrePanel.this.ceHint = null;
                if (CentrePanel.this.ceHintUntil != -1L) {
                    for (N = 120; N >= 0; N -= 10) {
                        this.setAlphaAndWait(N, 50);
                    }
                } else {
                    this.setAlphaAndWait(0, 0);
                }
                CentrePanel.this.repaint();
            }
        }
    }

    class TopLeftHint
    extends Thread {
        TopLeftHint() {
        }

        private void setAlphaAndWait(int N, int wait) {
            CentrePanel.this.tlHintBg = new Color(0, 0, 0, N);
            CentrePanel.this.tlHintFg = new Color(255, 255, 255, N * 2);
            CentrePanel.this.repaint();
            try {
                Thread.sleep(wait);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int N;
            Object object = CentrePanel.this.tlHint_LOCK;
            synchronized (object) {
                for (N = 0; N < 120; N += 10) {
                    this.setAlphaAndWait(N, 50);
                }
            }
            this.setAlphaAndWait(127, 2500);
            while (System.currentTimeMillis() < CentrePanel.this.tlHintUntil) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            object = CentrePanel.this.tlHint_LOCK;
            synchronized (object) {
                CentrePanel.this.tlHint = null;
                for (N = 120; N >= 0; N -= 10) {
                    this.setAlphaAndWait(N, 50);
                }
                CentrePanel.this.repaint();
            }
        }
    }
}

