/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.ClientScreenDataBatch;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.video.VideoRecorder;
import com.aem.shelp.util.ProcessCache;
import com.aem.shelp.util.ScreenDimension;
import com.aem.thp.AemRle;
import com.aem.utils.LogicalArrayUtil;
import com.aem.utils.NonNativeLogicalArray;
import com.aem.utils.ObjectBuffer;
import com.aem.utils.zip.DEFLATEer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import utils.message.Message;
import utils.message.MessageReader;
import utils.progtools.MemoryCache;
import utils.stream.OpenByteArrayOutputStream;

public class ScreenController
extends Thread
implements GC,
MSG {
    Controller controller;
    ClientUserInterface gui;
    MessageReader min;
    BufferedImage img = null;
    int[] decodeColors = new int[128];
    boolean lightweightOnly = false;
    private final ArrayList<Rectangle> rectangleListOfUpdatedRegions = new ArrayList();
    private ScreenDimension[] receivedScreenDimensions;
    private AemRle rle = new AemRle();
    int last_packet_y = -1;
    int packet_line_count = 0;
    boolean ignore_captures = false;
    long inactiveFor = 0L;
    long activeFor = 0L;
    long lastScreenStart = -1L;
    long lastScreenFinish = -1L;
    boolean no_mid_screen_refreshes = false;
    ObjectBuffer buffer = new ObjectBuffer();
    ProcessCache bigCache;
    MemoryCache memCache;
    int prevw = -1;
    int prevh = -1;
    OpenByteArrayOutputStream dcout = new OpenByteArrayOutputStream();
    int[] rgbadat = new int[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdatedRegion(Rectangle rect) {
        ArrayList<Rectangle> arrayList = this.rectangleListOfUpdatedRegions;
        synchronized (arrayList) {
            this.rectangleListOfUpdatedRegions.add(rect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle[] getUpdatedRegions() {
        ArrayList<Rectangle> arrayList = this.rectangleListOfUpdatedRegions;
        synchronized (arrayList) {
            Rectangle[] listOfRects = this.rectangleListOfUpdatedRegions.toArray(new Rectangle[0]);
            this.rectangleListOfUpdatedRegions.clear();
            return listOfRects;
        }
    }

    public void log(String msg, String details) {
    }

    public ScreenController(Controller controller, ClientUserInterface gui, MessageReader min, boolean lightweightOnly) {
        this.controller = controller;
        this.gui = gui;
        this.min = min;
        this.lightweightOnly = lightweightOnly;
    }

    @Override
    public void run() {
        Message m = null;
        try {
            while (true) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            this.log(Language.get("CONNECTION_TERMINATED"), Language.get("CONNECTION_TERMINATED_DETAILS"));
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Screen Controller) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[ScreenController] " + e);
                System.out.println("(Screen Controller) LAST MESSAGE:" + m);
            }
        }
        catch (Throwable e) {
            System.out.println("(Screen Controller) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
    }

    public void setIgnoreCaptures(boolean b) {
        this.ignore_captures = b;
    }

    public Message waitForScreenFlush(long timeout) throws InterruptedException, IOException {
        return (Message)this.buffer.next(timeout);
    }

    public long getLastScreenFinish() {
        return this.lastScreenFinish;
    }

    public void handleMessage(Message m) throws IOException {
        block178: {
            if (CentralDebugging.SCREEN_NO_PROCESSING_READ_FROM_PIPE_ONLY) {
                return;
            }
            int type = m.getType();
            if (type == 196614) {
                this.gui.clearScreenImage();
            } else if (type == 196642) {
                if (CentralDebugging.CACHE_ALL_CHUNKS) {
                    if (CentralDebugging.CACHE_EXTERNAL_PROCESS) {
                        if (this.bigCache != null) {
                            this.bigCache.clear();
                        }
                    } else if (this.memCache != null) {
                        this.memCache.clear();
                    }
                }
            } else if (type == 196615) {
                this.buffer.add(m);
            } else if (type == 196613) {
                ScreenDimension[] screens;
                if (CentralDebugging.MSG_VERBOSE) {
                    System.out.println("SCREEN_SIZE_PACKET " + m);
                }
                int x = m.getNextInt();
                int y = m.getNextInt();
                int w = m.getNextInt();
                int h = m.getNextInt();
                int scalingPercentage = m.getNextInt();
                try {
                    int screenCount = m.getNextInt();
                    System.out.println("[ScreenController] Screen count is " + screenCount);
                    screens = new ScreenDimension[screenCount];
                    int screenIndex = 1;
                    for (int i = 0; i < screenCount; ++i) {
                        int sx = m.getNextInt();
                        int sy = m.getNextInt();
                        int sw = m.getNextInt();
                        int sh = m.getNextInt();
                        System.out.println("[ScreenController] Initialising screen " + i + " (" + sx + "," + sy + "," + sw + "," + sh + ")");
                        screens[i] = new ScreenDimension(sx, sy, sw, sh, screenIndex, "" + screenIndex);
                        ++screenIndex;
                    }
                }
                catch (Throwable t) {
                    System.out.println("[ScreenController] Warning: default to single screen as dimensions couldn't be extracted from message.");
                    t.printStackTrace();
                    screens = new ScreenDimension[]{new ScreenDimension(x, y, w, h, 1, "1")};
                }
                if (w > 0 && h > 0) {
                    try {
                        if (this.lightweightOnly) {
                            if (this.prevw != -1) {
                                this.controller.requestScreenResend();
                            }
                            this.prevw = w;
                            this.prevh = h;
                        } else {
                            boolean resetImage = false;
                            if (this.img == null) {
                                if (w > 0 && h > 0) {
                                    this.img = new BufferedImage(w, h, 1);
                                    resetImage = true;
                                }
                            } else if (w != -1 && h != -1 && (this.img.getWidth() != w || this.img.getHeight() != h)) {
                                this.img = new BufferedImage(w, h, 1);
                                resetImage = true;
                                System.out.println("Remote screen size changed, requesting entire screen");
                                this.gui.setScreenImage(this.img, new Rectangle[]{new Rectangle(0, 0, this.img.getWidth(), this.img.getHeight())});
                                this.controller.requestScreenResend();
                            }
                            if (resetImage) {
                                Graphics g = this.img.getGraphics();
                                g.setColor(Color.black);
                                g.fillRect(0, 0, w, h);
                            }
                        }
                        this.receivedScreenDimensions = screens;
                        this.gui.setScreenSize(x, y, w, h, screens, scalingPercentage);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else if (type == 196632) {
                this.controller.respondScreenEcho(m);
            } else if (type == 196633) {
                int pointerx = (Integer)m.get(0);
                int pointery = (Integer)m.get(1);
                this.gui.setPointerLocation(pointerx, pointery);
            } else if (type == 196631) {
                int x = (Integer)m.get(0);
                int y = (Integer)m.get(1);
                byte[] png = (byte[])m.get(2);
                this.gui.setScreenPng(x, y, png);
            } else if (type == 196626) {
                m.setType(196610);
                this.handleMessage(m);
                m.setType(196612);
                this.handleMessage(m);
            } else if (type == 196610) {
                if (CentralDebugging.MSG_VERBOSE) {
                    System.out.println("SCREEN_PACKETS_START " + m);
                }
                this.lastScreenStart = System.currentTimeMillis();
                this.inactiveFor = this.lastScreenStart - this.lastScreenFinish;
                this.last_packet_y = -1;
                this.packet_line_count = 0;
                if (this.controller.continuous_request) {
                    if (CentralDebugging.MSG_VERBOSE) {
                        System.out.println("REQUESTING SCREEN_INTERNAL");
                    }
                    this.controller.requestScreen();
                }
            } else if (type == 196612) {
                if (CentralDebugging.MSG_VERBOSE) {
                    System.out.println("SCREEN_PACKETS_END " + m);
                }
                int pointerx = -1;
                int pointery = -1;
                if (m.length() > 0) {
                    if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                        int tmp = (Integer)m.get(0);
                        pointerx = (0xFFFF & tmp >>> 16) - 1;
                        pointery = (0xFFFF & tmp) - 1;
                    } else {
                        pointerx = (Integer)m.get(0);
                        pointery = (Integer)m.get(1);
                    }
                }
                if (pointerx != -1 || pointery != -1) {
                    this.gui.setPointerLocation(pointerx, pointery);
                }
                if (!this.ignore_captures) {
                    this.gui.setScreenImage(this.img, this.getUpdatedRegions());
                }
                this.lastScreenFinish = System.currentTimeMillis();
                this.activeFor = this.lastScreenFinish - this.lastScreenStart;
                CentralDebugging.counterFinishIfMax("Screen data total decompression (Max ms)");
                CentralDebugging.counterFinishIfMax("Screen data recreation (Max ms)");
                CentralDebugging.counterFinishIfMax("Screen data set GUI image (Max ms)");
                CentralDebugging.counterFinishIfMax("Screen data total getRGB (Max ms)");
                CentralDebugging.counterFinishIfMax("Screen data total pixel processing (Max ms)");
                CentralDebugging.counterFinishIfMax("Screen data total setRGB (Max ms)");
            } else if (type == 196617) {
                if (CentralDebugging.MSG_VERBOSE_ALL) {
                    System.out.println("SCREEN_PACKET_BATCH " + m);
                }
                this.no_mid_screen_refreshes = true;
                long T = System.currentTimeMillis();
                ClientScreenDataBatch.pipeBatchMessage(m, this);
                T = System.currentTimeMillis() - T;
                CentralDebugging.counterAdd("Screen message batch processing (Max ms)", T);
                CentralDebugging.counterFinishIfMax("Screen message batch processing (Max ms)");
                VideoRecorder.getInstance().addEndBatchMessage();
                this.no_mid_screen_refreshes = false;
            } else if (type == 196641 && !this.lightweightOnly) {
                if (CentralDebugging.MSG_VERBOSE_ALL) {
                    System.out.println("SCREEN_PACKET " + m);
                }
                if (this.img == null) {
                    return;
                }
                int xDelta = (Integer)m.get(0);
                int yDelta = (Integer)m.get(1);
                if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                    System.out.println("[ScreenController] Asked to translate " + (m.length() - 2) + " items >>" + xDelta + "vv" + yDelta);
                }
                this.rgbadat = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
                int imgWidth = this.img.getWidth();
                int imgHeight = this.img.getHeight();
                NonNativeLogicalArray screenLa = new NonNativeLogicalArray(imgWidth, imgHeight, this.rgbadat, imgWidth, 0, 0);
                Rectangle updatedRect = null;
                for (int i = 2; i < m.length(); i += 3) {
                    int gx = (Integer)m.get(i);
                    int gy = (Integer)m.get(i + 1);
                    int gwidth = (Integer)m.get(i + 2);
                    if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                        System.out.println("[ScreenController] Translate " + gx + "," + gy + "," + gwidth + " -> " + xDelta + "," + yDelta + " -> " + (gx + xDelta) + "," + (gy + yDelta));
                    }
                    if (i == 2) {
                        updatedRect = new Rectangle();
                        updatedRect.x = xDelta + gx;
                        updatedRect.y = yDelta + gy;
                        updatedRect.width = gwidth;
                        updatedRect.height = 1;
                    } else {
                        updatedRect = updatedRect.union(new Rectangle(xDelta + gx, yDelta + gy, gwidth, 1));
                    }
                    try {
                        if (CentralDebugging.VISUALLY_SHOW_TRANSLATIONS) {
                            for (int xx = gx; xx < gx + gwidth; xx += 3) {
                                screenLa.setXY(xx, gy, -16711936);
                            }
                        }
                        LogicalArrayUtil.translate(screenLa, gx, gy, gwidth, 1, xDelta + gx, yDelta + gy);
                        this.addUpdatedRegion(new Rectangle(xDelta + gx, yDelta + gy, gwidth, 1));
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException xxx) {
                        if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                            System.err.println("[ScreenController] ERROR from translate " + gx + "," + gy + " " + gwidth + "w >>" + xDelta + "vv" + yDelta);
                        }
                        xxx.printStackTrace();
                    }
                }
                if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                    System.out.println("[ScreenController] Translation bounding rectangle is " + updatedRect);
                }
                if (CentralDebugging.VISUALLY_SHOW_TRANSLATIONS && updatedRect != null) {
                    int yy;
                    int xx;
                    for (xx = updatedRect.x; xx < updatedRect.x + updatedRect.width; ++xx) {
                        screenLa.setXY(xx, updatedRect.y, -65536);
                    }
                    for (xx = updatedRect.x; xx < updatedRect.x + updatedRect.width; ++xx) {
                        screenLa.setXY(xx, updatedRect.y + updatedRect.height, -65536);
                    }
                    for (yy = updatedRect.y; yy < updatedRect.y + updatedRect.height; ++yy) {
                        screenLa.setXY(updatedRect.x, yy, -65536);
                    }
                    for (yy = updatedRect.y; yy < updatedRect.y + updatedRect.height; ++yy) {
                        screenLa.setXY(updatedRect.x + updatedRect.width, yy, -65536);
                    }
                }
                if (VideoRecorder.getInstance() != null && updatedRect != null && !VideoRecorder.getInstance().isPaused()) {
                    int chunkSize = 64;
                    int xStart = chunkSize * (updatedRect.x / chunkSize);
                    int yStart = chunkSize * (updatedRect.y / chunkSize);
                    int chunksAcross = (updatedRect.x + updatedRect.width - xStart) / chunkSize;
                    int chunksDown = (updatedRect.y + updatedRect.height - yStart) / chunkSize;
                    if (xStart + chunkSize * chunksAcross < updatedRect.x + updatedRect.width) {
                        ++chunksAcross;
                    }
                    if (yStart + chunkSize * chunksDown < updatedRect.y + updatedRect.height) {
                        ++chunksDown;
                    }
                    for (int yChunk = 0; yChunk < chunksDown; ++yChunk) {
                        for (int xChunk = 0; xChunk < chunksAcross; ++xChunk) {
                            int x = xStart + chunkSize * xChunk;
                            int y = yStart + chunkSize * yChunk;
                            int w = chunkSize;
                            int h = chunkSize;
                            if (x + w > imgWidth) {
                                w = imgWidth - x;
                            }
                            if (y + h > imgHeight) {
                                h = imgHeight - y;
                            }
                            if (w <= 0 || h <= 0) continue;
                            Message videoMessage = new Message(8);
                            videoMessage.append(x);
                            videoMessage.append(y);
                            videoMessage.append(w);
                            videoMessage.append(h);
                            for (int yOffset = 0; yOffset < h; ++yOffset) {
                                videoMessage.append(this.rgbadat, (y + yOffset) * imgWidth + x, w);
                            }
                            VideoRecorder.getInstance().addScreenMessageToQueue(x, y, w, h, videoMessage);
                        }
                    }
                }
            } else if (type == 196640 && !this.lightweightOnly) {
                if (CentralDebugging.MSG_VERBOSE_ALL) {
                    System.out.println("SCREEN_PACKET " + m);
                }
                if (this.img == null) {
                    return;
                }
                int x = (Integer)m.get(0);
                int y = (Integer)m.get(1);
                int w = (Integer)m.get(2);
                int h = (Integer)m.get(3);
                Long hash = (Long)m.get(4);
                this.rgbadat = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
                int imgWidth = this.img.getWidth();
                NonNativeLogicalArray screenLa = new NonNativeLogicalArray(w, h, this.rgbadat, imgWidth, x, y);
                boolean problemExpected = imgWidth * (y + h) + x > this.rgbadat.length;
                try {
                    if (CentralDebugging.CACHE_EXTERNAL_PROCESS) {
                        this.bigCache.readFromCache(hash, screenLa);
                    } else {
                        byte[] dat = (byte[])this.memCache.getFromCache(hash);
                        ProcessCache.loadLogicalArray(dat, screenLa);
                        if (VideoRecorder.getInstance() != null) {
                            VideoRecorder.getInstance().addCachedDataToQueue(dat, x, y, w, h);
                        }
                    }
                    this.addUpdatedRegion(new Rectangle(x, y, w, h));
                }
                catch (NullPointerException xx) {
                    if (problemExpected) {
                        System.out.println("NP issue in ScreenController Load Chunk, ignoring since screen res change expected");
                        break block178;
                    }
                    System.err.println("Unexpected NP issue in ScreenController Load Chunk, ignoring since screen res change expected");
                    xx.printStackTrace();
                }
                catch (ArrayIndexOutOfBoundsException xx) {
                    if (problemExpected) {
                        System.out.println("Bounds issue in ScreenController Load Chunk, ignoring since screen res change expected");
                        break block178;
                    }
                    System.err.println("Unexpected bounds issue in ScreenController Load Chunk, ignoring since screen res change expected");
                    xx.printStackTrace();
                }
                catch (Exception xx) {
                    xx.printStackTrace();
                }
            } else if (!(type != 196611 && type != 196616 || this.lightweightOnly)) {
                int y;
                block179: {
                    int pointery;
                    int pointerx;
                    int packet_len;
                    byte[] packet_dat;
                    int comp;
                    int fil;
                    int enc;
                    int h;
                    int w;
                    int x;
                    if (CentralDebugging.MSG_VERBOSE_ALL) {
                        System.out.println("SCREEN_PACKET " + m);
                    }
                    if (this.img == null) {
                        return;
                    }
                    Long hash = null;
                    if (CentralDebugging.CACHE_ALL_CHUNKS) {
                        hash = (Long)m.pop();
                        if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
                            System.out.println("[ScreenController] received screen chunk ID " + hash);
                        }
                    }
                    boolean blackIsEmpty = false;
                    if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                        int tmp = (Integer)m.get(0);
                        x = 0xFFFF & tmp >>> 16;
                        y = 0xFFFF & tmp;
                        tmp = (Integer)m.get(1);
                        w = 0xFFFF & tmp >>> 16;
                        h = 0xFFFF & tmp;
                        tmp = (Integer)m.get(2);
                        enc = tmp >>> 6;
                        fil = ((tmp & 0x3F) >>> 4) + 50;
                        blackIsEmpty = (tmp & 0xF) >> 3 != 0;
                        comp = (tmp & 7) + 100;
                        packet_dat = (byte[])m.get(3);
                        packet_len = packet_dat.length;
                        pointerx = -1;
                        pointery = -1;
                        if (m.length() > 4) {
                            tmp = (Integer)m.get(4);
                            pointerx = (0xFFFF & tmp >>> 16) - 1;
                            pointery = (0xFFFF & tmp) - 1;
                        }
                    } else {
                        x = (Integer)m.get(0);
                        y = (Integer)m.get(1);
                        w = (Integer)m.get(2);
                        h = (Integer)m.get(3);
                        enc = (Integer)m.get(4);
                        fil = (Integer)m.get(5);
                        blackIsEmpty = (Boolean)m.get(6);
                        comp = (Integer)m.get(7);
                        packet_dat = (byte[])m.get(8);
                        packet_len = packet_dat.length;
                        pointerx = -1;
                        pointery = -1;
                        if (m.length() > 9) {
                            pointerx = (Integer)m.get(9);
                            pointery = (Integer)m.get(10);
                        }
                    }
                    if (VideoRecorder.getInstance() != null) {
                        VideoRecorder.getInstance().addScreenMessage(x, y, w, h, m);
                    }
                    if (pointerx != -1 || pointery != -1) {
                        this.gui.setPointerLocation(pointerx, pointery);
                    }
                    if (comp != 100) {
                        if (comp == 101) {
                            long T = System.currentTimeMillis();
                            this.dcout.reset();
                            ByteArrayInputStream bin = new ByteArrayInputStream(packet_dat);
                            GZIPInputStream gzin = new GZIPInputStream(bin);
                            byte[] buf = new byte[10240];
                            int n = 0;
                            while (n != -1) {
                                n = gzin.read(buf, 0, 10240);
                                if (n <= 0) continue;
                                this.dcout.write(buf, 0, n);
                            }
                            packet_dat = this.dcout.getByteArray();
                            packet_len = this.dcout.size();
                            CentralDebugging.counterAdd("Screen data total decompression (Max ms)", System.currentTimeMillis() - T);
                        } else if (comp == 104) {
                            packet_dat = this.rle.decompress(packet_dat);
                        } else if (comp == 102) {
                            packet_dat = DEFLATEer.s_decompress(packet_dat);
                        } else {
                            return;
                        }
                    }
                    this.rgbadat = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
                    int imgWidth = this.img.getWidth();
                    NonNativeLogicalArray screenLa = new NonNativeLogicalArray(w, h, this.rgbadat, imgWidth, x, y);
                    boolean problemExpected = imgWidth * (y + h) + x > this.rgbadat.length;
                    try {
                        int tmp;
                        long T_decoding = System.currentTimeMillis();
                        if (CentralDebugging.SCR_USE_COLOUR_RLE && enc != 5) {
                            int colourCount;
                            int pN = 0;
                            if ((colourCount = packet_dat[pN++]) == 0) {
                                for (int dy = 0; dy < screenLa.getHeight(); ++dy) {
                                    for (int dx = 0; dx < screenLa.getWidth(); ++dx) {
                                        int tmp2 = -1;
                                        tmp2 = tmp2 << 8 | 0xFF & packet_dat[pN++];
                                        tmp2 = tmp2 << 8 | 0xFF & packet_dat[pN++];
                                        tmp2 = tmp2 << 8 | 0xFF & packet_dat[pN++];
                                        if (blackIsEmpty && tmp2 == -16777216) continue;
                                        screenLa.setXY(dx, dy, tmp2);
                                    }
                                }
                            } else if (colourCount == 1) {
                                int tmp3 = -1;
                                tmp3 = tmp3 << 8 | 0xFF & packet_dat[pN++];
                                tmp3 = tmp3 << 8 | 0xFF & packet_dat[pN++];
                                tmp3 = tmp3 << 8 | 0xFF & packet_dat[pN++];
                                if (!blackIsEmpty || tmp3 != -16777216) {
                                    for (int dy = 0; dy < screenLa.getHeight(); ++dy) {
                                        for (int dx = 0; dx < screenLa.getWidth(); ++dx) {
                                            screenLa.setXY(dx, dy, tmp3);
                                        }
                                    }
                                }
                            } else if (colourCount > 0 && colourCount <= 16) {
                                int pixelsPerByte;
                                int bitsPerPixel;
                                for (int i = 0; i < colourCount; ++i) {
                                    int tmp4 = -1;
                                    tmp4 = tmp4 << 8 | 0xFF & packet_dat[pN++];
                                    tmp4 = tmp4 << 8 | 0xFF & packet_dat[pN++];
                                    this.decodeColors[i] = tmp4 = tmp4 << 8 | 0xFF & packet_dat[pN++];
                                }
                                switch (colourCount) {
                                    case 2: {
                                        bitsPerPixel = 1;
                                        pixelsPerByte = 8;
                                        break;
                                    }
                                    case 3: 
                                    case 4: {
                                        bitsPerPixel = 2;
                                        pixelsPerByte = 4;
                                        break;
                                    }
                                    default: {
                                        bitsPerPixel = 4;
                                        pixelsPerByte = 2;
                                    }
                                }
                                int mask = (1 << bitsPerPixel) - 1;
                                int totalColours = screenLa.getWidth() * screenLa.getHeight();
                                int width = screenLa.getWidth();
                                int dx = 0;
                                int dy = 0;
                                while (totalColours > 0) {
                                    byte b = packet_dat[pN++];
                                    for (int i = 0; i < pixelsPerByte && totalColours > 0; --totalColours, ++i) {
                                        int idx = b >> bitsPerPixel * (pixelsPerByte - 1 - i);
                                        if (!blackIsEmpty || this.decodeColors[idx &= mask] != -16777216) {
                                            screenLa.setXY(dx, dy, this.decodeColors[idx]);
                                        }
                                        dy += ++dx / width;
                                        dx %= width;
                                    }
                                }
                            } else if (colourCount > 0 && colourCount < 128) {
                                for (int i = 0; i < colourCount; ++i) {
                                    int tmp5 = -1;
                                    tmp5 = tmp5 << 8 | 0xFF & packet_dat[pN++];
                                    tmp5 = tmp5 << 8 | 0xFF & packet_dat[pN++];
                                    this.decodeColors[i] = tmp5 = tmp5 << 8 | 0xFF & packet_dat[pN++];
                                }
                                int rgb = 0;
                                int run = 0;
                                int width = screenLa.getWidth();
                                int dx = 0;
                                int dy = 0;
                                int totalColours = screenLa.getWidth() * screenLa.getHeight();
                                boolean tot = false;
                                while (totalColours > 0) {
                                    int idx;
                                    if (((idx = packet_dat[pN++]) & 0x80) == 128) {
                                        int b;
                                        idx += 128;
                                        run = 0;
                                        do {
                                            if ((b = packet_dat[pN++]) < 0) {
                                                b += 256;
                                            }
                                            run += b;
                                        } while (b == 255);
                                    }
                                    rgb = this.decodeColors[idx];
                                    if (!blackIsEmpty || rgb != -16777216) {
                                        screenLa.setXY(dx, dy, rgb);
                                    }
                                    --totalColours;
                                    dy += ++dx / width;
                                    dx %= width;
                                    for (int i = 0; i < run && totalColours > 0; ++i) {
                                        if (!blackIsEmpty || rgb != -16777216) {
                                            screenLa.setXY(dx, dy, rgb);
                                        }
                                        --totalColours;
                                        dy += ++dx / width;
                                        dx %= width;
                                    }
                                    run = 0;
                                }
                            }
                        } else if (blackIsEmpty) {
                            int pN = 0;
                            if (enc != 5) {
                                for (int dy = 0; dy < screenLa.getHeight(); ++dy) {
                                    for (int dx = 0; dx < screenLa.getWidth(); ++dx) {
                                        tmp = -1;
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                                        if ((tmp = tmp << 8 | 0xFF & packet_dat[pN++]) == -16777216) continue;
                                        screenLa.setXY(dx, dy, tmp);
                                    }
                                }
                            } else {
                                for (int dy = 0; dy < screenLa.getHeight(); ++dy) {
                                    for (int dx = 0; dx < screenLa.getWidth(); ++dx) {
                                        if (packet_dat[pN] != 0) {
                                            tmp = -1;
                                            tmp = tmp << 8 | 0xFF & packet_dat[pN];
                                            tmp = tmp << 8 | 0xFF & packet_dat[pN];
                                            tmp = tmp << 8 | 0xFF & packet_dat[pN];
                                            screenLa.setXY(dx, dy, tmp);
                                        }
                                        ++pN;
                                    }
                                }
                            }
                        } else {
                            int pN = 0;
                            if (enc != 5) {
                                for (int dy = 0; dy < screenLa.getHeight(); ++dy) {
                                    for (int dx = 0; dx < screenLa.getWidth(); ++dx) {
                                        tmp = -1;
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN++];
                                        screenLa.setXY(dx, dy, tmp);
                                    }
                                }
                            } else {
                                for (int dy = 0; dy < screenLa.getHeight(); ++dy) {
                                    for (int dx = 0; dx < screenLa.getWidth(); ++dx) {
                                        tmp = -1;
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN];
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN];
                                        tmp = tmp << 8 | 0xFF & packet_dat[pN];
                                        screenLa.setXY(dx, dy, tmp);
                                        ++pN;
                                    }
                                }
                            }
                        }
                        this.addUpdatedRegion(new Rectangle(x, y, w, h));
                        CentralDebugging.counterAdd("Screen data recreation (Max ms)", System.currentTimeMillis() - T_decoding);
                        if (!CentralDebugging.CACHE_ALL_CHUNKS) break block179;
                        if (CentralDebugging.CACHE_EXTERNAL_PROCESS) {
                            if (this.bigCache == null) {
                                try {
                                    this.bigCache = ProcessCache.forkProcessCacheTechnicianSide();
                                }
                                catch (ArrayIndexOutOfBoundsException xx) {
                                    throw xx;
                                }
                                catch (Exception xx) {
                                    xx.printStackTrace();
                                }
                            }
                            this.bigCache.addToCache(hash, screenLa);
                            break block179;
                        }
                        if (this.memCache == null) {
                            try {
                                this.memCache = ProcessCache.getEquivalentCacheCustomerSide();
                            }
                            catch (ArrayIndexOutOfBoundsException xx) {
                                throw xx;
                            }
                            catch (Exception xx) {
                                xx.printStackTrace();
                            }
                        }
                        try {
                            this.memCache.addToCache(hash, ProcessCache.storeLogicalArray(screenLa), ProcessCache.getStoredChunkSize(screenLa));
                        }
                        catch (ArrayIndexOutOfBoundsException xx) {
                            throw xx;
                        }
                        catch (Exception xx) {
                            xx.printStackTrace();
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException xx) {
                        if (problemExpected) {
                            System.out.println("Bounds issue in ScreenController Read Chunk, ignoring since screen res change expected");
                        }
                        System.err.println("Unexpected bounds issue in ScreenController Read Chunk, ignoring since screen res change expected");
                        xx.printStackTrace();
                    }
                }
                long T_setImage = System.currentTimeMillis();
                if (type == 196616) {
                    this.gui.setScreenImage(this.img, this.getUpdatedRegions());
                } else if (!this.no_mid_screen_refreshes && this.last_packet_y != y) {
                    ++this.packet_line_count;
                    this.last_packet_y = y;
                    if (this.packet_line_count >= 3) {
                        this.packet_line_count = 0;
                        if (!this.ignore_captures) {
                            this.gui.setScreenImage(this.img, this.getUpdatedRegions());
                        }
                    }
                }
                CentralDebugging.counterAdd("Screen data set GUI image (Max ms)", System.currentTimeMillis() - T_setImage);
            }
        }
    }

    public ScreenDimension[] getScreenDimensions() {
        return this.receivedScreenDimensions;
    }
}

