/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sgateway.ServiceConfigureGlassDialog;
import com.aem.shelp.common.Language;
import java.io.IOException;
import utils.message.Message;
import utils.message.MessageReader;

public class InputController
extends Thread
implements GC,
MSG {
    Controller controller;
    ClientUserInterface gui;
    MessageReader min;
    boolean die = false;

    public void log(String msg, String details) {
    }

    public InputController(Controller controller, ClientUserInterface gui, MessageReader min) {
        this.controller = controller;
        this.gui = gui;
        this.min = min;
    }

    @Override
    public void run() {
        Message m = null;
        try {
            while (true) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            this.log(Language.get("CONNECTION_TERMINATED"), Language.get("CONNECTION_TERMINATED_DETAILS"));
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Input Controller) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[InputController] " + e);
            }
        }
        catch (Throwable e) {
            System.out.println("(Input Controller) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.die = true;
    }

    public void handleMessage(Message m) throws IOException {
        if (m.getType() == 122333) {
            this.gui.showServerDisabledMessage();
        } else if (m.getType() == 458792) {
            this.controller.ftpJobFinished(m.getAsInt(0));
        } else if (m.getType() == 113595) {
            this.gui.disableDesktop();
        } else if (m.getType() == 109226) {
            boolean hasProxy;
            int index = 0;
            ServiceConfigureGlassDialog.DEF_SERVER_URL = (String)m.get(index++);
            if (hasProxy = m.getAsBoolean(index++)) {
                boolean hasCredentials;
                ServiceConfigureGlassDialog.DEF_PROXY_HOST = m.getAsString(index++);
                ServiceConfigureGlassDialog.DEF_PROXY_PORT = m.getAsInt(index++);
                if (hasCredentials = m.getAsBoolean(index++)) {
                    ServiceConfigureGlassDialog.DEF_PROXY_USERNAME = m.getAsString(index++);
                    ServiceConfigureGlassDialog.DEF_PROXY_PASSWORD = m.getAsString(index++);
                } else {
                    ServiceConfigureGlassDialog.DEF_PROXY_USERNAME = "";
                    ServiceConfigureGlassDialog.DEF_PROXY_PASSWORD = "";
                }
            } else {
                ServiceConfigureGlassDialog.DEF_PROXY_HOST = "";
                ServiceConfigureGlassDialog.DEF_PROXY_PORT = 8080;
            }
        } else if (m.getType() == 104857) {
            boolean canUninstallSg = (Boolean)m.get(0);
            if (canUninstallSg) {
                System.out.println("[InputController] Can uninstall SG");
            } else {
                System.out.println("[InputController] Cannot uninstall SG");
            }
            this.gui.setCanUninstallSG(canUninstallSg);
        }
    }
}

