/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop;

import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import utils.string.HexData;

public class VersionFiles {
    public static final String EXTRACT = "EXTRACT";
    public static final String FETCH = "FETCH";
    public static final String LOAD = "LOAD";

    public static FileInfo[] getFilesOfMode(FileInfo[] allFiles, String mode) {
        return VersionFiles.getFilesOfModes(allFiles, new String[]{mode});
    }

    public static FileInfo[] getFilesOfModes(FileInfo[] allFiles, String[] modes) {
        ArrayList<FileInfo> filteredList = new ArrayList<FileInfo>();
        for (int i = 0; i < allFiles.length; ++i) {
            for (int ii = 0; ii < modes.length; ++ii) {
                if (!allFiles[i].mode.equals(modes[ii])) continue;
                filteredList.add(allFiles[i]);
            }
        }
        FileInfo[] result = new FileInfo[filteredList.size()];
        filteredList.toArray(result);
        return result;
    }

    public static String getMD5OfBytes(byte[] bytes) {
        MessageDigest MD5_DIGEST;
        if (bytes == null) {
            return "-";
        }
        try {
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (Throwable t) {
            System.out.println("[VersionFiles] MD5 Digest Algorithm does not exist!");
            return "-";
        }
        byte[] digest = MD5_DIGEST.digest(bytes);
        String hex = HexData.byteArrayToHexString(digest);
        return hex;
    }

    public static String getMD5OfFile(File file) {
        MessageDigest MD5_DIGEST;
        if (!file.exists()) {
            return "-";
        }
        try {
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (Throwable t) {
            System.out.println("[VersionFiles] MD5 Digest Algorithm does not exist!");
            return "-";
        }
        try {
            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
            byte[] byteData = StreamUtils.readAll(fin);
            byte[] digest = MD5_DIGEST.digest(byteData);
            return HexData.byteArrayToHexString(digest);
        }
        catch (Throwable t) {
            System.out.println("[VersionFiles] MD5 computation failed: " + t.getMessage());
            t.printStackTrace();
            return "-";
        }
    }

    private static String getFileContentsFromServerAsString(String url) throws IOException {
        try {
            URL urlobj = new URL(url);
            URLConnection urlobjc = urlobj.openConnection();
            urlobjc.setUseCaches(false);
            urlobjc.setDoOutput(false);
            InputStream urlin = urlobjc.getInputStream();
            String result = StreamUtils.readAllAsStringISO88951(urlin);
            urlin.close();
            return result;
        }
        catch (IOException ex) {
            System.out.println("[Version] Unable to load " + url + " (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public static FileInfo[] parseVersionFiles(String sourceURL) throws IOException {
        String Versionfiles = VersionFiles.getFileContentsFromServerAsString(sourceURL);
        return VersionFiles.parseVersionFileContent(Versionfiles);
    }

    private static FileInfo[] parseVersionFileContent(String sourceContent) {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        String[] files = sourceContent.trim().split("\n");
        for (int i = 0; i < files.length; ++i) {
            result.add(FileInfo.fromString(files[i]));
        }
        FileInfo[] resultArray = new FileInfo[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static void appendToBuffer(String mode, File file, StringBuffer buffer) {
        VersionFiles.appendToBuffer(mode, file.getName(), file, buffer);
    }

    public static void appendToBuffer(String mode, String fileName, File file, StringBuffer buffer) {
        buffer.append(mode).append("|").append(fileName).append("|").append(file.length()).append("|").append(VersionFiles.getMD5OfFile(file)).append("\n");
    }

    public static class FileInfo {
        public String filename;
        public String md5;
        public long requiredFileSize;
        public String mode;

        public FileInfo(String mode, String filename, long requiredFileSize, String md5) {
            this.mode = mode;
            this.filename = filename;
            this.requiredFileSize = requiredFileSize;
            this.md5 = md5;
        }

        public String toString() {
            return this.mode + "|" + this.filename + "|" + this.requiredFileSize + "|" + this.md5;
        }

        public static FileInfo fromString(String string) {
            if (string.indexOf(124) != -1) {
                String[] fileInfo = string.split("\\|");
                FileInfo info = new FileInfo(fileInfo[0].trim(), fileInfo[1].trim(), Long.parseLong(fileInfo[2].trim()), fileInfo[3].trim());
                return info;
            }
            String[] fileInfo = string.split(":");
            FileInfo info = new FileInfo(fileInfo[0].trim(), fileInfo[1].trim(), 0L, "0");
            return info;
        }

        public boolean matches(File cachedFile) {
            if (!cachedFile.exists()) {
                return false;
            }
            if (cachedFile.length() != this.requiredFileSize) {
                return false;
            }
            String md5 = VersionFiles.getMD5OfFile(cachedFile);
            if (md5 == null) {
                return false;
            }
            return md5.equals(this.md5);
        }
    }
}

