/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStats;
import com.aem.nodelink.utils.BandwidthBuckets;
import com.aem.nodelink.utils.RTTBuckets;
import com.aem.sdesktop.CloseListener;
import com.aem.sdesktop.SessionDescription;
import com.aem.sdesktop.SessionPerformance;
import com.aem.sdesktop.SessionPerformanceReporter;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.client.controller.IgnoredCommandResponseListener;
import com.aem.sdesktop.client.gui.CloseSessionAdvancedDialog;
import com.aem.sdesktop.client.gui.CloseSessionDialog;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.client.gui.HeadlessGUI;
import com.aem.sdesktop.common.FileTransferStats;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.shelp.common.ConnectedTarget;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.login.TechUiLoginGlassDialog;
import com.aem.shelp.common.properties.ServerProperties;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.customer.ParameterHandler;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.authentication.TOTPCodeEntryGlassDialog;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import com.aem.shelp.tech.gstarted.MonitoringOnlyUtil;
import com.aem.shelp.util.SHelpNodelinkPatcher;
import com.aem.shelp.util.ScreenDimension;
import com.aem.shelp.util.WebTransactor;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeScreenUtil;
import com.jw.AuxConfig;
import com.jw.SHJWUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JFrame;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.message.Message;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.ostools.osx.OSXApplicationUtil;
import utils.progtools.time.Time;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.switches.Switches;

public class SimpleDesktop
extends TechClientAdapter
implements CloseListener,
SessionPerformanceReporter {
    private final boolean headless;
    private long startTime;
    private ClientUserInterface gui;
    private Controller con;
    private WebTransactor wtrans;
    private NodeLink sock;
    private SimpleDesktopReconnectListener reconnectListener = new SimpleDesktopReconnectListener();
    private TransientTechUser techUser;
    private byte[] avatarImage;
    private String techNetID;
    private String custNetID;
    private ProxyConnectSettings previousSettings;
    private final Object perf_LOCK = new Object();
    private int perf_N = 1;
    private final Object SAVE_SESSION_LOCK = new Object();

    public JFrame getFrame() {
        return this.gui.getParentFrame();
    }

    public SimpleDesktop(boolean applet, boolean headless) {
        this.headless = headless && Switches.SH_expose_as_a_service_dev_code;
        SessionProperties.INSTANCE.makeWritable();
        System.out.println("[SimpleDesktop] Starting GUI");
        this.gui = this.headless ? new HeadlessGUI() : new GUI(applet, this, this.reconnectListener);
        System.out.println("[SimpleDesktop] Started GUI");
        System.out.println("[SimpleDesktop] Registering MacOS");
        OSXApplicationUtil.macOSXRegistration(this.gui, false);
        System.out.println("[SimpleDesktop] Registered MacOS");
        System.out.println("[SimpleDesktop] Starting Controller");
        this.con = new Controller(false);
        this.con.setSessionPerformanceReporter(this);
        System.out.println("[SimpleDesktop] Started Controller, Initing GUI");
        this.gui.init(this.con);
        System.out.println("[SimpleDesktop] Inited GUI");
        this.con.setGUI(this.gui);
        this.loadNativeLibraries();
    }

    @Override
    public void sgUpdatingDuringConnect() {
        try {
            this.gui.setCentreGreyOverlay(Language.get("REMOTE_COMPUTER_UPDATING_JOINING") + "...", 600000L);
        }
        catch (Throwable t) {
            System.out.println("[SimpleDesktop] Unable to pass on message that SG is currently updating: " + t);
            t.printStackTrace();
        }
    }

    @Override
    public void waitingForRemoteUserToAccept() {
        try {
            this.gui.setCentreGreyOverlay(Language.get("REMOTE_COMPUTER_WAIT_ACCEPT") + "...", 600000L);
        }
        catch (Throwable t) {
            System.out.println("[SimpleDesktop] Unable to pass on message that SG is currently waiting for the remote user to accept the session: " + t);
            t.printStackTrace();
        }
    }

    @Override
    public void machineOnline(Machine machine) {
        this.reconnectListener.notifyMachineOnline(machine);
    }

    private void connect(ProxyConnectSettings settings) throws Exception {
        if (!this.headless && CentralDebugging.ENABLE_NATIVE_HOOKS) {
            try {
                this.setupKeyboardCapture();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (OS.isMacOS() && !this.headless) {
            System.out.println("[SimpleDesktop] Setting dock icon");
            try {
                NativeScreenUtil.showMacOSXDockApplication();
                OSXAdapter.requestForeground(true);
                Image image = ImageLoader.getAsImage("images/svg/logos/simplehelp-blue.svg,256");
                OSXAdapter.setDockIcon(image);
            }
            catch (Throwable image) {
                // empty catch block
            }
            System.out.println("[SimpleDesktop] Set dock icon");
        }
        this.gui.startup(settings);
        long initTime = System.currentTimeMillis();
        if (!settings.amReconnecting) {
            this.startTime = System.currentTimeMillis();
        }
        try {
            BCUtil sessionBCU;
            TechClient tc;
            this.previousSettings = settings;
            SHelpNodelinkPatcher patcherDirect = SHelpNodelinkPatcher.establishConnection(settings.host, settings.port);
            SHelpNodelinkPatcher patcherReplace = SHelpNodelinkPatcher.establishConnection(settings.host, settings.port);
            System.out.println("[SimpleDesktop] Creating TechClient");
            boolean mustDoLogin = false;
            if (settings.credentials == null || !settings.credentials.isValid()) {
                System.out.println("[SimpleDesktop] Incomplete credentials passed in. Will request login credentials now.");
                mustDoLogin = true;
            }
            if (mustDoLogin) {
                boolean first = true;
                boolean previousPasswordIncorrect = false;
                tc = null;
                while (tc == null) {
                    System.out.println("[SimpleDesktop] Requesting login credentials");
                    settings.credentials = this.requestLoginCredentials(SHJWUtil.getUpdateURLProtocol() + "://" + settings.host + ":" + settings.port + "/", first, previousPasswordIncorrect);
                    System.out.println("[SimpleDesktop] Got login credentials [" + settings.getUsername() + "]");
                    first = false;
                    try {
                        tc = new TechClient("NO LANGFILE NEEDED", Language.DEFLANG, settings.host, settings.port, settings.credentials, true, this, this.gui.getNodeLinkStatusListener());
                    }
                    catch (Exception x) {
                        System.out.println("[SimpleDesktop] Unable to create TechClient");
                        x.printStackTrace();
                        previousPasswordIncorrect = x instanceof TechClient.WrongPasswordException;
                    }
                }
                settings.credentials.setSessionToken(tc.getSessionID());
                try {
                    this.gui.setCentreGreyOverlay(Language.get("WAITING_FOR_REMOTE_COMPUTER"), 300000L);
                }
                catch (Throwable x) {}
            } else {
                try {
                    this.gui.setCentreGreyOverlay(Language.get("WAITING_FOR_REMOTE_COMPUTER"), 300000L);
                }
                catch (Throwable first) {
                    // empty catch block
                }
                tc = new TechClient("NO LANGFILE NEEDED", Language.DEFLANG, settings.host, settings.port, settings.credentials, true, this, this.gui.getNodeLinkStatusListener());
                settings.credentials.setSessionToken(tc.getSessionID());
            }
            if (tc.isMonitoringOnly()) {
                try {
                    this.gui.setCentreGreyOverlay(Language.get("SORRY_LIC_NOT_MESSAGE"), 300000L);
                }
                catch (Throwable first) {
                    // empty catch block
                }
                MonitoringOnlyUtil.disallowedPopup(this.gui.getParentFrame(), this.gui.getParentFrame());
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception first) {
                    // empty catch block
                }
                System.exit(0);
            }
            System.out.println("[SimpleDesktop] Setting up Web Transactor");
            this.wtrans = tc.createWebTransactor();
            System.out.println("[SimpleDesktop] Done");
            this.con.setWebTransactor(this.wtrans);
            this.con.setPreviouslyConnectedID(settings.customerOrMachineID, settings.isMachine);
            try {
                if (!settings.amReconnecting) {
                    this.gui.loadBoundsOfWindow();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.techUser = tc.getTechUser();
            System.out.println("[SimpleDesktop] Prefetching batch of requests");
            tc.batchLoadAvatarDebuggingAndToolBox(this.techUser.username);
            Time time = new Time();
            System.out.println("[SimpleDesktop] Checking for avatar image for technician " + this.techUser.username);
            this.avatarImage = tc.getAvatarImage(this.techUser.username);
            this.techUser.avatarBytes = this.avatarImage;
            System.out.println("[SimpleDesktop] Loading centralised debugging properties");
            tc.loadCentralisedDebuggingProperties();
            System.out.println("[SimpleDesktop] Loading toolbox");
            ToolBox box = tc.fetchToolBox();
            this.gui.setToolBox(box);
            System.out.println("[SimpleDesktop] Loading prefetched properties took " + time.lap());
            if (JWLaunchProperties.getProperty("no_preconnection").equalsIgnoreCase("yes")) {
                System.out.println("[SimpleDesktop] Forcing no preconnection");
                settings.preconnectedID = null;
                JWLaunchProperties.deleteProperty("no_preconnection");
            }
            if (JWLaunchProperties.isNonEmpty(settings.preconnectedID)) {
                System.out.println("[SimpleDesktop] Connecting TechClient to existing session");
                String tmpID = settings.preconnectedID;
                settings.preconnectedID = null;
                sessionBCU = tc.connect(tmpID, initTime, settings);
            } else {
                System.out.println("[SimpleDesktop] Connecting TechClient to new session");
                if (JWLaunchProperties.isNonEmpty(settings.directMachineByFilter)) {
                    settings.customerOrMachineID = tc.getConnectionIDUsingFilter(settings.directMachineByFilter, true);
                    settings.isMachine = true;
                } else if (JWLaunchProperties.isNonEmpty(settings.directCustomerByFilter)) {
                    settings.customerOrMachineID = tc.getConnectionIDUsingFilter(settings.directCustomerByFilter, false);
                    settings.isMachine = false;
                }
                System.out.println("[SimpleDesktop] Connecting TechClient to new session");
                sessionBCU = tc.connect(initTime, settings);
            }
            this.techNetID = tc.getTechNetID();
            this.custNetID = tc.getCustNetID();
            if (ConnectedTarget.TARGET != null) {
                AbstractSession session;
                if (ConnectedTarget.TARGET instanceof SupportSession) {
                    session = (SupportSession)ConnectedTarget.TARGET;
                    this.gui.setSessionTitle(((SupportSession)session).getCustomer().getUsefulHumanReadableName() + " - " + session.getOSSummary());
                } else if (ConnectedTarget.TARGET instanceof AccessSession) {
                    session = (AccessSession)ConnectedTarget.TARGET;
                    this.gui.setSessionTitle(((AccessSession)session).getMachine().getMachineName().getName() + " - " + session.getOSSummary());
                }
            }
            tc.setLinkStatusListener(this.gui.getNodeLinkStatusListener());
            try {
                this.gui.setCentreGreyOverlay(Language.get("REMOTE_COMPUTER_READY_JOINING"), 300000L);
            }
            catch (Throwable session) {
                // empty catch block
            }
            System.out.println("[SimpleDesktop] Got connection to customer");
            this.setWebTransactorAsBackingStore(this.wtrans);
            this.sock = tc.getConnectedSocketAndInvalidateTC();
            OutputStream out = tc.getConnectedOutputStream();
            InputStream in = tc.getConnectedInputStream();
            System.out.println("[SimpleDesktop] Beginning controller connection");
            if (settings.techname == null || settings.techname.length() == 0) {
                settings.techname = settings.getUsername();
            }
            if (!settings.isMachine) {
                this.reconnectListener.allowedToReconnect = false;
            }
            this.con.connectToProxy(settings, patcherDirect, patcherReplace, this.sock, in, out, this.gui.getNLOptimisationFeed(), sessionBCU, this.techUser);
            this.previousSettings.pspec = this.con.getPasswordSpecification();
            this.gui.setTechnicianDetails(this.techUser);
            if (!this.techUser.getPermissions().canInstallPersistentConnection()) {
                this.gui.disableSGManagement();
            }
            this.gui.setTechnicianPermissions(this.techUser.getPermissions(), settings.shouldRequestControl);
            this.gui.setCentreGreyOverlay(Language.get("CONNECTED_OK"), 2500L);
            this.fetchAvatar();
            this.gui.setWebTransactor(this.wtrans);
        }
        catch (Exception xx) {
            xx.printStackTrace();
            this.gui.setCentreGreyOverlay(Language.get("CONNECTION_FAILED") + ": " + xx.getMessage(), 25000L);
            throw xx;
        }
    }

    private void setWebTransactorAsBackingStore(WebTransactor wtrans) {
        TechProperties.INSTANCE.setRemoteStore(wtrans);
        SessionProperties.INSTANCE.setRemoteStore(wtrans);
    }

    private void fetchAvatar() {
        try {
            if (this.avatarImage != null && this.avatarImage.length > 0) {
                System.out.println("[SimpleDesktop] Received avatar. Setting in local UI.");
                this.gui.setTechnicianAvatar(this.avatarImage);
                System.out.println("[SimpleDesktop] Sending avatar to customer.");
                Message setAvatarMessage = new Message(-1061158871);
                setAvatarMessage.append(this.avatarImage);
                setAvatarMessage.append(this.techUser.username);
                setAvatarMessage.append(this.techUser.displayName);
                this.con.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), setAvatarMessage);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void connectToProxy(ProxyConnectSettings settings) {
        this.setupPostPreload();
        try {
            this.connect(settings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupPostPreload() {
        this.gui.setupPostPreload();
    }

    @Override
    public void customerListChanged() {
    }

    @Override
    public void setWarningMessage(String text) {
    }

    @Override
    public void doClose() {
    }

    public void forceCloseRequested() {
        try {
            this.reportEndStats();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.wtrans.deregister();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            this.con.closeConnection();
            this.con.terminate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean closeRequested(boolean sessionActive) {
        boolean justClose = true;
        try {
            this.gui.setAutoRefresh(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean advancedCloseDialog = false;
        try {
            advancedCloseDialog = ServerProperties.INSTANCE.getBooleanProp(ServerProperties.PROP_SS_ENABLE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            AbstractSession session = ConnectedTarget.TARGET;
            boolean customerSession = ClientManagement.isSimpleHelp();
            String targetName = "";
            targetName = customerSession && session != null ? session.toString() : ConnectedTarget.getMachineID();
            String chatText = this.getChatText();
            long ellapsedTime = System.currentTimeMillis() - this.startTime;
            String comments = "";
            String customerEmailAddressOption = "";
            boolean skipSessionSummaryEvent = false;
            if (advancedCloseDialog) {
                boolean includeTechComments = ServerProperties.INSTANCE.getBooleanProp(ServerProperties.PROP_SS_TECH_COMMENT);
                boolean allowSkip = ServerProperties.INSTANCE.getBooleanProp(ServerProperties.PROP_SS_ALLOW_SKIP);
                boolean emailCustom = ServerProperties.INSTANCE.getBooleanProp(ServerProperties.PROP_SS_CUSTOM_EMAIL);
                String custEmailDetail = ServerProperties.INSTANCE.getProp(ServerProperties.PROP_SS_CUSTOM_EMAIL_DETAIL);
                String customerEmailAddress = "";
                if (customerSession) {
                    Customer customer = ((SupportSession)session).getCustomer();
                    customerEmailAddress = customer.getValue(custEmailDetail, true);
                }
                this.gui.disableFullScreenMode();
                CloseSessionAdvancedDialog dialog = new CloseSessionAdvancedDialog(null, includeTechComments, emailCustom, customerEmailAddress, allowSkip);
                dialog.setLocationRelativeTo(this.gui.getParentFrame());
                dialog.toFront();
                dialog.setVisible(true);
                justClose = dialog.isOK() || dialog.isSkip();
                skipSessionSummaryEvent = dialog.isSkip();
                if (justClose) {
                    if (dialog.isOK()) {
                        comments = dialog.comments;
                        customerEmailAddressOption = dialog.sendCustomerEmailOption ? dialog.customerEmailAddressOption : "";
                    } else {
                        comments = "";
                        customerEmailAddressOption = "";
                    }
                }
            } else {
                HungExitThread het = new HungExitThread();
                het.start();
                ((GUI)this.gui).disableFullScreenMode();
                if (sessionActive) {
                    boolean showLock = false;
                    CloseSessionDialog dialog = new CloseSessionDialog(this.gui.getParentFrame(), showLock);
                    justClose = dialog.isOKPressed();
                    System.out.println("[SimpleDesktop] Close session dialog returned close:" + justClose);
                } else {
                    justClose = true;
                }
                het.moreThan = -999;
            }
            boolean perfSent = false;
            if (!justClose) {
                this.gui.setAutoRefresh(true);
            } else {
                this.getFrame().setVisible(false);
                if (!skipSessionSummaryEvent) {
                    perfSent = true;
                    System.out.println("[SimpleDesktop] Attempting to save session summary.");
                    this.saveSessionSummary(customerSession, comments, chatText, targetName, customerEmailAddressOption, ellapsedTime, this.getEndStats());
                }
            }
            if (!perfSent) {
                this.reportEndStats();
            }
            if (justClose) {
                try {
                    this.wtrans.deregister();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            System.out.println("[SimpleDesktop] Returning from closeRequested - result is " + justClose);
            return justClose;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return true;
        }
    }

    @Override
    public void reportInterimStats() {
        this.reportStats(false, true);
    }

    @Override
    public void reportEndStats() {
        this.reportStats(true, true);
    }

    @Override
    public SessionPerformance getEndStats() {
        return this.reportStats(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionPerformance reportStats(boolean isEnd, boolean report) {
        NodeLinkStats localNLStats;
        RTTBuckets rttBuckets;
        BandwidthBuckets screenSizes;
        SessionPerformance perf = new SessionPerformance();
        Object object = this.perf_LOCK;
        synchronized (object) {
            perf.sliceID = this.perf_N++;
        }
        perf.techLogin = this.previousSettings != null ? this.previousSettings.getUsername() : "unknown";
        perf.isEnd = isEnd;
        perf.remoteID = this.con.getCustomerOrMachineID();
        perf.techNetID = this.techNetID;
        perf.custNetID = this.custNetID;
        perf.nlSessionID = this.con.getSessionNLID();
        perf.apprtt = this.con.getAppRTTs().cloneSelf();
        FileTransferStats stats = this.gui.getFileTransferStats();
        if (stats != null) {
            perf.totalFilesTransferred = stats.totalFilesTransferred;
            perf.totalBytesTransferred = stats.totalBytesTransferred;
        }
        if ((screenSizes = this.con.getScreenSizes()) != null) {
            perf.screensizes = screenSizes.cloneSelf();
        }
        if ((rttBuckets = this.con.getScreenTimes()) != null) {
            perf.screentimes = rttBuckets.cloneSelf();
        }
        if ((localNLStats = this.con.getLocalSessionStats()) != null) {
            perf.local = localNLStats.cloneSelf();
            perf.sampleDuration = System.currentTimeMillis() - perf.local.sessionStarted;
        }
        if (perf.sampleDuration < 0L) {
            perf.sampleDuration = 0L;
        }
        perf.slowFiltering = this.con.getFiltering() == 52;
        perf.colour = this.con.isColour();
        perf.colourDepth = this.con.getColourDepth();
        perf.updateDelayMs = this.con.getUpdateDelay();
        if (ConnectedTarget.TARGET != null) {
            int i;
            perf.shSessionID = ConnectedTarget.TARGET.getSessionID();
            ScreenDimension[] dimensions = this.con.getScreenDimensions();
            if (dimensions != null) {
                perf.screenDimensions = new Rectangle[dimensions.length];
                for (i = 0; i < dimensions.length; ++i) {
                    perf.screenDimensions[i] = dimensions[i].getPhysicalBounds();
                }
            }
            this.con.getRemoteSessionStats(new PerfStatsPopulator(perf));
            for (i = 0; i < 50; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (perf.remote != null) break;
            }
        }
        this.con.clearSessionStats();
        System.out.println(perf);
        if (report) {
            new SessionPerformanceThread(perf).start();
        }
        return perf;
    }

    private String getChatText() {
        String text = this.gui.getChatText();
        if (text == null) {
            return "";
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSessionPerformance(SessionPerformance perf) {
        try {
            Object object = this.SAVE_SESSION_LOCK;
            synchronized (object) {
                if (this.wtrans != null) {
                    this.wtrans.sendSessionPerformance(perf);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSessionSummary(boolean customerSession, String comments, String chatText, String targetDetails, String customEmailAddress, long ellapsed, SessionPerformance perf) {
        block7: {
            try {
                Object object = this.SAVE_SESSION_LOCK;
                synchronized (object) {
                    SessionDescription sessionDescription;
                    if (customerSession) {
                        SupportSession session = (SupportSession)ConnectedTarget.TARGET;
                        sessionDescription = new SessionDescription.SupportSessionDescription(session.getCustomer());
                    } else {
                        AccessSession session = (AccessSession)ConnectedTarget.TARGET;
                        sessionDescription = new SessionDescription.AccessSessionDescription(session.getMachine());
                    }
                    sessionDescription.technicianSummary = comments;
                    sessionDescription.chatTranscript = chatText;
                    sessionDescription.sessionDurationMS = ellapsed;
                    sessionDescription.customEmailAddress = customEmailAddress;
                    sessionDescription.setSessionID(ConnectedTarget.TARGET.getSessionID());
                    this.wtrans.sendSessionSummary(sessionDescription, perf);
                }
            }
            catch (Throwable t) {
                System.out.println("[SimpleDesktop] Unable to save session summary: " + t.getMessage());
                t.printStackTrace();
                if (!this.gui.getParentFrame().isVisible()) break block7;
                System.out.println("[SimpleDesktop] Showing error dialog to notify user that the session has terminated");
                SHGlassOptionPane.showErrorDialog(this.gui.getParentFrame(), Language.get("ERROR_SAVING_SUMMARY_MSG"), Language.get("ERROR_SAVING_SUMMARY_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            }
        }
    }

    public void loadNativeLibraries() {
        AuxConfig.blockUntilAuxDownloaded();
        System.out.println("[SimpleDesktop] Loading native libraries");
        NativeLibraryLoader.loadLibrary(JWSystem.getAppFolder());
        this.gui.initEventListeners();
        System.out.println("[NativeUtilsLoader] Done");
    }

    private void setupKeyboardCapture() {
        System.out.println("[NativeUtilsLoader] Setting up keyboard capture hook");
        if (OS.isWindows() && JWNativeAPI.getInstance() != null) {
            new Thread("KeyboardHook"){

                @Override
                public void run() {
                    System.out.println("[SimpleDesktop] Loading keyboard hook.");
                    JWNativeAPI.getInstance().installKeyboardHookAndBlockThread(SimpleDesktop.this.gui);
                }
            }.start();
            System.out.println("[SimpleDesktop] Enabling keyboard hook.");
            JWNativeAPI.getInstance().setKeyboardHookEnabled(true);
        } else {
            System.out.println("[NativeUtilsLoader] Cannot set up keyboard capture hook as NativeUtils was not initialised.");
        }
    }

    @Override
    public TechClientListener.TwoTierResponse requestTwoTierCode(boolean showIncorrectWarning, String emailAddress, boolean allowRemember) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
        if (emailAddress != null) {
            TwoTierCodeEntryGlassDialog dialog = new TwoTierCodeEntryGlassDialog(this.getFrame(), showIncorrectWarning, emailAddress, allowRemember);
            return dialog.getCode();
        }
        TOTPCodeEntryGlassDialog dialog = new TOTPCodeEntryGlassDialog(this.getFrame(), showIncorrectWarning, allowRemember);
        return dialog.getCode();
    }

    @Override
    public TechClientListener.TwoTierResponse processAuthenticationChallenge(boolean showIncorrectWarning, String replyMessage) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
        TOTPCodeEntryGlassDialog dialog = new TOTPCodeEntryGlassDialog(this.getFrame(), showIncorrectWarning, false, replyMessage);
        return dialog.getCode();
    }

    public TechCredentials requestLoginCredentials(String baseurl, boolean first, boolean previousPasswordIncorrect) throws Exception {
        System.out.println("[SimpleDesktop] Launching TechUiLoginDialog");
        if (!baseurl.endsWith("/")) {
            baseurl = baseurl + "/";
        }
        ParameterHandler ph = new ParameterHandler(this.getFrame(), baseurl);
        try {
            ph.retrieveParametersFromServer();
        }
        catch (Exception x) {
            throw new Exception("Unable to contact server");
        }
        System.out.println("[SimpleDesktop] Launching Login dialog");
        TechUiLoginGlassDialog login = new TechUiLoginGlassDialog(this.getFrame(), null, first, previousPasswordIncorrect);
        TechCredentials credentials = login.getCredentials();
        if (credentials == null) {
            System.out.println("[SimpleDesktop] User cancelled login, exiting");
            System.exit(0);
        }
        System.out.println("[SimpleDesktop] Got credentials " + credentials);
        return credentials;
    }

    class HungExitThread
    extends Thread {
        int moreThan;

        public HungExitThread() {
            this.moreThan = SimpleDesktop.this.gui.getParentFrame().getOwnedWindows().length;
        }

        @Override
        public void run() {
            this.setName("HungExitThread");
            try {
                Thread.sleep(6000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (SimpleDesktop.this.gui.getParentFrame().getOwnedWindows().length <= this.moreThan) {
                System.exit(0);
            }
        }
    }

    class SessionPerformanceThread
    extends Thread {
        SessionPerformance perf;

        public SessionPerformanceThread(SessionPerformance perf) {
            this.perf = perf;
        }

        @Override
        public void run() {
            this.setName("SessionPerfReportThread");
            SimpleDesktop.this.sendSessionPerformance(this.perf);
        }
    }

    class PerfStatsPopulator
    implements CommandResponseListener {
        SessionPerformance perf;

        public PerfStatsPopulator(SessionPerformance perf) {
            this.perf = perf;
        }

        @Override
        public void response(Message m) {
            this.perf.remote = NodeLinkStats.fromBytes((byte[])m.get(0));
        }
    }

    private class SimpleDesktopReconnectListener
    implements ReconnectListener {
        boolean allowedToReconnect = false;
        private final ArrayList<TechClientListener> listeners = new ArrayList();

        private SimpleDesktopReconnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addMachineOnlineListener(TechClientListener listener) {
            ArrayList<TechClientListener> arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyMachineOnline(Machine machine) {
            ArrayList<TechClientListener> arrayList = this.listeners;
            synchronized (arrayList) {
                for (TechClientListener listener : this.listeners) {
                    listener.machineOnline(machine);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeMachineOnlineListener(TechClientListener listener) {
            ArrayList<TechClientListener> arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(listener);
            }
        }

        @Override
        public void setAllowReconnect() {
            System.out.println("[ReconnectUtil] Allowing reconnections...");
            this.allowedToReconnect = true;
        }

        @Override
        public boolean canReconnect() {
            System.out.println("[ReconnectUtil] CanReconnect = " + this.allowedToReconnect);
            return this.allowedToReconnect;
        }

        @Override
        public void reconnect() throws Exception {
            System.out.println("[ReconnectUtil] Session full reconnect requested");
            SimpleDesktop.this.con.clearConnection("session reconnect requested, closing current");
            System.out.println("[ReconnectUtil] Previous connection cleared. Calling reconnect.");
            try {
                ((SimpleDesktop)SimpleDesktop.this).previousSettings.retry = false;
                ((SimpleDesktop)SimpleDesktop.this).previousSettings.amReconnecting = true;
                SimpleDesktop.this.connect(SimpleDesktop.this.previousSettings);
            }
            catch (Exception ex) {
                SimpleDesktop.this.con.closeConnection();
                throw ex;
            }
            SimpleDesktop.this.gui.linkOK(null);
        }

        @Override
        public void setDisableReconnect() {
            System.out.println("[ReconnectUtil] Disabling reconnections...");
            this.allowedToReconnect = false;
        }
    }

    public static interface ReconnectListener {
        public void setAllowReconnect();

        public void reconnect() throws Exception;

        public void setDisableReconnect();

        public boolean canReconnect();

        public void addMachineOnlineListener(TechClientListener var1);

        public void notifyMachineOnline(Machine var1);

        public void removeMachineOnlineListener(TechClientListener var1);
    }
}

