/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop;

import com.aem.nodelink.NodeLinkStats;
import com.aem.nodelink.utils.BandwidthBuckets;
import com.aem.nodelink.utils.RTTBuckets;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Properties;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.string.HexData;
import utils.switches.Switches;
import utils.xml.XML14Util;

public class SessionPerformance {
    String techLogin;
    int sliceID;
    String remoteID;
    String techNetID;
    String custNetID;
    NodeLinkStats local;
    NodeLinkStats remote;
    RTTBuckets apprtt;
    RTTBuckets screentimes;
    BandwidthBuckets screensizes;
    long sampleDuration;
    boolean isEnd;
    long created = System.currentTimeMillis();
    long received;
    String nlSessionID;
    String shSessionID;
    int updateDelayMs;
    int colourDepth;
    boolean colour;
    boolean slowFiltering;
    int totalFilesTransferred;
    long totalBytesTransferred;
    Rectangle[] screenDimensions;

    public SessionPerformance() {
    }

    public SessionPerformance(Message m) {
        int i;
        this.techLogin = m.getNextString();
        if (m.getNextBoolean()) {
            this.local = NodeLinkStats.fromBytes(m.getNextByteArray());
        }
        if (m.getNextBoolean()) {
            this.remote = NodeLinkStats.fromBytes(m.getNextByteArray());
        }
        this.apprtt = new RTTBuckets();
        this.apprtt.rtts = new long[m.getNextInt()];
        for (i = 0; i < this.apprtt.rtts.length; ++i) {
            this.apprtt.rtts[i] = m.getNextInt();
        }
        this.screentimes = new RTTBuckets();
        this.screentimes.rtts = new long[m.getNextInt()];
        for (i = 0; i < this.screentimes.rtts.length; ++i) {
            this.screentimes.rtts[i] = m.getNextInt();
        }
        this.screensizes = new BandwidthBuckets();
        this.screensizes.bytes = new long[m.getNextInt()];
        for (i = 0; i < this.screensizes.bytes.length; ++i) {
            this.screensizes.bytes[i] = m.getNextInt();
        }
        this.sampleDuration = m.getNextLong();
        this.isEnd = m.getNextBoolean();
        this.nlSessionID = m.getNextString();
        this.colour = m.getNextBoolean();
        this.slowFiltering = m.getNextBoolean();
        this.colourDepth = m.getNextInt();
        this.updateDelayMs = m.getNextInt();
        this.remoteID = m.getNextString();
        this.techNetID = m.getNextString();
        this.custNetID = m.getNextString();
        if (Switches.SH_enhancement_2783401_3_indexedPerfStats && m.hasNext()) {
            this.sliceID = m.getNextInt();
        }
        if (m.hasNext()) {
            this.shSessionID = m.getNextString();
        }
        if (m.hasNext()) {
            this.screenDimensions = new Rectangle[m.getNextInt()];
            for (i = 0; i < this.screenDimensions.length; ++i) {
                this.screenDimensions[i] = new Rectangle(m.getNextInt(), m.getNextInt(), m.getNextInt(), m.getNextInt());
            }
        }
        if (m.hasNext()) {
            this.totalFilesTransferred = m.getNextInt();
            this.totalBytesTransferred = m.getNextLong();
        }
        if (m.hasNext()) {
            this.created = m.getNextLong();
            this.received = System.currentTimeMillis();
        }
    }

    public Message toMessage() {
        int i;
        Message m = new Message();
        m.append(this.techLogin);
        if (this.local != null) {
            m.append(true);
            m.append(this.local.toBytes());
        } else {
            m.append(false);
        }
        if (this.remote != null) {
            m.append(true);
            m.append(this.remote.toBytes());
        } else {
            m.append(false);
        }
        if (this.apprtt == null || this.apprtt.rtts == null) {
            m.append(0);
        } else {
            m.append(this.apprtt.rtts.length);
            for (i = 0; i < this.apprtt.rtts.length; ++i) {
                m.append((int)this.apprtt.rtts[i]);
            }
        }
        if (this.screentimes == null || this.screentimes.rtts == null) {
            m.append(0);
        } else {
            m.append(this.screentimes.rtts.length);
            for (i = 0; i < this.screentimes.rtts.length; ++i) {
                m.append((int)this.screentimes.rtts[i]);
            }
        }
        if (this.screensizes == null || this.screensizes.bytes == null) {
            m.append(0);
        } else {
            m.append(this.screensizes.bytes.length);
            for (i = 0; i < this.screensizes.bytes.length; ++i) {
                m.append((int)this.screensizes.bytes[i]);
            }
        }
        m.append(this.sampleDuration);
        m.append(this.isEnd);
        m.append(this.nlSessionID);
        m.append(this.colour);
        m.append(this.slowFiltering);
        m.append(this.colourDepth);
        m.append(this.updateDelayMs);
        m.append(this.remoteID);
        m.append(this.techNetID);
        m.append(this.custNetID);
        if (Switches.SH_enhancement_2783401_3_indexedPerfStats) {
            m.append(this.sliceID);
        }
        m.append(this.shSessionID);
        if (this.screenDimensions == null) {
            m.append(0);
        } else {
            m.append(this.screenDimensions.length);
            for (Rectangle screenDimension : this.screenDimensions) {
                m.append(screenDimension.x);
                m.append(screenDimension.y);
                m.append(screenDimension.width);
                m.append(screenDimension.height);
            }
        }
        m.append(this.totalFilesTransferred);
        m.append(this.totalBytesTransferred);
        m.append(this.created);
        return m;
    }

    private void appendStats(StringBuffer sb, NodeLinkStats stats) {
        if (stats == null) {
            return;
        }
        long length = (stats.currentTime - stats.sessionStarted) / 1000L;
        sb.append("Type:").append(this.getType(stats));
        if (stats.diedTimes > 0L) {
            sb.append(", Failures:***").append(stats.diedTimes).append("***");
        } else {
            sb.append(", Failures:").append(stats.diedTimes);
        }
    }

    public String getType(NodeLinkStats stats) {
        if (stats == null) {
            return "";
        }
        if (stats.type == 0) {
            return "HTTP";
        }
        if (stats.type == 1) {
            return "SSL";
        }
        if (stats.type == 2) {
            return "TCP";
        }
        if (stats.type == 3) {
            return "ProxiedUDP";
        }
        if (stats.type == 4) {
            return "DirectUDP";
        }
        if (stats.type == 5) {
            return "ProxyTCP";
        }
        if (stats.type == 6) {
            return "UdpNLtoServer";
        }
        return "";
    }

    public String getTypeShort(NodeLinkStats stats) {
        if (stats == null) {
            return "";
        }
        if (stats.type == 0) {
            return "HTTP";
        }
        if (stats.type == 1) {
            return "SSL";
        }
        if (stats.type == 2) {
            return "TCP";
        }
        if (stats.type == 3) {
            return "UDP 4*";
        }
        if (stats.type == 4) {
            return "UDP 5*";
        }
        if (stats.type == 5) {
            return "ProxyTCP";
        }
        if (stats.type == 6) {
            return "UdpNLtoServer";
        }
        return "";
    }

    private void appendStatsXML(StringBuffer sb, NodeLinkStats stats, int indent) {
        if (stats == null) {
            return;
        }
        sb.append(" Type=\"").append(XML14Util.escape(this.getType(stats))).append("\"");
        sb.append(" AppTP=\"").append(XML14Util.escape((int)stats.maxReadRateKB + "kb/s")).append("\"");
        sb.append(" Failures=\"").append(XML14Util.escape("" + stats.diedTimes)).append("\"");
    }

    public String getNLSessionID() {
        return this.nlSessionID;
    }

    public String getSHSessionID() {
        return this.shSessionID;
    }

    public String toXML(int indent) {
        StringBuffer buffer = new StringBuffer();
        this.toXML(buffer, indent);
        return buffer.toString();
    }

    public String toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent(indent)).append("<SessionPerformance");
        buffer.append(" User=\"").append(XML14Util.escape(this.techLogin)).append("\"");
        buffer.append(" NL=\"").append(XML14Util.escape(this.nlSessionID)).append("\"");
        buffer.append(" Entity=\"").append(XML14Util.escape(this.remoteID)).append("\"");
        buffer.append(" TechNet=\"").append(XML14Util.escape(this.techNetID)).append("\"");
        buffer.append(" CustNet=\"").append(XML14Util.escape(this.custNetID)).append("\"");
        buffer.append(" Sample=\"").append(XML14Util.escape(Math.max(0L, (this.sampleDuration - RTTBuckets.IGNORE_FIRST_MS) / 1000L) + "s")).append("\"");
        buffer.append(" Index=\"").append(XML14Util.escape(this.sliceID + "")).append("\"");
        buffer.append(" Slice=\"").append(XML14Util.escape(this.isEnd ? "Final" : "Interim")).append("\"");
        buffer.append(" Colour=\"").append(XML14Util.escape(this.colour ? "Color" : "B+W")).append("\"");
        buffer.append(" Filtering=\"").append(XML14Util.escape(this.slowFiltering ? "Fine" : "Coarse")).append("\"");
        buffer.append(" Depth=\"").append(XML14Util.escape(this.colourDepth + "")).append("\"");
        buffer.append(" Updates=\"").append(XML14Util.escape(this.updateDelayMs + "ms")).append("\"");
        buffer.append(" FileTransferCount=\"").append(XML14Util.escape(this.totalFilesTransferred + "")).append("\"");
        buffer.append(" FileTransferSize=\"").append(XML14Util.escape(this.totalBytesTransferred + "")).append("\"");
        buffer.append(">\n");
        if (this.local != null) {
            buffer.append(XML14Util.getIndent(indent + 1)).append("<TechSide");
            this.appendStatsXML(buffer, this.local, indent + 2);
            buffer.append("/>\n");
        }
        if (this.remote != null) {
            buffer.append(XML14Util.getIndent(indent + 1)).append("<CustSide");
            this.appendStatsXML(buffer, this.remote, indent + 2);
            buffer.append("/>\n");
        }
        if (this.screenDimensions != null && this.screenDimensions.length > 0) {
            buffer.append(XML14Util.getIndent(indent + 1)).append("<Displays>\n");
            for (Rectangle size : this.screenDimensions) {
                buffer.append(XML14Util.getIndent(indent + 2)).append("<Display width=\"").append(size.width).append("\" height=\"").append(size.height).append("\"/>\n");
            }
            buffer.append(XML14Util.getIndent(indent + 1)).append("</Displays>\n");
        }
        BucketsWrapper[] commonBuckets = new BucketsWrapper[]{new BucketsWrapper(this.apprtt, "App"), new BucketsWrapper(this.local.buckets, "Transport"), new BucketsWrapper(this.screentimes, "Screen")};
        buffer.append(this.RTTBucketsToXML(commonBuckets, indent + 1));
        buffer.append(this.UpdatesBucketsToXML(this.screensizes, indent + 1));
        buffer.append(XML14Util.getIndent(indent)).append("</SessionPerformance>\n");
        return buffer.toString();
    }

    public void toProperties(Properties properties) {
        String value = this.toString();
        String[] parts = value.split("\n");
        properties.put("metrics_settings", parts[0]);
    }

    public int getColourDepth() {
        return this.colourDepth;
    }

    private String RTTBucketsToXML(BucketsWrapper[] commonBuckets, int indent) {
        StringBuilder result = new StringBuilder();
        result.append(XML14Util.getIndent(indent)).append("<AppRTTBands units=\"ms\">\n");
        int to = 0;
        String fromString = "0";
        long[] totals = new long[commonBuckets.length];
        for (int j = 0; j < totals.length; ++j) {
            for (int k = 0; k < commonBuckets[j].bucket.rtts.length; ++k) {
                int n = j;
                totals[n] = totals[n] + commonBuckets[j].bucket.rtts[k];
            }
        }
        for (int i = 0; i < RTTBuckets.rttLimits.length; ++i) {
            to = RTTBuckets.rttLimits[i];
            String toString = i == RTTBuckets.rttLimits.length - 1 ? "Infinity" : "" + to;
            result.append(XML14Util.getIndent(indent + 1)).append("<RTTBand from=\"").append(fromString).append("\" to=\"").append(toString).append("\" ");
            DecimalFormat df = new DecimalFormat("0");
            for (int j = 0; j < commonBuckets.length; ++j) {
                double pc;
                long[] rtts = commonBuckets[j].bucket.rtts;
                double frac = 100.0 / (double)totals[j];
                String sResult = "0%";
                if (!Double.isNaN(frac) && !Double.isInfinite(frac) && (pc = frac * (double)rtts[i]) > 0.0) {
                    String str = df.format(Math.min(99.0, pc));
                    sResult = str + "%";
                }
                result.append(commonBuckets[j].name).append("=\"").append(sResult).append("\" ");
            }
            result.append("/>").append("\n");
            fromString = toString;
        }
        result.append(XML14Util.getIndent(indent)).append("</AppRTTBands>\n");
        return result.toString();
    }

    private String UpdatesBucketsToXML(BandwidthBuckets buckets, int indent) {
        StringBuilder result = new StringBuilder();
        result.append(XML14Util.getIndent(indent)).append("<ScreenUpdateBands units=\"b\">\n");
        int to = 0;
        String fromString = "0";
        long total = 0L;
        for (int k = 0; k < buckets.bytes.length; ++k) {
            total += buckets.bytes[k];
        }
        for (int i = 0; i < BandwidthBuckets.byteLimits.length; ++i) {
            double pc;
            to = BandwidthBuckets.byteLimits[i];
            String toString = i == BandwidthBuckets.byteLimits.length - 1 ? "Infinity" : "" + to;
            result.append(XML14Util.getIndent(indent + 1)).append("<UpdateBand from=\"").append(fromString).append("\" to=\"").append(toString).append("\" ");
            DecimalFormat df = new DecimalFormat("0");
            long[] bytes = buckets.bytes;
            double frac = 100.0 / (double)total;
            String sResult = "0%";
            if (!Double.isNaN(frac) && !Double.isInfinite(frac) && (pc = frac * (double)bytes[i]) > 0.0) {
                String str = df.format(Math.min(99.0, pc));
                sResult = str + "%";
            }
            result.append("ScreenUpdates").append("=\"").append(sResult).append("\" ");
            result.append("/>").append("\n");
            fromString = toString;
        }
        result.append(XML14Util.getIndent(indent)).append("</ScreenUpdateBands>\n");
        return result.toString();
    }

    public static void main(String[] args) {
        String hex = "0B00016C000007FF0501B000000150FC4E0D2900000000000000000000000300000150FC4E5D1200000000000055D400000000000C0F280000001E0000000F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004045752D2830ACD907FF0501B000000150FC4E087300000000000000000000000300000150FC4E5DC300000000000C0F2800000000000056380000001E0000000F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003FF4C4F2F8B9718901011E01010C0100010101010101010101010101010001010101010101000100010001000100010001000100010001000100010001000100010001000100010001000100010001011E01000100010001000100010001000101030101050101030100010001000100010001000100010001000100010001000100010001000100010001000100010001011E0101060100010001000100010101010102010001000100010001010201000100010001000100010001000100010001000100010001000100010001000100010002024FE907FF0001084E4C39373932393007FF07EE0101FF01012800011653475F373536313836363638303639363631353132330001093132372E302E302E3100010831302E302E312E36";
        Message m = MessageUtils.bytesToMessage(HexData.hexStringToByteArray(hex));
        SessionPerformance sp = new SessionPerformance(m);
        System.out.println(sp.toXML(6));
        sp.screenDimensions = new Rectangle[1];
        sp.screenDimensions[0] = new Rectangle(0, 0, 1024, 768);
        System.out.println(sp.toXML(6));
    }

    public static SessionPerformance createTestPerformance() {
        String hex = "0B00016C000007FF0501B000000150FC4E0D2900000000000000000000000300000150FC4E5D1200000000000055D400000000000C0F280000001E0000000F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004045752D2830ACD907FF0501B000000150FC4E087300000000000000000000000300000150FC4E5DC300000000000C0F2800000000000056380000001E0000000F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003FF4C4F2F8B9718901011E01010C0100010101010101010101010101010001010101010101000100010001000100010001000100010001000100010001000100010001000100010001000100010001011E01000100010001000100010001000101030101050101030100010001000100010001000100010001000100010001000100010001000100010001000100010001011E0101060100010001000100010101010102010001000100010001010201000100010001000100010001000100010001000100010001000100010001000100010002024FE907FF0001084E4C39373932393007FF07EE0101FF01012800011653475F373536313836363638303639363631353132330001093132372E302E302E3100010831302E302E312E36";
        Message m = MessageUtils.bytesToMessage(HexData.hexStringToByteArray(hex));
        SessionPerformance sp = new SessionPerformance(m);
        return sp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("User:[").append(this.techLogin).append("]");
        sb.append(", NL:").append(this.nlSessionID);
        if (Switches.SH_enhancement_2783401_3_indexedPerfStats) {
            sb.append(", Index:").append(this.sliceID);
        }
        sb.append(", Entity:").append(this.remoteID);
        sb.append(", TechNet:").append(this.techNetID);
        sb.append(", CustNet:").append(this.custNetID);
        sb.append(", Sample:").append(Math.max(0L, (this.sampleDuration - RTTBuckets.IGNORE_FIRST_MS) / 1000L)).append("s");
        if (this.isEnd) {
            sb.append(", Final");
        } else {
            sb.append(", Interim");
        }
        if (this.colour) {
            sb.append(", Color");
        } else {
            sb.append(", B+W");
        }
        if (this.slowFiltering) {
            sb.append(", Fine");
        } else {
            sb.append(", Coarse");
        }
        sb.append(", Depth:").append(this.colourDepth);
        sb.append(", Updates:").append(this.updateDelayMs).append("ms");
        sb.append(", FileTransfers:").append(this.totalFilesTransferred).append("/").append(this.totalBytesTransferred).append("b");
        if (this.local != null) {
            sb.append(", TechSide: ");
            this.appendStats(sb, this.local);
        }
        if (this.remote != null) {
            sb.append(", CustSide: ");
            this.appendStats(sb, this.remote);
        }
        sb.append("\n");
        if (this.apprtt != null) {
            sb.append(this.apprtt.getRttLines("      App", true, true));
        }
        if (this.local != null && this.local.buckets != null) {
            sb.append(this.local.buckets.getRttLines("Transport", false, true));
        }
        if (this.screentimes != null) {
            sb.append(this.screentimes.getRttLines("   Screen", false, true));
        }
        if (this.screensizes != null) {
            sb.append(this.screensizes.getRttLines("  Updates", true, true));
        }
        return sb.toString();
    }

    public String getLocalConnectionType() {
        return this.getTypeShort(this.local);
    }

    public String getRemoteConnectionType() {
        return this.getTypeShort(this.remote);
    }

    public long getUpdateDelayMS() {
        return this.updateDelayMs;
    }

    private static class BucketsWrapper {
        final RTTBuckets bucket;
        final String name;

        public BucketsWrapper(RTTBuckets bucket, String name) {
            this.name = name;
            this.bucket = bucket;
        }
    }
}

