/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStats;
import com.aem.nodelink.vis.NLOptimisationFeed;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.controller.MachinePrefs;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.server.controller.ImmediateFileTransferListener;
import com.aem.sdesktop.util.FileEntry;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.util.SHelpNodelinkPatcher;
import com.aem.utils.keyhandling.KeyRequest;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.sound.sampled.Mixer;
import utils.files.RemoteFile;
import utils.message.Message;
import utils.swing.components.path.elements.FTPVolume;

public class ProxiedClientController
implements ClientController {
    private static int REQ_SCR_PNGS = 88000;
    private static int CONT_REQ_SCR = 88001;
    private static int REQ_SCR_RESEND = 88002;
    private static int GET_FILTERING = 88003;
    private static int IS_COLOUR = 88004;
    private static int GET_COLOUR_DEPTH = 88005;
    private static int GET_UPDATE_DELAY = 88006;
    private static int SET_AERO_STATE = 88007;
    private static int SET_BG_IMAGE_STATE = 88008;
    private static int SET_USE_HW_ACCEL = 88009;
    private static int SET_COLOUR = 88010;
    private static int SET_FILTERING = 88011;
    private static int SET_COLOUR_DEPTH = 88012;
    private static int SET_UPDATE_DELAY = 88013;
    private static int GET_LOCAL_CONNECTION_STATS = 88014;
    private static int SET_LOCK_DESKTOP_STATE = 88015;
    private static int OK = 88888;
    private static int NOT_RECOGNISED = 89999;
    private static boolean isSdemo = true;
    private boolean screenUpdatesOn = false;
    TechClient client;
    String demoName;
    ClientController con;

    public ProxiedClientController(TechClient client, String demoName) {
        this.client = client;
        this.demoName = demoName;
    }

    private Message doProxiedClientControllerTransaction(Message m) {
        try {
            Message r = this.client.doProxiedClientControllerTransaction(this.demoName, m);
            if (r.getType() == NOT_RECOGNISED) {
                throw new Exception("Proxied client controller message not recognised at server " + m.getType());
            }
            return r;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public boolean screenUpdatesAreOn() {
        return this.screenUpdatesOn;
    }

    public ProxiedClientController(ClientController con) {
        this.con = con;
    }

    public Message handleProxiedControllerMessage(Message m) {
        Message ret;
        int type;
        if (CentralDebugging.PX_PROXIED_CONTROLLER_MSGS) {
            System.out.println("[ProxiedController] " + m);
        }
        if ((type = m.getType()) == REQ_SCR_PNGS) {
            if (m.length() > 0) {
                int x = m.getAsInt(0);
                int y = m.getAsInt(1);
                int w = m.getAsInt(2);
                int h = m.getAsInt(3);
                this.con.requestScreenAsPngs(new Rectangle(x, y, w, h));
            } else {
                this.con.requestScreenAsPngs(null);
            }
            ret = new Message(OK);
        } else if (type == CONT_REQ_SCR) {
            boolean b;
            this.screenUpdatesOn = b = ((Boolean)m.get(0)).booleanValue();
            this.con.setContinuousRequestScreen(b);
            ret = new Message(OK);
        } else if (type == REQ_SCR_RESEND) {
            this.con.requestScreenResend();
            ret = new Message(OK);
        } else if (type == GET_FILTERING) {
            ret = new Message(OK);
            ret.append(this.con.getFiltering());
        } else if (type == IS_COLOUR) {
            ret = new Message(OK);
            ret.append(this.con.isColour());
        } else if (type == GET_COLOUR_DEPTH) {
            ret = new Message(OK);
            ret.append(this.con.getColourDepth());
        } else if (type == GET_UPDATE_DELAY) {
            ret = new Message(OK);
            ret.append(this.con.getUpdateDelay());
        } else if (type == SET_AERO_STATE) {
            this.con.setAeroEffectsState(m.getNextBoolean());
            ret = new Message(OK);
        } else if (type == SET_LOCK_DESKTOP_STATE) {
            this.con.setLockDesktop(m.getNextBoolean());
            ret = new Message(OK);
        } else if (type == SET_BG_IMAGE_STATE) {
            this.con.setBackgroundImageState(m.getNextBoolean());
            ret = new Message(OK);
        } else if (type == SET_USE_HW_ACCEL) {
            this.con.setUseHardwareAcceleration(m.getNextBoolean());
            ret = new Message(OK);
        } else if (type == SET_COLOUR) {
            this.con.setColour(m.getNextBoolean());
            ret = new Message(OK);
        } else if (type == SET_FILTERING) {
            this.con.setFiltering(m.getNextInt());
            ret = new Message(OK);
        } else if (type == SET_COLOUR_DEPTH) {
            this.con.setColourDepth(m.getNextInt());
            ret = new Message(OK);
            this.con.requestScreenAsPngs(null);
        } else if (type == SET_UPDATE_DELAY) {
            this.con.setUpdateDelay(m.getNextLong());
            ret = new Message(OK);
            this.con.requestScreenAsPngs(null);
        } else if (type == GET_LOCAL_CONNECTION_STATS) {
            NodeLinkStats stats = this.con.getLocalSessionStats();
            ret = new Message(OK);
            ret.append(stats.toBytes());
        } else {
            ret = new Message(NOT_RECOGNISED);
        }
        return ret;
    }

    @Override
    public void requestScreenResend() {
        Message m = new Message(REQ_SCR_RESEND);
        this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void requestScreenResendAsPngs(Rectangle requestArea) {
        Message m = new Message(REQ_SCR_RESEND);
        if (requestArea != null) {
            m.append(requestArea.x);
            m.append(requestArea.y);
            m.append(requestArea.width);
            m.append(requestArea.height);
        }
        this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void requestScreenAsPngs(Rectangle requestArea) {
        Message m = new Message(REQ_SCR_PNGS);
        if (requestArea != null) {
            m.append(requestArea.x);
            m.append(requestArea.y);
            m.append(requestArea.width);
            m.append(requestArea.height);
        }
        this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void setContinuousRequestScreen(boolean b) {
        Message m = new Message(CONT_REQ_SCR);
        m.append(b);
        this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public int getFiltering() {
        Message m = new Message(GET_FILTERING);
        m = this.doProxiedClientControllerTransaction(m);
        return (Integer)m.get(0);
    }

    @Override
    public boolean isColour() {
        Message m = new Message(IS_COLOUR);
        m = this.doProxiedClientControllerTransaction(m);
        return (Boolean)m.get(0);
    }

    @Override
    public int getColourDepth() {
        Message m = new Message(GET_COLOUR_DEPTH);
        m = this.doProxiedClientControllerTransaction(m);
        return (Integer)m.get(0);
    }

    @Override
    public int getUpdateDelay() {
        Message m = new Message(GET_UPDATE_DELAY);
        m = this.doProxiedClientControllerTransaction(m);
        return (Integer)m.get(0);
    }

    @Override
    public void setAeroEffectsState(boolean enabled) {
        Message m = new Message(SET_AERO_STATE);
        m.append(enabled);
        m = this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void setLockDesktop(boolean enabled) {
        Message m = new Message(SET_LOCK_DESKTOP_STATE);
        m.append(enabled);
        m = this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void setBackgroundImageState(boolean enabled) {
        Message m = new Message(SET_BG_IMAGE_STATE);
        m.append(enabled);
        m = this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void setUseHardwareAcceleration(boolean enabled) {
        Message m = new Message(SET_USE_HW_ACCEL);
        m.append(enabled);
        m = this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void setFiltering(int enc) {
        if (!isSdemo) {
            Message m = new Message(SET_FILTERING);
            m.append(enc);
            Message message = this.doProxiedClientControllerTransaction(m);
        }
    }

    @Override
    public void setColour(boolean col) {
        if (!isSdemo) {
            Message m = new Message(SET_COLOUR);
            m.append(col);
            Message message = this.doProxiedClientControllerTransaction(m);
        }
    }

    @Override
    public void setColourDepth(int depth) {
        Message m = new Message(SET_COLOUR_DEPTH);
        m.append(depth);
        m = this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public void setUpdateDelay(long delayMS) {
        Message m = new Message(SET_UPDATE_DELAY);
        m.append(delayMS);
        m = this.doProxiedClientControllerTransaction(m);
    }

    @Override
    public NodeLinkStats getLocalSessionStats() {
        return null;
    }

    @Override
    public void getRemoteSessionStats(CommandResponseListener listener) {
        Message m = new Message(GET_LOCAL_CONNECTION_STATS);
        m = this.doProxiedClientControllerTransaction(m);
        listener.response(m);
    }

    public void sendTypedCharacters(String chars) {
    }

    @Override
    public int addGetRequest(int ID, String localdir, String remotedir, String remotefile) {
        return 0;
    }

    @Override
    public void addPortRedirection(long UID, int clientport, String remotehost, int remoteport) {
    }

    @Override
    public int addPutRequest(int ID, String localdir, String remotedir, String localfile) {
        return 0;
    }

    @Override
    public void addRemotePortRedirection(long UID, int clientport, String remotehost, int remoteport) {
    }

    @Override
    public void cancelGet(int jobID) {
    }

    @Override
    public void cancelPut(int jobID) {
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public void connectToProxy(ProxyConnectSettings settings, SHelpNodelinkPatcher patcher, SHelpNodelinkPatcher patcher2, NodeLink sock, InputStream in, OutputStream out, NLOptimisationFeed feed, BCUtil bcu, TransientTechUser techUser) throws Exception {
    }

    @Override
    public boolean switchTransports(int transportL, int transport) {
        return false;
    }

    @Override
    public void sendSessionPerformanceSlice() {
    }

    @Override
    public boolean deleteLocalFile(String dir, String file) {
        return false;
    }

    @Override
    public boolean deleteRemoteFile(String dir, String file) {
        return false;
    }

    @Override
    public void deregisterListener(String converation) {
    }

    @Override
    public void doAsyncRemoteCommand(CommandResponseListener listener, Message m) {
    }

    @Override
    public void doElevatedAsyncRemoteCommand(CommandResponseListener listener, Message m, String performingElevatedActionMessage) {
    }

    @Override
    public void fetchClipboard(boolean textOnly) {
    }

    @Override
    public FileEntry[] getRemoteDir(RemoteFile path) {
        return null;
    }

    @Override
    public String getRemoteSeparator() {
        return null;
    }

    @Override
    public String getRemoteTempDir() {
        return null;
    }

    @Override
    public String getRemoteHomeDir() {
        return null;
    }

    @Override
    public FTPVolume[] getRemoteVolumes() {
        return null;
    }

    @Override
    public void ignoreCurrentClipboard() {
    }

    public void listenForSingleIncoming(int port) {
    }

    @Override
    public String getConnectedServerIp() {
        return null;
    }

    @Override
    public int getConnectedServerPort() {
        return 0;
    }

    public void newConnection(String ip, int port, String username, String password) {
    }

    public void newConnection(String ip, int port, String httpProxy, int httpPort, String username, String password) {
    }

    @Override
    public void newLocalFolder(String ldir, String folder) {
    }

    @Override
    public void newRemoteFolder(String rdir, String folder) {
    }

    @Override
    public void notifyGrabRectangleHasChanged() {
    }

    @Override
    public void optimizeConnection() {
    }

    @Override
    public void registerOngoingListener(CommandResponseListener listener, String conversation) {
    }

    @Override
    public void removePortRedirection(long UID) {
    }

    @Override
    public void renameLocalFile(String ldir, String oldname, String newname) {
    }

    @Override
    public void renameRemoteFile(String rdir, String oldname, String newname) {
    }

    @Override
    public void requestDuplicateBackConnection() {
    }

    @Override
    public void requestScreen() {
    }

    @Override
    public void requestSimpleGatewayInstallation(SimpleGatewayConfig config, boolean installShortcuts) {
    }

    @Override
    public void requestSimpleGatewayUninstallation() {
    }

    @Override
    public void runProgram(String program, String workingDir, boolean elevate) {
    }

    @Override
    public void saveRemoteClipboard(File directory) {
    }

    @Override
    public void sendAllowWiggle(boolean allowed) {
    }

    @Override
    public void sendAsyncRemoteCommand(Message m, String conversation) {
    }

    @Override
    public boolean sendClipboard() {
        return false;
    }

    @Override
    public boolean sendClipboardAndPaste() {
        return false;
    }

    @Override
    public void sendControlAltDelete() {
    }

    @Override
    public void sendElevateMouseMove(String username, String password) {
    }

    @Override
    public void sendElevateMouseMove() {
    }

    @Override
    public void sendFilesAndPaste(List files) {
    }

    @Override
    public void sendKeyRequest(KeyRequest request) {
    }

    @Override
    public void sendLockingKey(int code, boolean on) {
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public String getRemoteEnv(String name) {
        return null;
    }

    @Override
    public void sendMouseDown(int x, int y, int buttons, int modifiers, int nativebutton) {
    }

    @Override
    public void sendMouseMove(int x, int y) {
    }

    @Override
    public void sendMouseUp(int x, int y, int buttons, int modifiers, int nativebutton) {
    }

    @Override
    public void sendMouseWheel(int clicksRotation) {
    }

    @Override
    public void sendRemoteReboot(boolean safeModeIfPossible, boolean forceIfPossible) {
    }

    public void sendWhiteboard() {
    }

    @Override
    public void setCompression(int enc) {
    }

    @Override
    public void setControlEnabled(boolean b) {
    }

    @Override
    public void setCurrentMouseLocation(int x, int y) {
    }

    @Override
    public void setEncoding(int enc) {
    }

    @Override
    public void setGUI(ClientUserInterface gui) {
    }

    @Override
    public void setGraphicsDriverDisabled(boolean disabled) {
    }

    @Override
    public void setScaling(int enc) {
    }

    @Override
    public void doImmediateFileGet(String remotedir, String remotefile, ImmediateFileTransferListener listener) throws IOException {
    }

    @Override
    public String getRemoteKeyMappingName() {
        return null;
    }

    @Override
    public String getLocalKeyMappingName() {
        return null;
    }

    public void sendKeyCombination(KeyRequest sk) {
    }

    @Override
    public void flushAllBufferedKeys() {
    }

    @Override
    public void fetchClipboardAfterInputSent() {
    }

    @Override
    public void terminate() {
    }

    public boolean setCaptureSpecialKeysState(boolean enabled) {
        return false;
    }

    @Override
    public void setBlankScreenState(boolean enabled, String title, String message) {
    }

    @Override
    public void setBlockControlState(boolean enabled) {
    }

    @Override
    public void setSelectedScreen(int selectedScreen) {
    }

    @Override
    public void sendPermissionsRequest(String title, String message, CommandResponseListener listener) {
    }

    public void setPreferredKeymap(String keymap) {
    }

    @Override
    public void launchRemoteDebugger() {
    }

    @Override
    public void setProcessHighPriority(boolean high) {
    }

    public boolean reestablishNonUdpTransport() {
        return false;
    }

    @Override
    public boolean reestablishUdpTransport(boolean direct, boolean allowPortScan) {
        return false;
    }

    @Override
    public MachinePrefs getConnectedMachinePrefs() {
        return null;
    }

    @Override
    public void setAlterNumLock(boolean allowed) {
    }

    public boolean getCaptureSpecialKeysState() {
        return false;
    }

    public void setAeroEffectsState(boolean turningOn, boolean block) {
    }

    @Override
    public void sendAlertRemoteUser() {
    }

    @Override
    public void installCallingCard(String cardName, boolean createDesktopShortcut, boolean createMenuShortcut, boolean autoLogin) {
    }

    @Override
    public void setMonitorOffState(boolean turningOn) {
    }

    @Override
    public void setCaptureAudio(boolean isPlaying) {
    }

    @Override
    public boolean isTechnicianSide() {
        return false;
    }

    @Override
    public void notifyTechnicianTyping(String displayName) {
    }

    public void doImmediateFileGet(int ID, String remotedir, String remotefile, ImmediateFileTransferListener listener) throws IOException {
    }

    @Override
    public ToolBoxResult runToolBoxItem(ToolBoxItem item) {
        return null;
    }

    @Override
    public void sendFailoverRequest(String url) {
    }

    @Override
    public void sendTerminalControl(char toWrite) {
    }

    @Override
    public void sendTerminalControl(byte[] data, int offset, int len) {
    }

    @Override
    public boolean isDirectSocketUDP() {
        return false;
    }

    @Override
    public void setUpperBandwidthLimit(int KBps) {
    }

    @Override
    public void setMixerForAudioOutput(Mixer mixer) {
    }

    @Override
    public boolean isSwitchingTransport() {
        return false;
    }

    @Override
    public void setWinSize(int columns, int rows) {
    }
}

