/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.utils.SSLCipherSuiteHelper;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.nodelink.utils.VerboseSocket;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.SocketCloseTimeoutMap;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.stream.OpenByteArrayOutputStream;
import utils.stream.SocketLeaks;
import utils.stream.StreamUtils;
import utils.switches.Switches;

public class WorkingNioSslSocket
extends VerboseSocket {
    static int sslOutBufferSize = 15360;
    static int sslInBufferSize = 100000;
    boolean DEBUG = false;
    boolean DEBUG_CLOSE_TRACE = false;
    boolean DEBUG_DELEGATE_TASKS = false;
    boolean suppressCloseErrors = false;
    SSLEngine engine;
    ByteBuffer inBuffer;
    ByteBuffer outBuffer;
    ByteBuffer interimUnwrap;
    ByteBuffer interimWrap;
    private boolean amClosed = false;
    private static boolean firstCiphers;
    private static TimeoutMap<TimeoutByteChannel, TimeoutByteChannel> timeouts;
    static SocketCloseTimeoutMap socketCloseTimeoutMap;
    ByteChannel internalReads;
    private final Object in_LOCK = new Object();
    private final Object out_LOCK = new Object();
    private NioSslInputStream fixedin;
    private NioSslOutputStream fixedout;
    static OnDemandThreadPool pool;
    private static TimeoutMap<NioSslInputStream, NioSslInputStream> ssltimeouts;

    public WorkingNioSslSocket(Socket s, byte[] initialData) throws IOException, NoSuchAlgorithmException, Exception {
        super(s);
        this.engine = SslToTcp.getSSLContext().createSSLEngine();
        this.engine.setUseClientMode(false);
        this.engine.setNeedClientAuth(false);
        this.engine.setWantClientAuth(false);
        String[] enabledCiphers = SSLCipherSuiteHelper.getGoodAvailableCiphers(SslToTcp.getPossibleAcceptedCiphers(), this.engine);
        String[] enabledProtocols = SSLCipherSuiteHelper.getGoodAvailableProtocols(SslToTcp.getPossibleAcceptedProtocols(), this.engine);
        if (firstCiphers) {
            firstCiphers = false;
            System.out.println("[NioSsl] " + enabledProtocols.length + " Protocols enabled:");
            for (String protocol : enabledProtocols) {
                System.out.println("[NioSsl] -- " + protocol);
            }
            System.out.println("[NioSsl] " + enabledCiphers.length + " Ciphers enabled:");
            for (String cipher : enabledCiphers) {
                System.out.println("[NioSsl] -- " + cipher);
            }
        }
        this.engine.setEnabledCipherSuites(enabledCiphers);
        this.engine.setEnabledProtocols(enabledProtocols);
        this.engine.beginHandshake();
        SSLSession session = this.engine.getSession();
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        if (this.DEBUG) {
            System.out.println("[NioSsl] App buffer max is " + appBufferMax + ", ssl out buffer size is " + sslOutBufferSize + ", in is " + sslInBufferSize);
        }
        this.interimUnwrap = ByteBuffer.allocate(sslInBufferSize);
        this.interimWrap = ByteBuffer.allocate(sslOutBufferSize);
        this.inBuffer = ByteBuffer.allocate(sslInBufferSize);
        this.outBuffer = ByteBuffer.allocate(sslOutBufferSize * 2);
        this.inBuffer.clear();
        this.outBuffer.clear();
        this.interimUnwrap.clear();
        this.interimUnwrap.put(initialData, 0, initialData.length);
    }

    public static Socket fixNIO(Socket sock, byte[] initialData) throws IOException, NoSuchAlgorithmException, Exception {
        if (sock instanceof WorkingNioSslSocket) {
            return sock;
        }
        WorkingNioSslSocket newsock = new WorkingNioSslSocket(sock, initialData);
        SocketLeaks.replace(sock, newsock);
        return newsock;
    }

    @Override
    protected void toot() {
    }

    private ByteChannel wrapChannel(final ByteChannel channel) {
        if (Switches.SH_artificiallyTimeoutBlockingNioSocketReads) {
            return new TimeoutByteChannel(channel);
        }
        ByteChannel ret = new ByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                return channel.write(src);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return channel.read(dst);
            }

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
        return ret;
    }

    private ByteChannel getInternalReadChannel() {
        if (this.internalReads == null) {
            this.internalReads = this.wrapChannel(this.getChannel());
        }
        return this.internalReads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        SocketChannel channel = this.getChannel();
        if (channel != null) {
            Object object = this.in_LOCK;
            synchronized (object) {
                if (this.fixedin == null) {
                    this.fixedin = new NioSslInputStream();
                }
                return this.fixedin;
            }
        }
        throw new IOException("WorkingNioSslSocket does not support sockets without channels");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        SocketChannel channel = this.getChannel();
        if (channel != null) {
            Object object = this.out_LOCK;
            synchronized (object) {
                if (this.fixedout == null) {
                    this.fixedout = new NioSslOutputStream(Channels.newOutputStream(this.wrapChannel(channel)));
                }
                return this.fixedout;
            }
        }
        throw new IOException("WorkingNioSslSocket does not support sockets without channels");
    }

    private NioSslOutputStream getNioSslOutputStream() throws IOException {
        this.getOutputStream();
        return this.fixedout;
    }

    private NioSslInputStream getNioSslInputStream() throws IOException {
        this.getInputStream();
        return this.fixedin;
    }

    @Override
    public void close() throws IOException {
        if (this.DEBUG_CLOSE_TRACE) {
            new Throwable("CLOSED").printStackTrace();
        }
        this.suppressCloseErrors = true;
        if (!pool.runAsync(new ShutdownThread())) {
            System.out.println("[NioSsl] Unable to process delegate tasks on shutdown (pool full), terminating socket directly instead");
            if (Switches.SH_1778_nioSocketCloseChannelsWithSockClose) {
                try {
                    if (this.fixedin != null) {
                        this.fixedin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.fixedout != null) {
                        this.fixedout.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Switches.SH_2054_nullBuffersOnSslSocketClose) {
            try {
                this.amClosed = true;
                this.inBuffer = null;
                this.outBuffer = null;
                this.interimUnwrap = null;
                this.interimWrap = null;
                this.engine = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isEngineClosed(SSLEngine engine) {
        return engine.isOutboundDone() && engine.isInboundDone();
    }

    private void runDelegatedTasks(SSLEngine engine) throws IOException {
        try {
            boolean moreJobs = true;
            while (moreJobs) {
                if (this.DEBUG) {
                    System.out.println("[NioSslDelTask] HandshakeStatus is " + (Object)((Object)engine.getHandshakeStatus()));
                }
                if (engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    if (this.DEBUG) {
                        System.out.println("[NioSslDelTask] Doing courtesy wrap...");
                    }
                    this.getNioSslOutputStream().doCourtesyWrap();
                    continue;
                }
                if (engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    if (this.DEBUG) {
                        System.out.println("[NioSslDelTask] Doing courtesy unwrap...");
                    }
                    if (this.getNioSslInputStream().readChunk(false) != -1) continue;
                    throw new IOException("End of data");
                }
                if (engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    Runnable runnable;
                    while ((runnable = engine.getDelegatedTask()) != null) {
                        if (this.DEBUG) {
                            System.out.println("[NioSslDelTask] Running delegated task...");
                        }
                        runnable.run();
                    }
                    continue;
                }
                moreJobs = false;
            }
        }
        catch (IOException x) {
            if (this.DEBUG_DELEGATE_TASKS) {
                x.printStackTrace();
            }
            throw x;
        }
        catch (Exception x) {
            x.printStackTrace();
            IOException err = new IOException("Problem during delegate tasks");
            err.initCause(x);
            throw err;
        }
    }

    public void dumpEngineStatus() {
        System.out.println("[NioSocket] SSL Engine Status: " + (Object)((Object)this.engine.getHandshakeStatus()));
    }

    static /* synthetic */ TimeoutMap access$600() {
        return ssltimeouts;
    }

    static {
        File file = new File("configuration" + File.separator + "sslBufferSize");
        if (file.exists()) {
            try {
                FileInputStream fin = new FileInputStream(file);
                try {
                    sslOutBufferSize = Integer.parseInt(StreamUtils.readAllAsStringUTF8(fin).trim());
                }
                finally {
                    fin.close();
                }
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        firstCiphers = true;
        timeouts = new TimeoutMap(1000);
        socketCloseTimeoutMap = new SocketCloseTimeoutMap();
        pool = new OnDemandThreadPool("NioSslShutdown", 50, 5000, 5);
        ssltimeouts = new TimeoutMap(1000);
    }

    private class NioSslInputStream
    extends InputStream
    implements TimeoutMapListener<NioSslInputStream, NioSslInputStream> {
        Socket mysock;
        Thread current;
        int cptr;
        int clen;
        byte[] chunk;
        OpenByteArrayOutputStream plain;

        public NioSslInputStream() {
            this.mysock = WorkingNioSslSocket.this;
            this.cptr = 0;
            this.clen = 0;
            this.chunk = new byte[0];
            this.plain = new OpenByteArrayOutputStream();
        }

        @Override
        public void close() throws IOException {
            WorkingNioSslSocket.this.getChannel().close();
        }

        @Override
        public int read() throws IOException {
            if (Switches.SH_XXXX_monitorAllPxSocketsForInactivityAndClose) {
                socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            }
            if (this.readNextChunk() == -1) {
                return -1;
            }
            return 0xFF & this.chunk[this.cptr++];
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (Switches.SH_2018_monitorAllSslPxSocketsForInactivityAndClose) {
                socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            }
            if (this.readNextChunk() == -1) {
                return -1;
            }
            int rem_clen = this.clen - this.cptr;
            int minlen = Math.min(len, rem_clen);
            System.arraycopy(this.chunk, this.cptr, b, off, minlen);
            this.cptr += minlen;
            return minlen;
        }

        public int readNextChunk() throws IOException {
            if (this.cptr < this.clen) {
                return 0;
            }
            try {
                int n = this.readChunk(true);
                if (n == -1) {
                    return -1;
                }
                while (this.plain.size() == 0) {
                    n = this.readChunk(true);
                    if (n != -1) continue;
                    return -1;
                }
                this.chunk = this.plain.getByteArray();
                this.cptr = 0;
                this.clen = this.plain.size();
                return this.plain.size();
            }
            catch (EOFException e) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        int readChunk(boolean runDelegates) throws IOException {
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Read CHUNK");
            }
            this.plain.reset();
            status = null;
            if (WorkingNioSslSocket.access$300(WorkingNioSslSocket.this) | WorkingNioSslSocket.access$400(WorkingNioSslSocket.this.engine)) {
                throw new IOException("Stream closed");
            }
            doRead = runDelegates != false && WorkingNioSslSocket.this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            firstRead = true;
            useTimeouts = false;
            timeoutAt = SafeClock.currentTimeMillis() + (long)WorkingNioSslSocket.this.getSoTimeout();
            do {
                if (WorkingNioSslSocket.this.getSoTimeout() != 0 && SafeClock.currentTimeMillis() > timeoutAt) {
                    System.out.println("THROWING SOCKET READ TIMEOUT " + WorkingNioSslSocket.this.getSoTimeout());
                    throw new SocketTimeoutException("Socket read timed out");
                }
                if (WorkingNioSslSocket.access$300(WorkingNioSslSocket.this) | WorkingNioSslSocket.access$400(WorkingNioSslSocket.this.engine)) {
                    throw new IOException("Stream closed");
                }
                if (doRead || useTimeouts) {
                    if (useTimeouts) {
                        channel = WorkingNioSslSocket.this.getChannel();
                        origTimeout = WorkingNioSslSocket.this.getSoTimeout();
                        try {
                            timetoread = System.currentTimeMillis();
                            N = 0;
                            try {
                                this.current = Thread.currentThread();
                                WorkingNioSslSocket.access$600().put(this, this, 1000L, this);
                                N = channel.read(WorkingNioSslSocket.this.interimUnwrap);
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                            finally {
                                WorkingNioSslSocket.access$600().remove(this);
                            }
                            timetoread = System.currentTimeMillis() - timetoread;
                            if (timetoread > 1200L) {
                                System.out.println("*** WARNING READ of " + N + " TOOK " + timetoread);
                            }
                            if (N == 0) {
                                System.out.println("Read: " + N + " " + timetoread + "ms");
                            }
                            if (N == -1) {
                                throw new EOFException("End of data");
                            }
                            if (!WorkingNioSslSocket.this.DEBUG) ** GOTO lbl64
                            System.out.println("[NioSslIn] Read " + N + " raw data, have " + WorkingNioSslSocket.this.interimUnwrap.position() + " total for unwrapping");
                        }
                        finally {
                            WorkingNioSslSocket.this.setSoTimeout(origTimeout);
                        }
                    } else {
                        channel = WorkingNioSslSocket.this.getChannel();
                        if (firstRead) {
                            channel.configureBlocking(false);
                        }
                        N = channel.read(WorkingNioSslSocket.this.interimUnwrap);
                        if (firstRead) {
                            if (!channel.isBlocking()) {
                                channel.configureBlocking(true);
                            }
                            firstRead = false;
                        }
                        if (N == -1) {
                            throw new EOFException("End of data");
                        }
                        if (WorkingNioSslSocket.this.DEBUG) {
                            System.out.println("[NioSslIn] Read " + N + " raw data, have " + WorkingNioSslSocket.this.interimUnwrap.position() + " total for unwrapping");
                        }
                    }
                }
lbl64:
                // 7 sources

                result = null;
                try {
                    WorkingNioSslSocket.this.interimUnwrap.flip();
                    if (WorkingNioSslSocket.this.DEBUG) {
                        System.out.println("[NioSslIn] Unwrapping " + WorkingNioSslSocket.this.interimUnwrap.remaining());
                    }
                    result = WorkingNioSslSocket.this.engine.unwrap(WorkingNioSslSocket.this.interimUnwrap, WorkingNioSslSocket.this.inBuffer);
                    if (WorkingNioSslSocket.this.DEBUG) {
                        System.out.println("[NioSslIn] Unwrap consumed " + result.bytesConsumed() + ", produced " + result.bytesProduced() + ", " + WorkingNioSslSocket.this.inBuffer.position() + " total bytes decrypted, " + WorkingNioSslSocket.this.interimUnwrap.position() + " still to go");
                    }
                    WorkingNioSslSocket.this.interimUnwrap.compact();
                    if (WorkingNioSslSocket.this.DEBUG) {
                        System.out.println("[NioSslIn] Still to unwrap: " + WorkingNioSslSocket.this.interimUnwrap.position());
                    }
                }
                catch (IOException x) {
                    if (WorkingNioSslSocket.this.DEBUG && Switches.SH_suppressNioSslCloseErrors) {
                        throw x;
                    }
                    if (!WorkingNioSslSocket.this.suppressCloseErrors) {
                        x.printStackTrace();
                    }
                    throw x;
                }
                try {
                    if (runDelegates) {
                        WorkingNioSslSocket.access$500(WorkingNioSslSocket.this, WorkingNioSslSocket.this.engine);
                    }
                }
                catch (IOException x) {
                    throw x;
                }
                catch (Exception x) {
                    err = new IOException("SSL delegated tasks failed");
                    err.initCause(x);
                    throw err;
                }
                status = result.getStatus();
                if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    System.out.println("BUFFER OVERFLOW!!!!!!");
                }
                if (status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                doRead = true;
            } while (status == SSLEngineResult.Status.BUFFER_UNDERFLOW);
            WorkingNioSslSocket.this.inBuffer.flip();
            arr = new byte[WorkingNioSslSocket.this.inBuffer.remaining()];
            WorkingNioSslSocket.this.inBuffer.get(arr);
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Copying " + arr.length + " into plaintext buffer");
            }
            this.plain.write(arr);
            WorkingNioSslSocket.this.inBuffer.clear();
            return arr.length;
        }

        @Override
        public void objectTimedOut(NioSslInputStream key, NioSslInputStream val) {
            try {
                this.current.interrupt();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private class NioSslOutputStream
    extends OutputStream {
        Socket mysock;
        long total;
        DataOutputStream out;
        OpenByteArrayOutputStream bout;

        public NioSslOutputStream(OutputStream out) {
            this.mysock = WorkingNioSslSocket.this;
            this.total = 0L;
            this.bout = new OpenByteArrayOutputStream();
            this.out = new DataOutputStream(out);
        }

        @Override
        public void close() throws IOException {
            this.out.flush();
            this.out.close();
        }

        @Override
        public final void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public final void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws IOException {
            if (Switches.SH_XXXX_monitorAllPxSocketsForInactivityAndClose) {
                socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            }
            while (len > 0) {
                if (WorkingNioSslSocket.this.DEBUG) {
                    System.out.println("[NioSslOut] Writing " + off + "->" + len);
                }
                int written = this.writeByteArray(b, off, len);
                this.total += (long)written;
                if (WorkingNioSslSocket.this.DEBUG) {
                    System.out.println("[NioSslOut] Wrote " + written + " of " + off + "->" + len + " (total=" + this.total + ")");
                }
                off += written;
                len -= written;
            }
        }

        @Override
        public final void write(int b) throws IOException {
            if (Switches.SH_XXXX_monitorAllPxSocketsForInactivityAndClose) {
                socketCloseTimeoutMap.closeSocketIfNoUpdate(this.mysock, NodeLink.DEFAULT_ERROR_TIMEOUT);
            }
            byte[] bb = new byte[]{(byte)b};
            this.write(bb);
        }

        private int writeByteArray(byte[] dat, int off, int len) throws IOException {
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Write CHUNK");
            }
            if (WorkingNioSslSocket.this.amClosed || WorkingNioSslSocket.isEngineClosed(WorkingNioSslSocket.this.engine)) {
                throw new IOException("Stream closed");
            }
            int max = Math.min(len, WorkingNioSslSocket.this.interimWrap.capacity() - 1 - WorkingNioSslSocket.this.interimWrap.position());
            WorkingNioSslSocket.this.interimWrap.put(dat, off, max);
            WorkingNioSslSocket.this.interimWrap.flip();
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Wrapping " + WorkingNioSslSocket.this.interimWrap.remaining());
            }
            SSLEngineResult result = WorkingNioSslSocket.this.engine.wrap(WorkingNioSslSocket.this.interimWrap, WorkingNioSslSocket.this.outBuffer);
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Wrap consumed " + result.bytesConsumed() + ", produced " + result.bytesProduced());
            }
            WorkingNioSslSocket.this.interimWrap.compact();
            try {
                WorkingNioSslSocket.this.runDelegatedTasks(WorkingNioSslSocket.this.engine);
            }
            catch (IOException x) {
                throw x;
            }
            catch (Exception x) {
                IOException err = new IOException("SSL delegated tasks failed");
                err.initCause(x);
                throw err;
            }
            WorkingNioSslSocket.this.outBuffer.flip();
            byte[] arr = new byte[WorkingNioSslSocket.this.outBuffer.remaining()];
            WorkingNioSslSocket.this.outBuffer.get(arr);
            WorkingNioSslSocket.this.outBuffer.clear();
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Writing " + arr.length + " encrypted bytes");
            }
            this.out.write(arr);
            this.out.flush();
            return max;
        }

        private SSLEngineResult doCourtesyWrap() throws IOException {
            WorkingNioSslSocket.this.interimWrap.flip();
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Wrapping " + WorkingNioSslSocket.this.interimWrap.remaining());
            }
            SSLEngineResult result = WorkingNioSslSocket.this.engine.wrap(WorkingNioSslSocket.this.interimWrap, WorkingNioSslSocket.this.outBuffer);
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Wrap consumed " + result.bytesConsumed() + ", produced " + result.bytesProduced());
            }
            WorkingNioSslSocket.this.interimWrap.compact();
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslOut] Did courtesy wrap, produced " + result.bytesProduced());
            }
            WorkingNioSslSocket.this.outBuffer.flip();
            byte[] arr = new byte[WorkingNioSslSocket.this.outBuffer.remaining()];
            WorkingNioSslSocket.this.outBuffer.get(arr);
            WorkingNioSslSocket.this.outBuffer.clear();
            if (WorkingNioSslSocket.this.DEBUG) {
                System.out.println("[NioSslIn] Writing " + arr.length + " encrypted bytes");
            }
            this.out.write(arr);
            this.out.flush();
            return result;
        }
    }

    class ShutdownThread
    implements Runnable {
        ShutdownThread() {
        }

        @Override
        public void run() {
            try {
                WorkingNioSslSocket.this.engine.closeOutbound();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (Switches.SH_1778_nioSocketCloseChannelsWithSockClose) {
                try {
                    if (WorkingNioSslSocket.this.fixedin != null) {
                        WorkingNioSslSocket.this.fixedin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (WorkingNioSslSocket.this.fixedout != null) {
                        WorkingNioSslSocket.this.fixedout.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                WorkingNioSslSocket.this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class TimeoutByteChannel
    implements ByteChannel,
    TimeoutMapListener<TimeoutByteChannel, TimeoutByteChannel> {
        ByteChannel channel;
        long lastTimeoutAdd = 0L;
        long lastTimeoutValue = 0L;
        Thread readThread = null;
        boolean timedOut = false;

        public TimeoutByteChannel(ByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.channel.write(src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            long timeout = WorkingNioSslSocket.this.getSoTimeout();
            long T = System.currentTimeMillis();
            if (T - this.lastTimeoutAdd > 500L || this.lastTimeoutValue != timeout) {
                this.lastTimeoutAdd = T;
                this.lastTimeoutValue = timeout;
                if (timeout > 0L) {
                    timeouts.put(this, this, WorkingNioSslSocket.this.getSoTimeout(), this);
                } else {
                    timeouts.remove(this);
                }
            }
            this.readThread = timeout > 0L ? Thread.currentThread() : null;
            long lastRead = T;
            try {
                int n = this.channel.read(dst);
                return n;
            }
            finally {
                this.readThread = null;
                if (this.timedOut) {
                    this.timedOut = false;
                    if (Switches.SH_terminateSocketsOnReadTimeout) {
                        this.channel.close();
                        WorkingNioSslSocket.this.close();
                    }
                    SocketTimeoutException timeoutException = new SocketTimeoutException("Timed out while reading from socket " + WorkingNioSslSocket.this.s + " (" + (System.currentTimeMillis() - T) + " > " + WorkingNioSslSocket.this.s.getSoTimeout() + ")");
                    if (WorkingNioSslSocket.this.DEBUG) {
                        timeoutException.printStackTrace();
                    }
                    throw timeoutException;
                }
            }
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }

        @Override
        public void objectTimedOut(TimeoutByteChannel key, TimeoutByteChannel val) {
            Thread target = this.readThread;
            if (target != null) {
                this.timedOut = true;
                target.interrupt();
            }
        }
    }
}

