/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.utils.SafeClock;
import java.util.Date;
import utils.switches.Switches;

public class SocketRestrictor {
    public static boolean VERBOSE_RESTRICTIONS = true;
    public static final int MAX_FREQ = 10000;
    int nMins = 5;
    long lastPerMins = 0L;
    int nPerMins = 0;
    int[] delay = new int[]{0, 0, 0, 500, 1000, 1000, 1000, 5000, 5000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000};

    public boolean requestCreateOrQuit(String source) {
        long Tsafe = SafeClock.currentTimeMillis();
        if (Tsafe > this.lastPerMins + (long)(60000 * this.nMins)) {
            this.lastPerMins = Tsafe;
            this.nPerMins = 0;
        }
        ++this.nPerMins;
        if (Switches.SH_socketRestrictorAllows3minReconnect) {
            if (this.nPerMins >= this.delay.length) {
                if (VERBOSE_RESTRICTIONS) {
                    System.out.println("[SocketRestrictor] " + source + " too many failed socket attempts, recommending quit");
                }
                return true;
            }
            long sleep = this.delay[this.nPerMins];
            if (sleep == 0L) {
                if (VERBOSE_RESTRICTIONS) {
                    System.out.println("[SocketRestrictor] " + source + " allowing new socket creation");
                }
            } else if (VERBOSE_RESTRICTIONS) {
                System.out.println("[SocketRestrictor] " + source + " throttling new socket creation, delaying " + (int)((double)sleep / 1000.0) + "s");
            }
            try {
                Thread.sleep(sleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        int delayLimitPerNMins = 3;
        int quitLimitPerNMins = 8;
        if (this.nPerMins >= delayLimitPerNMins) {
            if (VERBOSE_RESTRICTIONS) {
                System.out.println("[SocketRestrictor] " + source + " throttling new socket creation, delaying " + 10.0 + "s");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.nPerMins >= quitLimitPerNMins) {
            if (VERBOSE_RESTRICTIONS) {
                System.out.println("[SocketRestrictor] " + source + " too many failed socket attempts, recommending quit");
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        SocketRestrictor sr = new SocketRestrictor();
        while (!sr.requestCreateOrQuit("TEST")) {
            System.out.println(new Date() + ": New Socket!");
        }
        return;
    }
}

