/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;

public class SSLCipherSuiteHelper {
    public static final String[] DEFAULT_GOOD_CIPHERS = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
    public static final String[] DEFAULT_GOOD_PROTOCOLS = new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private static String[] CURRENT_CIPHERS = null;
    private static String[] CURRENT_PROTOCOLS = null;

    public static void saveCipherListTo(File targetFile, boolean overwrite) throws IOException {
        SSLCipherSuiteHelper.save(targetFile, overwrite, CURRENT_CIPHERS, DEFAULT_GOOD_CIPHERS);
    }

    public static void saveProtocolListTo(File targetFile, boolean overwrite) throws IOException {
        SSLCipherSuiteHelper.save(targetFile, overwrite, CURRENT_PROTOCOLS, DEFAULT_GOOD_PROTOCOLS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(File targetFile, boolean overwrite, String[] current, String[] defaultGood) throws IOException {
        if (targetFile.exists()) {
            if (!overwrite) {
                return;
            }
            targetFile.delete();
        }
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(targetFile));
        try {
            String[] list = current;
            if (list == null) {
                list = defaultGood;
            }
            for (String s : list) {
                String line = s + "\n";
                ((OutputStream)fout).write(line.getBytes("ASCII"));
            }
        }
        finally {
            ((OutputStream)fout).close();
        }
    }

    public static String[] getGoodAvailableCiphers(String[] possibleCiphersToUse, SSLServerSocket engine) {
        String[] supportedCiphers = engine.getSupportedCipherSuites();
        return SSLCipherSuiteHelper.pickOut(possibleCiphersToUse, supportedCiphers);
    }

    public static String[] getGoodAvailableCiphers(String[] possibleCiphersToUse, SSLEngine engine) {
        String[] supportedCiphers = engine.getSupportedCipherSuites();
        return SSLCipherSuiteHelper.pickOut(possibleCiphersToUse, supportedCiphers);
    }

    private static String[] pickOut(String[] possibleCiphersToUse, String[] supportedCiphers) {
        HashSet<String> set = new HashSet<String>();
        for (String s : possibleCiphersToUse) {
            set.add(s);
        }
        set.retainAll(Arrays.asList(supportedCiphers));
        String[] resultArray = set.toArray(new String[0]);
        return resultArray;
    }

    public static String[] getGoodAvailableProtocols(String[] possibleAcceptedProtocols, SSLServerSocket ssock) {
        String[] supportedProtocols = ssock.getSupportedProtocols();
        return SSLCipherSuiteHelper.pickOut(possibleAcceptedProtocols, supportedProtocols);
    }

    public static String[] getGoodAvailableProtocols(String[] possibleAcceptedProtocols, SSLEngine ssock) {
        String[] supportedProtocols = ssock.getSupportedProtocols();
        return SSLCipherSuiteHelper.pickOut(possibleAcceptedProtocols, supportedProtocols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] loadCipherListFrom(File targetFile) throws IOException {
        if (targetFile.exists()) {
            FileInputStream fin = new FileInputStream(targetFile);
            String data = null;
            try {
                byte[] byteData = SSLCipherSuiteHelper.readAll(fin);
                data = new String(byteData, "ASCII");
                CURRENT_CIPHERS = data.split("[\r\n\\,]");
                CURRENT_CIPHERS = SSLCipherSuiteHelper.removeEmpties(CURRENT_CIPHERS);
                String[] stringArray = CURRENT_CIPHERS;
                return stringArray;
            }
            finally {
                fin.close();
            }
        }
        return DEFAULT_GOOD_CIPHERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] loadProtocolListFrom(File targetFile) throws IOException {
        if (targetFile.exists()) {
            FileInputStream fin = new FileInputStream(targetFile);
            String data = null;
            try {
                byte[] byteData = SSLCipherSuiteHelper.readAll(fin);
                data = new String(byteData, "ASCII");
                CURRENT_PROTOCOLS = data.split("[\r\n\\,]");
                CURRENT_PROTOCOLS = SSLCipherSuiteHelper.removeEmpties(CURRENT_PROTOCOLS);
                String[] stringArray = CURRENT_PROTOCOLS;
                return stringArray;
            }
            finally {
                fin.close();
            }
        }
        return DEFAULT_GOOD_PROTOCOLS;
    }

    private static String[] removeEmpties(String[] list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            if (s == null || (s = s.trim()).length() == 0 || s.equals(",")) continue;
            result.add(s);
        }
        return result.toArray(new String[0]);
    }

    private static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int n = 0;
        while (n != -1) {
            n = in.read(buf, 0, 65536);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }
}

