/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Properties;

public class ProxyUtil {
    static boolean VERBOSE = false;
    private static final String[] NO_PROXY_HOST = new String[]{"", "80"};
    private static final String PLUGIN_PROXY_CONFIG_PROP = "javaplugin.proxy.config.list";

    public static String[] detectProxy(URL sampleURL) {
        String[] result = null;
        try {
            String javaVers = System.getProperty("java.runtime.version");
            if (VERBOSE) {
                System.out.println("About to attempt auto proxy detection under Java version:" + javaVers);
            }
            boolean invokeFailover = false;
            if (javaVers.startsWith("1.3")) {
                result = ProxyUtil.detectProxySettingsJDK13(sampleURL);
                if (result == null) {
                    invokeFailover = true;
                }
            } else if (javaVers.startsWith("1.4") || javaVers.startsWith("1.5") || javaVers.startsWith("1.6") || javaVers.startsWith("1.7") || javaVers.startsWith("1.8") || javaVers.startsWith("1.9")) {
                result = ProxyUtil.detectProxySettingsJDK14_JDK15_JDK16(sampleURL);
                if (result == null) {
                    invokeFailover = true;
                }
            } else {
                if (VERBOSE) {
                    System.out.println("Sun Plugin reported java version not 1.3.X, 1.4.X, 1.5.X, 1.6.X or 1.7.X - trying failover detection...");
                }
                invokeFailover = true;
            }
            if (invokeFailover) {
                if (VERBOSE) {
                    System.out.println("Using failover proxy detection...");
                }
                result = ProxyUtil.getPluginProxyConfigSettings();
            }
            if (NO_PROXY_HOST.equals(result)) {
                result = null;
            }
            if (result == null) {
                result = ProxyUtil.detectProxySettingsAnyJreUsingReflectiveProxySelector(sampleURL);
            }
            return result;
        }
        catch (Exception e) {
            result = null;
            if (result == null && System.getProperty("proxyHost") != null) {
                result = new String[]{System.getProperty("proxyHost"), System.getProperty("proxyPort")};
            }
            if (result == null && System.getProperty("http.proxyHost") != null) {
                result = new String[]{System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort")};
            }
            if (result != null && result[1].trim().equals("0")) {
                result[1] = "80";
            }
            return result;
        }
    }

    private static String[] detectProxySettingsJDK13(URL sampleURL) throws Exception {
        String[] result;
        block11: {
            result = null;
            try {
                Class<?> pluginProxyHandler = Class.forName("sun.plugin.protocol.PluginProxyHandler");
                Method getDefaultProxyHandlerMethod = pluginProxyHandler.getDeclaredMethod("getDefaultProxyHandler", null);
                Object proxyHandlerObj = getDefaultProxyHandlerMethod.invoke(null, null);
                if (proxyHandlerObj != null) {
                    Class<?> proxyHandlerClass = proxyHandlerObj.getClass();
                    Method getProxyInfoMethod = proxyHandlerClass.getDeclaredMethod("getProxyInfo", URL.class);
                    Object proxyInfoObject = getProxyInfoMethod.invoke(proxyHandlerObj, sampleURL);
                    if (proxyInfoObject != null) {
                        boolean useProxy;
                        Class<?> proxyInfoClass = proxyInfoObject.getClass();
                        Method getProxyMethod = proxyInfoClass.getDeclaredMethod("getProxy", null);
                        boolean bl = useProxy = getProxyMethod.invoke(proxyInfoObject, null) != null;
                        if (useProxy) {
                            String proxyIP = (String)getProxyMethod.invoke(proxyInfoObject, null);
                            Method getProxyPortMethod = proxyInfoClass.getDeclaredMethod("getPort", null);
                            Integer portInteger = (Integer)getProxyPortMethod.invoke(proxyInfoObject, null);
                            int proxyPort = portInteger;
                            if (VERBOSE) {
                                System.out.println("1.3.X: proxy=" + proxyIP + " port=" + proxyPort);
                            }
                            result = new String[]{proxyIP, "" + proxyPort};
                        } else {
                            if (VERBOSE) {
                                System.out.println("1.3.X reported NULL for proxyInfo.getProxy (no proxy assumed)");
                            }
                            result = NO_PROXY_HOST;
                        }
                    } else {
                        if (VERBOSE) {
                            System.out.println("NULL proxyInfo in 1.3.X auto proxy detection, (no proxy assumed)");
                        }
                        result = NO_PROXY_HOST;
                    }
                    break block11;
                }
                throw new Exception("Sun Plugin 1.3.X failed to provide a default proxy handler");
            }
            catch (Exception e) {
                if (VERBOSE) {
                    System.out.println("Sun Plugin 1.3.X proxy detection class not found, will try failover detection, e:" + e);
                }
                if (!VERBOSE) break block11;
                e.printStackTrace();
            }
        }
        return result;
    }

    private static String[] detectProxySettingsAnyJreUsingReflectiveProxySelector(URL sampleURL) {
        try {
            System.out.println("Attempting ProxySelector proxy detection");
            Class<?> pselC = Class.forName("java.net.ProxySelector");
            Class<?> proxyC = Class.forName("java.net.Proxy");
            Object pselO = pselC.getDeclaredMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            List proxies = (List)pselC.getDeclaredMethod("select", URI.class).invoke(pselO, sampleURL.toURI());
            System.out.println(proxies.size() + " proxies listed by ProxySelector");
            for (int i = 0; i < proxies.size(); ++i) {
                Object proxyO = proxies.get(i);
                System.out.println(proxyO);
                String proxyType = proxyC.getDeclaredMethod("type", new Class[0]).invoke(proxyO, new Object[0]).toString();
                if (proxyType == null || !proxyType.equalsIgnoreCase("HTTP")) continue;
                System.out.println("HTTP Proxy found");
                SocketAddress proxyAddr = (SocketAddress)proxyC.getDeclaredMethod("address", new Class[0]).invoke(proxyO, new Object[0]);
                System.out.println("Detected HTTP proxy via ProxySelector - " + proxyAddr + " (" + proxyAddr.getClass() + ")");
                InetSocketAddress inetAddr = (InetSocketAddress)proxyAddr;
                return new String[]{inetAddr.getHostName(), "" + inetAddr.getPort()};
            }
        }
        catch (ClassNotFoundException x) {
            System.out.println("Unable to determinte proxy based on ProxySelector - JRE too old");
        }
        catch (Throwable x) {
            System.out.println("Unable to determinte proxy based on ProxySelector...");
            x.printStackTrace();
        }
        return null;
    }

    private static String[] detectProxySettingsJDK14_JDK15_JDK16(URL sampleURL) {
        String[] result;
        block7: {
            result = null;
            try {
                Class<?> ProxyServiceClass = Class.forName("com.sun.java.browser.net.ProxyService");
                Method getProxyInfoMethod = ProxyServiceClass.getDeclaredMethod("getProxyInfo", URL.class);
                Object proxyInfoArrayObj = getProxyInfoMethod.invoke(null, sampleURL);
                if (proxyInfoArrayObj == null || Array.getLength(proxyInfoArrayObj) == 0) {
                    if (VERBOSE) {
                        System.out.println("1.4.X reported NULL proxy (no proxy assumed)");
                    }
                    result = NO_PROXY_HOST;
                } else {
                    Object proxyInfoObject = Array.get(proxyInfoArrayObj, 0);
                    Class<?> proxyInfoClass = proxyInfoObject.getClass();
                    Method getHostMethod = proxyInfoClass.getDeclaredMethod("getHost", null);
                    String proxyIP = (String)getHostMethod.invoke(proxyInfoObject, null);
                    Method getPortMethod = proxyInfoClass.getDeclaredMethod("getPort", null);
                    Integer portInteger = (Integer)getPortMethod.invoke(proxyInfoObject, null);
                    int proxyPort = portInteger;
                    if (VERBOSE) {
                        System.out.println("1.4.X Proxy info geProxy:" + proxyIP + " get Port:" + proxyPort);
                    }
                    result = new String[]{proxyIP, "" + proxyPort};
                }
            }
            catch (Exception e) {
                if (VERBOSE) {
                    System.out.println("Sun Plugin 1.4.X proxy detection class not found, will try failover detection, e:" + e);
                }
                if (!VERBOSE) break block7;
                e.printStackTrace();
            }
        }
        return result;
    }

    private static String[] getPluginProxyConfigSettings() throws Exception {
        String[] result;
        block9: {
            result = null;
            try {
                boolean useProxy;
                Properties properties = System.getProperties();
                String proxyList = properties.getProperty(PLUGIN_PROXY_CONFIG_PROP);
                if (VERBOSE) {
                    System.out.println("Plugin Proxy Config List Property:" + proxyList);
                }
                boolean bl = useProxy = proxyList != null;
                if (useProxy) {
                    proxyList = proxyList.toUpperCase();
                    String proxyIP = "";
                    proxyIP = proxyList.indexOf("HTTP=") > -1 ? proxyList.substring(proxyList.indexOf("HTTP=") + 5, proxyList.indexOf(":")) : proxyList.substring(0, proxyList.indexOf(":"));
                    int endOfPort = proxyList.indexOf(",");
                    if (endOfPort < 1) {
                        endOfPort = proxyList.length();
                    }
                    String portString = proxyList.substring(proxyList.indexOf(":") + 1, endOfPort);
                    int proxyPort = Integer.parseInt(portString);
                    if (VERBOSE) {
                        System.out.println("proxy " + proxyIP + " port " + proxyPort);
                    }
                    result = new String[]{proxyIP, "" + proxyPort};
                } else {
                    if (VERBOSE) {
                        System.out.println("No configured plugin proxy list");
                    }
                    result = NO_PROXY_HOST;
                }
            }
            catch (Exception e) {
                if (VERBOSE) {
                    System.out.println("Exception during failover auto proxy detection, , e:" + e);
                }
                if (!VERBOSE) break block9;
                e.printStackTrace();
            }
        }
        return result;
    }
}

