/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.utils.HeadlessByteVisualiserInterface;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.Random;
import javax.imageio.ImageIO;

public class ByteVisualiser
implements HeadlessByteVisualiserInterface {
    static int INST = 1;
    DecimalFormat df = new DecimalFormat("00000");
    int x = 0;
    int y = 0;
    int I = 0;
    static int M = 100;
    BufferedImage bimg;
    File dir;
    FileOutputStream data;

    public ByteVisualiser() {
        File inst = new File("BV-instance-" + INST++);
        inst.mkdirs();
        this.dir = inst;
        try {
            this.data = new FileOutputStream(new File(this.dir, "DATA"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(byte b) {
        int n = b;
        if (n < 0) {
            n = 128 + -n;
        }
        if (this.bimg == null) {
            this.bimg = new BufferedImage(M, M, 2);
        }
        this.bimg.setRGB(this.x, this.y, 0xFF000000 | n << 8);
        ++this.x;
        if (this.x == M) {
            this.x = 0;
            ++this.y;
        }
        if (this.y == M) {
            try {
                ImageIO.write((RenderedImage)this.bimg, "PNG", new File(this.dir, "bviz" + this.df.format(this.I++) + ".png"));
                this.bimg = null;
                this.x = 0;
                this.y = 0;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        try {
            this.data.write(b);
            this.data.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        HeadlessByteVisualiserInterface bv = (HeadlessByteVisualiserInterface)Class.forName("com.aem.nodelink.utils.ByteVisualiser").newInstance();
        Random r = new Random();
        for (i = 0; i < 1000000; ++i) {
            bv.write((byte)r.nextInt());
        }
        for (i = 0; i < 1000; ++i) {
            bv.write((byte)i);
        }
        for (i = 0; i < 1000000; ++i) {
            bv.write((byte)r.nextInt());
        }
    }
}

