/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.utils.SafeClock;
import java.text.DecimalFormat;

public class BandwidthBuckets {
    public static long IGNORE_FIRST_MS = 20000L;
    public static int[] byteLimits = new int[30];
    public long[] bytes = new long[byteLimits.length];
    long setupAt = SafeClock.currentTimeMillis();

    public BandwidthBuckets cloneSelf() {
        BandwidthBuckets buckets = new BandwidthBuckets();
        buckets.bytes = (long[])this.bytes.clone();
        return buckets;
    }

    public void clear() {
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = 0L;
        }
    }

    public String getRttLines(String prefix, boolean header, boolean data) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (header) {
            sb.append(prefix + " Bands:");
            DecimalFormat dfMs = new DecimalFormat("000");
            DecimalFormat df = new DecimalFormat("#.0");
            for (i = 0; i < byteLimits.length; ++i) {
                String s;
                double kb = byteLimits[i];
                kb /= 1024.0;
                if (i == byteLimits.length - 1) {
                    sb.append(">>>");
                    continue;
                }
                if (kb < 10.0) {
                    sb.append(df.format(kb) + "|");
                    continue;
                }
                if (kb > 99999.0) {
                    s = (int)(kb / 1000.0) + "|";
                    sb.append(s);
                    continue;
                }
                if (kb > 999.0) {
                    if (kb < 9999.0) {
                        s = df.format(kb / 1000.0) + "|";
                        while (s.length() < 4) {
                            s = " " + s;
                        }
                        sb.append(s);
                        continue;
                    }
                    s = (int)(kb / 1000.0) + "M|";
                    while (s.length() < 4) {
                        s = " " + s;
                    }
                    sb.append(s);
                    continue;
                }
                s = "" + (int)kb;
                if (s.length() < 3) {
                    s = s + "K";
                }
                while (s.length() < 3) {
                    s = " " + s;
                }
                sb.append(s + "|");
            }
            sb.append("\n");
        }
        if (data) {
            double total = 0.0;
            for (i = 0; i < this.bytes.length; ++i) {
                total += (double)this.bytes[i];
            }
            double frac = 100.0 / total;
            DecimalFormat df = new DecimalFormat("0");
            sb.append(prefix + " KBs  :");
            if (!Double.isNaN(frac) && !Double.isInfinite(frac)) {
                for (int i2 = 0; i2 < this.bytes.length; ++i2) {
                    double pc = frac * (double)this.bytes[i2];
                    if (pc == 0.0) {
                        sb.append("    ");
                        continue;
                    }
                    String str = df.format(Math.min(99.0, pc));
                    if (str.length() == 1) {
                        sb.append(" " + str + "% ");
                        continue;
                    }
                    sb.append(str + "% ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void bytesMeasured(long rtt) {
        if (SafeClock.currentTimeMillis() < this.setupAt + IGNORE_FIRST_MS) {
            return;
        }
        for (int i = 0; i < byteLimits.length; ++i) {
            if (rtt > (long)byteLimits[i]) continue;
            int n = i;
            this.bytes[n] = this.bytes[n] + 1L;
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        IGNORE_FIRST_MS = 0L;
        for (int i = 0; i < byteLimits.length; ++i) {
            System.out.println(byteLimits[i]);
        }
        BandwidthBuckets stats = new BandwidthBuckets();
        for (int i = 0; i < 1000; ++i) {
            stats.bytesMeasured(1400L);
            stats.bytesMeasured(2800L);
            stats.bytesMeasured(2500L);
            stats.bytesMeasured(45000L);
            stats.bytesMeasured(450000L);
            stats.bytesMeasured(900000L);
        }
        System.out.println(stats.getRttLines("Network", true, true));
    }

    static {
        double L = 1500.0;
        for (int i = 0; i < byteLimits.length; ++i) {
            BandwidthBuckets.byteLimits[i] = (int)L;
            L *= 1.35;
        }
        BandwidthBuckets.byteLimits[BandwidthBuckets.byteLimits.length - 1] = Integer.MAX_VALUE;
    }
}

