/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.tcp;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.Robustness;
import com.aem.nodelink.Transport;
import com.aem.nodelink.attempt.ConcurrentAttempt;
import com.aem.nodelink.attempt.socket.ClientSocketConnectAttempt;
import com.aem.nodelink.tcp.Base64;
import com.aem.nodelink.tcp.TcpEndpoint;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.NotNodelinkSslConnectionException;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.nodelink.utils.WorkingNioSocket;
import com.aem.nodelink.utils.WorkingNioSslSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.SSLException;
import utils.progtools.Counter;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.stream.LimitedBandwidthOutputStream;
import utils.stream.SocketLeaks;
import utils.stream.StreamUtils;
import utils.switches.Switches;

public class TcpTransport
implements Transport,
TimeoutMapListener<String, Socket> {
    private final boolean VERBOSE = false;
    public static boolean VERBOSE_CLEANUP = false;
    public static boolean VERBOSE_CREATE = false;
    private static final boolean VERBOSE_SSL_PROXY = false;
    private static final boolean VERBOSE_BYTES = false;
    public static boolean VERBOSE_TCPTRANSPORT_HANDLING_ERRORS = false;
    private static final int MAGIC_NODELINK = 1313098827;
    private static boolean UNIVERSAL_AGGRESSIVE_RECONNECT = false;
    private static boolean FAIL_ON_NO_DATA = false;
    private static long FAIL_ON_NO_DATA_TIMEOUT = Long.MAX_VALUE;
    private static final boolean DEBUG_SIMULATE_LATENCY = false;
    private static final long DEBUG_SIMULATE_LATENCY_MS = 200L;
    private static final boolean DEBUG_SMALL_PACKET_TRACES = false;
    private static long NO_DATA_CLOSE_TIMEOUT = Switches.SH_nlTcpTransportCloseOnTimeout ? 300000L : 1800000L;
    Node idnode;
    Node mynode;
    long tcpConnectTimeout;
    Object ssocks_LOCK = new Object();
    HashMap ssocks = new HashMap();
    final Object socks_LOCK = new Object();
    TimeoutMap<String, Socket> tsocks = new TimeoutMap();
    HashMap outs = new HashMap();
    HashMap sockslocks = new HashMap();
    HashMap sockslocksmasters = new HashMap();
    OnDemandThreadPool odp = new OnDemandThreadPool("TcpPRPool", Switches.SH_1778_largerTccMapPool ? Switches.SH_1778_tcpTransportPoolSize : (Switches.SH_1595_largeTccMapPool ? 600 : 150), Switches.SH_1778_largerTccMapPool ? Switches.SH_1778_tcpTransportBufferCount : 10000, 9);
    private static Object packetTraces_LOCK;
    private static Counter packetTraces;
    private static long nextDump;
    HashMap accepters = new HashMap();
    boolean dropAll = false;
    Transport fwdTransport;
    Node fwdNode;
    Endpoint fwdEndpoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemove(String key) {
        Object object = this.socks_LOCK;
        synchronized (object) {
            Socket sock = this.tsocks.remove(key);
            this.outs.remove(key);
            this.sockslocks.remove(key);
            this.sockslocksmasters.remove(key);
            try {
                if (sock != null) {
                    if (VERBOSE_CLEANUP) {
                        System.out.println("[TCPTransport] closing " + sock);
                    }
                    sock.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void objectTimedOut(String key, Socket val) {
        if (Switches.SH_nlTcpTransportCloseOnTimeout) {
            System.out.println("[TCPTransport] Timed out " + key + " / " + val);
            this.closeAndRemove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAllConnections() throws Exception {
        Object object = this.socks_LOCK;
        synchronized (object) {
            try {
                String[] keys = this.tsocks.keySetArray((String[])new String[0]);
                if (VERBOSE_CLEANUP) {
                    System.out.println("[TCPTransport] cleaning up " + keys.length + " sockets");
                }
                for (int i = 0; i < keys.length; ++i) {
                    this.closeAndRemove(keys[i]);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAllConnectionsTo(Node target) throws Exception {
        if (VERBOSE_CLEANUP) {
            System.out.println("[TCPTransport] cleaning up connections to " + target);
        }
        Object object = this.socks_LOCK;
        synchronized (object) {
            this.closeAndRemove(target.getUID());
        }
    }

    public static void setFailOnNoDataTimeout(long ms) {
        TcpTransport.setFailOnNoDataTimeout(ms, NodeLink.KEEPALIVE_WRITE_EVERY);
    }

    public static void setFailOnNoDataTimeout(long ms, int nodeLinkKeepaliveEvery) {
        NodeLink.KEEPALIVE_WRITE_EVERY = nodeLinkKeepaliveEvery;
        FAIL_ON_NO_DATA_TIMEOUT = ms;
        FAIL_ON_NO_DATA = true;
    }

    public TcpTransport(Node selfnode, long tcpConnectTimeout) {
        this.idnode = this.mynode = selfnode;
        this.tcpConnectTimeout = tcpConnectTimeout;
    }

    public Node getMyNode() {
        return this.mynode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSocketLock(String key) {
        Object object = this.socks_LOCK;
        synchronized (object) {
            Object lock = this.sockslocks.get(key);
            if (lock == null) {
                lock = new Object();
                this.sockslocks.put(key, lock);
            }
            this.sockslocksmasters.put(key, new Exception("Socket Lock Owner"));
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception getSocketLockOwner(String key) {
        Object object = this.socks_LOCK;
        synchronized (object) {
            Exception owner = (Exception)this.sockslocksmasters.get(key);
            return owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHumanReadableTransportIdentifierFor(Node target) throws Exception {
        if (Switches.SH_2003_tcpTransportNoLockSocketOnGetHumanID) {
            try {
                Socket sock = this.tsocks.get(target.getUID());
                if (sock == null && Switches.SH_XXXX_tcpTransportReturnValidNameIfUnconnected) {
                    return "(unconnected TCP socket)";
                }
                return ((InetSocketAddress)sock.getRemoteSocketAddress()).getAddress().getHostAddress();
            }
            catch (Throwable t) {
                return "(unconnected TCP socket T)";
            }
        }
        Object object = this.getSocketLock(target.getUID());
        synchronized (object) {
            Socket sock;
            Object object2 = this.socks_LOCK;
            synchronized (object2) {
                sock = this.tsocks.get(target.getUID());
            }
            if (sock == null && Switches.SH_XXXX_tcpTransportReturnValidNameIfUnconnected) {
                return "(unconnected TCP socket)";
            }
            return ((InetSocketAddress)sock.getRemoteSocketAddress()).getAddress().getHostAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket debugGetSocketFor(Node target) throws Exception {
        Object object = this.getSocketLock(target.getUID());
        synchronized (object) {
            Object object2 = this.socks_LOCK;
            synchronized (object2) {
                return this.tsocks.get(target.getUID());
            }
        }
    }

    @Override
    public void sendPacketTo(Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        this.sendPacketTo(this.mynode, target, ep, data, rarelyVerifyLiveness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacketTo(Node sentFrom, Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        if (this.dropAll) {
            return;
        }
        Object object = this.getSocketLock(target.getUID());
        synchronized (object) {
            OutputStream out;
            Socket sock;
            Object object2 = this.socks_LOCK;
            synchronized (object2) {
                sock = this.tsocks.get(target.getUID(), NO_DATA_CLOSE_TIMEOUT);
                out = (OutputStream)this.outs.get(target.getUID());
                if (sock == null) {
                    TcpEndpoint et = (TcpEndpoint)ep;
                    if (et.isServerEndpoint()) {
                        throw new Exception("Waiting for client to re-establish connection");
                    }
                    if (Robustness.ALL_TCP_CONNECTIONS_FAIL) {
                        throw new Exception("Robustness forcing all TCP connects to fail");
                    }
                    if (et.ssl) {
                        sock = SslToTcp.createSslMappedTcpSocket(et.host, et.port);
                    } else if (et.proxyhost != null) {
                        sock = new Socket();
                        sock.connect(new InetSocketAddress(et.proxyhost, et.proxyport), (int)this.tcpConnectTimeout);
                        if (Robustness.HALF_SSL_TCP_CONNECTIONS_FAIL && Math.random() < 0.5) {
                            throw new Exception("Robustness forcing half of all SSL proxied TCP connections to fail");
                        }
                        int origTimeout = sock.getSoTimeout();
                        sock.setSoTimeout(15000);
                        OutputStream sslout = sock.getOutputStream();
                        sslout.write(("CONNECT " + et.host + ":" + et.port + " HTTP/1.0\r\n").getBytes("UTF8"));
                        sslout.write("\r\n".getBytes("UTF8"));
                        sslout.flush();
                        InputStream sslin = sock.getInputStream();
                        String resp = new String(DataUtils.readLine(sslin));
                        String line = new String(DataUtils.readLine(sslin));
                        int contentLength = 0;
                        while (line.trim().length() > 0) {
                            if (line.toLowerCase().indexOf("content-length") != -1) {
                                contentLength = Integer.parseInt(line.substring(line.indexOf(58) + 1).trim());
                            }
                            line = new String(DataUtils.readLine(sslin));
                        }
                        for (int i = 0; i < contentLength; ++i) {
                            char c = (char)sslin.read();
                        }
                        if (resp.indexOf("407") != -1) {
                            try {
                                sock.close();
                            }
                            catch (Throwable i) {
                                // empty catch block
                            }
                            sock = new Socket();
                            sock.connect(new InetSocketAddress(et.proxyhost, et.proxyport), (int)this.tcpConnectTimeout);
                            sslin = sock.getInputStream();
                            sslout = sock.getOutputStream();
                            if (et.auth == null) {
                                throw new Exception("SSL Proxy requires authentication but no provider has been set");
                            }
                            String[] credentials = et.auth.getBasicCredentials(et.host, et.port);
                            String base64 = Base64.byteArrayToBase64((credentials[0] + ":" + credentials[1]).getBytes("ASCII"));
                            sslout.write(("CONNECT " + et.host + ":" + et.port + " HTTP/1.0\r\n").getBytes("UTF8"));
                            sslout.write(("Proxy-authorization: basic " + base64 + "r\n").getBytes("UTF8"));
                            sslout.write("\r\n".getBytes("UTF8"));
                            sslout.flush();
                            resp = new String(DataUtils.readLine(sslin));
                            line = new String(DataUtils.readLine(sslin));
                            contentLength = 0;
                            while (line.trim().length() > 0) {
                                if (line.toLowerCase().indexOf("content-length") != -1) {
                                    contentLength = Integer.parseInt(line.substring(line.indexOf(58) + 1).trim());
                                }
                                line = new String(DataUtils.readLine(sslin));
                            }
                            for (int i = 0; i < contentLength; ++i) {
                                char c = (char)sslin.read();
                            }
                            if (resp.indexOf("200") == -1) {
                                throw new Exception("Failed to authenticate against SSL proxy, response was " + resp);
                            }
                        } else if (resp.indexOf("200") == -1) {
                            throw new Exception("Failed to tunnel via SSL proxy, response was " + resp);
                        }
                        sock.setSoTimeout(origTimeout);
                    } else if (et.aggressiveReconnect || UNIVERSAL_AGGRESSIVE_RECONNECT) {
                        for (int i = 0; i < 3; ++i) {
                            ConcurrentAttempt ca = new ConcurrentAttempt();
                            ca.newAttemptLayer();
                            ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt(et.host, et.port, 0, 7500L, 0L));
                            ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt(et.host, et.port, 0, 7500L, 2500L));
                            ca.appendAttemptToCurrentLayer(new ClientSocketConnectAttempt(et.host, et.port, 0, 7500L, 5000L));
                            ClientSocketConnectAttempt attempt = (ClientSocketConnectAttempt)ca.attemptNow();
                            if (attempt == null) {
                                throw new IOException("Socket connection failed");
                            }
                            sock = attempt.getSocket();
                        }
                    } else {
                        if (et.sres.requestCreateOrQuit("TcpTransport")) {
                            System.out.println("[TcpTransport] Too many failed attempts and new sockets, delaying then exiting");
                            try {
                                Thread.sleep(240000L);
                            }
                            catch (Exception i) {
                                // empty catch block
                            }
                            return;
                        }
                        System.out.println("[TcpTransport] Creating new socket to " + et.host + ":" + et.port);
                        sock = new Socket();
                        sock.connect(new InetSocketAddress(et.host, et.port), (int)this.tcpConnectTimeout);
                        System.out.println("[TcpTransport] Got new socket to " + et.host + ":" + et.port);
                    }
                    System.out.println("[TcpTransport] Connected, sending from " + sentFrom);
                    System.out.println("[TcpTransport] Connected, mynode is " + this.mynode);
                    System.out.println("[TcpTransport] Connected, sending to " + target);
                    if (NodeLink.DISABLE_NAGLE) {
                        sock.setTcpNoDelay(true);
                    }
                    out = Switches.SH_nlFractionalTcpBandwidthLimiting ? new BufferedOutputStream(new LimitedBandwidthOutputStream(sock.getOutputStream(), 90)) : new BufferedOutputStream(sock.getOutputStream());
                    DataUtils.writeInt(out, 1313098827);
                    out.flush();
                    System.out.println("[TcpTransport] Setting socket for " + target.getUID() + " sending from " + this.idnode.getUID());
                    this.tsocks.put(target.getUID(), sock, NO_DATA_CLOSE_TIMEOUT, this);
                    this.outs.put(target.getUID(), out);
                    DataUtils.writeString(out, this.idnode.getUID());
                    out.flush();
                    PacketReader pr = new PacketReader(sock, et, target);
                    if (Switches.SH_1778_tcpTransportPacketReaderPool) {
                        if (!this.odp.runAsync(pr)) {
                            throw new IOException("Unable to process new outgoing TcpTransport PR connection (pool alert)");
                        }
                    } else {
                        new Thread(pr).start();
                    }
                    if (FAIL_ON_NO_DATA) {
                        et.lastReceivedData = SafeClock.currentTimeMillis();
                    }
                }
            }
            if (Robustness.BROKEN_UNDERLYING_CONNECTION) {
                sock.close();
                Robustness.BROKEN_UNDERLYING_CONNECTION = false;
            }
            try {
                if (FAIL_ON_NO_DATA) {
                    TcpEndpoint et = (TcpEndpoint)ep;
                    if (SafeClock.currentTimeMillis() - et.lastReceivedData > FAIL_ON_NO_DATA_TIMEOUT) {
                        throw new Exception("No data received for " + FAIL_ON_NO_DATA_TIMEOUT + "ms");
                    }
                }
                DataUtils.writeString(out, sentFrom.getUID());
                DataUtils.writeBytes(out, data);
                out.flush();
            }
            catch (Exception e) {
                this.closeAndRemove(target.getUID());
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugSmallPacketTrace(int len) {
        Object object = packetTraces_LOCK;
        synchronized (object) {
            packetTraces.add(TcpTransport.getTrace("All packets"), 1.0);
            if (len < 100) {
                packetTraces.add(TcpTransport.getTrace("Under 100"), 1.0);
            } else if (len < 500) {
                packetTraces.add(TcpTransport.getTrace("Under 500"), 1.0);
            } else if (len < 1000) {
                packetTraces.add(TcpTransport.getTrace("Under 1000"), 1.0);
            } else {
                packetTraces.add(TcpTransport.getTrace("Over 1K"), 1.0);
            }
            if (System.currentTimeMillis() > nextDump + 10000L) {
                packetTraces.sortByValue(false);
                System.out.println("Analysis of small packet traces through TCP:");
                System.out.println(packetTraces);
                packetTraces = new Counter();
                nextDump = System.currentTimeMillis();
            }
        }
    }

    private static String getTrace(String category) {
        Throwable t = new Throwable(category);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    @Override
    public void ensureAcceptingOn(Endpoint ee) throws Exception {
        TcpEndpoint e = (TcpEndpoint)ee;
        e.setIsServerEndpoint(true);
        Accepter accepter = new Accepter(e);
        this.accepters.put(e.toString(), accepter);
    }

    public void stopAcceptingOn(Endpoint ee) throws Exception {
        TcpEndpoint e = (TcpEndpoint)ee;
        Accepter accepter = (Accepter)this.accepters.get(e.toString());
        if (accepter != null) {
            accepter.shutdown();
        }
    }

    public String toString() {
        return "TcpTransport[" + this.mynode + "]";
    }

    @Override
    public void setMyNode(Node node, Endpoint ep) {
        this.mynode = node;
    }

    public void setIdNode(Node node) {
        this.idnode = node;
    }

    @Override
    public void dropAllPackets() {
        this.dropAll = true;
    }

    @Override
    public void stopDroppingAllPackets() {
        this.dropAll = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTransportData(Node currentTarget, Node newTarget, Endpoint myEp) {
        Object object = this.socks_LOCK;
        synchronized (object) {
            Socket sock = this.tsocks.get(currentTarget.getUID(), NO_DATA_CLOSE_TIMEOUT);
            OutputStream out = (OutputStream)this.outs.get(currentTarget.getUID());
            System.out.println("[TcpTransport] Got socket " + sock + " for " + currentTarget.getUID() + ", will use for " + newTarget.getUID());
            this.tsocks.put(newTarget.getUID(), sock, NO_DATA_CLOSE_TIMEOUT, this);
            this.outs.put(newTarget.getUID(), out);
        }
    }

    @Override
    public void swapTargetsWith(Node myTarget, Transport fromTransport, Endpoint fromEndpoint, Node fromTarget) {
    }

    @Override
    public void forwardAllPacketsTo(Transport transport, Node target, Endpoint ep) throws Exception {
        this.fwdEndpoint = ep;
        this.fwdNode = target;
        this.fwdTransport = transport;
    }

    @Override
    public boolean isProxiedConnection(Endpoint ep) {
        return false;
    }

    public boolean areForwarding() {
        return this.fwdTransport != null;
    }

    static /* synthetic */ Object access$100(TcpTransport x0, String x1) {
        return x0.getSocketLock(x1);
    }

    static /* synthetic */ long access$200() {
        return NO_DATA_CLOSE_TIMEOUT;
    }

    static /* synthetic */ boolean access$300() {
        return FAIL_ON_NO_DATA;
    }

    static {
        TcpTransport.setFailOnNoDataTimeout(Math.max(NodeLink.KEEPALIVE_WRITE_EVERY * 2, 30000), 1500);
        packetTraces_LOCK = new Object();
        packetTraces = new Counter();
        nextDump = System.currentTimeMillis();
    }

    class PacketReader
    implements Runnable {
        Socket sock;
        TcpEndpoint e;
        String fromnode;
        HashMap havestored = new HashMap();
        String lastsaw = "";

        public PacketReader(Socket sock, TcpEndpoint e, Node node) {
            this.sock = sock;
            this.e = e;
            this.fromnode = node != null ? node.getUID() : null;
            SocketLeaks.associate(sock, "TcpStage", "PR Create");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (!Switches.SH_1778_tcpTransportPacketReaderPool) {
                Thread.currentThread().setName("TcpTransport$PacketReader-" + System.currentTimeMillis());
            }
            if (!Switches.SH_1778_tcpTransportPacketReaderPool) {
                Thread.currentThread().setPriority(10);
            }
            initialFailureTime = SafeClock.currentTimeMillis() + 20000L;
            cleanup = new ArrayList<Socket>();
            try {
                block48: {
                    block47: {
                        cleanup.add(this.sock);
                        if (Switches.SH_1595_nlUseChannelServerSocketsNioShim) {
                            this.sock = WorkingNioSocket.fixNIO(this.sock);
                            cleanup.add(this.sock);
                        }
                        SocketLeaks.associate(this.sock, "TcpStage", "Post NIO Fix");
                        this.sock.setSoTimeout(300000);
                        in = this.sock.getInputStream();
                        SocketLeaks.associate(this.sock, "TcpStage", "Got IS");
                        if (this.fromnode != null) break block48;
                        magic = DataUtils.readInt(this.sock.getInputStream());
                        if (magic == 1313098827) ** GOTO lbl93
                        SocketLeaks.associate(this.sock, "TcpStage", "Not NL");
                        handler = this.e.getAlternateSocketHandler();
                        if (handler == null) {
                            SocketLeaks.associate(this.sock, "TcpStage", "Not NL, no alt");
                            throw new Exception("Incoming socket not a nodelink socket and no alternate socket handler registered");
                        }
                        initialData = new byte[4];
                        DataUtils.writeInt(initialData, magic);
                        SocketLeaks.associate(this.sock, "TcpStage", "About to handle");
                        handled = handler.incomingSocket(initialData, this.sock);
                        if (handled) {
                            SocketLeaks.associate(this.sock, "TcpStage", "As web");
                        } else {
                            SocketLeaks.associate(this.sock, "TcpStage", "Not web");
                        }
                        if (handled) {
                            return;
                        }
                        if (Switches.SH_1829_useNioSsl) {
                            try {
                                this.sock = WorkingNioSslSocket.fixNIO(this.sock, initialData);
                                SocketLeaks.associate(this.sock, "TcpStage", "Wrapped NIO ssl");
                                in = this.sock.getInputStream();
                                out = this.sock.getOutputStream();
                                DEBUG_SSL = false;
                                if (!DEBUG_SSL) {
                                    SocketLeaks.associate(this.sock, "TcpStage", "NIO ssl set timeout");
                                    if (Switches.SH_1778_tcpTransportTimeoutSslMappedSocket) {
                                        this.sock.setSoTimeout(300000);
                                    }
                                    if ((magic = ByteArrayUtils.readInt(initialData = StreamUtils.readBytes(in, 4), 0)) == 1313098827) ** GOTO lbl100
                                    SocketLeaks.associate(this.sock, "TcpStage", "Not secure NL");
                                    if (handler.incomingSocket(initialData, this.sock)) {
                                        SocketLeaks.associate(this.sock, "TcpStage", "Is secure web");
                                        return;
                                    }
                                    SocketLeaks.associate(this.sock, "TcpStage", "Not secure web (unrecognised)");
                                    throw new Exception("Incoming secure socket not a nodelink socket or a web connection");
                                }
                                wsock = (WorkingNioSslSocket)this.sock;
                                SocketLeaks.associate(this.sock, "TcpStage", "Debug SSL");
                                line = StreamUtils.readLineAsStringUTF8(in);
                                while (line.trim().length() > 0) {
                                    System.out.println(line.trim());
                                    line = StreamUtils.readLineAsStringUTF8(in);
                                }
                                System.out.println("SSLDebug Read all HTTP lines");
                                out.write("HTTP/1.0 404 Not Found\n\n\n\n\n".getBytes());
                                out.flush();
                                System.out.println("SSLDebug Wrote HTTP data");
                                Thread.sleep(5000L);
                                System.out.println("SSLDebug dumping engine status");
                                wsock.dumpEngineStatus();
                            }
                            catch (EOFException t) {
                                throw t;
                            }
                            catch (SSLException t) {
                                throw t;
                            }
                            catch (Exception t) {
                                t.printStackTrace();
                                throw t;
                            }
                        } else {
                            SocketLeaks.associate(this.sock, "TcpStage", "SslToTcp");
                            SslToTcp.startListening();
                            try {
                                sslpack = SslToTcp.mapTcpToSsl(this.sock, initialData);
                                this.sock = sslpack.getReplacement();
                                cleanup.addAll(sslpack.getSocks());
                                in = this.sock.getInputStream();
                                if (Switches.SH_1778_tcpTransportTimeoutSslMappedSocket) {
                                    this.sock.setSoTimeout(300000);
                                }
                                if ((magic = DataUtils.readInt(in)) != 1313098827) {
                                    throw new Exception("Incoming secure socket not a nodelink socket");
                                }
                                break block47;
                            }
                            catch (NotNodelinkSslConnectionException xxx) {
                                if (handler.incomingSocket(xxx.initialData, xxx.sslSock)) {
                                    return;
                                }
                                throw new Exception("Incoming secure socket not a nodelink socket or a web connection");
                            }
lbl93:
                            // 1 sources

                            handler = this.e.getAlternateSocketHandler();
                            if (handler != null) {
                                handler.incomingNodelinkSocket(this.sock);
                            }
                            SocketLeaks.associate(this.sock, "TcpStage", "Incoming NL");
                            if (SslToTcp.ACCEPT_ONLY_SSL_CONNECTIONS) {
                                SocketLeaks.associate(this.sock, "TcpStage", "Refused incoming NL (SSL only)");
                                throw new Exception("Non-SSL connections are being refused");
                            }
                        }
                    }
                    this.fromnode = DataUtils.readNString(in, 100000);
                    handler = TcpTransport.access$100(TcpTransport.this, this.fromnode);
                    synchronized (handler) {
                        var7_12 = TcpTransport.this.socks_LOCK;
                        synchronized (var7_12) {
                            oldsock = TcpTransport.this.tsocks.get(this.fromnode);
                            try {
                                oldsock.close();
                            }
                            catch (Exception xxx) {
                                // empty catch block
                            }
                            if (NodeLink.DISABLE_NAGLE) {
                                this.sock.setTcpNoDelay(true);
                            }
                            out = Switches.SH_nlFractionalTcpBandwidthLimiting != false ? new BufferedOutputStream(new LimitedBandwidthOutputStream(this.sock.getOutputStream(), 90)) : new BufferedOutputStream(this.sock.getOutputStream());
                            TcpTransport.this.tsocks.put(this.fromnode, this.sock, TcpTransport.access$200(), TcpTransport.this);
                            TcpTransport.this.outs.put(this.fromnode, out);
                            TcpTransport.this.mynode.setRemoteNodeAddress(new Node(this.fromnode), this.e, TcpTransport.this);
                        }
                    }
                }
                in = new BufferedInputStream(in);
                this.sock.setSoTimeout(600000);
                il = new InfiniteLoop();
                while (true) {
                    this.fromnode = DataUtils.readNString(in, 100000);
                    if (!this.lastsaw.equals(this.fromnode) && !this.havestored.containsKey(this.fromnode)) {
                        out = Switches.SH_nlFractionalTcpBandwidthLimiting != false ? new BufferedOutputStream(new LimitedBandwidthOutputStream(this.sock.getOutputStream(), 90)) : new BufferedOutputStream(this.sock.getOutputStream());
                        TcpTransport.this.tsocks.put(this.fromnode, this.sock, TcpTransport.access$200(), TcpTransport.this);
                        TcpTransport.this.outs.put(this.fromnode, out);
                        TcpTransport.this.mynode.setRemoteNodeAddress(new Node(this.fromnode), this.e, TcpTransport.this);
                        this.havestored.put(this.fromnode, this.fromnode);
                        this.lastsaw = this.fromnode;
                    }
                    TcpTransport.this.tsocks.get(this.fromnode, TcpTransport.access$200());
                    dat = DataUtils.readNBytes(in, 10000000);
                    if (TcpTransport.access$300()) {
                        this.e.lastReceivedData = SafeClock.currentTimeMillis();
                    }
                    if (TcpTransport.this.dropAll) continue;
                    if (TcpTransport.this.areForwarding()) {
                        TcpTransport.this.fwdTransport.sendPacketTo(TcpTransport.this.fwdNode, TcpTransport.this.fwdEndpoint, dat, false);
                        continue;
                    }
                    TcpTransport.this.mynode.processPacket(dat, this.fromnode);
                }
            }
            catch (Exception e) {
                if (TcpTransport.VERBOSE_TCPTRANSPORT_HANDLING_ERRORS) {
                    System.out.println("[TcpTransport] socket could not be handled (" + e + "), closing");
                }
                if (SafeClock.currentTimeMillis() < initialFailureTime) {
                    System.out.println("[TcpTransport] PacketReader failed, connection will be closed - " + e);
                }
                if (Switches.SH_1778_tcpCleanupAllSocketsOnFailureToHandle) {
                    for (Socket toclose : cleanup) {
                        try {
                            toclose.close();
                        }
                        catch (Exception var6_11) {}
                    }
                }
                try {
                    this.sock.close();
                }
                catch (Exception var4_6) {
                    // empty catch block
                }
                return;
            }
        }
    }

    class Accepter
    extends Thread {
        TcpEndpoint e;
        ServerSocket ssock;
        boolean die = false;

        private void shutdown() {
            this.die = true;
            try {
                this.ssock.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public Accepter() throws Exception {
            this.setName("TcpTransport$Accepter");
        }

        public Accepter(TcpEndpoint e) throws Exception {
            this.e = e;
            this.setName("TcpTransport$Accepter");
            this.setDaemon(true);
            if (Robustness.ALL_TCP_BINDS_FAIL) {
                throw new Exception("Robustness forcing all TCP binds to fail");
            }
            if (Switches.SH_2018_tcpPrPoolSetName && TcpTransport.this.odp != null) {
                TcpTransport.this.odp.setName("TcpPrPool" + e.port);
            }
            if (e.bindIp != null) {
                if (Switches.SH_1595_nlUseChannelServerSockets) {
                    ServerSocketChannel chansock = ServerSocketChannel.open();
                    this.ssock = chansock.socket();
                    this.ssock.bind(new InetSocketAddress(InetAddress.getByName(e.bindIp), e.port), -1);
                } else {
                    this.ssock = new ServerSocket(e.port, -1, InetAddress.getByName(e.bindIp));
                }
            } else if (Switches.SH_1595_nlUseChannelServerSockets) {
                ServerSocketChannel chansock = ServerSocketChannel.open();
                this.ssock = chansock.socket();
                this.ssock.bind(new InetSocketAddress(e.port), -1);
            } else {
                this.ssock = new ServerSocket(e.port);
            }
            this.start();
        }

        @Override
        public void run() {
            int count = 0;
            long lastError = 0L;
            InfiniteLoop il = new InfiniteLoop();
            while (!this.die) {
                il.LOOP();
                Socket sock = null;
                try {
                    sock = this.ssock.accept();
                    SocketLeaks.associate(sock, "TcpStage", "Initial Accept");
                    try {
                        if (Switches.SH_1595_nlUseChannelServerSocketsNioShim) {
                            sock = WorkingNioSocket.fixNIO(sock);
                        }
                    }
                    catch (Exception x) {
                        if (Switches.SH_1847_closeSocketOnFailToHandle) {
                            try {
                                sock.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw x;
                    }
                    ++count;
                    if (NodeLink.VERBOSE_SOCKETS) {
                        System.out.println("New incoming TCP connection (no " + count + ") from " + sock.getRemoteSocketAddress());
                    }
                    PacketReader pr = new PacketReader(sock, this.e, null);
                    if (Switches.SH_1778_tcpTransportPacketReaderPool) {
                        if (!TcpTransport.this.odp.runAsync(pr)) {
                            if (Switches.SH_1847_closeSocketOnFailToHandle) {
                                try {
                                    sock.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            throw new IOException("Unable to process new incoming TcpTransport connection (pool alert)");
                        }
                    } else {
                        new Thread(pr).start();
                    }
                    lastError = 0L;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (Switches.SH_1847_closeSocketOnAnyHandlingException) {
                        try {
                            sock.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        if (SafeClock.currentTimeMillis() - lastError < 500L) {
                            Thread.sleep(1500L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    lastError = SafeClock.currentTimeMillis();
                }
            }
        }
    }
}

