/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.http;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.Node;
import com.aem.nodelink.Robustness;
import com.aem.nodelink.Transport;
import com.aem.nodelink.http.HttpEndpoint;
import com.aem.nodelink.http.NotifiableList;
import com.aem.nodelink.http.extend.HttpRequestPoster;
import com.aem.nodelink.http.extend.HttpRequestProcessor;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SslToTcp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class BasicHttpTransport
implements Transport,
HttpRequestProcessor {
    static boolean DEBUG = false;
    static boolean VERBOSE = false;
    public static int PUSHER_COUNT = 1;
    public static int PULLER_COUNT = 1;
    boolean dead = false;
    HttpEndpoint server;
    Node mynode;
    Node alsoFetch;
    Object pollers_LOCK = new Object();
    HashMap pollers = new HashMap();
    Object passes_LOCK = new Object();
    HashMap passes = new HashMap();
    InetAddress from;
    long MAX_BUF = 400000L;
    Cache fromAddresses = new Cache("HttpTransport", 1000);
    Object bout_LOCK = new Object();
    int boutsize = 0;
    ArrayList bouts = new ArrayList();
    boolean dropAll = false;
    Transport fwdTransport;
    Node fwdNode;
    Endpoint fwdEndpoint;

    @Override
    public String getHumanReadableTransportIdentifierFor(Node target) throws Exception {
        InetAddress addr = (InetAddress)this.fromAddresses.getFromCache(target.toString());
        if (addr == null) {
            return "127.0.0.1";
        }
        return addr.getHostAddress();
    }

    private NotifiableList getNotifiableList(Node node, boolean canCreate) {
        return this.getNotifiableList(node.toString(), canCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotifiableList getNotifiableList(String node, boolean canCreate) {
        NotifiableList list;
        Object object = this.passes_LOCK;
        synchronized (object) {
            list = (NotifiableList)this.passes.get(node);
            if (list == null && canCreate) {
                list = new NotifiableList();
                this.passes.put(node, list);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNotifiableList(String node, NotifiableList list) {
        Object object = this.passes_LOCK;
        synchronized (object) {
            this.passes.put(node, list);
        }
    }

    public BasicHttpTransport(Node node) {
        this.mynode = node;
    }

    @Override
    public void ensureAcceptingOn(Endpoint ee) throws Exception {
        HttpEndpoint e = (HttpEndpoint)ee;
        this.server = new HttpEndpoint(new URL("http://SERVER/"));
        if (Robustness.ALL_HTTP_BINDS_FAIL) {
            throw new Exception("Robustness forcing all HTTP binds (server creates) to fail");
        }
        e.factory.redirectUrlRequests(e.url, this);
    }

    @Override
    public void sendPacketTo(Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        this.sendPacketTo(this.mynode, target, ep, data, rarelyVerifyLiveness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacketTo(Node sentFrom, Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        if (this.dropAll) {
            return;
        }
        if (ep == this.server) {
            NotifiableList list = this.getNotifiableList(target, false);
            if (list != null) {
                while (list.getSize() > this.MAX_BUF) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {}
                }
                list.add(sentFrom, data);
                return;
            }
            ArrayList<byte[]> datas = new ArrayList<byte[]>();
            datas.add(data);
            HttpEndpoint e = (HttpEndpoint)ep;
            this.makeHttpRequest(sentFrom, e, datas, target, false);
        } else {
            while (true) {
                Object list = this.bout_LOCK;
                synchronized (list) {
                    if ((long)this.boutsize <= this.MAX_BUF) {
                        this.bouts.add(data);
                        this.boutsize += data.length;
                        break;
                    }
                    this.bout_LOCK.wait(1000L);
                }
            }
            HttpEndpoint e = (HttpEndpoint)ep;
            Object object = this.pollers_LOCK;
            synchronized (object) {
                Poller[] poller = (Poller[])this.pollers.get(e.toString());
                if (poller == null && !this.dead) {
                    int i;
                    poller = new Poller[PUSHER_COUNT + PULLER_COUNT];
                    for (i = 0; i < PUSHER_COUNT; ++i) {
                        poller[i] = new Poller(e, target, true);
                        poller[i].start();
                    }
                    for (i = 0; i < PULLER_COUNT; ++i) {
                        poller[i] = new Poller(e, target, false);
                        poller[i].start();
                    }
                    this.pollers.put(e.toString(), poller);
                }
            }
        }
    }

    private boolean makeHttpRequest(Node sentFrom, HttpEndpoint e, ArrayList outgoings, Node target, boolean mayBlock) throws Exception {
        if (DEBUG) {
            System.out.println(System.currentTimeMillis() + ": " + mayBlock + " IN>>>");
        }
        if (this.dead) {
            return false;
        }
        HttpRequestPoster poster = e.cfactory.newClient();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataUtils.writeString(bout, sentFrom.getUID());
        if (this.alsoFetch == null) {
            DataUtils.writeString(bout, sentFrom.getUID());
        } else {
            DataUtils.writeString(bout, this.alsoFetch.getUID());
        }
        DataUtils.writeInt(bout, outgoings.size());
        for (int i = 0; i < outgoings.size(); ++i) {
            DataUtils.writeBytes(bout, (byte[])outgoings.get(i));
        }
        DataUtils.writeBoolean(bout, mayBlock);
        if (!mayBlock) {
            System.out.println("DELETEME pushing out " + bout.size());
        }
        try {
            if (Robustness.ALL_HTTP_CONNECTIONS_FAIL) {
                throw new Exception("Robustness forcing all HTTP connects (queries) to fail");
            }
            if (DEBUG) {
                System.out.println(System.currentTimeMillis() + ": " + mayBlock + " IN>>> >>>>");
            }
            byte[] ret = poster.doPost(e.url, bout.toByteArray());
            if (DEBUG) {
                System.out.println(System.currentTimeMillis() + ": " + mayBlock + " OT<<< <<<<");
            }
            if (DEBUG) {
                System.out.println("Transfer (" + mayBlock + ") \t\t" + bout.size() + "\t\t" + ret.length);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(ret);
            long tot = 0L;
            int packets = DataUtils.readInt(in);
            for (int i = 0; i < packets; i += 2) {
                String sendingNode = DataUtils.readNStringUTF8(in, 10000);
                this.mynode.setRemoteNodeAddress(new Node(sendingNode), e, this);
                byte[] rdat = DataUtils.readNBytes(in, 10000000);
                tot += (long)rdat.length;
                if (this.dropAll) continue;
                if (this.areForwarding()) {
                    this.fwdTransport.sendPacketTo(this.fwdNode, this.fwdEndpoint, rdat, false);
                    continue;
                }
                this.mynode.processPacket(rdat, target.toString());
            }
            if (mayBlock) {
                System.out.println("DELETEME pulled in " + tot);
            }
            if (DEBUG) {
                System.out.println(System.currentTimeMillis() + ": " + mayBlock + " OT<<<");
            }
            try {
                poster.close();
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
            return packets > 0;
        }
        catch (Exception x) {
            try {
                poster.close();
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
            throw x;
        }
    }

    @Override
    public int getStreamContentLength() {
        return -1;
    }

    @Override
    public boolean isStreamProcessor() {
        return false;
    }

    @Override
    public void processHttpRequest(Socket sock, InputStream in, OutputStream out, boolean isSslConnection, InetAddress fromAddr) throws Exception {
        throw new Exception("Unsupported HTTP processing method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] processHttpRequest(byte[] incoming, boolean isSslConnection, InetAddress fromAddr) throws Exception {
        ArrayList biglist;
        Object dat;
        if (SslToTcp.ACCEPT_ONLY_SSL_CONNECTIONS && !isSslConnection) {
            throw new Exception("Refusing non-SSL session connections");
        }
        if (DEBUG) {
            System.out.println(System.currentTimeMillis() + ": \t\tSERVER >>>");
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(incoming);
        String fromnode = DataUtils.readNString(bin, 100000);
        String fetchnode = DataUtils.readNString(bin, 10000);
        this.fromAddresses.addToCache(fromnode, fromAddr);
        this.mynode.setRemoteNodeAddress(new Node(fromnode), this.server, this);
        NotifiableList nlist = this.getNotifiableList(fromnode, true);
        this.setNotifiableList(fetchnode, nlist);
        boolean mayBlock = false;
        ArrayList<byte[]> dats = new ArrayList<byte[]>();
        int packets = DataUtils.readInt(bin);
        for (int i = 0; i < packets; ++i) {
            dats.add(DataUtils.readNBytes(bin, 10000000));
        }
        try {
            mayBlock = DataUtils.readBoolean(bin);
        }
        catch (Exception i) {
            // empty catch block
        }
        if (DEBUG) {
            System.out.println(System.currentTimeMillis() + ": \t\tSERVER RESP >>>");
        }
        if (DEBUG) {
            System.out.println(System.currentTimeMillis() + ": \t\tSERVER RESP <<<");
        }
        for (int i = 0; i < dats.size(); ++i) {
            dat = (byte[])dats.get(i);
            if (this.dropAll) continue;
            if (this.areForwarding()) {
                this.fwdTransport.sendPacketTo(this.fwdNode, this.fwdEndpoint, (byte[])dat, false);
                continue;
            }
            this.mynode.processPacket((byte[])dat, fromnode);
        }
        if (DEBUG) {
            System.out.println(System.currentTimeMillis() + ": \t\tSERVER LOOP>>>");
        }
        if (mayBlock) {
            Object object = nlist.getLOCK();
            dat = object;
            synchronized (object) {
                biglist = nlist.getAndClearDataList(mayBlock ? 2000L : -1L);
                // ** MonitorExit[dat /* !! */ ] (shouldn't be in output)
            }
        } else {
            biglist = new ArrayList();
        }
        {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataUtils.writeInt(bout, biglist.size());
            for (int i = 0; i < biglist.size(); i += 2) {
                Node node = (Node)biglist.get(i);
                DataUtils.writeStringUTF8(bout, node.getUID());
                byte[] rdat = (byte[])biglist.get(i + 1);
                DataUtils.writeBytes(bout, rdat);
            }
            byte[] toret = bout.toByteArray();
            return toret;
        }
    }

    @Override
    public Object getLockObject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAllConnections() throws Exception {
        System.out.println("[HttpTransport] Cleaning up all connections");
        this.dead = true;
        Object object = this.pollers_LOCK;
        synchronized (object) {
            System.out.println("[HttpTransport] Trying to shut down threads");
            Object[] arrays = this.pollers.values().toArray();
            for (int i = 0; i < arrays.length; ++i) {
                Poller[] tmp = (Poller[])arrays[i];
                for (int k = 0; k < tmp.length; ++k) {
                    tmp[k].join();
                }
                System.out.println("[HttpTransport] Joined " + (1 + i) + " of " + arrays.length);
            }
        }
    }

    @Override
    public void cleanupAllConnectionsTo(Node target) throws Exception {
        this.cleanupAllConnections();
    }

    @Override
    public void setMyNode(Node node, Endpoint e) {
        System.out.println("[HttpTransport] My Node set to " + this.mynode + " from " + node);
        this.mynode = node;
    }

    public void addFetchTarget(Node node) {
        System.out.println("[HttpTransport] Also fetching packets for node " + node);
        this.alsoFetch = node;
    }

    @Override
    public void dropAllPackets() {
        this.dropAll = true;
    }

    @Override
    public void stopDroppingAllPackets() {
        this.dropAll = false;
    }

    @Override
    public void swapTargetsWith(Node myTarget, Transport fromTransport, Endpoint fromEndpoint, Node fromTarget) {
    }

    @Override
    public void forwardAllPacketsTo(Transport transport, Node target, Endpoint ep) throws Exception {
        this.fwdEndpoint = ep;
        this.fwdNode = target;
        this.fwdTransport = transport;
    }

    @Override
    public boolean isProxiedConnection(Endpoint ep) {
        return false;
    }

    public boolean areForwarding() {
        return this.fwdTransport != null;
    }

    @Override
    public void copyTransportData(Node currentTarget, Node newTarget, Endpoint myEp) {
    }

    class Poller
    extends Thread {
        HttpEndpoint e;
        Node target;
        Node orig;
        byte[] empty = new byte[0];
        boolean pusher;

        public Poller(HttpEndpoint e, Node target, boolean pusher) {
            this.setName("HttpTransport$Poller");
            this.e = e;
            this.target = target;
            this.orig = target;
            this.pusher = pusher;
            this.setPriority(10);
            this.setDaemon(true);
            System.out.println("[HttpTransport] Poller created for " + target + " (" + e + ") (httpT=" + BasicHttpTransport.this.hashCode() + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int errors = 0;
            boolean wasted = false;
            while (!BasicHttpTransport.this.dead) {
                try {
                    if (VERBOSE) {
                        System.out.println("Poller about to make HTTP request");
                    }
                    if (this.pusher) {
                        ArrayList list = new ArrayList();
                        Object object = BasicHttpTransport.this.bout_LOCK;
                        synchronized (object) {
                            if (BasicHttpTransport.this.bouts.size() <= 0) {
                                Thread.sleep(20L);
                                continue;
                            }
                            list = BasicHttpTransport.this.bouts;
                            BasicHttpTransport.this.bouts = new ArrayList();
                            BasicHttpTransport.this.boutsize = 0;
                            BasicHttpTransport.this.bout_LOCK.notifyAll();
                        }
                        BasicHttpTransport.this.makeHttpRequest(BasicHttpTransport.this.mynode, this.e, list, this.target, false);
                    } else {
                        BasicHttpTransport.this.makeHttpRequest(BasicHttpTransport.this.mynode, this.e, new ArrayList(), this.target, true);
                    }
                    errors = 0;
                    if (!VERBOSE) continue;
                    System.out.println("Poller OK");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (VERBOSE) {
                        t.printStackTrace();
                    }
                    if (errors < 7) {
                        ++errors;
                    }
                    try {
                        if (VERBOSE) {
                            System.out.println("Poller sleeping for " + errors + "secs");
                        }
                        Thread.sleep(errors * 1000);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

