/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.fec;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.fec.ReedSolomon;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.SafeClock;

public class ParityReader {
    static int PARITY_CACHE_SIZE = 12;
    static boolean VERBOSE_PARITY_GROUPS_INCOMING = false;
    static boolean VERBOSE_PARITY = false;
    static boolean VERBOSE_PARITY_ON_RESTART = false;
    Cache paritys = new Cache("NodelinkParityGroups", PARITY_CACHE_SIZE);

    private Object getParityGroupKey(int pgid) {
        return new Integer(pgid);
    }

    private byte[] unpadShardToData(byte[] padded) {
        short contentLen = ByteArrayUtils.readShort(padded, 0);
        short datlen = ByteArrayUtils.readShort(padded, 2);
        byte[] tmp = new byte[datlen];
        System.arraycopy(padded, 4, tmp, 0, datlen);
        return tmp;
    }

    private int getUnpaddedLogicalLen(byte[] padded) {
        short datlen = ByteArrayUtils.readShort(padded, 0);
        return datlen;
    }

    public byte[] decodeShard(byte[] shard) {
        long groupStart = ByteArrayUtils.readLong(shard, 0);
        int dataCount = ByteArrayUtils.readUnsignedByte(shard, 8);
        int parityCount = ByteArrayUtils.readUnsignedByte(shard, 9);
        int pgid = ByteArrayUtils.readUnsignedByte(shard, 10);
        int shardIndex = ByteArrayUtils.readUnsignedByte(shard, 11);
        short datlen = ByteArrayUtils.readShort(shard, 12);
        Object pgkey = this.getParityGroupKey(pgid);
        ParityGroup pg = (ParityGroup)this.paritys.getFromCache(pgkey);
        if (pg == null) {
            pg = new ParityGroup();
            this.paritys.addToCache(pgkey, pg);
            if (VERBOSE_PARITY_GROUPS_INCOMING) {
                System.out.println("[NL Parity] New parity group " + pgkey + " starting at " + groupStart);
            }
            pg.pgid = pgkey;
            pg.groupStart = groupStart;
            pg.dataCount = dataCount;
            pg.parityCount = parityCount;
            pg.validDataCount = dataCount;
            pg.shards = new byte[dataCount + parityCount][];
        }
        if (VERBOSE_PARITY) {
            System.out.println("[ParityReader] DATLEN " + datlen);
        }
        if (datlen < 0) {
            short SHARDLEN = -datlen;
            if (VERBOSE_PARITY) {
                System.out.println("[ParityReader] MUST SKIP " + SHARDLEN + " from " + shardIndex + " to " + pg.dataCount);
            }
            for (int k = shardIndex; k < pg.dataCount; ++k) {
                pg.shards[k] = new byte[SHARDLEN];
            }
            pg.validDataCount = shardIndex;
            return null;
        }
        byte[] padded = new byte[datlen];
        System.arraycopy(shard, 14, padded, 0, datlen);
        pg.shards[shardIndex] = padded;
        if (shardIndex >= pg.dataCount) {
            return null;
        }
        return this.unpadShardToData(padded);
    }

    public byte[] recreate(long start) {
        return this.recreate(start, false);
    }

    public byte[] recreate(long start, boolean verbose) {
        boolean printState;
        boolean allTooOld = true;
        boolean bl = printState = VERBOSE_PARITY || verbose && VERBOSE_PARITY_ON_RESTART;
        if (printState) {
            System.out.println("[NL Parity] Request for packet at " + start);
        }
        Object[] objects = this.paritys.getAllCacheObjects();
        if (printState) {
            System.out.println("[NL Parity] " + objects.length + " total ParityGroups");
        }
        for (Object o : objects) {
            ParityGroup pg = (ParityGroup)o;
            if (pg.groupStart <= start) {
                allTooOld = false;
                if (pg.canRecreate()) {
                    byte[] attempt;
                    if (printState) {
                        System.out.println("[NL Parity] Checking ParityGroup " + pg.pgid + " / " + pg.groupStart + "+ (will search...)");
                    }
                    if (printState) {
                        System.out.println("[NL Parity] ParityGroup " + pg.pgid + " / " + pg.groupStart + " has enough shards, will search...");
                    }
                    if ((attempt = pg.getPacketAt(start)) == null) continue;
                    if (printState) {
                        System.out.println("[NL Parity] ParityGroup " + pg.pgid + " / " + pg.groupStart + "+ was able to recreate packet " + start);
                    }
                    return attempt;
                }
                if (printState) {
                    System.out.println("[NL Parity] Checking ParityGroup " + pg.pgid + " / " + pg.groupStart + "+ (does not have enough shards)");
                }
                if (!printState) continue;
                pg.dumpValidShards();
                continue;
            }
            if (!printState) continue;
            System.out.println("[NL Parity] Checking ParityGroup " + pg.pgid + " / " + pg.groupStart + "+ (too new)");
        }
        if (verbose && allTooOld) {
            System.out.println("***pg cache too short");
        }
        return null;
    }

    class ParityGroup {
        long created = SafeClock.currentTimeMillis();
        Object pgid;
        long groupStart;
        int dataCount;
        int parityCount;
        int validDataCount;
        int validShards;
        byte[][] shards;
        boolean recreated = false;

        ParityGroup() {
        }

        public void dumpValidShards() {
            boolean canRecreate = this.canRecreate();
            System.out.println("[NL Parity] ParityGroup " + this.pgid + " canRecreate=" + canRecreate + " validShards=" + this.validShards + " / " + (this.dataCount + this.parityCount));
            for (int i = 0; i < this.shards.length; ++i) {
                if (this.shards[i] != null) {
                    System.out.println("[NL Parity] -- ParityGroup " + this.pgid + " checking shard " + i + "=" + this.shards[i].length);
                    continue;
                }
                System.out.println("[NL Parity] -- ParityGroup " + this.pgid + " shard " + i + "=empty");
            }
        }

        public boolean canRecreate() {
            if (this.recreated) {
                return true;
            }
            int shardlen = 0;
            int valid = 0;
            for (int i = 0; i < this.shards.length; ++i) {
                if (this.shards[i] != null) {
                    shardlen = this.shards[i].length;
                    ++valid;
                    if (!VERBOSE_PARITY) continue;
                    System.out.println("[NL Parity] ParityGroup " + this.pgid + " checking shard " + i + "=" + this.shards[i].length);
                    continue;
                }
                if (!VERBOSE_PARITY) continue;
                System.out.println("[NL Parity] ParityGroup " + this.pgid + " shard " + i + "=empty");
            }
            this.validShards = valid;
            if (valid == this.shards.length) {
                this.recreated = true;
                return true;
            }
            if (valid >= this.dataCount) {
                ReedSolomon reedSolomon = ReedSolomon.create(this.dataCount, this.shards.length - this.dataCount);
                boolean[] shardsPresent = new boolean[this.shards.length];
                for (int i = 0; i < this.shards.length; ++i) {
                    if (this.shards[i] == null) {
                        this.shards[i] = new byte[shardlen];
                        shardsPresent[i] = false;
                        continue;
                    }
                    shardsPresent[i] = true;
                }
                reedSolomon.decodeMissing(this.shards, shardsPresent, 0, shardlen);
                this.recreated = true;
                return true;
            }
            return false;
        }

        public byte[] getPacketAt(long start) {
            long Twaited = SafeClock.currentTimeMillis() - this.created;
            long shardStart = this.groupStart;
            for (int i = 0; i < this.validDataCount; ++i) {
                if (VERBOSE_PARITY) {
                    System.out.println("[NL Parity] ParityGroup " + this.pgid + " index " + i + " is packet starting at " + shardStart + " (vs " + start + ")");
                }
                if (start == shardStart) {
                    if (VERBOSE_PARITY) {
                        System.out.println("[NL Parity] Packet FOUND in ParityGroup " + this.pgid + ", returning now");
                    }
                    if (NodeLink.VERBOSE_PG_MANAGEMENT) {
                        System.out.println("*** PG waited " + Twaited);
                    }
                    return ParityReader.this.unpadShardToData(this.shards[i]);
                }
                int len = ParityReader.this.getUnpaddedLogicalLen(this.shards[i]);
                shardStart += (long)len;
            }
            return null;
        }
    }
}

