/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.utils.IterableWeakReferenceListThread;

public class QuietListener
extends IterableWeakReferenceListThread<Node> {
    private static final int UDP_TIMEOUT = 9000;
    private static final int TCP_UDP_TIMEOUT = 15000;
    private static Object LOCK = new Object();
    private static QuietListener INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuietListener get() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new QuietListener();
            }
        }
        return INSTANCE;
    }

    private QuietListener() {
        super("QuietListener", 500, 120000);
    }

    public void registerNodeLink(NodeLink nodelink, Node node) {
        node.addNodeLinkListener(nodelink);
        this.addToList(node);
    }

    public void deregisterNodeLink(NodeLink nodelink, Node node) {
        node.removeNodeLinkListener(nodelink);
        this.removeFromList(node);
    }

    @Override
    protected void process(Node node) {
        long timeSinceLastPacket = node.getTimeSinceLastPacket();
        if (timeSinceLastPacket > 9000L) {
            boolean notifyUdpOnly;
            boolean bl = notifyUdpOnly = timeSinceLastPacket < 15000L;
            if (!node.didNotifyLinkDown()) {
                node.notifyNodeLinkListenerLinkDown(new Exception("No packets through for some time"), notifyUdpOnly);
            }
        } else if (node.didNotifyLinkDown()) {
            node.notifyNodeLinkListenerLinkOK();
        }
    }
}

