/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkFlowController;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.SafeClock;
import utils.switches.Switches;

public class NodeLinkBEFController2
implements NodeLinkFlowController {
    static int ADJUST_EVERY_MS = 1000;
    static final double DESIRED_UTILISATION = 0.75;
    static final double DECREASE_ADJUST_FACTOR = 0.3;
    static final double INCREASE_ADJUST_FACTOR = 0.7;
    static final double MAX_INCREASE_FACTOR = 1.7;
    double packetsPerT = 4.0;
    long msT = 40L;
    long TperSec = 1000L / this.msT;
    long nextT = 0L;
    int packetsInCurrentT = 0;
    int typicalPacketSizeB = 512;
    int burstForMs = 125;
    byte[] burstPacket = new byte[380];
    int burstFor = 0;
    Object LOCK = new Object();
    long lastRTTraw;
    double lastRTTsmooth;

    public boolean maySlowFlow() {
        return false;
    }

    public NodeLinkBEFController2(int msT) {
        this.msT = msT;
        ByteArrayUtils.writeShort(this.burstPacket, 0, (short)17478);
    }

    public NodeLinkBEFController2() {
        ByteArrayUtils.writeShort(this.burstPacket, 0, (short)17478);
    }

    @Override
    public byte[] nextRequiredPacket() {
        ByteArrayUtils.writeInt(this.burstPacket, 2, (int)((double)this.burstForMs * 0.8));
        if (this.burstFor > 0) {
            return this.burstPacket;
        }
        return null;
    }

    private boolean maySend() {
        long Tnow = SafeClock.currentTimeMillis();
        double windowPacketsPerT = this.packetsPerT;
        if (this.burstFor > 0) {
            windowPacketsPerT *= 2.0;
        }
        if (Tnow > this.nextT) {
            int burstT = (int)((long)this.burstForMs / this.msT);
            int normalT = (int)((long)(ADJUST_EVERY_MS - this.burstForMs) / this.msT);
            if ((double)this.packetsInCurrentT >= this.packetsPerT && this.burstFor <= -normalT) {
                this.burstFor = burstT;
                System.out.println("[NL BEF] Bursting now for " + burstT + " (" + (long)burstT * this.msT + ")");
            } else {
                --this.burstFor;
                if (this.burstFor == 0) {
                    System.out.println("[NL BEF] Burst done");
                }
            }
            this.nextT = Tnow + this.msT;
            this.packetsInCurrentT = 0;
        }
        return (double)this.packetsInCurrentT <= windowPacketsPerT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flowControl(int dataLength, boolean allowIncrease) {
        Object object = this.LOCK;
        synchronized (object) {
            while (!this.maySend()) {
                try {
                    Thread.sleep(2L);
                }
                catch (Exception exception) {}
            }
            ++this.packetsInCurrentT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readRateMeasured(long packetsPerSecond) {
        double kbps = packetsPerSecond;
        kbps *= (double)this.typicalPacketSizeB;
        System.out.println("[NL BEF] Send rate is " + packetsPerSecond + " packets/s, approx " + (int)(kbps /= 1024.0) + " k/s");
        Object object = this.LOCK;
        synchronized (object) {
            boolean increase;
            double maxMeasuredPerT = (double)packetsPerSecond / (double)this.TperSec;
            double desiredMeasuredPerT = maxMeasuredPerT * 0.75;
            boolean bl = increase = maxMeasuredPerT > this.packetsPerT;
            this.packetsPerT = increase ? (Switches.SH_1555_nlBefAdjustUp100 ? desiredMeasuredPerT : Math.min(this.packetsPerT * 1.7, this.packetsPerT * 0.30000000000000004 + desiredMeasuredPerT * 0.7)) : this.packetsPerT * 0.7 + desiredMeasuredPerT * 0.3;
            int maxPacketsPerT = this.kbPerSec_to_PacketsPerT(20000);
            if (this.packetsPerT < 1.0) {
                this.packetsPerT = 1.0;
            }
            if (this.packetsPerT > (double)maxPacketsPerT) {
                this.packetsPerT = maxPacketsPerT;
            }
            System.out.println("[NL BEF] New send rate is " + (int)((double)this.TperSec * this.packetsPerT) + " packets/s (max " + (int)((double)this.TperSec * maxMeasuredPerT) + "), approx " + (int)this.packetsPerT_to_KBperSec(this.packetsPerT) + " k/s (max " + (int)this.packetsPerT_to_KBperSec(maxMeasuredPerT) + " k/s)");
        }
    }

    double packetsPerT_to_KBperSec(double pPerT) {
        return pPerT * (double)this.TperSec * (double)this.typicalPacketSizeB / 1024.0;
    }

    int kbPerSec_to_PacketsPerT(int kbPerSec) {
        if (kbPerSec > 0) {
            int calculatedPacketsPerT = (int)((long)(kbPerSec * 1024 / this.typicalPacketSizeB) / this.TperSec);
            return calculatedPacketsPerT;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rttMeasured(long rtt) {
        Object object = this.LOCK;
        synchronized (object) {
            if (NodeLink.FIX_SYSTEM_CLOCK_CHANGES) {
                if (rtt < 0L) {
                    System.out.println("[NL BEF] System clock changed produced erroneous RTT, ignoring");
                    return 30000L;
                }
                if (rtt > 30000L) {
                    System.out.println("[NL BEF] System clock changed produced erroneous RTT, ignoring");
                    return 30000L;
                }
            }
            this.lastRTTraw = rtt;
            this.lastRTTsmooth = this.lastRTTsmooth * 0.9 + (double)this.lastRTTraw * 0.1;
            this.burstForMs = (int)this.bounded(Math.max(20L, this.msT), this.lastRTTsmooth / 5.0, 150.0);
            if (this.burstForMs % (int)this.msT > 0) {
                this.burstForMs = this.burstForMs - this.burstForMs % (int)this.msT + (int)this.msT;
            }
            if (Switches.SH_1555_nlBefLongerAdjustPeriods) {
                ADJUST_EVERY_MS = 2500;
            }
        }
        return (long)this.lastRTTsmooth;
    }

    private double bounded(double min, double val, double max) {
        return Math.max(min, Math.min(max, val));
    }

    @Override
    public int getMaxDataPerWrite() {
        return 999999;
    }

    public void setFlexibleFlowRate() {
    }

    @Override
    public void setInitialRateKbPerSec(int kbPerSec) {
        int calculatedPacketsPerT;
        if (kbPerSec > 0 && (double)(calculatedPacketsPerT = this.kbPerSec_to_PacketsPerT(kbPerSec)) > this.packetsPerT) {
            this.packetsPerT = calculatedPacketsPerT;
        }
    }

    public void resetRateKbPerSec(int kbPerSec) {
        if (kbPerSec > 0) {
            int calculatedPacketsPerT = this.kbPerSec_to_PacketsPerT(kbPerSec);
            this.packetsPerT = calculatedPacketsPerT;
        }
    }

    @Override
    public double getRateKbPerSec() {
        return this.packetsPerT_to_KBperSec(this.packetsPerT);
    }

    public void setLowLatencyRequired(boolean b) {
    }

    public void setFixedFlowRate(double kbps) {
    }

    @Override
    public void packetLossDetected(long start, long probableHoleSize) {
    }

    @Override
    public void packetLossDuringResendDetected(long start, long probableHoleSize) {
    }

    @Override
    public void writeWasRestricted() {
    }

    @Override
    public void packetSent(long time) {
    }

    @Override
    public void ackReceived(long time) {
    }
}

