/*
 * Decompiled with CFR 0.152.
 */
package com.aem.gstore;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.gstore.DataBlock;
import com.aem.gstore.GenCollator;
import com.aem.gstore.GenStore;
import com.aem.gstore.StoreProcessor;
import java.util.ArrayList;
import java.util.Date;
import utils.message.Message;
import utils.message.MessageUtils;

public class StorePacket {
    long uid = Math.abs(BCUtil.getSecureRandom().nextLong());
    long sent = System.currentTimeMillis();
    long packetIndex;
    byte[] data;

    public StorePacket(byte[] allData) {
        this.data = allData;
        if (CentralDebugging.PX_GENSTORE_UPLOAD) {
            System.out.println("[GenStore] StorePacket created " + allData.length);
        }
    }

    public StorePacket(Message m) {
        this(MessageUtils.messageToBytes(m));
    }

    public static void main(String[] args) {
        Message m = new Message();
        for (int i = 0; i < 500; ++i) {
            m.append(i);
        }
        StorePacket sp = new StorePacket(m);
        ArrayList<DataBlock> dbs = sp.split(50L);
        GenCollator gc = new GenCollator(new TestProcessor(), null);
        for (DataBlock db : dbs) {
            gc.receivedBlock(db);
        }
    }

    void setPacketUID(long uid) {
        this.uid = uid;
    }

    void setPacketIndex(long index) {
        this.packetIndex = index;
    }

    public String toString() {
        return "Packet-P" + this.uid + " @" + this.packetIndex + " +" + this.data.length + " (" + new Date(this.sent) + ")";
    }

    public long getUID() {
        return this.uid;
    }

    public byte[] getData() {
        return this.data;
    }

    public long size() {
        return this.data.length;
    }

    ArrayList<DataBlock> split(long maxPacketSize) {
        DataBlock db;
        ArrayList<DataBlock> list = new ArrayList<DataBlock>();
        for (long pos = 0L; pos < (long)this.data.length; pos += (long)db.getLength()) {
            byte[] blockdat = new byte[(int)Math.min(maxPacketSize, (long)this.data.length - pos)];
            db = new DataBlock(this.uid, this.packetIndex, pos, blockdat);
            System.arraycopy(this.data, (int)pos, blockdat, 0, blockdat.length);
            if (GenStore.DEBUG_GENSTORE_UPDATES) {
                System.out.println("[GenStore] " + db);
            }
            list.add(db);
        }
        if (list.size() > 0) {
            list.get((int)(list.size() - 1)).lastBlock = true;
        }
        return list;
    }

    static class TestProcessor
    implements StoreProcessor {
        TestProcessor() {
        }

        @Override
        public void processStorePacket(StorePacket packet, GenCollator collator, Object userObject) {
            Message m = MessageUtils.bytesToMessage(packet.getData());
            System.out.println(m.toPretty(null));
        }
    }
}

