/*
 * Decompiled with CFR 0.152.
 */
package com.aem.admin;

import com.aem.TestResourceBundle;
import com.aem.nodelink.Node;
import com.aem.nodelink.attempt.NodelinkAttempt;
import com.aem.nodelink.http.HttpEndpoint;
import com.aem.nodelink.tcp.TcpEndpoint;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jwrapper.failover.FailoverMonitor;
import jwrapper.jwutils.network.JWSockets;
import jwrapper.jwutils.network.JWSocketsListener;
import jwrapper.updater.JWLaunchProperties;
import org.w3c.dom.Element;
import utils.files.FileUtil;
import utils.osstats.LinuxStats;
import utils.osstats.MacOSStats;
import utils.osstats.Stats;
import utils.osstats.WindowsStats;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.FetchURL;
import utils.progtools.SocketCloseTimeoutMap;
import utils.progtools.StackDumper;
import utils.progtools.clock.TimingClock;
import utils.progtools.net.URLParser;
import utils.stream.SSLHelper;
import utils.stream.StreamUtils;
import utils.xml.XML14Util;

public class Admin {
    static boolean ARTIFICIAL_FAST_CHECKS = false;
    static File serverConfigFile;
    static Object checks_LOCK;
    static ArrayList<ServerCheck> checks;

    public static void main(String[] args) throws Exception {
        OS.detect(true);
        System.out.println("");
        System.out.println("Welcome to the " + OemBranding.OEM_APPLICATION_NAME + " Administration Script");
        System.out.println("");
        boolean noServerDir = false;
        try {
            serverConfigFile = Admin.getServerConfigFile();
        }
        catch (NullPointerException ex) {
            noServerDir = true;
        }
        catch (FileNotFoundException ex) {
            noServerDir = true;
        }
        if (noServerDir) {
            System.out.println("WARNING: Unable to locate server configuration file. Unless you are performing server connectivity checks please run this ");
            System.out.println("         script from the 'admin' folder of your " + OemBranding.OEM_APPLICATION_NAME + " installation.");
            System.out.println("");
        }
        if (args.length > 0) {
            System.out.println("Admin script command line usage:");
            System.out.println("<Admin> <once|ongoing> <server URL> [auth=y|n] [conn=y|n] [user=...] [pass=...] [wait=seconds]");
            boolean once = false;
            if (args[0].equalsIgnoreCase("once")) {
                once = true;
            } else if (args[0].equalsIgnoreCase("ongoing")) {
                once = false;
            } else {
                System.exit(0);
            }
            URLParser urlp = new URLParser(args[1]);
            String host = urlp.getHostname();
            int port = urlp.getPort(true);
            boolean https = urlp.getProtocol(true).equalsIgnoreCase("https");
            boolean nl = false;
            boolean verify = false;
            String user = "";
            String pass = "";
            long waitms = 60000L;
            System.out.println("Host: " + host);
            System.out.println("Port: " + port);
            System.out.println("HTTPS: " + https);
            for (int i = 2; i < args.length; ++i) {
                String arg = args[i];
                if (arg.toLowerCase().startsWith("conn=") && arg.toLowerCase().substring(5).startsWith("y")) {
                    nl = true;
                }
                if (arg.toLowerCase().startsWith("auth=") && arg.toLowerCase().substring(5).startsWith("y")) {
                    verify = true;
                }
                if (arg.toLowerCase().startsWith("user=")) {
                    user = arg.substring(5);
                }
                if (arg.toLowerCase().startsWith("pass=")) {
                    pass = arg.substring(5);
                }
                if (!arg.toLowerCase().startsWith("wait=")) continue;
                waitms = Long.parseLong(arg.substring(5)) * 1000L;
            }
            System.out.println("Verify: " + verify);
            System.out.println("Connections: " + nl);
            System.out.println("Login: " + (user.length() > 0) + " / " + (pass.length() > 0));
            System.out.println("Wait (seconds): " + waitms / 1000L);
            if (!verify) {
                SSLHelper.setupSslAndHttpsToAcceptAllCerts(true);
            }
            JWLaunchProperties.setUpTestProperties();
            if (once) {
                Admin.doServerChecks(false, verify, host, port, nl, user.length() > 0, user, pass, https, -1L);
            } else {
                Admin.doServerChecks(true, verify, host, port, nl, user.length() > 0, user, pass, https, waitms);
            }
            System.exit(0);
        }
        System.out.println("Please select the action you wish to perform:");
        if (!noServerDir) {
            System.out.println();
            System.out.println("1) Reset " + OemBranding.OEM_ADMIN_USERNAME + " password");
            System.out.println("2) Disable " + OemBranding.OEM_ADMIN_USERNAME + " multi-factor authentication");
            System.out.println();
            System.out.println("3) Configure " + OemBranding.OEM_APPLICATION_NAME + " to bind to first available port");
            System.out.println("4) Check server configuration");
        }
        System.out.println();
        System.out.println("5) Perform a server connection check");
        System.out.println("6) Perform continuous server connection checks and save to file");
        System.out.println();
        System.out.println("0) Exit");
        System.out.println("\n");
        Scanner s = new Scanner(System.in);
        String choice = "";
        while (!choice.equals("0")) {
            System.out.print("Please enter your choice: ");
            choice = s.nextLine().trim();
            try {
                int choiceInt = Integer.parseInt(choice);
                switch (choiceInt) {
                    case 1: {
                        Admin.option1_resetPassword();
                        break;
                    }
                    case 2: {
                        Admin.option2_disableMFA();
                        break;
                    }
                    case 3: {
                        Admin.option3_allowAutoPort();
                        break;
                    }
                    case 4: {
                        Admin.option4_checkServerConfig();
                        break;
                    }
                    case 5: {
                        Admin.option5_checkServerConnection();
                        System.exit(0);
                        break;
                    }
                    case 6: {
                        Admin.option6_checkServerConnectionOngoing();
                        System.exit(0);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static File lookUpConfigurationFolder(File start) {
        if (start == null || !start.exists()) {
            return null;
        }
        File test = new File(start, "configuration");
        if (test.exists()) {
            return test;
        }
        return Admin.lookUpConfigurationFolder(start.getParentFile());
    }

    public static File getServerConfigFile() throws FileNotFoundException {
        File configuration = Admin.lookUpConfigurationFolder(new File(".").getAbsoluteFile());
        if (configuration == null || !configuration.exists()) {
            String[] paths;
            String classPath = System.getProperty("java.class.path");
            for (String path : paths = classPath.split("\\" + File.pathSeparatorChar)) {
                File possibleConfig;
                File configxml;
                File jar = new File(path);
                if (!jar.exists() || !(configxml = new File(possibleConfig = new File(jar.getParentFile().getParentFile(), "configuration"), "serverconfig.xml")).exists()) continue;
                return configxml;
            }
        }
        if (!configuration.exists()) {
            throw new FileNotFoundException();
        }
        return new File(configuration, "serverconfig.xml");
    }

    public static Element readConfiguration() throws Exception {
        try {
            return XML14Util.parseXML(FileUtil.readFileAsStringUTF8(serverConfigFile));
        }
        catch (Throwable t) {
            System.out.println("ERROR : Unable to read configuration file '" + serverConfigFile + "'.");
            System.out.println("REASON: " + t.getMessage());
            Admin.blockAndExit();
            return null;
        }
    }

    private static void blockAndExit() throws IOException {
        System.out.println("\n\nPress any key to exit.");
        System.in.read();
        System.exit(1);
    }

    public static void saveConfiguration(Element root) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(root.getOwnerDocument());
        StreamResult result = new StreamResult(new StringWriter());
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        String xmlString = result.getWriter().toString();
        try {
            FileUtil.writeFile(serverConfigFile, xmlString.getBytes("UTF8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void deleteChild(Element parent, String childName) {
        Element child = XML14Util.getChildByName(parent, childName);
        while (child != null) {
            parent.removeChild(child);
            child = XML14Util.getChildByName(parent, childName);
        }
    }

    public static void option1_resetPassword() throws Exception {
        Element root = Admin.readConfiguration();
        if (root != null) {
            Admin.deleteChild(root, "Password");
            Admin.deleteChild(root, "SecurePassword");
            Admin.deleteChild(root, "SecurePasswordv2");
            Element password = root.getOwnerDocument().createElement("Password");
            password.appendChild(root.getOwnerDocument().createTextNode("password"));
            root.appendChild(password);
            Admin.saveConfiguration(root);
            System.out.println("\nSuccess! " + OemBranding.OEM_ADMIN_USERNAME + " password reset complete.");
            Admin.blockAndExit();
        }
    }

    public static void option2_disableMFA() throws Exception {
        Element root = Admin.readConfiguration();
        if (root != null) {
            Admin.deleteChild(root, "AdminAppAuthentication");
            Admin.deleteChild(root, "AdminTwoTier");
            Admin.saveConfiguration(root);
            System.out.println("\nSuccess! " + OemBranding.OEM_ADMIN_USERNAME + " MFA is now disabled.");
            Admin.blockAndExit();
        }
    }

    public static void option3_allowAutoPort() throws Exception {
        Element root = Admin.readConfiguration();
        if (root != null) {
            Admin.deleteChild(root, "IP");
            Admin.deleteChild(root, "IpPort");
            Admin.deleteChild(root, "Port");
            Element port = root.getOwnerDocument().createElement("Port");
            port.appendChild(root.getOwnerDocument().createTextNode("Auto"));
            root.appendChild(port);
            Admin.saveConfiguration(root);
            System.out.println("\nSuccess! " + OemBranding.OEM_APPLICATION_NAME + " will now claim any available port when next launched.");
            Admin.blockAndExit();
        }
    }

    private static String downloadFrom(String ip, String port) throws Exception {
        URL url = new URL("https://" + ip + ":" + port + "/version");
        URLConnection openConnection = url.openConnection();
        openConnection.setUseCaches(false);
        openConnection.setConnectTimeout(5000);
        openConnection.connect();
        String result = StreamUtils.readAllAsStringUTF8(openConnection.getInputStream());
        if (openConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)openConnection).disconnect();
        }
        return result;
    }

    private static String isSimpleHelpRunning(ArrayList<String> ports, ArrayList<String> ipPorts) {
        System.out.print("Checking if SimpleHelp is running... ");
        for (String port : ports) {
            if (port.equalsIgnoreCase("Auto")) continue;
            try {
                String version = Admin.downloadFrom("127.0.0.1", port);
                if (!version.startsWith("SSuite-")) continue;
                return version;
            }
            catch (Throwable version) {
            }
        }
        for (String ipPort : ipPorts) {
            try {
                String[] parts = ipPort.split("\\:");
                String version = Admin.downloadFrom(parts[0], parts[1]);
                if (!version.startsWith("SSuite-")) continue;
                return version;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static void option5_checkServerConnection() throws Exception {
        String host = "localhost";
        System.out.println("Enter the hostname or hit enter to check the local server: ");
        String input = StreamUtils.readLineAsStringUTF8(System.in).trim();
        if (input.length() > 0) {
            host = input;
        }
        System.out.println("Please enter the server port to connect on: ");
        int port = Integer.parseInt(StreamUtils.readLineAsStringUTF8(System.in).trim());
        System.out.println("Perform full connection checks? (y/n): ");
        boolean nl = false;
        try {
            nl = StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.out.println("Perform login checks? (y/n): ");
        boolean logins = false;
        try {
            logins = StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String user = "";
        String pass = "";
        if (logins) {
            System.out.println("Enter the login user (note this user must not have multi factor auth): ");
            user = OemBranding.OEM_ADMIN_USERNAME;
            input = StreamUtils.readLineAsStringUTF8(System.in).trim();
            if (input.length() > 0) {
                user = input;
            }
            System.out.println("Enter the login password: ");
            pass = "";
            try {
                pass = new String(System.console().readPassword());
            }
            catch (NullPointerException x) {
                pass = StreamUtils.readLineAsStringUTF8(System.in).trim();
            }
        }
        System.out.println("Use HTTPS? (y/n): ");
        boolean https = false;
        try {
            https = StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.out.println("Allow invalid HTTPS? (y/n): ");
        boolean verify = true;
        try {
            if (StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y")) {
                verify = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.out.println("Checking " + host + " on port " + port);
        JWLaunchProperties.setUpTestProperties();
        Admin.doServerChecks(false, verify, host, port, nl, logins, user, pass, https, -1L);
    }

    public static void option6_checkServerConnectionOngoing() throws Exception {
        String host = "localhost";
        System.out.println("Enter the hostname or hit enter to check the local server: ");
        String input = StreamUtils.readLineAsStringUTF8(System.in).trim();
        if (input.length() > 0) {
            host = input;
        }
        System.out.println("Please enter the server port to connect on: ");
        int port = Integer.parseInt(StreamUtils.readLineAsStringUTF8(System.in).trim());
        System.out.println("Perform full connection checks? (y/n): ");
        boolean nl = false;
        try {
            nl = StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.out.println("Perform login checks? (y/n): ");
        boolean logins = false;
        try {
            logins = StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String user = "";
        String pass = "";
        if (logins) {
            System.out.println("Enter the login user (note this user must not have multi factor auth): ");
            user = OemBranding.OEM_ADMIN_USERNAME;
            input = StreamUtils.readLineAsStringUTF8(System.in).trim();
            if (input.length() > 0) {
                user = input;
            }
            System.out.println("Enter the login password: ");
            pass = "";
            try {
                pass = new String(System.console().readPassword());
            }
            catch (NullPointerException x) {
                pass = StreamUtils.readLineAsStringUTF8(System.in).trim();
            }
        }
        System.out.println("Use HTTPS? (y/n): ");
        boolean https = false;
        try {
            https = StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.out.println("Allow invalid HTTPS? (y/n): ");
        boolean verify = true;
        try {
            if (StreamUtils.readLineAsStringUTF8(System.in).trim().startsWith("y")) {
                verify = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.out.println("Checking " + host + " on port " + port);
        Admin.doServerChecks(true, verify, host, port, nl, logins, user, pass, https, ARTIFICIAL_FAST_CHECKS ? 2000L : 60000L);
    }

    private static void doServerChecks(boolean ongoing, boolean verifySSL, String host, int port, boolean nl, boolean logins, String user, String pass, boolean https, long waitms) throws Exception {
        if (ongoing) {
            try {
                JWSockets sockets = JWSockets.interceptSockets();
                sockets.addListener(new SocketsTerminator());
                System.out.println("Intercepting sockets now");
            }
            catch (Exception x) {
                System.out.println("***WARNING*** UNABLE TO INTERCEPT SOCKETS TO FORCE CLOSURE");
                x.printStackTrace();
            }
        }
        FailoverMonitor.DEBUG_DISABLE = true;
        if (!verifySSL) {
            SSLHelper.setupSslAndHttpsToAcceptAllCerts(true);
        }
        JWLaunchProperties.setUpTestProperties();
        if (ongoing) {
            File maindir = new File(".");
            try {
                maindir = serverConfigFile.getParentFile().getParentFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            File output = new File(maindir, "ServerConnectivity-" + System.currentTimeMillis() + ".log");
            PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(output)));
            System.out.println("Writing checks to " + output.getAbsoluteFile().getCanonicalPath());
            pout.println("Main dir:      " + maindir.getCanonicalFile().getAbsolutePath());
            pout.println("Server config: " + serverConfigFile);
            pout.println("Host:          " + host);
            pout.println("Port:          " + port);
            pout.println("Https:         " + https + " (" + (verifySSL ? "verified" : "unverified") + ")");
            pout.println("Check NL:      " + nl);
            pout.println("Check login:   " + logins);
            pout.println("Wait millis:   " + waitms);
            File adminlog = new File(maindir, "ServerAdmin-" + System.currentTimeMillis() + ".log");
            PrintStream aout = new PrintStream(new BufferedOutputStream(new FileOutputStream(adminlog)));
            System.out.println("Redirecting all further output to " + adminlog.getAbsoluteFile().getCanonicalPath());
            System.setOut(aout);
            System.setErr(aout);
            System.out.println("Server config is " + serverConfigFile);
            System.out.println("Maindir is " + maindir);
            try {
                System.out.println("Current dir is " + new File(".").getAbsoluteFile().getCanonicalPath());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            while (true) {
                if (!Admin.checkServerConnection(host, port, user, pass, nl, https, pout)) {
                    File debug = new File(maindir.getCanonicalFile(), "debug.txt");
                    if (debug.exists()) {
                        System.out.println("Modifying debug.txt at " + debug.getAbsolutePath());
                        debug.setLastModified(System.currentTimeMillis());
                    } else {
                        System.out.println("Writing debug.txt to " + debug.getAbsolutePath());
                        try {
                            FileUtil.writeFileAsString(debug, "STACKDUMP=yes\n");
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    File onfail = new File(maindir.getCanonicalFile(), "connectfail.sh");
                    if (onfail.exists()) {
                        try {
                            System.out.println("Running connect fail script " + onfail.getAbsolutePath());
                            RunCommandGetOutput.runCommandGetOutput(new String[]{"bash", onfail.getAbsoluteFile().getCanonicalPath()});
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                }
                pout.flush();
                aout.flush();
                Thread.sleep(waitms);
            }
        }
        Admin.checkServerConnection(host, port, user, pass, nl, https, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkServerConnection(String host, int port, String user, String pass, boolean nl, boolean https, PrintStream pout) {
        ServerCheck check = null;
        Object object = checks_LOCK;
        synchronized (object) {
            for (int i = 0; i < checks.size(); ++i) {
                ServerCheck broken = checks.get(i);
                if (!broken.isAlive()) {
                    checks.remove(i--);
                    continue;
                }
                try {
                    broken.interrupt();
                    continue;
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
            }
            if (checks.size() >= 10) {
                System.out.println("***WARNING*** Too many queued checks (" + checks.size() + "), not attempting this check");
            } else {
                check = new ServerCheck(host, port, user, pass, nl, https, pout);
                checks.add(check);
            }
            System.out.println(checks.size() + " checks queued");
        }
        if (check != null) {
            check.start();
            long T = System.currentTimeMillis();
            try {
                check.join(ARTIFICIAL_FAST_CHECKS ? 2000L : 60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            T = System.currentTimeMillis() - T;
            if (!check.success && T >= 60000L) {
                String message = check.getMessage();
                pout.println(message + " (Check timed out)");
                System.out.println(message + " (Check timed out)");
                StackDumper.dumpCondensedCompleteThreadStacks();
            }
            return check.success;
        }
        return false;
    }

    public static void option4_checkServerConfig() throws Exception {
        Element root = Admin.readConfiguration();
        if (root != null) {
            Object text;
            ArrayList<String> ports = new ArrayList<String>();
            boolean autoPort = false;
            ArrayList<String> ipPorts = new ArrayList<String>();
            Stats.LocalPort[] allListeningApplications = OS.isWindows() ? WindowsStats.getListeningApplications() : (OS.isMacOS() ? MacOSStats.getListeningApplications() : LinuxStats.getListeningApplications());
            boolean portsAreAProblem = false;
            for (Element child : XML14Util.getChildrenByName(root, "Port")) {
                text = XML14Util.getTextContent(child);
                if (text == null || ((String)(text = ((String)text).trim())).length() <= 0) continue;
                ports.add((String)text);
                if (!((String)text).equalsIgnoreCase("Auto")) continue;
                autoPort = true;
            }
            for (Element child : XML14Util.getChildrenByName(root, "IpPort")) {
                text = XML14Util.getTextContent(child);
                if (text == null || ((String)(text = ((String)text).trim())).length() <= 0) continue;
                ipPorts.add((String)text);
            }
            System.out.println("\n");
            String version = Admin.isSimpleHelpRunning(ports, ipPorts);
            if (version != null) {
                System.out.println("Server is running with version " + version + ".\n\nChecking public availability...");
                boolean portFailed = false;
                for (String port : ports) {
                    if (Admin.checkPublicAccessibility(port)) {
                        System.out.println("\tPort " + port + ": Available");
                        continue;
                    }
                    System.out.println("\tPort " + port + ": ERROR. Not publicly accessible.");
                    portFailed = true;
                }
                for (String ipPort : ipPorts) {
                    String ip = ipPort.substring(0, ipPort.indexOf(58));
                    String port = ipPort.substring(ipPort.indexOf(58) + 1);
                    if (Admin.checkPublicAccessibility(port)) {
                        System.out.println("\tPort " + port + ": Available");
                        continue;
                    }
                    System.out.println("\tPort " + port + ": ERROR. Not publicly accessible.");
                    portFailed = true;
                }
                if (portFailed) {
                    System.out.println("\n");
                    System.out.println("Public accessibility check FAILED. It appears that your server is not publicly accessible");
                    System.out.println("on your server's public IP address. Check the following:");
                    System.out.println("\t1) Any routers or NAT devices are configured to forward the above ports to your " + OemBranding.OEM_APPLICATION_NAME);
                    System.out.println("\t   server's internal LAN address, for both TCP and UDP traffic.");
                    System.out.println("\t2) Check that the firewall on this server is not blocking incoming connections on the above ports");
                    System.out.println("\t   for both TCP and UDP traffic.");
                }
            } else {
                System.out.print("Server is NOT running.\n\nChecking port configuration... ");
                if (autoPort) {
                    System.out.println(OemBranding.OEM_APPLICATION_NAME + " has been asked to listen to any available port on startup.");
                } else if (ports.size() > 0) {
                    System.out.println(OemBranding.OEM_APPLICATION_NAME + " has been asked to listen on the following ports:");
                    for (String requestedPortString : ports) {
                        int requestedPort = Integer.parseInt(requestedPortString);
                        boolean portInUse = false;
                        for (Stats.LocalPort port : allListeningApplications) {
                            if (requestedPort != port.port) continue;
                            portInUse = true;
                            System.out.println("\tPort " + requestedPortString + ": In Use! This port is already used by application with process ID " + port.pid);
                            portsAreAProblem = true;
                        }
                        if (portInUse) continue;
                        System.out.println("\tPort " + requestedPortString + ": Available");
                    }
                }
                if (ipPorts.size() > 0) {
                    System.out.println("\n");
                    System.out.println(OemBranding.OEM_APPLICATION_NAME + " has been asked to listen on the following IP:port combinations:");
                    for (String requestedIpPortString : ipPorts) {
                        int colon = requestedIpPortString.indexOf(58);
                        String ip = requestedIpPortString.substring(0, colon);
                        int port = Integer.parseInt(requestedIpPortString.substring(colon + 1));
                        boolean available = true;
                        for (Stats.LocalPort localPort : allListeningApplications) {
                            if (port != localPort.port || !localPort.ip.equalsIgnoreCase("*")) continue;
                            System.out.println("\t" + ip + ":" + port + "  : In Use! This IP and port is already used by application with process ID " + localPort.pid);
                            portsAreAProblem = true;
                            available = false;
                            break;
                        }
                        if (!available) continue;
                        System.out.println("\t" + ip + ":" + port + "  Available");
                    }
                }
                if (portsAreAProblem) {
                    System.out.println("\n");
                    System.out.println("Configuration check FAILED. To correct this take one of these two steps:");
                    System.out.println("\t1) If you wish " + OemBranding.OEM_APPLICATION_NAME + " to use the ports that are in use, ");
                    System.out.println("\t   reconfigure the applications that are currently using the ports.");
                    System.out.println("\t2) Rerun this administration script, and use option (3) to");
                    System.out.println("\t   reconfigure " + OemBranding.OEM_APPLICATION_NAME + " to use any available port.");
                }
            }
            Admin.blockAndExit();
        }
    }

    private static boolean checkPublicAccessibility(String port) {
        try {
            URL acurl = new URL("https://www.simple-help.com/ispublicaccessible?port=" + port);
            URLConnection acurlc = acurl.openConnection();
            acurlc.setUseCaches(false);
            InputStream acin = acurlc.getInputStream();
            String result = StreamUtils.readAllAsStringUTF8(acin).toLowerCase().trim();
            acin.close();
            return result.contains("accessed ok");
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        checks_LOCK = new Object();
        checks = new ArrayList();
    }

    static class CheckTechClientListener
    implements TechClientListener {
        CheckTechClientListener() {
        }

        @Override
        public long requestAppAuthenticationSetup(String totpKey, String totpUsername, String hostname, int length) {
            return 0L;
        }

        @Override
        public void closeAppAuthenticationSetup() {
        }

        @Override
        public void configChanged() {
        }

        @Override
        public void waitingForRemoteUserToAccept() {
        }

        @Override
        public void sgUpdatingDuringConnect() {
        }

        @Override
        public void customerListChanged() {
        }

        @Override
        public void customerLiveListChanged() {
        }

        @Override
        public void demoListChanged() {
        }

        @Override
        public void setWarningMessage(String text) {
        }

        @Override
        public void updateSessionCounts(boolean isJoinedSessionCounts, boolean isEvaluation, boolean isPlan2, int totalSessions, int maxSHSessions, int maxSGSessions, int alertedMachines, int alertLimit, int regMachines, int machineLimit) {
        }

        @Override
        public TechClientListener.TwoTierResponse requestTwoTierCode(boolean showIncorrectWarning, String techEmailAddress, boolean allowRemember) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
            return null;
        }

        @Override
        public TechClientListener.TwoTierResponse processAuthenticationChallenge(boolean showIncorrectWarning, String replyMessage) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
            return null;
        }

        @Override
        public void machineAdded(Machine machine) {
        }

        @Override
        public void machineRemoved(Machine machine) {
        }

        @Override
        public void machinesAdded(Machine[] machine) {
        }

        @Override
        public void machinesRemoved(Machine[] machine) {
        }

        @Override
        public void machineOnline(Machine machine) {
        }

        @Override
        public void machineOffline(Machine machine) {
        }

        @Override
        public void machineDataChanged(Machine machine) {
        }

        @Override
        public void machineFilterableInfoChanged(Machine machine) {
        }

        @Override
        public void sessionAdded(AccessSession session) {
        }

        @Override
        public void sessionRemoved(AccessSession session) {
        }

        @Override
        public void licenseChanged() {
        }

        @Override
        public void peersChanged() {
        }

        @Override
        public void alertAdded(ResourceContainer alert) {
        }

        @Override
        public void alertRemoved(ResourceContainer alert) {
        }

        @Override
        public void alertChanged(ResourceContainer alert) {
        }

        @Override
        public void newNotificationReceived(Notification newNotification) {
        }
    }

    private static class ServerCheck
    extends Thread {
        String host;
        int port;
        String user;
        String pass;
        boolean nl;
        boolean https;
        PrintStream pout;
        String date;
        boolean success = false;
        long allversions = -1L;
        long random = -1L;
        long welcome = -1L;
        long tcp = -1L;
        long fdhttp = -1L;
        long tclient = -1L;

        public ServerCheck(String host, int port, String user, String pass, boolean nl, boolean https, PrintStream pout) {
            super("ServerCheck");
            this.host = host;
            this.port = port;
            this.user = user;
            this.pass = pass;
            this.nl = nl;
            this.https = https;
            this.pout = pout;
            this.date = new Date() + "";
        }

        @Override
        public void run() {
            block29: {
                block28: {
                    NodelinkAttempt nla;
                    Node tmpme;
                    Node them;
                    String protocol;
                    block27: {
                        block26: {
                            URL url;
                            block25: {
                                block24: {
                                    protocol = "http";
                                    if (this.https) {
                                        protocol = "https";
                                    }
                                    if (!this.nl) {
                                        this.tcp = 0L;
                                        this.fdhttp = 0L;
                                    }
                                    if (this.user.length() == 0) {
                                        this.tclient = 0L;
                                    }
                                    try {
                                        url = new URL(protocol + "://" + this.host + ":" + this.port + "/allversions");
                                        this.allversions = FetchURL.fetchAndTimeMs(url);
                                    }
                                    catch (Exception x) {
                                        x.printStackTrace();
                                        if (this.pout == null) break block24;
                                        this.pout.println("AllVersions check failed: " + x);
                                    }
                                }
                                try {
                                    url = new URL(protocol + "://" + this.host + ":" + this.port + "/pseudorandomdata");
                                    this.random = FetchURL.fetchAndTimeMs(url);
                                }
                                catch (Exception x) {
                                    x.printStackTrace();
                                    if (this.pout == null) break block25;
                                    this.pout.println("PRand check failed: " + x);
                                }
                            }
                            try {
                                url = new URL(protocol + "://" + this.host + ":" + this.port + "/welcome");
                                this.welcome = FetchURL.fetchAndTimeMs(url);
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                                if (this.pout == null) break block26;
                                this.pout.println("Welcome check failed: " + x);
                            }
                        }
                        if (!this.nl) {
                            this.tcp = 0L;
                        } else {
                            try {
                                long T = TimingClock.currentTimeMillis();
                                them = new Node();
                                tmpme = new Node();
                                tmpme.setSingleUse(true);
                                tmpme.setRemoteNodeAddress(them, new TcpEndpoint(this.host, this.port));
                                nla = new NodelinkAttempt("Direct TCP connection (" + this.host + ":" + this.port + ")", tmpme, them, 2, null, 0L);
                                nla.attemptNow();
                                nla.getNodeLink().stopImmediate("successful connection completed");
                                if (nla.wasSuccessful()) {
                                    this.tcp = TimingClock.currentTimeMillis() - T;
                                }
                            }
                            catch (Throwable x) {
                                x.printStackTrace();
                                if (this.pout == null) break block27;
                                this.pout.println("NL/TCP check failed: " + x);
                            }
                        }
                    }
                    if (!this.nl) {
                        this.fdhttp = 0L;
                    } else {
                        try {
                            long T = TimingClock.currentTimeMillis();
                            them = new Node();
                            tmpme = new Node();
                            tmpme.setSingleUse(true);
                            tmpme.setRemoteNodeAddress(them, new HttpEndpoint(new URL(protocol + "://" + this.host + ":" + this.port + "/data")));
                            nla = new NodelinkAttempt("FDHTTP (" + protocol + ") connection (" + this.host + ":" + this.port + ")", tmpme, them, 0, null, 0L);
                            nla.attemptNow();
                            nla.getNodeLink().stopImmediate("successful connection completed");
                            if (nla.wasSuccessful()) {
                                this.fdhttp = TimingClock.currentTimeMillis() - T;
                            }
                        }
                        catch (Throwable x) {
                            x.printStackTrace();
                            if (this.pout == null) break block28;
                            this.pout.println("NL/FDHTTP check failed: " + x);
                        }
                    }
                }
                if (this.user.length() == 0) {
                    this.tclient = 0L;
                } else {
                    try {
                        long T = TimingClock.currentTimeMillis();
                        TechCredentials creds = new TechCredentials();
                        creds.setUsername(OemBranding.OEM_ADMIN_USERNAME);
                        creds.setPassword(this.pass);
                        TechClient.USE_FAKE_MAGIC = true;
                        TechClient client = new TechClient("en", (ResourceBundle)new TestResourceBundle(), this.host, this.port, creds, false, new CheckTechClientListener());
                        Machine[] machines = client.getEntireMachineList_Expensive();
                        System.out.println("Fetched " + machines.length + " machines");
                        this.tclient = TimingClock.currentTimeMillis() - T;
                        client.disconnect("successful test completed");
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                        if (this.pout == null) break block29;
                        this.pout.println("TechClient login and get machines check failed: " + x);
                    }
                }
            }
            String message = this.getMessage();
            if (this.pout != null) {
                this.pout.println(message);
            }
            System.out.println(message);
            this.success = !message.contains("FAILED");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getMessage() {
            String result = "successful";
            if (this.allversions == -1L || this.random == -1L || this.welcome == -1L || this.tcp == -1L || this.fdhttp == -1L || this.tclient == -1L) {
                result = "FAILED";
            }
            StringBuffer build = new StringBuffer();
            build.append(this.date + ": ");
            build.append("Server check " + result);
            Object object = checks_LOCK;
            synchronized (object) {
                int waiting = checks.size();
                build.append(" [n=" + waiting + "]");
            }
            if (this.allversions == -1L) {
                build.append(" (allver=FAIL)");
            } else {
                build.append(" (allver=" + this.allversions + ")");
            }
            if (this.random == -1L) {
                build.append(" (prand=FAIL)");
            } else {
                build.append(" (prand=" + this.random + ")");
            }
            if (this.welcome == -1L) {
                build.append(" (welcome=FAIL)");
            } else {
                build.append(" (welcome=" + this.welcome + ")");
            }
            if (this.tcp != 0L) {
                if (this.tcp == -1L) {
                    build.append(" (nl/tcp=FAIL)");
                } else {
                    build.append(" (nl/tcp=" + this.tcp + ")");
                }
            }
            if (this.fdhttp != 0L) {
                if (this.fdhttp == -1L) {
                    build.append(" (nl/fdhttp=FAIL)");
                } else {
                    build.append(" (nl/fdhttp=" + this.fdhttp + ")");
                }
            }
            if (this.tclient != 0L) {
                if (this.tclient == -1L) {
                    build.append(" (login+getRA=FAIL)");
                } else {
                    build.append(" (login+getRA=" + this.tclient + ")");
                }
            }
            return build.toString();
        }
    }

    private static class SocketsTerminator
    implements JWSocketsListener {
        SocketCloseTimeoutMap timeoutMap = new SocketCloseTimeoutMap();

        private SocketsTerminator() {
        }

        @Override
        public void socketConnected(Socket sock) {
            this.timeoutMap.closeSocketIfNoUpdate(sock, 60000);
        }

        @Override
        public void socketClosed(Socket sock) {
        }
    }
}

