/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import utils.stream.OpenByteArrayOutputStream;

public class BCUtilInputStream
extends InputStream {
    DataInputStream in;
    BCUtil bcu;
    int cptr = 0;
    int clen = 0;
    byte[] chunk = new byte[0];
    OpenByteArrayOutputStream interim = new OpenByteArrayOutputStream();
    byte[] buffer = new byte[200000];
    OpenByteArrayOutputStream plain = new OpenByteArrayOutputStream();

    public BCUtilInputStream(InputStream in, BCUtil bcu) {
        this.in = new DataInputStream(in);
        this.bcu = bcu;
    }

    @Override
    public int read() throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        return 0xFF & this.chunk[this.cptr++];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        int rem_clen = this.clen - this.cptr;
        int minlen = Math.min(len, rem_clen);
        System.arraycopy(this.chunk, this.cptr, b, off, minlen);
        this.cptr += minlen;
        return minlen;
    }

    public int readNextChunk() throws IOException {
        if (this.cptr < this.clen) {
            return 0;
        }
        try {
            int n = this.readChunk();
            if (n == -1) {
                return -1;
            }
            while (this.plain.size() == 0) {
                n = this.readChunk();
                if (n != -1) continue;
                return -1;
            }
            this.chunk = this.plain.getByteArray();
            this.cptr = 0;
            this.clen = this.plain.size();
            return this.plain.size();
        }
        catch (EOFException e) {
            return -1;
        }
    }

    int readChunk() throws IOException {
        this.interim.reset();
        this.plain.reset();
        return this.bcu.unwrapHighPerformance(this.in, this.interim, this.buffer, this.plain);
    }
}

