/*
 * Decompiled with CFR 0.152.
 */
package utils.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XML14Util {
    public static String getChildText(Element parent, String tag, String def) {
        Element child = XML14Util.getChild(parent, tag);
        if (child == null) {
            return def;
        }
        String text = XML14Util.getTextContent(child);
        if (text == null) {
            return def;
        }
        if (text.trim().length() == 0) {
            return def;
        }
        return XML14Util.unescape(text.trim());
    }

    public static String getChildTextAllowEmptyStr(Element parent, String tag, String def) {
        Element child = XML14Util.getChild(parent, tag);
        if (child == null) {
            return def;
        }
        String text = XML14Util.getTextContent(child);
        if (text == null) {
            return def;
        }
        return XML14Util.unescape(text.trim());
    }

    public static String getIndent(int size) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            buffer.append("\t");
        }
        return buffer.toString();
    }

    public static boolean childExists(Element parent, String tag) {
        return XML14Util.getChild(parent, tag) != null;
    }

    public static Element getChild(Element parent, String tag) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            if (!(list.item(i) instanceof Element) || !(element = (Element)list.item(i)).getTagName().equals(tag)) continue;
            return element;
        }
        return null;
    }

    public static ArrayList<Element> getChildren(Element parent, String tag) {
        ArrayList<Element> returnList = new ArrayList<Element>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            Element element = (Element)list.item(i);
            if (tag != null && !element.getTagName().equals(tag)) continue;
            returnList.add(element);
        }
        return returnList;
    }

    public static ArrayList<Element> getChildren(Element parent) {
        return XML14Util.getChildren(parent, null);
    }

    public static String getTextContent(Node baseNode) throws DOMException {
        if (baseNode == null) {
            return null;
        }
        Node child = baseNode.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return XML14Util.hasTextContent(child) ? child.getNodeValue() : "";
            }
            StringBuilder buf = new StringBuilder();
            XML14Util.getTextContent(baseNode, buf);
            return buf.toString();
        }
        return "";
    }

    private static void getTextContent(Node baseNode, StringBuilder buf) throws DOMException {
        for (Node child = baseNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!XML14Util.hasTextContent(child)) continue;
            XML14Util.getTextContent_Extra(child, buf);
        }
    }

    private static final boolean hasTextContent(Node child) {
        return child.getNodeType() != 8 && child.getNodeType() != 7 && (child.getNodeType() != 3 || !XML14Util.isIgnorableWhitespace(child));
    }

    private static boolean isIgnorableWhitespace(Node child) {
        if (child.getNodeType() == 3) {
            String val = child.getNodeValue();
            return val.trim().length() == 0;
        }
        return false;
    }

    private static void getTextContent_Extra(Node child, StringBuilder buf) throws DOMException {
        String content = child.getNodeValue();
        if (content != null) {
            buf.append(content);
        }
    }

    public static String unescape(String string) {
        string = string.replaceAll("&amp;", "&");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&quot;", "\"");
        return string;
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = string.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String elementToString(Element element, boolean recurse, boolean include_text) {
        return element.toString();
    }

    public static Element getChildByName(Element parent, String tagName) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            if (!(list.item(i) instanceof Element) || !(element = (Element)list.item(i)).getTagName().equals(tagName)) continue;
            return element;
        }
        return null;
    }

    public static int getElementChildCount(Element element) {
        int count = 0;
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            ++count;
        }
        return count;
    }

    public static Element parseXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        return XML14Util.parseXML(new StringReader(xml));
    }

    public static Element parseXML(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document dom = builder.parse(new InputSource(reader));
        return dom.getDocumentElement();
    }

    public static ArrayList<Element> getChildrenByName(Element parent, String tagName) {
        ArrayList<Element> returnList = new ArrayList<Element>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            if (!(list.item(i) instanceof Element) || !(element = (Element)list.item(i)).getTagName().equals(tagName)) continue;
            returnList.add(element);
        }
        return returnList;
    }

    public static void appendTextNode(StringBuffer buffer, int indent, String tag, String value) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(tag).append(">").append(XML14Util.escape(value)).append("</").append(tag).append(">\n");
    }

    public static void appendTextNode(StringBuilder buffer, int indent, String tag, String value) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(tag).append(">").append(XML14Util.escape(value)).append("</").append(tag).append(">\n");
    }

    public static void appendTextNode(StringBuffer buffer, int indent, String tag, String value, String[] attributes, String[] values) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(tag);
        for (int i = 0; i < attributes.length; ++i) {
            String key = XML14Util.escape(attributes[i]);
            String val = XML14Util.escape(values[i]);
            buffer.append(" ").append(key).append("=\"").append(val).append("\"");
        }
        buffer.append(">");
        if (value != null) {
            buffer.append(XML14Util.escape(value));
        }
        buffer.append("</").append(tag).append(">\n");
    }

    public static void appendTextNode(StringBuilder buffer, int indent, String tag, String value, String[] attributes, String[] values) {
        buffer.append(XML14Util.getIndent(indent)).append("<").append(tag);
        for (int i = 0; i < attributes.length; ++i) {
            String key = XML14Util.escape(attributes[i]);
            String val = XML14Util.escape(values[i]);
            buffer.append(" ").append(key).append("=\"").append(val).append("\"");
        }
        buffer.append(">");
        if (value != null) {
            buffer.append(XML14Util.escape(value));
        }
        buffer.append("</").append(tag).append(">\n");
    }

    public static boolean getAttribute(Element user, String attribute, boolean def) {
        if (attribute == null || user == null) {
            return def;
        }
        String value = user.getAttribute(attribute);
        if (value == null || value.length() == 0) {
            return def;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Throwable t) {
            return def;
        }
    }
}

