/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JPanel;

public class LinePanel
extends JPanel {
    public static final int ORIENTATION_VERTICAL = 0;
    public static final int ORIENTATION_HORIZONTAL = 1;
    boolean vert = false;
    JPanel stuff = new JPanel();
    GridLayout grid = new GridLayout(1, 1);
    JPanel toppad = new JPanel();
    JPanel botpad = new JPanel();

    public JPanel getTopOrLeftPaddingPanel() {
        return this.toppad;
    }

    public JPanel getBottomOrRightPaddingPanel() {
        return this.botpad;
    }

    @Override
    public void setOpaque(boolean b) {
        super.setOpaque(b);
        if (this.toppad != null) {
            this.toppad.setOpaque(b);
        }
        if (this.botpad != null) {
            this.botpad.setOpaque(b);
        }
        if (this.stuff != null) {
            this.stuff.setOpaque(b);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.toppad != null) {
            this.toppad.setBackground(c);
        }
        if (this.botpad != null) {
            this.botpad.setBackground(c);
        }
        if (this.stuff != null) {
            this.stuff.setBackground(c);
        }
    }

    public LinePanel(int orientation, boolean pad_top_or_left, boolean pad_bottom_or_right) {
        super.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.stuff.setOpaque(false);
        boolean bl = this.vert = orientation == 0;
        if (pad_top_or_left && pad_bottom_or_right) {
            JPanel tmp = new JPanel();
            tmp.setLayout(new BorderLayout());
            tmp.setOpaque(false);
            if (this.vert) {
                super.add("Center", this.toppad);
                super.add("South", tmp);
                tmp.add("North", this.stuff);
                tmp.add("Center", this.botpad);
            } else {
                super.add("Center", this.toppad);
                super.add("East", tmp);
                tmp.add("West", this.stuff);
                tmp.add("Center", this.botpad);
            }
        } else if (pad_top_or_left || pad_bottom_or_right) {
            this.botpad = this.toppad;
            super.add("Center", this.toppad);
            if (this.vert) {
                if (pad_top_or_left) {
                    super.add("South", this.stuff);
                } else if (pad_bottom_or_right) {
                    super.add("North", this.stuff);
                }
            } else if (pad_top_or_left) {
                super.add("East", this.stuff);
            } else if (pad_bottom_or_right) {
                super.add("West", this.stuff);
            }
        } else {
            super.add("Center", this.stuff);
        }
        this.stuff.setLayout(this.grid);
        this.toppad.setOpaque(false);
    }

    public void setGridLayoutSpacing(int hgap, int vgap) {
        this.grid.setHgap(hgap);
        this.grid.setVgap(vgap);
        this.invalidate();
        this.doLayout();
        this.validate();
        this.repaint();
    }

    @Override
    public void setLayout(LayoutManager lm) {
    }

    private void updateLayout() {
        int n = Math.max(1, this.stuff.getComponentCount());
        if (this.vert) {
            this.grid.setRows(n);
        } else {
            this.grid.setColumns(n);
        }
    }

    public ArrayList<Component> getComponentList() {
        Component[] comps = this.stuff.getComponents();
        ArrayList<Component> list = new ArrayList<Component>();
        for (Component comp : comps) {
            list.add(comp);
        }
        return list;
    }

    public JPanel getSubPanel() {
        return this.stuff;
    }

    public Component getComponentAt(int n) {
        return this.stuff.getComponent(n);
    }

    @Override
    public Component add(Component comp) {
        Component c = this.stuff.add(comp);
        this.updateLayout();
        return c;
    }

    @Override
    public Component add(Component comp, int index) {
        Component c = this.stuff.add(comp, index);
        this.updateLayout();
        return c;
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.stuff.add(comp);
        this.updateLayout();
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.stuff.add(comp, index);
        this.updateLayout();
    }

    @Override
    public Component add(String name, Component comp) {
        Component c = this.stuff.add(name, comp);
        this.updateLayout();
        return c;
    }

    @Override
    public void remove(Component comp) {
        this.stuff.remove(comp);
        this.updateLayout();
    }

    @Override
    public void remove(int index) {
        this.stuff.remove(index);
        this.updateLayout();
    }

    @Override
    public void removeAll() {
        this.stuff.removeAll();
        this.updateLayout();
    }
}

