/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.images;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import utils.files.FileUtil;
import utils.stream.StreamUtils;
import utils.swing.IconLoader;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.NotificationOverlayPainter;

public class ImageLoader {
    public static final int OP_NONE = 0;
    public static final int OP_GRAYSCALE = 1;
    public static final int OP_COLOUR_LIGHTER = 2;
    public static final int OP_COLOUR_DIMMER = 3;
    public static final int OP_ORIGINAL = 4;
    public static final int OP_SVG_TEST = 5;
    public static final int OP_LOW_SATURATION = 6;
    public static final int OP_COLOUR_LIGHTGREY = 7;
    private static double scaling = 1.0;
    private static ArrayList<ImageLoaderExtension> extensions = new ArrayList();
    private static HashMap<String, Icon> loaded;
    private static HashMap<Icon, BufferedImage> rasterisationCache;
    private static final byte[] tmpBuffer;

    public static void clearCache() {
        loaded.clear();
    }

    public static Image createDisabledImage(Image i) {
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), IconLoader.LIGHT_GRAY_FILTER);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return grayImage;
    }

    public static Icon getDisabledVersionOf(Icon icon) {
        if (icon instanceof ReferencedIcon) {
            return ImageLoader.getImageIconDisabled(((ReferencedIcon)icon).source);
        }
        if (icon instanceof ImageIcon) {
            Image disabledImage = ImageLoader.createDisabledImage(((ImageIcon)icon).getImage());
            return new ImageIcon(disabledImage);
        }
        return null;
    }

    public static void setScaling(int scalingPercentage) {
        scaling = 1.0 * (double)scalingPercentage / 100.0;
        for (ImageLoaderExtension extension : extensions) {
            extension.setScaling(scaling);
        }
    }

    public static boolean isScaling() {
        return scaling != 1.0;
    }

    public static boolean canLoad(String extension) {
        for (ImageLoaderExtension handler : extensions) {
            if (!handler.getExtension().equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public static ImageLoaderExtension getExtensionHandler(String extension) {
        for (ImageLoaderExtension e : extensions) {
            if (!e.getExtension().equalsIgnoreCase(extension)) continue;
            return e;
        }
        return null;
    }

    public static void registerExtensionHandler(ImageLoaderExtension extension) {
        if (!extensions.contains(extension)) {
            extensions.add(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertToImageAndCache(Icon icon) {
        BufferedImage image = rasterisationCache.get(icon);
        if (image != null) {
            return image;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = bufferedImage.createGraphics();
        try {
            icon.paintIcon(null, g, 0, 0);
            rasterisationCache.put(icon, bufferedImage);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            g.dispose();
        }
    }

    public static File getFileForImage(String name) {
        File f = new File(name);
        if (f.exists()) {
            return f;
        }
        f = new File(name.replace('\\', File.separatorChar).replace('/', File.separatorChar));
        if (f.exists()) {
            return f;
        }
        f = new File("SimpleHelp", name);
        if (f.exists()) {
            return f;
        }
        f = new File("../SimpleHelp", name);
        if (f.exists()) {
            return f;
        }
        f = new File("../Tools/shftp", name);
        if (f.exists()) {
            return f;
        }
        f = new File("lib", name);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static InputStream getResourceInputStreamForImage(String name) {
        InputStream in = null;
        try {
            in = ImageLoader.class.getResourceAsStream(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = ImageLoader.class.getResourceAsStream("/" + name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return in;
    }

    private static byte[] getResourceForImage(String name) throws IOException {
        InputStream in = ImageLoader.getResourceInputStreamForImage(name);
        if (in == null) {
            throw new IOException("Could not get image as input stream: " + name);
        }
        try {
            byte[] byArray = StreamUtils.readAll(in, tmpBuffer);
            return byArray;
        }
        finally {
            FileUtil.robustClose(in);
        }
    }

    private static Icon loadImageIcon(String name) throws IOException {
        return ImageLoader.loadImageIcon(name, 0);
    }

    private static Icon loadImageIconDisabled(String name) throws IOException {
        return ImageLoader.loadImageIcon(name, 1);
    }

    private static Icon loadImageIcon(String name, int op) throws IOException {
        Icon result = null;
        if (name.startsWith("O[")) {
            if ((name = name.substring(2)).endsWith("]")) {
                name = name.substring(0, name.length() - 1);
            }
            String[] icons = name.split("\\|");
            String bottom = icons[0].trim();
            String top = icons[1].trim();
            if (op == 0) {
                Icon bottomIcon = ImageLoader.getImageIcon(bottom, op);
                Icon topIcon = ImageLoader.getImageIcon(top, op);
                Icon bottomIconDisabled = ImageLoader.getImageIcon(bottom, 1);
                Icon topIconDisabled = ImageLoader.getImageIcon(top, 1);
                return new OverlayedIcon(bottomIcon, topIcon, bottomIconDisabled, topIconDisabled);
            }
            Icon bottomIcon = ImageLoader.getImageIcon(bottom, op);
            Icon topIcon = ImageLoader.getImageIcon(top, op);
            return new OverlayedIcon(bottomIcon, topIcon, bottomIcon, topIcon);
        }
        if (name.startsWith("LR[")) {
            if ((name = name.substring(3)).endsWith("]")) {
                name = name.substring(0, name.length() - 1);
            }
            String[] icons = name.split("\\|");
            String left = icons[0].trim();
            String right = icons[1].trim();
            int gap = 0;
            if (icons.length > 2) {
                gap = Integer.parseInt(icons[2].trim());
            }
            if (op == 0) {
                Icon leftIcon = ImageLoader.getImageIcon(left, op);
                Icon rightIcon = ImageLoader.getImageIcon(right, op);
                Icon leftIconDisabled = ImageLoader.getImageIcon(left, 1);
                Icon rightIconDisabled = ImageLoader.getImageIcon(right, 1);
                return new LeftRightIcon(leftIcon, rightIcon, leftIconDisabled, rightIconDisabled, gap);
            }
            Icon leftIcon = ImageLoader.getImageIcon(left, op);
            Icon rightIcon = ImageLoader.getImageIcon(right, op);
            return new LeftRightIcon(leftIcon, rightIcon, leftIcon, rightIcon, gap);
        }
        boolean foundHandler = false;
        for (ImageLoaderExtension extension : extensions) {
            if (!name.contains("." + extension.getExtension())) continue;
            foundHandler = true;
            try {
                result = extension.loadImageIcon(name, op);
                if (result == null) continue;
                break;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (!foundHandler) {
            System.out.println("[ImageLoader] Warning. No handler for " + name + " found.");
        }
        return result;
    }

    public static Image loadImageNoCache(String name) throws IOException {
        Icon icon = ImageLoader.loadImageIcon(name);
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    public static Image getAsImage(String name) {
        return ImageLoader.getAsImage(name, 0);
    }

    public static Image getAsImageOriginal(String name) {
        return ImageLoader.getAsImage(name, 4);
    }

    public static Image getAsImageDisabled(String name) {
        return ImageLoader.getAsImage(name, 1);
    }

    private static Image getAsImage(String name, int op) {
        try {
            Icon icon = ImageLoader.getImageIcon(name, op);
            return ImageLoader.convertToImageAndCache(icon);
        }
        catch (Throwable t) {
            System.out.println("IO error while loading image " + name + ": " + t.getMessage());
            t.printStackTrace();
            return null;
        }
    }

    public static Icon getImageIcon(String name) {
        return ImageLoader.getImageIcon(name, 0);
    }

    public static Icon getImageIconDisabled(String name) {
        return ImageLoader.getImageIcon(name, 1);
    }

    public static Icon getImageIconLighter(String name) {
        return ImageLoader.getImageIcon(name, 2);
    }

    public static Icon getImageIconDimmer(String name) {
        return ImageLoader.getImageIcon(name, 3);
    }

    public static Icon getImageIconLowSaturation(String name) {
        return ImageLoader.getImageIcon(name, 6);
    }

    public static Icon getImageIconLightGrey(String name) {
        return ImageLoader.getImageIcon(name, 7);
    }

    public static Icon getImageIconOriginal(String name) {
        return ImageLoader.getImageIcon(name, 4);
    }

    public static Icon getImageIconTest(String name) {
        return ImageLoader.getImageIcon(name, 5);
    }

    private static Icon getImageIcon(String name, int op) {
        String key = name;
        if (op > 0) {
            key = key + "-" + op;
        }
        try {
            Icon onept = loaded.get(key);
            if (onept == null) {
                ImageLoader.fix(name);
                onept = loaded.get(key);
            }
            if (onept == null && (onept = ImageLoader.loadImageIcon(name, op)) != null) {
                loaded.put(key, onept);
            }
            return onept;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("IO error while loading image " + name + ": " + e.getMessage());
            return null;
        }
    }

    private static void fix(String name) {
        char c = File.separatorChar;
        if (c != '\\') {
            name.replace('\\', File.separatorChar);
        }
        if (c != '/') {
            name.replace('/', File.separatorChar);
        }
    }

    public static Icon getOverlayedIcon(Icon bottom, Icon top) {
        return ImageLoader.getOverlayedIcon(bottom, top, bottom, top, true);
    }

    public static Icon getOverlayedIcon(Icon bottom, Icon top, Icon disabledBottom, Icon disabledTop) {
        return ImageLoader.getOverlayedIcon(bottom, top, disabledBottom, disabledTop, true);
    }

    public static Icon getOverlayedIcon(Icon bottom, Icon top, Icon disabledBottom, Icon disabledTop, boolean onRight) {
        return new OverlayedIcon(bottom, top, disabledBottom, disabledTop, onRight);
    }

    public static Icon getIncrementalOverlayedIcon(Icon bottom, int number) {
        int size = SimpleHelpLookAndFeel.scale(16);
        return ImageLoader.getIncrementalOverlayedIcon(bottom, number, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getIncrementalOverlayedIcon(Icon bottom, int number, int size) {
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g2d = image.createGraphics();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            NotificationOverlayPainter.paint(g2d, 0, 0, size, "" + number, NotificationOverlayPainter.NOTIFICATION_RED, Color.white);
        }
        finally {
            g2d.dispose();
        }
        ImageIcon icon = new ImageIcon(image);
        return new OverlayedIcon(bottom, icon);
    }

    static {
        ImageLoader.registerExtensionHandler(new PNGImageLoaderExtensions());
        try {
            Class<?> c = Class.forName("com.aem.shelp.util.SVGImageLoaderExtension");
            Method m = c.getMethod("getInstance", new Class[0]);
            ImageLoaderExtension ex = (ImageLoaderExtension)m.invoke(null, new Object[0]);
            if (ex != null) {
                ImageLoader.registerExtensionHandler(ex);
            }
        }
        catch (ClassNotFoundException t) {
            System.out.println("[ImageLoader] Couldn't load SVG extension (ClassNotFoundException)");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        loaded = new HashMap();
        rasterisationCache = new HashMap();
        tmpBuffer = new byte[51200];
    }

    public static class ReferencedIcon
    implements Icon {
        private final int op;
        private final String source;
        private final Icon icon;

        public ReferencedIcon(String name, int op, Icon onept) {
            this.source = name;
            this.op = op;
            this.icon = onept;
        }

        public String getSourceName() {
            return this.source;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    public static class BrightnessContrastFilter
    extends RGBImageFilter {
        private int[] mLUT = null;

        public BrightnessContrastFilter() {
            this(0.3f, 0.3f);
        }

        public BrightnessContrastFilter(float pBrightness, float pContrast) {
            this.mLUT = this.createLUT(pBrightness, pContrast);
        }

        private int[] createLUT(float pBrightness, float pContrast) {
            int[] lut = new int[256];
            double contrast = pContrast > 0.0f ? Math.pow(pContrast, 7.0) * 127.0 : (double)pContrast;
            double brightness = (double)pBrightness + 1.0;
            for (int i = 0; i < 256; ++i) {
                lut[i] = this.clamp((int)(127.5 * brightness + (double)(i - 127) * (contrast + 1.0)));
            }
            if (pContrast == 1.0f) {
                lut[127] = lut[126];
            }
            return lut;
        }

        private int clamp(int i) {
            if (i < 0) {
                return 0;
            }
            if (i > 255) {
                return 255;
            }
            return i;
        }

        @Override
        public int filterRGB(int pX, int pY, int pARGB) {
            int r = pARGB >> 16 & 0xFF;
            int g = pARGB >> 8 & 0xFF;
            int b = pARGB & 0xFF;
            r = this.mLUT[r];
            g = this.mLUT[g];
            b = this.mLUT[b];
            return pARGB & 0xFF000000 | r << 16 | g << 8 | b;
        }
    }

    private static class PNGImageLoaderExtensions
    implements ImageLoaderExtension {
        private static final BrightnessContrastFilter dimFilter = new BrightnessContrastFilter(0.3f, -0.7f);
        private static BrightnessContrastFilter brightFilter = new BrightnessContrastFilter();
        private static final LightGrayFilter lightGrayFilter = new LightGrayFilter(true, 40);
        private static final LightGrayFilter veryLightGrayFilter = new LightGrayFilter(true, 70);
        private Toolkit tk = Toolkit.getDefaultToolkit();

        private PNGImageLoaderExtensions() {
        }

        @Override
        public String getExtension() {
            return "png";
        }

        @Override
        public Icon loadImageIcon(String name, int op) throws IOException {
            Image image;
            ImageIcon result = null;
            File f = ImageLoader.getFileForImage(name);
            if (f != null && (image = this.tk.getImage(f.getPath())) != null) {
                result = new ImageIcon(image);
            }
            if (result == null) {
                byte[] bytes = ImageLoader.getResourceForImage(name);
                Image image2 = this.tk.createImage(bytes);
                result = new ImageIcon(image2);
            }
            switch (op) {
                case 0: {
                    return result;
                }
                case 1: {
                    Image grayImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(result.getImage().getSource(), lightGrayFilter));
                    return new ImageIcon(grayImage);
                }
                case 3: {
                    Image dimImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(result.getImage().getSource(), dimFilter));
                    return new ImageIcon(dimImage);
                }
                case 2: {
                    Image lightImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(result.getImage().getSource(), brightFilter));
                    return new ImageIcon(lightImage);
                }
                case 7: {
                    Image grayImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(result.getImage().getSource(), veryLightGrayFilter));
                    return new ImageIcon(grayImage);
                }
            }
            return result;
        }

        @Override
        public void setScaling(double scaling) {
        }
    }

    static class LightGrayFilter
    extends RGBImageFilter {
        private boolean brighter;
        private int percent;

        public LightGrayFilter(boolean b, int p) {
            this.brighter = b;
            this.percent = p;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)((0.9 * (double)(rgb >> 16 & 0xFF) + 0.9 * (double)(rgb >> 8 & 0xFF) + 0.81 * (double)(rgb & 0xFF)) / 3.0);
            gray = this.brighter ? 255 - (255 - gray) * (100 - this.percent) / 100 : gray * (100 - this.percent) / 100;
            if (gray < 0) {
                gray = 0;
            }
            if (gray > 255) {
                gray = 255;
            }
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }

    public static class LeftRightIcon
    implements Icon {
        private final int gap;
        private Icon left = null;
        private Icon right = null;
        private Icon disabledLeft;
        private Icon disabledRight;

        public LeftRightIcon(Icon left, Icon right, Icon disabledLeft, Icon disabledRight, int gap) {
            this.left = left;
            this.right = right;
            this.disabledLeft = disabledLeft;
            this.disabledRight = disabledRight;
            this.gap = gap;
        }

        public LeftRightIcon(Icon left, Icon right, int gap) {
            this(left, right, left, right, gap);
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            int height = Math.max(this.left.getIconHeight(), this.right.getIconHeight());
            if (c.isEnabled()) {
                this.left.paintIcon(c, g, x, y + (height - this.left.getIconHeight()) / 2);
                this.right.paintIcon(c, g, x + this.gap + this.left.getIconWidth(), y + (height - this.right.getIconHeight()) / 2);
            } else {
                this.disabledLeft.paintIcon(c, g, x, y + (height - this.left.getIconHeight()) / 2);
                this.disabledRight.paintIcon(c, g, x + this.gap + this.left.getIconWidth(), y + (height - this.right.getIconHeight()) / 2);
            }
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.left.getIconHeight(), this.right.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return this.left.getIconWidth() + this.gap + this.right.getIconWidth();
        }
    }

    public static class OverlayedIcon
    implements Icon {
        private Icon bottom = null;
        private Icon top = null;
        private Icon disabledBottom;
        private Icon disabledTop;
        private boolean onRight = true;

        public OverlayedIcon(Icon bottom, Icon iconTop, Icon disabledBottom, Icon disabledTop) {
            this(bottom, iconTop, disabledBottom, disabledTop, true);
        }

        public OverlayedIcon(Icon bottom, Icon iconTop, Icon disabledBottom, Icon disabledTop, boolean onRight) {
            this.bottom = bottom;
            this.top = iconTop;
            this.onRight = onRight;
            this.disabledBottom = disabledBottom;
            this.disabledTop = disabledTop;
        }

        public OverlayedIcon(Icon bottom, Icon top) {
            this(bottom, top, bottom, top, true);
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                if (this.bottom == null && this.top != null) {
                    this.top.paintIcon(c, g, x, y);
                } else if (this.top == null && this.bottom != null) {
                    this.bottom.paintIcon(c, g, x, y);
                } else if (this.top == null && this.bottom == null) {
                    return;
                }
                int xx = this.onRight ? x + (this.bottom.getIconWidth() - this.top.getIconWidth()) : x;
                int yy = y + (this.bottom.getIconHeight() - this.top.getIconHeight());
                this.bottom.paintIcon(c, g, x, y);
                this.top.paintIcon(c, g, xx, yy);
            } else {
                if (this.disabledBottom == null && this.disabledTop != null) {
                    this.disabledTop.paintIcon(c, g, x, y);
                } else if (this.disabledTop == null && this.disabledBottom != null) {
                    this.disabledBottom.paintIcon(c, g, x, y);
                } else if (this.disabledTop == null && this.disabledBottom == null) {
                    return;
                }
                int xx = this.onRight ? x + (this.disabledBottom.getIconWidth() - this.disabledTop.getIconWidth()) : x;
                int yy = y + (this.disabledBottom.getIconHeight() - this.disabledTop.getIconHeight());
                this.disabledBottom.paintIcon(c, g, x, y);
                this.disabledTop.paintIcon(c, g, xx, yy);
            }
        }

        @Override
        public int getIconHeight() {
            if (this.bottom != null && this.top != null) {
                return Math.max(this.bottom.getIconHeight(), this.top.getIconHeight());
            }
            return 5;
        }

        @Override
        public int getIconWidth() {
            if (this.bottom != null && this.top != null) {
                return Math.max(this.bottom.getIconWidth(), this.top.getIconWidth());
            }
            return 5;
        }
    }

    public static interface ImageLoaderExtension {
        public String getExtension();

        public Icon loadImageIcon(String var1, int var2) throws IOException;

        public void setScaling(double var1);
    }
}

