/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.images;

import java.awt.Color;
import utils.swing.images.HSLColor;

public class ColorUtils {
    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static String colorToHexRGBString(Color c) {
        return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    public static boolean useBlackFontForBackgroundColor(Color color) {
        double a = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        return a < 0.45;
    }

    public static void writeARGB(int argb, byte[] target, int offset) {
        target[offset] = (byte)ColorUtils.getAlpha(argb);
        target[offset + 1] = (byte)ColorUtils.getRed(argb);
        target[offset + 2] = (byte)ColorUtils.getGreen(argb);
        target[offset + 3] = (byte)ColorUtils.getBlue(argb);
    }

    public static void writeRGB(int rgb, byte[] target, int offset) {
        target[offset] = (byte)ColorUtils.getRed(rgb);
        target[offset + 1] = (byte)ColorUtils.getGreen(rgb);
        target[offset + 2] = (byte)ColorUtils.getBlue(rgb);
    }

    public static void writeRGBA(int argb, byte[] target, int offset) {
        target[offset] = (byte)ColorUtils.getRed(argb);
        target[offset + 1] = (byte)ColorUtils.getGreen(argb);
        target[offset + 2] = (byte)ColorUtils.getBlue(argb);
        target[offset + 3] = (byte)ColorUtils.getAlpha(argb);
    }

    public static Color darker(Color color, double factor) {
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0), color.getAlpha());
    }

    public static Color lighter(Color color, double factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255), alpha);
    }

    public static Color getShadeOf(Color baseColor, double percentageDifference) {
        if (percentageDifference < 0.0) {
            percentageDifference = 0.0;
        }
        if (percentageDifference > 1.0) {
            percentageDifference = 1.0;
        }
        percentageDifference -= 0.5;
        int red = (int)Math.round(Math.max(0.0, Math.min(255.0, (double)baseColor.getRed() + 200.0 * (percentageDifference *= 2.0))));
        int green = (int)Math.round(Math.max(0.0, Math.min(255.0, (double)baseColor.getGreen() + 200.0 * percentageDifference)));
        int blue = (int)Math.round(Math.max(0.0, Math.min(255.0, (double)baseColor.getBlue() + 200.0 * percentageDifference)));
        int alpha = baseColor.getAlpha();
        return new Color(red, green, blue, alpha);
    }

    public static int getColorInt(int a, int r, int g, int b) {
        return 0xFF000000 & a << 24 | 0xFF0000 & r << 16 | 0xFF00 & g << 8 | 0xFF & b;
    }

    public static int getIntFromColor(int Red, int Green, int Blue) {
        Red = Red << 16 & 0xFF0000;
        Green = Green << 8 & 0xFF00;
        return 0xFF000000 | Red | Green | (Blue &= 0xFF);
    }

    public static Color getTransparentVersion(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static String makeSVGColoursPop(String svg) {
        StringBuilder builder = new StringBuilder();
        int hash = svg.indexOf(35);
        int previousHash = 0;
        if (hash == -1) {
            return svg;
        }
        while (hash != -1) {
            builder.append(svg.substring(previousHash, hash));
            previousHash = hash + 7;
            String colour = svg.substring(hash, hash + 7);
            if (!colour.equalsIgnoreCase("#FFFFFF")) {
                Color c = Color.decode(colour);
                HSLColor hsl = new HSLColor(c);
                c = hsl.adjustTone(-10.0f);
                builder.append(ColorUtils.colorToHexRGBString(c));
            } else {
                builder.append(colour);
            }
            hash = svg.indexOf(35, hash + 1);
        }
        builder.append(svg.substring(previousHash));
        return builder.toString();
    }
}

