/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.glassdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.GlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.DialogHandler;
import utils.swing.dialog.panels.OKCancelDialogPanel;

public class AbstractGlassDialog
extends GlassDialog
implements DialogHandler {
    private final int width;
    private final int heightOfEmptyDecoratedGlassDialog;
    private final int heightOfEmptyUndecoratedGlassDialog;
    protected AbstractDialogPanel dialogPanel;
    protected JButton lastButtonPressed;
    private JComponent closeRequestor;

    public AbstractGlassDialog(RootPaneContainer rootPaneContainer, int w, AbstractDialogPanel contentPanel) {
        super(rootPaneContainer, 100, 100, true, true, false);
        this.width = SimpleHelpLookAndFeel.scale(w);
        this.dialogPanel = contentPanel;
        this.heightOfEmptyDecoratedGlassDialog = this.getInternalFrame().getPreferredSize().height;
        this.setShowDecoration(false);
        this.heightOfEmptyUndecoratedGlassDialog = this.getInternalFrame().getPreferredSize().height;
        this.setShowDecoration(true);
        contentPanel.setDialogHandler(this);
        JPanel test = new JPanel(new BorderLayout());
        test.add((Component)contentPanel.getRootComponent(), "North");
        super.getContentPane().add(test);
    }

    public AbstractGlassDialog(Frame rootPane, int w, AbstractDialogPanel contentPanel) {
        this(SwingUtil.getRootPaneContainer(rootPane), w, contentPanel);
    }

    public void setDialogIconImage(Image image) {
    }

    public void showDialog() {
        this.setVisible(true, true);
    }

    public void showDialog(boolean block) {
        this.setVisible(true, block);
    }

    @Override
    public void setVisible(boolean visible, boolean block) {
        if (visible) {
            this.reinitDialogSize();
            if (this.dialogPanel.getFocusComponent() != null) {
                this.setFocusComponent(this.dialogPanel.getFocusComponent());
            }
        }
        super.setVisible(visible, block);
    }

    public void reinitDialogSize() {
        this.dialogPanel.prepareToShow(this.width);
        this.initialiseDialogSize();
        this.setShowDecoration(this.showDecoration);
    }

    private void initialiseDialogSize() {
        JPanel rootComponent = this.dialogPanel.getRootComponent();
        SwingUtil.setWidth(rootComponent, this.width);
        Dimension preferredSize = rootComponent.getPreferredSize();
        int height = preferredSize.height;
        height = this.showDecoration() ? (height += this.heightOfEmptyDecoratedGlassDialog) : (height += this.heightOfEmptyUndecoratedGlassDialog);
        int widthOfInternalFrame = this.width + this.internalFrame.getInsets().left + this.internalFrame.getInsets().right;
        this.setSize(widthOfInternalFrame, height);
        this.updateBoundsForCenteredOnScreen();
    }

    @Override
    public void setOkEnabled(boolean enabled) {
        if (this.dialogPanel instanceof OKCancelDialogPanel) {
            ((OKCancelDialogPanel)this.dialogPanel).setOkEnabled(enabled);
        }
    }

    @Override
    public void closeDialog(JComponent closeRequestor) {
        this.closeRequestor = closeRequestor;
        this.closeDialog();
    }

    @Override
    public JComponent getCloseRequestor() {
        return this.closeRequestor;
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public void okPressed() {
        this.okPressed(null);
    }

    protected void okPressed(JButton source) {
        this.lastButtonPressed = source;
        if (this.dialogPanel instanceof OKCancelDialogPanel) {
            ((OKCancelDialogPanel)this.dialogPanel).okPressed();
        } else {
            this.closeDialog(source);
        }
    }

    @Override
    public void cancelPressed() {
        this.closeDialog();
    }
}

