/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import utils.swing.customlaf.SHStyle;

public class SHMenuItemUI
extends BasicMenuItemUI {
    public static ComponentUI createUI(JComponent c) {
        return new SHMenuItemUI();
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        arrowIcon = null;
        if (!(c instanceof JCheckBoxMenuItem) || !((JCheckBoxMenuItem)c).isSelected()) {
            checkIcon = null;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintMenuItem(g, c, checkIcon, arrowIcon, background, foreground, 4);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        return super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, 8);
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        super.paintText(g, menuItem, textRect, text);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        g.setColor(UIManager.getColor("PopupMenu.background"));
        g.fillRect(0, 0, menuWidth, menuHeight);
        g.setColor(oldColor);
        if (model.isArmed()) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle2D.Float s = new Rectangle2D.Float(-2.0f, 0.0f, menuWidth + 4, menuHeight);
            g2d.setColor(SHStyle.SELECTION_BACKGROUND);
            g2d.fill(s);
        }
    }
}

