/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import utils.swing.borders.aqua.SlicedShadowBorder;
import utils.swing.customlaf.LegacySwingUtils;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.oem.OEMSwitches;

public class SHInternalFrameUI
extends BasicInternalFrameUI {
    private final Border shadedBorder_decorated;
    private final Border shadedBorder_undecorated;
    private JComponent oldNorthPane;

    public SHInternalFrameUI(JInternalFrame frame) {
        super(frame);
        this.shadedBorder_undecorated = this.shadedBorder_decorated = new CompoundBorder(SlicedShadowBorder.getInstance(), SHBorderFactory.createMatteBorder(1, 1, 1, 1, SHStyle.BORDER_COLOR)){

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        };
        this.oldNorthPane = null;
        frame.setOpaque(false);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SHInternalFrameUI((JInternalFrame)c);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new SHInternalFrameTitlePane(w);
        return this.titlePane;
    }

    public void setDecorated(boolean showDecoration) {
        if (showDecoration && this.getNorthPane() != null) {
            return;
        }
        if (!showDecoration && this.getNorthPane() == null) {
            return;
        }
        if (showDecoration) {
            this.northPane = this.oldNorthPane;
        } else {
            this.oldNorthPane = this.northPane;
            this.northPane = null;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.frame.setBorder(this.shadedBorder_undecorated);
    }

    private class SHInternalFrameTitlePane
    extends BasicInternalFrameTitlePane {
        public SHInternalFrameTitlePane(JInternalFrame f) {
            super(f);
            this.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        @Override
        protected void paintTitleBackground(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (!OEMSwitches.DARK_THEME) {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(243, 243, 243), 0.0f, this.getHeight(), new Color(212, 212, 212)));
            } else {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(65, 66, 70), 0.0f, this.getHeight(), new Color(56, 57, 59)));
            }
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (OEMSwitches.DARK_THEME) {
                g2d.setColor(Color.BLACK);
                g2d.drawLine(0, (int)((float)this.getHeight() - SHButtonUI.getBorderStrokeWidth()), this.getWidth(), (int)((float)this.getHeight() - SHButtonUI.getBorderStrokeWidth()));
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            this.paintTitleBackground(g);
            if (this.frame.getTitle() != null) {
                boolean isSelected = this.frame.isSelected();
                Font f = g.getFont();
                if (isSelected) {
                    g.setColor(this.selectedTextColor);
                } else {
                    g.setColor(this.notSelectedTextColor);
                }
                FontMetrics fm = LegacySwingUtils.getFontMetrics(this.frame, g);
                float baselineFloat = this.getHeight() - SimpleHelpLookAndFeel.scale(fm.getAscent()) - SimpleHelpLookAndFeel.scale(fm.getDescent());
                baselineFloat /= 2.0f;
                int baseline = (int)((baselineFloat += (float)SimpleHelpLookAndFeel.scale(fm.getAscent())) + SHButtonUI.getBorderStrokeWidth());
                String title = this.frame.getTitle();
                int stringWidth = SimpleHelpLookAndFeel.scale(fm.stringWidth(title));
                int titleX = this.getWidth() / 2 - stringWidth / 2;
                LegacySwingUtils.drawString(this.frame, g, title, titleX, baseline);
                g.setFont(f);
            }
        }
    }
}

