/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.SwingUtilities;

public class EventThreadExceptionPrinter
implements Thread.UncaughtExceptionHandler {
    static boolean DUMP_EXCEPTIONS_TO_FILE = false;
    static boolean inited = false;

    private static void dumpExceptionToFile(Throwable t) {
        try {
            FileOutputStream fout = new FileOutputStream("/tmp/UncaughtException-" + System.currentTimeMillis() + ".txt");
            PrintStream ps = new PrintStream(fout);
            t.printStackTrace(ps);
            fout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handle(Throwable thrown) {
        try {
            this.handleException(Thread.currentThread().getName(), thrown);
        }
        catch (Throwable x) {
            if (DUMP_EXCEPTIONS_TO_FILE) {
                EventThreadExceptionPrinter.dumpExceptionToFile(x);
            }
            x.printStackTrace();
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable thrown) {
        try {
            this.handleException(thread.getName(), thrown);
        }
        catch (Throwable x) {
            if (DUMP_EXCEPTIONS_TO_FILE) {
                EventThreadExceptionPrinter.dumpExceptionToFile(x);
            }
            x.printStackTrace();
        }
    }

    protected void handleException(String tname, Throwable thrown) {
        try {
            System.err.println("[AWT/Swing Exception] (STDERR) Exception on thread " + tname + " (" + thrown + ")");
            thrown.printStackTrace();
        }
        catch (Throwable x) {
            if (DUMP_EXCEPTIONS_TO_FILE) {
                EventThreadExceptionPrinter.dumpExceptionToFile(x);
            }
            x.printStackTrace();
        }
    }

    public static void setup() {
        try {
            if (!inited) {
                System.out.println("[EDT Exception Printer] Catching all EDT and uncaught exceptions and printing");
                inited = true;
                Thread.setDefaultUncaughtExceptionHandler(new EventThreadExceptionPrinter());
                System.setProperty("sun.awt.exception.handler", EventThreadExceptionPrinter.class.getName());
            }
        }
        catch (Throwable x) {
            if (DUMP_EXCEPTIONS_TO_FILE) {
                EventThreadExceptionPrinter.dumpExceptionToFile(x);
            }
            x.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        EventThreadExceptionPrinter.setup();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Object)null).toString();
            }
        });
        ((Object)null).toString();
    }
}

