/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.lang.ref.WeakReference;
import utils.progtools.Cleanable;

public class WeakReferenceTimerThread {
    long delay;
    WeakReference ref;
    TimerThread timer;

    public WeakReferenceTimerThread(Runnable listener, int delayMS) {
        this.ref = new WeakReference<Runnable>(listener);
        this.delay = delayMS;
        this.timer = new TimerThread();
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.ref.clear();
    }

    public class TimerThread
    extends Thread
    implements Cleanable {
        Object SLEEPY = new Object();
        boolean quit = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("WRTTimerThread");
            while (!this.quit) {
                try {
                    Object object = this.SLEEPY;
                    synchronized (object) {
                        this.SLEEPY.wait(WeakReferenceTimerThread.this.delay);
                    }
                    if (this.quit) {
                        return;
                    }
                    Runnable listener = (Runnable)WeakReferenceTimerThread.this.ref.get();
                    if (listener == null) {
                        return;
                    }
                    listener.run();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanupNow() {
            this.quit = true;
            Object object = this.SLEEPY;
            synchronized (object) {
                this.SLEEPY.notifyAll();
            }
        }
    }
}

