/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DataUtil {
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_KB = 1024L;
    private static final DecimalFormat spdf = new DecimalFormat("###,###,###,###,###,##0.#");
    private static final NumberFormat percentageFormat = NumberFormat.getPercentInstance();

    public static String getSensiblePercentage(double percentage) {
        return percentageFormat.format(percentage);
    }

    public static String getSensiblePercentage(int percentage) {
        double d = percentage;
        return percentageFormat.format(d /= 100.0);
    }

    public static String getSensibleSpeed(double speedHz) {
        String metric;
        if (speedHz < 1000.0) {
            metric = "Hz";
        } else if (speedHz < Math.pow(1000.0, 2.0)) {
            metric = "KHz";
            speedHz /= 1000.0;
        } else if (speedHz < Math.pow(1000.0, 3.0)) {
            metric = "MHz";
            speedHz /= Math.pow(1000.0, 2.0);
        } else {
            metric = "GHz";
            speedHz /= Math.pow(1000.0, 3.0);
        }
        if (speedHz * 10.0 % 10.0 == 0.0) {
            return speedHz + " " + metric;
        }
        return spdf.format(speedHz) + " " + metric;
    }

    public static long getBytesWithUnit(String units) {
        if (units == null) {
            return 0L;
        }
        if ((units = units.toLowerCase().trim()).length() == 0) {
            return 0L;
        }
        try {
            return (long)Double.parseDouble(units);
        }
        catch (Throwable throwable) {
            long factor = 1L;
            int unitsLength = 2;
            if (units.endsWith("kb")) {
                factor = 1024L;
            } else if (units.endsWith("mb")) {
                factor = 0x100000L;
            } else if (units.endsWith("gb")) {
                factor = 0x40000000L;
            } else if (units.endsWith("tb")) {
                factor = 0x10000000000L;
            } else if (units.endsWith("k")) {
                unitsLength = 1;
                factor = 1024L;
            } else if (units.endsWith("m")) {
                unitsLength = 1;
                factor = 0x100000L;
            } else if (units.endsWith("g")) {
                unitsLength = 1;
                factor = 0x40000000L;
            } else if (units.endsWith("t")) {
                unitsLength = 1;
                factor = 0x10000000000L;
            } else if (units.endsWith("b")) {
                unitsLength = 1;
            } else {
                System.out.println("[DataUtil] Unable to parse units '" + units + "'");
                return -1L;
            }
            units = units.substring(0, units.length() - unitsLength).trim();
            return (long)(Double.parseDouble(units) * (double)factor);
        }
    }

    public static String getSensibleSize(long sizeBytes) {
        String metric;
        double size = sizeBytes;
        if (size < 1024.0) {
            metric = "B";
        } else if (size < Math.pow(1024.0, 2.0)) {
            metric = "KB";
            size /= 1024.0;
        } else if (size < Math.pow(1024.0, 3.0)) {
            metric = "MB";
            size /= Math.pow(1024.0, 2.0);
        } else {
            metric = "GB";
            size /= Math.pow(1024.0, 3.0);
        }
        if (size * 10.0 % 10.0 == 0.0) {
            return (long)size + " " + metric;
        }
        return spdf.format(size) + " " + metric;
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

