/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.OutputStream;
import java.io.PrintStream;
import utils.progtools.CheapTimingProvider;

public class CheapTimingPrintStream
extends PrintStream {
    public static boolean usedForStdout = false;
    long previous = this.getMillis();
    private CheapTimingProvider provider;

    public CheapTimingPrintStream(OutputStream out) {
        super(out);
    }

    public void setProvider(CheapTimingProvider provider) {
        this.provider = provider;
    }

    public long getMillis() {
        return System.currentTimeMillis() % 10000000L + 80000000L;
    }

    @Override
    public void println(Object o) {
        long now = this.getMillis();
        StringBuffer sb = new StringBuffer();
        if (this.provider != null) {
            try {
                sb.append(this.provider.getCheapTime());
            }
            catch (Exception x) {
                this.provider = null;
                System.out.println("[TimingPrintStream] Had to abort provider due to exception: " + x);
                x.printStackTrace();
            }
        } else {
            sb.append(now);
        }
        sb.append(" (+");
        long delta = now - this.previous;
        String s = delta + "";
        int spaces = 5 - s.length();
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
        sb.append(s);
        sb.append(") ");
        sb.append(o);
        super.println(sb.toString());
        this.previous = now;
    }

    @Override
    public void println(String s) {
        this.println((Object)s);
    }
}

