/*
 * Decompiled with CFR 0.152.
 */
package utils.plist;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.w3c.dom.Element;
import utils.plist.BoolObject;
import utils.plist.DateObject;
import utils.plist.IntegerObject;
import utils.plist.Key;
import utils.plist.PListArray;
import utils.plist.PListDict;
import utils.plist.PListException;
import utils.plist.PListObject;
import utils.plist.RealObject;
import utils.plist.StringObject;
import utils.xml.XML14Util;

public class PListParser {
    private static final String TAG = PListParser.class.getSimpleName();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private PListParser() {
    }

    public static <T extends PListObject> T parse(InputStream is) throws PListException {
        return PListParser.parse(new InputStreamReader(is));
    }

    public static <T extends PListObject> T parse(String plist) throws PListException {
        StringReader sr = new StringReader(plist);
        return PListParser.parse(sr);
    }

    public static <T extends PListObject> T parse(Reader reader) throws PListException {
        PListObject plistObject = null;
        try {
            Element root = XML14Util.parseXML(reader);
            ArrayList<Element> children = XML14Util.getChildren(root);
            for (Element child : children) {
                String tag = child.getTagName();
                if (tag.equals("plist")) continue;
                plistObject = PListParser.getValue(child);
            }
        }
        catch (Exception e) {
            throw new PListException(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)plistObject;
    }

    private static void getChildValues(Element parent, PListArray array) throws PListException {
        array.clear();
        ArrayList<Element> children = XML14Util.getChildren(parent);
        for (Element child : children) {
            array.add(PListParser.getValue(child));
        }
    }

    private static void getChildValues(Element parent, PListDict dict) throws PListException {
        dict.clear();
        ArrayList<Element> children = XML14Util.getChildren(parent);
        for (int i = 0; i < children.size(); i += 2) {
            Element keyElement = children.get(i);
            Element valueElement = children.get(i + 1);
            Key key = new Key(XML14Util.getTextContent(keyElement));
            PListObject value = PListParser.getValue(valueElement);
            dict.put(key, value);
        }
    }

    private static PListObject getValue(Element parent) throws PListException {
        String tagName = parent.getTagName();
        if (tagName.equals("array")) {
            PListArray val = new PListArray();
            PListParser.getChildValues(parent, val);
            return val;
        }
        if (tagName.equals("dict")) {
            PListDict val = new PListDict();
            PListParser.getChildValues(parent, val);
            return val;
        }
        if (tagName.equals("key")) {
            return new Key(XML14Util.getTextContent(parent));
        }
        if (tagName.equals("string")) {
            return new StringObject(XML14Util.getTextContent(parent));
        }
        if (tagName.equals("integer")) {
            String text = XML14Util.getTextContent(parent);
            try {
                return new IntegerObject(Long.parseLong(text));
            }
            catch (NumberFormatException e) {
                throw new PListException("NumberFormatException occurred.");
            }
        }
        if (tagName.equals("real")) {
            String text = XML14Util.getTextContent(parent);
            try {
                return new RealObject(Double.parseDouble(text));
            }
            catch (NumberFormatException e) {
                throw new PListException("NumberFormatException occurred. " + text);
            }
        }
        if (tagName.equals("true") || tagName.equals("false")) {
            return new BoolObject(tagName.equals("true"));
        }
        if (tagName.equals("date")) {
            String text = XML14Util.getTextContent(parent);
            try {
                return new DateObject(DATE_FORMAT.parse(text));
            }
            catch (ParseException e) {
                throw new PListException("ParseException occurred. " + text);
            }
        }
        return null;
    }
}

